/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.synth;

import de.sciss.lucre.Txn$;
import de.sciss.lucre.TxnLike;
import de.sciss.lucre.synth.AudioBus;
import de.sciss.lucre.synth.Bus;
import de.sciss.lucre.synth.ControlBus;
import de.sciss.lucre.synth.RT;
import de.sciss.lucre.synth.Server;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.RichInt$;
import de.sciss.synth.Server;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.TMap;
import scala.concurrent.stm.TMap$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class Bus$ {
    public static final Bus$ MODULE$ = new Bus$();
    private static final TMap<Server, SortedMap<Object, Bus.OneWayAudioBusHolder>> readOnlyBuses = TMap$.MODULE$.empty();
    private static final TMap<Server, SortedMap<Object, Bus.OneWayAudioBusHolder>> writeOnlyBuses = TMap$.MODULE$.empty();
    private static final SortedMap<Object, Bus.OneWayAudioBusHolder> de$sciss$lucre$synth$Bus$$emptySortedMap = (SortedMap)SortedMap$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);

    public AudioBus audio(Server server, int numChannels) {
        return new Bus.AudioImpl(server, numChannels);
    }

    public ControlBus control(Server server, int numChannels) {
        return new Bus.ControlImpl(server, numChannels);
    }

    public AudioBus tmpAudio(Server server, int numChannels) {
        return new Bus.TempAudioImpl(server, numChannels);
    }

    public AudioBus soundIn(Server server, int numChannels, int offset) {
        Server.Config o = server.peer().config();
        Predef$.MODULE$.require(offset + numChannels <= o.inputBusChannels(), (Function0 & Serializable)() -> "soundIn - offset is beyond allocated hardware channels");
        return new Bus.FixedImpl(server, new de.sciss.synth.AudioBus(server.peer(), o.outputBusChannels() + offset, numChannels));
    }

    public int soundIn$default$3() {
        return 0;
    }

    public AudioBus soundOut(Server server, int numChannels, int offset) {
        Server.Config o = server.peer().config();
        Predef$.MODULE$.require(offset + numChannels <= o.outputBusChannels(), (Function0 & Serializable)() -> "soundOut - offset is beyond allocated hardware channels");
        return new Bus.FixedImpl(server, new de.sciss.synth.AudioBus(server.peer(), offset, numChannels));
    }

    public int soundOut$default$3() {
        return 0;
    }

    public AudioBus wrap(Server server, de.sciss.synth.AudioBus bus) {
        de.sciss.synth.Server server2 = server.peer();
        de.sciss.synth.Server server3 = bus.server();
        Predef$.MODULE$.require(!(server2 != null ? !server2.equals(server3) : server3 != null));
        return new Bus.FixedImpl(server, bus);
    }

    private TMap<Server, SortedMap<Object, Bus.OneWayAudioBusHolder>> readOnlyBuses() {
        return readOnlyBuses;
    }

    private TMap<Server, SortedMap<Object, Bus.OneWayAudioBusHolder>> writeOnlyBuses() {
        return writeOnlyBuses;
    }

    public SortedMap<Object, Bus.OneWayAudioBusHolder> de$sciss$lucre$synth$Bus$$emptySortedMap() {
        return de$sciss$lucre$synth$Bus$$emptySortedMap;
    }

    public void serverRemoved(Server server, RT tx) {
        this.readOnlyBuses().remove((Object)server, Txn$.MODULE$.peer((TxnLike)tx));
        this.writeOnlyBuses().remove((Object)server, Txn$.MODULE$.peer((TxnLike)tx));
    }

    public Bus.BusHolder<de.sciss.synth.AudioBus> de$sciss$lucre$synth$Bus$$createReadOnlyBus(Server server, int numChannels, RT tx) {
        return this.createOneWayAudioBus(server, numChannels, this.readOnlyBuses(), tx);
    }

    public Bus.BusHolder<de.sciss.synth.AudioBus> de$sciss$lucre$synth$Bus$$createWriteOnlyBus(Server server, int numChannels, RT tx) {
        return this.createOneWayAudioBus(server, numChannels, this.writeOnlyBuses(), tx);
    }

    private Bus.BusHolder<de.sciss.synth.AudioBus> createOneWayAudioBus(Server server, int numChannels, TMap<Server, SortedMap<Object, Bus.OneWayAudioBusHolder>> mapRef, RT tx) {
        SortedMap channelMap = (SortedMap)TMap$.MODULE$.asMap(mapRef, Txn$.MODULE$.peer((TxnLike)tx)).getOrElse((Object)server, (Function0 & Serializable)() -> MODULE$.de$sciss$lucre$synth$Bus$$emptySortedMap());
        int n = RichInt$.MODULE$.nextPowerOfTwo$extension(Implicits$.MODULE$.intNumberWrapper(numChannels));
        return (Bus.BusHolder)((IterableOps)channelMap.from((Object)BoxesRunTime.boxToInteger((int)n))).headOption().fold((Function0 & Serializable)() -> {
            int index = server.allocAudioBus(n, tx);
            de.sciss.synth.AudioBus full = new de.sciss.synth.AudioBus(server.peer(), index, n);
            de.sciss.synth.AudioBus peer = new de.sciss.synth.AudioBus(server.peer(), index, numChannels);
            Bus.OneWayAudioBusHolder res = new Bus.OneWayAudioBusHolder(server, full, peer, mapRef, (Ref<Object>)Ref$.MODULE$.apply(0));
            res.add(tx);
            return res;
        }, (Function1 & Serializable)x$1 -> ((Bus.OneWayAudioBusHolder)x$1._2()).withChannels(numChannels));
    }

    public Bus.BusHolder<de.sciss.synth.AudioBus> de$sciss$lucre$synth$Bus$$createAudioBus(Server server, int numChannels, RT tx) {
        int index = server.allocAudioBus(numChannels, tx);
        de.sciss.synth.AudioBus peer = new de.sciss.synth.AudioBus(server.peer(), index, numChannels);
        return new Bus.PlainAudioBusHolder(server, peer);
    }

    public Bus.BusHolder<de.sciss.synth.ControlBus> de$sciss$lucre$synth$Bus$$createControlBus(Server server, int numChannels, RT tx) {
        int index = server.allocControlBus(numChannels, tx);
        de.sciss.synth.ControlBus peer = new de.sciss.synth.ControlBus(server.peer(), index, numChannels);
        return new Bus.PlainControlBusHolder(server, peer);
    }

    private Bus$() {
    }
}

