/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre;

import de.sciss.lucre.util.FastOutputStream;
import de.sciss.lucre.util.PackedInteger;
import de.sciss.lucre.util.UtfOps;
import java.math.BigInteger;

public class DataOutput
extends FastOutputStream {
    static final int NULL_STRING_UTF_VALUE = -1;

    public DataOutput() {
    }

    public DataOutput(byte[] byArray) {
        super(byArray);
    }

    public final DataOutput writeBytes(String string) {
        this.writeBytes(string.toCharArray());
        return this;
    }

    public final DataOutput writeChars(String string) {
        this.writeChars(string.toCharArray());
        return this;
    }

    public final DataOutput writeString(String string) {
        if (string != null) {
            this.writeString(string.toCharArray());
        } else {
            this.writeFast(-1);
        }
        this.writeFast(0);
        return this;
    }

    public final DataOutput writeChar(int n) {
        this.writeFast((byte)(n >>> 8));
        this.writeFast((byte)n);
        return this;
    }

    public final DataOutput writeBoolean(boolean bl) {
        this.writeFast(bl ? 1 : 0);
        return this;
    }

    public final DataOutput writeByte(int n) {
        this.writeUnsignedByte(n ^ 0x80);
        return this;
    }

    public final DataOutput writeShort(int n) {
        this.writeUnsignedShort(n ^ 0x8000);
        return this;
    }

    public final DataOutput writeInt(int n) {
        this.writeUnsignedInt(n ^ Integer.MIN_VALUE);
        return this;
    }

    public final DataOutput writeLong(long l) {
        this.writeUnsignedLong(l ^ Long.MIN_VALUE);
        return this;
    }

    public final DataOutput writeFloat(float f) {
        this.writeUnsignedInt(Float.floatToIntBits(f));
        return this;
    }

    public final DataOutput writeDouble(double d) {
        this.writeUnsignedLong(Double.doubleToLongBits(d));
        return this;
    }

    public final DataOutput writeSortedFloat(float f) {
        int n;
        this.writeUnsignedInt(n ^= (n = Float.floatToIntBits(f)) < 0 ? -1 : Integer.MIN_VALUE);
        return this;
    }

    public final DataOutput writeSortedDouble(double d) {
        long l;
        this.writeUnsignedLong(l ^= (l = Double.doubleToLongBits(d)) < 0L ? -1L : Long.MIN_VALUE);
        return this;
    }

    public final DataOutput writeBytes(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.writeFast((byte)cArray[i]);
        }
        return this;
    }

    public final DataOutput writeChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.writeFast((byte)(cArray[i] >>> 8));
            this.writeFast((byte)cArray[i]);
        }
        return this;
    }

    public final DataOutput writeString(char[] cArray) {
        if (cArray.length == 0) {
            return this;
        }
        int n = UtfOps.getByteLength(cArray);
        this.makeSpace(n);
        UtfOps.charsToBytes(cArray, 0, this.getBufferBytes(), this.getBufferLength(), cArray.length);
        this.addSize(n);
        return this;
    }

    public final DataOutput writeUnsignedByte(int n) {
        this.writeFast(n);
        return this;
    }

    public final DataOutput writeUnsignedShort(int n) {
        this.writeFast((byte)(n >>> 8));
        this.writeFast((byte)n);
        return this;
    }

    public final DataOutput writeUnsignedInt(long l) {
        this.writeFast((byte)(l >>> 24));
        this.writeFast((byte)(l >>> 16));
        this.writeFast((byte)(l >>> 8));
        this.writeFast((byte)l);
        return this;
    }

    private final DataOutput writeUnsignedLong(long l) {
        this.writeFast((byte)(l >>> 56));
        this.writeFast((byte)(l >>> 48));
        this.writeFast((byte)(l >>> 40));
        this.writeFast((byte)(l >>> 32));
        this.writeFast((byte)(l >>> 24));
        this.writeFast((byte)(l >>> 16));
        this.writeFast((byte)(l >>> 8));
        this.writeFast((byte)l);
        return this;
    }

    public final void writePackedInt(int n) {
        this.makeSpace(5);
        int n2 = this.getBufferLength();
        int n3 = PackedInteger.writeInt(this.getBufferBytes(), n2, n);
        this.addSize(n3 - n2);
    }

    public final void writePackedLong(long l) {
        this.makeSpace(9);
        int n = this.getBufferLength();
        int n2 = PackedInteger.writeLong(this.getBufferBytes(), n, l);
        this.addSize(n2 - n);
    }

    public final DataOutput writeBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("BigInteger byte array is larger than 0x7fff bytes");
        }
        byte by = byArray[0];
        this.writeShort(by < 0 ? -byArray.length : byArray.length);
        this.writeByte(by);
        this.writeFast(byArray, 1, byArray.length - 1);
        return this;
    }

    public static int getBigIntegerByteLength(BigInteger bigInteger) {
        return 2 + (bigInteger.bitLength() + 1 + 7) / 8;
    }
}

