/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.util;

import java.io.InputStream;

public class FastInputStream
extends InputStream {
    protected int len;
    protected int off;
    protected int mark;
    protected byte[] buf;

    public FastInputStream(byte[] byArray) {
        this.buf = byArray;
        this.len = byArray.length;
    }

    public FastInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.off = n;
        this.len = n + n2;
    }

    @Override
    public int available() {
        return this.len - this.off;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.off;
    }

    @Override
    public void reset() {
        this.off = this.mark;
    }

    @Override
    public long skip(long l) {
        int n = (int)l;
        if (n + this.off > this.len) {
            n = this.len - this.off;
        }
        this.skipFast(n);
        return n;
    }

    @Override
    public int read() {
        return this.readFast();
    }

    @Override
    public int read(byte[] byArray) {
        return this.readFast(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        return this.readFast(byArray, n, n2);
    }

    public final void skipFast(int n) {
        this.off += n;
    }

    public final int readFast() {
        return this.off < this.len ? this.buf[this.off++] & 0xFF : -1;
    }

    public final int readFast(byte[] byArray) {
        return this.readFast(byArray, 0, byArray.length);
    }

    public final int readFast(byte[] byArray, int n, int n2) {
        int n3 = this.len - this.off;
        if (n3 <= 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.buf, this.off, byArray, n, n2);
        this.off += n2;
        return n2;
    }

    public final byte[] getBufferBytes() {
        return this.buf;
    }

    public final int getBufferOffset() {
        return this.off;
    }

    public final int getBufferLength() {
        return this.len;
    }
}

