/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.io;

import de.sciss.synth.io.AudioFile;
import de.sciss.synth.io.AudioFile$;
import de.sciss.synth.io.AudioFileHeader;
import de.sciss.synth.io.AudioFileHeaderFactory;
import de.sciss.synth.io.AudioFileHeaderReader;
import de.sciss.synth.io.AudioFileHeaderWriter;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.AudioFileType;
import de.sciss.synth.io.AudioFileType$;
import de.sciss.synth.io.BufferBidi;
import de.sciss.synth.io.BufferBidiFactory;
import de.sciss.synth.io.BufferReader;
import de.sciss.synth.io.BufferReaderFactory;
import de.sciss.synth.io.BufferWriter;
import de.sciss.synth.io.BufferWriterFactory;
import de.sciss.synth.io.SampleFormat;
import de.sciss.synth.io.WritableAudioFileHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AudioFile$
implements ScalaObject {
    public static final AudioFile$ MODULE$;

    static {
        new AudioFile$();
    }

    public AudioFile openRead(String path) throws IOException {
        return this.openRead(new File(path));
    }

    public AudioFile openRead(File f) throws IOException {
        RandomAccessFile raf$1 = new RandomAccessFile(f, "r");
        DataInputStream dis = this.dataInput(Channels.newInputStream(raf$1.getChannel()));
        AudioFileHeaderReader afhr = this.createHeaderReader(dis);
        raf$1.seek(0L);
        AudioFileHeader afh = afhr.read(raf$1);
        ByteBuffer buf$1 = this.createBuffer(afh);
        AudioFileSpec spec$1 = afh.spec();
        SampleFormat sf$1 = spec$1.sampleFormat();
        BufferReader br = (BufferReader)sf$1.readerFactory().map((Function1)new Serializable(raf$1, buf$1, spec$1){
            public static final long serialVersionUID;
            private final RandomAccessFile raf$1;
            private final ByteBuffer buf$1;
            private final AudioFileSpec spec$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BufferReader apply(BufferReaderFactory bufferReaderFactory) {
                return bufferReaderFactory.apply(this.raf$1.getChannel(), this.buf$1, this.spec$1.numChannels());
            }
            {
                this.raf$1 = randomAccessFile;
                this.buf$1 = byteBuffer;
                this.spec$1 = audioFileSpec;
            }
        }).getOrElse((Function0)new Serializable(sf$1){
            public static final long serialVersionUID;
            private final SampleFormat sf$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noDecoder(this.sf$1);
            }
            {
                this.sf$1 = sampleFormat;
            }
        });
        return new AudioFile.ReadableFileImpl(f, raf$1, afh, br);
    }

    public AudioFile openRead(InputStream is) throws IOException {
        DataInputStream dis$1 = this.dataInput(is);
        AudioFileHeaderReader afhr = this.createHeaderReader(dis$1);
        AudioFileHeader afh = afhr.read(dis$1);
        ByteBuffer buf$2 = this.createBuffer(afh);
        AudioFileSpec spec$2 = afh.spec();
        SampleFormat sf$2 = spec$2.sampleFormat();
        BufferReader br = (BufferReader)sf$2.readerFactory().map((Function1)new Serializable(dis$1, buf$2, spec$2){
            public static final long serialVersionUID;
            private final DataInputStream dis$1;
            private final ByteBuffer buf$2;
            private final AudioFileSpec spec$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BufferReader apply(BufferReaderFactory bufferReaderFactory) {
                return bufferReaderFactory.apply(Channels.newChannel(this.dis$1), this.buf$2, this.spec$2.numChannels());
            }
            {
                this.dis$1 = dataInputStream;
                this.buf$2 = byteBuffer;
                this.spec$2 = audioFileSpec;
            }
        }).getOrElse((Function0)new Serializable(sf$2){
            public static final long serialVersionUID;
            private final SampleFormat sf$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noDecoder(this.sf$2);
            }
            {
                this.sf$2 = sampleFormat;
            }
        });
        return new AudioFile.ReadableStreamImpl(dis$1, afh, br);
    }

    private AudioFileHeaderReader createHeaderReader(DataInputStream dis) throws IOException {
        AudioFileType fileType$1 = (AudioFileType)this.identify(dis).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                throw new IOException("Unrecognized audio file format");
            }
        });
        AudioFileHeaderFactory factory = (AudioFileHeaderFactory)fileType$1.factory().getOrElse((Function0)new Serializable(fileType$1){
            public static final long serialVersionUID;
            private final AudioFileType fileType$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noDecoder(this.fileType$1);
            }
            {
                this.fileType$1 = audioFileType;
            }
        });
        return (AudioFileHeaderReader)factory.createHeaderReader().getOrElse((Function0)new Serializable(fileType$1){
            public static final long serialVersionUID;
            private final AudioFileType fileType$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noDecoder(this.fileType$1);
            }
            {
                this.fileType$1 = audioFileType;
            }
        });
    }

    private ByteBuffer createBuffer(AudioFileHeader afh) {
        AudioFileSpec spec = afh.spec();
        int frameSize = (spec.sampleFormat().bitsPerSample() >> 3) * spec.numChannels();
        int bufFrames = package$.MODULE$.max(1, 65536 / package$.MODULE$.max(1, frameSize));
        int bufSize = bufFrames * frameSize;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(bufSize);
        return byteBuf.order(afh.byteOrder());
    }

    private DataInputStream dataInput(InputStream is) {
        return new DataInputStream(new BufferedInputStream(is, 1024));
    }

    private DataOutputStream dataOutput(OutputStream os) {
        return new DataOutputStream(new BufferedOutputStream(os, 1024));
    }

    public final Nothing$ de$sciss$synth$io$AudioFile$$noDecoder(Object msg) {
        throw new IOException(new StringBuilder().append((Object)"No decoder for ").append(msg).toString());
    }

    public final Nothing$ de$sciss$synth$io$AudioFile$$noEncoder(Object msg) {
        throw new IOException(new StringBuilder().append((Object)"No encoder for ").append(msg).toString());
    }

    public AudioFile openWrite(String path, AudioFileSpec spec) throws IOException {
        return this.openWrite(new File(path), spec);
    }

    public AudioFile openWrite(File f, AudioFileSpec spec$4) throws IOException {
        Option<BufferBidiFactory> option;
        block4: {
            AudioFile.WritableFileLike writableFileLike;
            block3: {
                FileChannel ch$1;
                SampleFormat sf$3;
                ByteBuffer buf$3;
                WritableAudioFileHeader afh;
                RandomAccessFile raf;
                block2: {
                    BufferBidiFactory bufferBidiFactory;
                    AudioFileHeaderWriter afhw = this.createHeaderWriter(spec$4);
                    Object object = f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.delete()) : BoxedUnit.UNIT;
                    raf = new RandomAccessFile(f, "rw");
                    afh = afhw.write(raf, spec$4);
                    buf$3 = this.createBuffer(afh);
                    sf$3 = spec$4.sampleFormat();
                    ch$1 = raf.getChannel();
                    option = sf$3.bidiFactory();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    BufferBidiFactory bbf = bufferBidiFactory = (BufferBidiFactory)some.x();
                    BufferBidi bb = bbf.apply(ch$1, ch$1, buf$3, spec$4.numChannels());
                    writableFileLike = new AudioFile.BidiFileImpl(f, raf, afh, bb);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<BufferBidiFactory> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                BufferWriter bw = (BufferWriter)sf$3.writerFactory().map((Function1)new Serializable(spec$4, buf$3, ch$1){
                    public static final long serialVersionUID;
                    private final AudioFileSpec spec$4;
                    private final ByteBuffer buf$3;
                    private final FileChannel ch$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final BufferWriter apply(BufferWriterFactory bufferWriterFactory) {
                        return bufferWriterFactory.apply(this.ch$1, this.buf$3, this.spec$4.numChannels());
                    }
                    {
                        this.spec$4 = audioFileSpec;
                        this.buf$3 = byteBuffer;
                        this.ch$1 = fileChannel;
                    }
                }).getOrElse((Function0)new Serializable(sf$3){
                    public static final long serialVersionUID;
                    private final SampleFormat sf$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Nothing$ apply() {
                        return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noEncoder(this.sf$3);
                    }
                    {
                        this.sf$3 = sampleFormat;
                    }
                });
                writableFileLike = new AudioFile.WritableFileImpl(f, raf, afh, bw);
            }
            return writableFileLike;
        }
        throw new MatchError(option);
    }

    public AudioFile openWrite(OutputStream os, AudioFileSpec spec$3) throws IOException {
        AudioFileHeaderWriter afhw = this.createHeaderWriter(spec$3);
        DataOutputStream dos$1 = this.dataOutput(os);
        WritableAudioFileHeader afh = afhw.write(dos$1, spec$3);
        ByteBuffer buf$4 = this.createBuffer(afh);
        SampleFormat sf$4 = spec$3.sampleFormat();
        BufferWriter bw = (BufferWriter)sf$4.writerFactory().map((Function1)new Serializable(spec$3, dos$1, buf$4){
            public static final long serialVersionUID;
            private final AudioFileSpec spec$3;
            private final DataOutputStream dos$1;
            private final ByteBuffer buf$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BufferWriter apply(BufferWriterFactory bufferWriterFactory) {
                return bufferWriterFactory.apply(Channels.newChannel(this.dos$1), this.buf$4, this.spec$3.numChannels());
            }
            {
                this.spec$3 = audioFileSpec;
                this.dos$1 = dataOutputStream;
                this.buf$4 = byteBuffer;
            }
        }).getOrElse((Function0)new Serializable(sf$4){
            public static final long serialVersionUID;
            private final SampleFormat sf$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noEncoder(this.sf$4);
            }
            {
                this.sf$4 = sampleFormat;
            }
        });
        return new AudioFile.WritableStreamImpl(dos$1, afh, bw);
    }

    private AudioFileHeaderWriter createHeaderWriter(AudioFileSpec spec) {
        AudioFileType fileType$2 = spec.fileType();
        AudioFileHeaderFactory factory = (AudioFileHeaderFactory)fileType$2.factory().getOrElse((Function0)new Serializable(fileType$2){
            public static final long serialVersionUID;
            private final AudioFileType fileType$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noEncoder(this.fileType$2);
            }
            {
                this.fileType$2 = audioFileType;
            }
        });
        return (AudioFileHeaderWriter)factory.createHeaderWriter().getOrElse((Function0)new Serializable(fileType$2){
            public static final long serialVersionUID;
            private final AudioFileType fileType$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return AudioFile$.MODULE$.de$sciss$synth$io$AudioFile$$noEncoder(this.fileType$2);
            }
            {
                this.fileType$2 = audioFileType;
            }
        });
    }

    public float[][] buffer(int numChannels, int bufFrames) {
        return (float[][])Array$.MODULE$.ofDim(numChannels, bufFrames, (ClassManifest)Manifest$.MODULE$.Float());
    }

    public int buffer$default$2() {
        return 8192;
    }

    public AudioFileSpec readSpec(String path) {
        return this.readSpec(new File(path));
    }

    public AudioFileSpec readSpec(File f) {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        AudioFileSpec exceptionResult1 = null;
        try {
            DataInputStream dis = this.dataInput(Channels.newInputStream(raf.getChannel()));
            AudioFileHeaderReader afhr = this.createHeaderReader(dis);
            raf.seek(0L);
            exceptionResult1 = afhr.read(raf).spec();
            return exceptionResult1;
        }
        finally {
            raf.close();
        }
    }

    public AudioFileSpec readSpec(DataInputStream dis) throws IOException {
        AudioFileHeaderReader afhr = this.createHeaderReader(dis);
        return afhr.read(dis).spec();
    }

    public Option<AudioFileType> identify(String path) throws IOException {
        return this.identify(new File(path));
    }

    public Option<AudioFileType> identify(File f) throws IOException {
        DataInputStream dis = this.dataInput(new FileInputStream(f));
        Option<AudioFileType> exceptionResult2 = null;
        try {
            exceptionResult2 = this.identify(dis);
            return exceptionResult2;
        }
        finally {
            dis.close();
        }
    }

    public Option<AudioFileType> identify(DataInputStream dis$2) throws IOException {
        return AudioFileType$.MODULE$.known().find((Function1)new Serializable(dis$2){
            public static final long serialVersionUID;
            public final DataInputStream dis$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(AudioFileType audioFileType) {
                return BoxesRunTime.unboxToBoolean((Object)audioFileType.factory().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.identify.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(AudioFileHeaderFactory f) {
                        this.$outer.dis$2.mark(1024);
                        boolean exceptionResult3 = false;
                        try {
                            exceptionResult3 = f.identify(this.$outer.dis$2);
                        }
                        catch (Throwable throwable) {
                            exceptionResult3 = false;
                            return exceptionResult3;
                        }
                        this.$outer.dis$2.reset();
                        return exceptionResult3;
                        {
                            finally {
                                this.$outer.dis$2.reset();
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
            {
                this.dis$2 = dataInputStream;
            }
        });
    }

    private AudioFile$() {
        MODULE$ = this;
    }
}

