/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.io;

import de.sciss.synth.io.AudioFileHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteOrder;
import scala.ScalaObject;
import scala.runtime.Nothing$;

public final class AudioFileHeader$
implements ScalaObject {
    public static final AudioFileHeader$ MODULE$;

    static {
        new AudioFileHeader$();
    }

    public int readLittleUShort(DataInput din) throws IOException {
        int i = din.readUnsignedShort();
        return i >> 8 | (i & 0xFF) << 8;
    }

    public int readLittleInt(DataInput din) throws IOException {
        int i = din.readInt();
        return i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    public float readLittleFloat(DataInput din) throws IOException {
        int i = din.readInt();
        return Float.intBitsToFloat(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public long readLittleLong(DataInput din) throws IOException {
        long n = din.readLong();
        return n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56;
    }

    public void writeLittleShort(DataOutput dout, int i) throws IOException {
        dout.writeShort(i >> 8 | (i & 0xFF) << 8);
    }

    public void writeLittleInt(DataOutput dout, int i) throws IOException {
        dout.writeInt(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public void writeLittleFloat(DataOutput dout, float f) throws IOException {
        int i = Float.floatToIntBits(f);
        dout.writeInt(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public void writeLittleLong(DataOutput dout, long n) throws IOException {
        dout.writeLong(n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56);
    }

    public String readNullTermString(DataInput din) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte b = din.readByte();
        while (b != 0) {
            buf.append((char)b);
            b = din.readByte();
        }
        return buf.toString();
    }

    public Nothing$ formatError() {
        throw new IOException("A header format error occurred");
    }

    public Nothing$ encodingError() {
        throw new IOException("File has unsupported encoding");
    }

    public Nothing$ incompleteError() {
        throw new IOException("Header data is incomplete");
    }

    public AudioFileHeader.DataInputReader dataInputReader(DataInput din, ByteOrder byteOrder2) {
        ByteOrder byteOrder3 = byteOrder2;
        ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
        return !(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null) ? new AudioFileHeader.LittleDataInputReader(din) : new AudioFileHeader.BigDataInputReader(din);
    }

    public AudioFileHeader.DataInputReader nativeDataInputReader(DataInput din) {
        return this.dataInputReader(din, ByteOrder.nativeOrder());
    }

    public AudioFileHeader.DataOutputWriter dataOutputWriter(DataOutput dout, ByteOrder byteOrder2) {
        ByteOrder byteOrder3 = byteOrder2;
        ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
        return !(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null) ? new AudioFileHeader.LittleDataOutputWriter(dout) : new AudioFileHeader.BigDataOutputWriter(dout);
    }

    public AudioFileHeader.DataOutputWriter nativeDataOutputWriter(DataOutput dout) {
        return this.dataOutputWriter(dout, ByteOrder.nativeOrder());
    }

    private AudioFileHeader$() {
        MODULE$ = this;
    }
}

