/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.io.impl;

import de.sciss.synth.io.AudioFileHeader;
import de.sciss.synth.io.AudioFileHeader$;
import de.sciss.synth.io.AudioFileHeaderReader;
import de.sciss.synth.io.AudioFileHeaderWriter;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.AudioFileType;
import de.sciss.synth.io.AudioFileType$AIFF$;
import de.sciss.synth.io.ReadableAudioFileHeader;
import de.sciss.synth.io.SampleFormat;
import de.sciss.synth.io.SampleFormat$Double$;
import de.sciss.synth.io.SampleFormat$Float$;
import de.sciss.synth.io.SampleFormat$Int16$;
import de.sciss.synth.io.SampleFormat$Int24$;
import de.sciss.synth.io.SampleFormat$Int32$;
import de.sciss.synth.io.SampleFormat$Int8$;
import de.sciss.synth.io.ScalaAudioFile$;
import de.sciss.synth.io.WritableAudioFileHeader;
import de.sciss.synth.io.impl.AIFFHeader$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r=sAB\u0001\u0003\u0011\u000b!A\"\u0001\u0006B\u0013\u001a3\u0005*Z1eKJT!a\u0001\u0003\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011!B:z]RD'BA\u0005\u000b\u0003\u0015\u00198-[:t\u0015\u0005Y\u0011A\u00013f!\tia\"D\u0001\u0003\r\u0019y!\u0001#\u0002\u0005!\tQ\u0011)\u0013$G\u0011\u0016\fG-\u001a:\u0014\t9\t\u0012$\b\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tA\u0001\\1oO*\ta#\u0001\u0003kCZ\f\u0017B\u0001\r\u0014\u0005\u0019y%M[3diB\u0011!dG\u0007\u0002\t%\u0011A\u0004\u0002\u0002\u0017\u0003V$\u0017n\u001c$jY\u0016DU-\u00193fe\u001a\u000b7\r^8ssB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\tY1kY1mC>\u0013'.Z2u\u0011\u0015!c\u0002\"\u0001'\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0007\t\u000f!r!\u0019!C\u0005S\u0005Qai\u0014*N?6\u000bu)S\"\u0016\u0003)\u0002\"AH\u0016\n\u00051z\"aA%oi\"1aF\u0004Q\u0001\n)\n1BR(S\u001b~k\u0015iR%DA!9\u0001G\u0004b\u0001\n\u0013I\u0013AC!J\r\u001a{V*Q$J\u0007\"1!G\u0004Q\u0001\n)\n1\"Q%G\r~k\u0015iR%DA!9AG\u0004b\u0001\n\u0013I\u0013AC!J\r\u000e{V*Q$J\u0007\"1aG\u0004Q\u0001\n)\n1\"Q%G\u0007~k\u0015iR%DA!9\u0001H\u0004b\u0001\n\u0013I\u0013AC\"P\u001b6{V*Q$J\u0007\"1!H\u0004Q\u0001\n)\n1bQ(N\u001b~k\u0015iR%DA!9AH\u0004b\u0001\n\u0013I\u0013AC%O'R{V*Q$J\u0007\"1aH\u0004Q\u0001\n)\n1\"\u0013(T)~k\u0015iR%DA!9\u0001I\u0004b\u0001\n\u0013I\u0013AC'B%.{V*Q$J\u0007\"1!I\u0004Q\u0001\n)\n1\"T!S\u0017~k\u0015iR%DA!9AI\u0004b\u0001\n\u0013I\u0013AC*T\u001d\u0012{V*Q$J\u0007\"1aI\u0004Q\u0001\n)\n1bU*O\t~k\u0015iR%DA!9\u0001J\u0004b\u0001\n\u0013I\u0013A\u0003$W\u000bJ{V*Q$J\u0007\"1!J\u0004Q\u0001\n)\n1B\u0012,F%~k\u0015iR%DA!9AJ\u0004b\u0001\n\u0013I\u0013AC!Q!2{V*Q$J\u0007\"1aJ\u0004Q\u0001\n)\n1\"\u0011)Q\u0019~k\u0015iR%DA!9\u0001K\u0004b\u0001\n\u0013I\u0013AC\"P\u001bR{V*Q$J\u0007\"1!K\u0004Q\u0001\n)\n1bQ(N)~k\u0015iR%DA!9AK\u0004b\u0001\n\u0013I\u0013AC!O\u001d>{V*Q$J\u0007\"1aK\u0004Q\u0001\n)\n1\"\u0011(O\u001f~k\u0015iR%DA!9\u0001L\u0004b\u0001\n\u0013I\u0013A\u0003(P\u001d\u0016{V*Q$J\u0007\"1!L\u0004Q\u0001\n)\n1BT(O\u000b~k\u0015iR%DA!9AL\u0004b\u0001\n\u0013I\u0013A\u00034mgIzV*Q$J\u0007\"1aL\u0004Q\u0001\n)\n1B\u001a74e}k\u0015iR%DA!9\u0001M\u0004b\u0001\n\u0013I\u0013A\u0003$MgIzV*Q$J\u0007\"1!M\u0004Q\u0001\n)\n1B\u0012'4e}k\u0015iR%DA!9AM\u0004b\u0001\n\u0013I\u0013A\u00034mmQzV*Q$J\u0007\"1aM\u0004Q\u0001\n)\n1B\u001a77i}k\u0015iR%DA!9\u0001N\u0004b\u0001\n\u0013I\u0013A\u0003$MmQzV*Q$J\u0007\"1!N\u0004Q\u0001\n)\n1B\u0012'7i}k\u0015iR%DA!9AN\u0004b\u0001\n\u0013I\u0013AC5ocYzV*Q$J\u0007\"1aN\u0004Q\u0001\n)\n1\"\u001b82m}k\u0015iR%DA!9\u0001O\u0004b\u0001\n\u0013I\u0013AC5oeQzV*Q$J\u0007\"1!O\u0004Q\u0001\n)\n1\"\u001b83i}k\u0015iR%DA!9AO\u0004b\u0001\n\u0013I\u0013AC5ogIzV*Q$J\u0007\"1aO\u0004Q\u0001\n)\n1\"\u001b84e}k\u0015iR%DA!9\u0001P\u0004b\u0001\n\u0013I\u0013\u0001D5ocYbUiX'B\u000f&\u001b\u0005B\u0002>\u000fA\u0003%!&A\u0007j]F2D*R0N\u0003\u001eK5\t\t\u0005\by:\u0011\r\u0011\"\u0003*\u00031\t\u0015JR\"WKJ\u001c\u0018n\u001c82\u0011\u0019qh\u0002)A\u0005U\u0005i\u0011)\u0013$D-\u0016\u00148/[8oc\u0001B\u0011\"!\u0001\u000f\u0005\u0004%I!a\u0001\u0002\u0015\u0019d7GM0I+6\u000be*\u0006\u0002\u0002\u0006A)a$a\u0002\u0002\f%\u0019\u0011\u0011B\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0007y\ti!C\u0002\u0002\u0010}\u0011AAQ=uK\"A\u00111\u0003\b!\u0002\u0013\t)!A\u0006gYN\u0012t\fS+N\u0003:\u0003\u0003\"CA\f\u001d\t\u0007I\u0011BA\u0002\u0003)1GN\u000e\u001b`\u0011Vk\u0015I\u0014\u0005\t\u00037q\u0001\u0015!\u0003\u0002\u0006\u0005Ya\r\u001c\u001c5?\"+V*\u0011(!\u0011%\tyB\u0004b\u0001\n\u0013\t\u0019!\u0001\u0006j]F2t\fS+N\u0003:C\u0001\"a\t\u000fA\u0003%\u0011QA\u0001\fS:\fdg\u0018%V\u001b\u0006s\u0005\u0005C\u0005\u0002(9\u0011\r\u0011\"\u0003\u0002*\u0005!AJ\u0014\u001aS+\t\tY\u0003E\u0002\u001f\u0003[I1!a\f \u0005\u0019!u.\u001e2mK\"A\u00111\u0007\b!\u0002\u0013\tY#A\u0003M\u001dJ\u0012\u0006\u0005C\u0004\u000289!\t!!\u000f\u0002%\r\u0014X-\u0019;f\u0011\u0016\fG-\u001a:SK\u0006$WM]\u000b\u0003\u0003w\u0001RAHA\u001f\u0003\u0003J1!a\u0010 \u0005\u0019y\u0005\u000f^5p]B\u0019!$a\u0011\n\u0007\u0005\u0015CAA\u000bBk\u0012LwNR5mK\"+\u0017\rZ3s%\u0016\fG-\u001a:\t\u000f\u0005%c\u0002\"\u0001\u0002L\u0005\u00112M]3bi\u0016DU-\u00193fe^\u0013\u0018\u000e^3s+\t\ti\u0005E\u0003\u001f\u0003{\ty\u0005E\u0002\u001b\u0003#J1!a\u0015\u0005\u0005U\tU\u000fZ5p\r&dW\rS3bI\u0016\u0014xK]5uKJDq!a\u0016\u000f\t\u0003\tI&\u0001\u0005jI\u0016tG/\u001b4z)\u0011\tY&!\u0019\u0011\u0007y\ti&C\u0002\u0002`}\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002d\u0005U\u0003\u0019AA3\u0003\r!\u0017n\u001d\t\u0005\u0003O\nY'\u0004\u0002\u0002j)\u0011Q!F\u0005\u0005\u0003[\nIGA\bECR\f\u0017J\u001c9viN#(/Z1nQ\u0019\t)&!\u001d\u0002xA\u0019a$a\u001d\n\u0007\u0005UtD\u0001\u0004uQJ|wo]\u0012\u0003\u0003s\u0002B!a\u001a\u0002|%!\u0011QPA5\u0005-Iu*\u0012=dKB$\u0018n\u001c8\u0007\r\u0005\u0005e\u0002BAB\u0005\u0019\u0011V-\u00193feN1\u0011qP\t\u0002BuAq\u0001JA@\t\u0003\t9\t\u0006\u0002\u0002\nB!\u00111RA@\u001b\u0005q\u0001\u0002CAH\u0003\u007f\"\t!!%\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003'\u000bI\nE\u0002\u001b\u0003+K1!a&\u0005\u0005=\tU\u000fZ5p\r&dW\rS3bI\u0016\u0014\b\u0002CAN\u0003\u001b\u0003\r!!(\u0002\u0007I\fg\r\u0005\u0003\u0002h\u0005}\u0015\u0002BAQ\u0003S\u0012\u0001CU1oI>l\u0017iY2fgN4\u0015\u000e\\3)\r\u00055\u0015\u0011OA<\u0011!\ty)a \u0005\u0002\u0005\u001dF\u0003BAJ\u0003SC\u0001\"a\u0019\u0002&\u0002\u0007\u0011Q\r\u0015\u0007\u0003K\u000b\t(a\u001e\t\u0011\u0005=\u0016q\u0010C\u0005\u0003c\u000bQB]3bI\u0012\u000bG/Y%oaV$H\u0003BAJ\u0003gC\u0001\"!.\u0002.\u0002\u0007\u0011qW\u0001\u0004I&t\u0007\u0003BA4\u0003sKA!a/\u0002j\tIA)\u0019;b\u0013:\u0004X\u000f\u001e\u0015\u0007\u0003[\u000b\t(a\u001e\t\u0011\u0005\u0005\u0017q\u0010C\u0005\u0003\u0007\fq\"\u001b8u'\u0006l\u0007\u000f\\3G_Jl\u0017\r\u001e\u000b\u0005\u0003\u000b\fY\rE\u0002\u001b\u0003\u000fL1!!3\u0005\u00051\u0019\u0016-\u001c9mK\u001a{'/\\1u\u0011\u001d\ti-a0A\u0002)\nQBY5ugB+'oU1na2,gABAi\u001d\u0011\t\u0019N\u0001\u0004Xe&$XM]\n\u0007\u0003\u001f\f\u0012qJ\u000f\t\u000f\u0011\ny\r\"\u0001\u0002XR\u0011\u0011\u0011\u001c\t\u0005\u0003\u0017\u000by\r\u0003\u0005\u0002^\u0006=G\u0011AAp\u0003\u00159(/\u001b;f)\u0019\t\t/a:\u0002jB\u0019!$a9\n\u0007\u0005\u0015HAA\fXe&$\u0018M\u00197f\u0003V$\u0017n\u001c$jY\u0016DU-\u00193fe\"A\u00111TAn\u0001\u0004\ti\n\u0003\u0005\u0002l\u0006m\u0007\u0019AAw\u0003\u0011\u0019\b/Z2\u0011\u0007i\ty/C\u0002\u0002r\u0012\u0011Q\"Q;eS>4\u0015\u000e\\3Ta\u0016\u001c\u0007FBAn\u0003c\n9\b\u0003\u0005\u0002^\u0006=G\u0011AA|)\u0019\t\t/!?\u0003\u0004!A\u00111`A{\u0001\u0004\ti0A\u0002e_N\u0004B!a\u001a\u0002\u0000&!!\u0011AA5\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002l\u0006U\b\u0019AAwQ\u0019\t)0!\u001d\u0002x!A!\u0011BAh\t\u0013\u0011Y!A\bxe&$X\rR1uC>+H\u000f];u)\u0019\u0011iAa\u0005\u0003\u001eA9aDa\u0004+U\u00055\u0018b\u0001B\t?\t1A+\u001e9mKNB\u0001B!\u0006\u0003\b\u0001\u0007!qC\u0001\u0005I>,H\u000f\u0005\u0003\u0002h\te\u0011\u0002\u0002B\u000e\u0003S\u0012!\u0002R1uC>+H\u000f];u\u0011!\tYOa\u0002A\u0002\u00055\bF\u0002B\u0004\u0003c\n9H\u0002\u0004\u0003$9!!Q\u0005\u0002\u0013/JLG/\u00192mK\u001aKG.\u001a%fC\u0012,'o\u0005\u0004\u0003\"E\t\t/\b\u0005\f\u00037\u0013\tC!A!\u0002\u0013\ti\nC\u0006\u0003,\t\u0005\"\u0011!Q\u0001\n\u00055\u0018!B:qK\u000e\u0004\u0004B\u0003B\u0018\u0005C\u0011\t\u0011)A\u0005U\u0005Aq\u000e\u001e5fe2+g\u000e\u0003\u0006\u00034\t\u0005\"\u0011!Q\u0001\n)\nqaY8n[2+g\u000eC\u0004%\u0005C!\tAa\u000e\u0015\u0015\te\"1\bB\u001f\u0005\u007f\u0011\t\u0005\u0005\u0003\u0002\f\n\u0005\u0002\u0002CAN\u0005k\u0001\r!!(\t\u0011\t-\"Q\u0007a\u0001\u0003[DqAa\f\u00036\u0001\u0007!\u0006C\u0004\u00034\tU\u0002\u0019\u0001\u0016\t\u0015\t\u0015#\u0011\u0005a\u0001\n\u0013\u00119%\u0001\u0006ok64%/Y7fgB*\"A!\u0013\u0011\u0007y\u0011Y%C\u0002\u0003N}\u0011A\u0001T8oO\"Q!\u0011\u000bB\u0011\u0001\u0004%IAa\u0015\u0002\u001d9,XN\u0012:b[\u0016\u001c\bg\u0018\u0013fcR!!Q\u000bB.!\rq\"qK\u0005\u0004\u00053z\"\u0001B+oSRD!B!\u0018\u0003P\u0005\u0005\t\u0019\u0001B%\u0003\rAH%\r\u0005\n\u0005C\u0012\t\u0003)Q\u0005\u0005\u0013\n1B\\;n\rJ\fW.Z:1A!A!Q\rB\u0011\t\u0003\u00119'\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0005+\u0012I\u0007\u0003\u0005\u0003l\t\r\u0004\u0019\u0001B%\u0003%qW/\u001c$sC6,7\u000f\u000b\u0004\u0003d\u0005E\u0014q\u000f\u0005\t\u0003W\u0014\t\u0003\"\u0001\u0003rU\u0011\u0011Q\u001e\u0005\t\u0005k\u0012\t\u0003\"\u0001\u0003x\u0005I!-\u001f;f\u001fJ$WM]\u000b\u0003\u0005s\u0002BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0004\u0005\u007f*\u0012a\u00018j_&!!1\u0011B?\u0005%\u0011\u0015\u0010^3Pe\u0012,'O\u0002\u0004\u0003\b:!%\u0011\u0012\u0002\u0015/JLG/\u00192mKN#(/Z1n\u0011\u0016\fG-\u001a:\u0014\u0015\t\u0015\u0015#!9\u001e\u0005\u0017\u0013\t\nE\u0002\u001f\u0005\u001bK1Aa$ \u0005\u001d\u0001&o\u001c3vGR\u00042A\bBJ\u0013\r\u0011)j\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\f\u0003W\u0014)I!f\u0001\n\u0003\u0011\t\bC\u0006\u0003\u001c\n\u0015%\u0011#Q\u0001\n\u00055\u0018!B:qK\u000e\u0004\u0003b\u0002\u0013\u0003\u0006\u0012\u0005!q\u0014\u000b\u0005\u0005C\u0013\u0019\u000b\u0005\u0003\u0002\f\n\u0015\u0005\u0002CAv\u0005;\u0003\r!!<\t\u0011\t\u0015$Q\u0011C\u0001\u0005O#BA!\u0016\u0003*\"A!1\u000eBS\u0001\u0004\u0011I\u0005\u000b\u0004\u0003&\u0006E\u0014q\u000f\u0005\t\u0005k\u0012)\t\"\u0001\u0003x!Q!\u0011\u0017BC\u0003\u0003%\tAa-\u0002\t\r|\u0007/\u001f\u000b\u0005\u0005C\u0013)\f\u0003\u0006\u0002l\n=\u0006\u0013!a\u0001\u0003[D!B!/\u0003\u0006F\u0005I\u0011\u0001B^\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!0+\t\u00055(qX\u0016\u0003\u0005\u0003\u0004BAa1\u0003N6\u0011!Q\u0019\u0006\u0005\u0005\u000f\u0014I-A\u0005v]\u000eDWmY6fI*\u0019!1Z\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003P\n\u0015'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"A!1\u001bBC\t\u0003\u0012).\u0001\u0005iCND7i\u001c3f)\u0005Q\u0003\u0002\u0003Bm\u0005\u000b#\tEa7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!8\u0011\t\t}'Q\u001d\b\u0004=\t\u0005\u0018b\u0001Br?\u00051\u0001K]3eK\u001aLAAa:\u0003j\n11\u000b\u001e:j]\u001eT1Aa9 \u0011!\u0011iO!\"\u0005B\t=\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\\\tE\bB\u0003B/\u0005W\f\t\u00111\u0001\u0003tB\u0019aD!>\n\u0007\t]xDA\u0002B]fD\u0001Ba?\u0003\u0006\u0012\u0005#Q`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\bc\u0001\n\u0004\u0002%\u0019!q]\n\t\u000f\r\u0015!Q\u0011C!S\u0005a\u0001O]8ek\u000e$\u0018I]5us\"A1\u0011\u0002BC\t\u0003\u001aY!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tM8Q\u0002\u0005\n\u0005;\u001a9!!AA\u0002)B\u0001b!\u0005\u0003\u0006\u0012\u000531C\u0001\tG\u0006tW)];bYR!\u00111LB\u000b\u0011)\u0011ifa\u0004\u0002\u0002\u0003\u0007!1_\u0004\n\u00073q\u0011\u0011!E\u0007\u00077\tAc\u0016:ji\u0006\u0014G.Z*ue\u0016\fW\u000eS3bI\u0016\u0014\b\u0003BAF\u0007;1\u0011Ba\"\u000f\u0003\u0003Eiaa\b\u0014\u000f\ru1\u0011E\u000f\u0003\u0012BA11EB\u0015\u0003[\u0014\t+\u0004\u0002\u0004&)\u00191qE\u0010\u0002\u000fI,h\u000e^5nK&!11FB\u0013\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bI\ruA\u0011AB\u0018)\t\u0019Y\u0002\u0003\u0005\u0003Z\u000euAQIB\u001a)\t\u0011y\u0010\u0003\u0006\u00048\ru\u0011\u0011!CA\u0007s\tQ!\u00199qYf$BA!)\u0004<!A\u00111^B\u001b\u0001\u0004\ti\u000f\u0003\u0006\u0004@\ru\u0011\u0011!CA\u0007\u0003\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004D\r\u0015\u0003#\u0002\u0010\u0002>\u00055\b\u0002CB$\u0007{\u0001\rA!)\u0002\u0007a$\u0003\u0007\u0003\u0005\u0004L\ruA\u0011CB'\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003E\u0001")
public final class AIFFHeader {
    public static final boolean identify(DataInputStream dataInputStream) throws IOException {
        return AIFFHeader$.MODULE$.identify(dataInputStream);
    }

    public static final Option<AudioFileHeaderWriter> createHeaderWriter() {
        return AIFFHeader$.MODULE$.createHeaderWriter();
    }

    public static final Option<AudioFileHeaderReader> createHeaderReader() {
        return AIFFHeader$.MODULE$.createHeaderReader();
    }

    public static final double de$sciss$synth$io$impl$AIFFHeader$$LN2R() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$LN2R();
    }

    public static final byte[] de$sciss$synth$io$impl$AIFFHeader$$in16_HUMAN() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16_HUMAN();
    }

    public static final byte[] de$sciss$synth$io$impl$AIFFHeader$$fl64_HUMAN() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl64_HUMAN();
    }

    public static final byte[] de$sciss$synth$io$impl$AIFFHeader$$fl32_HUMAN() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl32_HUMAN();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$AIFCVersion1() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFCVersion1();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$in16LE_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16LE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$in32_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in32_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$in24_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in24_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$in16_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$FL64_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FL64_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$fl64_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl64_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$FL32_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FL32_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$fl32_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl32_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$NONE_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$NONE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$ANNO_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$ANNO_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$COMT_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$COMT_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$APPL_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$APPL_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$FVER_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FVER_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$SSND_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$SSND_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$MARK_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$MARK_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$INST_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$INST_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$COMM_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$COMM_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$AIFC_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFC_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$AIFF_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFF_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$AIFFHeader$$FORM_MAGIC() {
        return AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FORM_MAGIC();
    }

    public static class Reader
    implements AudioFileHeaderReader,
    ScalaObject {
        public AudioFileHeader read(RandomAccessFile raf) throws IOException {
            return this.readDataInput(raf);
        }

        public AudioFileHeader read(DataInputStream dis) throws IOException {
            return this.readDataInput(dis);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private AudioFileHeader readDataInput(DataInput din) throws IOException {
            boolean bl;
            if (din.readInt() != AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FORM_MAGIC()) {
                throw AudioFileHeader$.MODULE$.formatError();
            }
            din.readInt();
            int n = din.readInt();
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFC_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n))) {
                bl = true;
            } else {
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFF_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n))) throw AudioFileHeader$.MODULE$.formatError();
                bl = false;
            }
            boolean isAIFC = bl;
            int chunkLen = 0;
            ReadableAudioFileHeader afh = null;
            boolean ssndFound = false;
            try {
                while (!ssndFound) {
                    Object object = chunkLen != 0 ? BoxesRunTime.boxToInteger((int)din.skipBytes(chunkLen)) : BoxedUnit.UNIT;
                    int magic = din.readInt();
                    chunkLen = din.readInt() + 1 & 0xFFFFFFFE;
                    int n2 = magic;
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$COMM_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2))) {
                        Tuple2 tuple2;
                        Tuple2 tuple22;
                        short numChannels = din.readShort();
                        long numFrames = (long)din.readInt() & 0xFFFFFFFFL;
                        short bitsPerSample = din.readShort();
                        long l1 = din.readLong();
                        int l2 = din.readUnsignedShort();
                        long l3 = l1 & 0xFFFFFFFFFFFFL;
                        int i1 = ((int)(l1 >> 48) & Short.MAX_VALUE) - 16382;
                        double sampleRate = ((double)l3 * package$.MODULE$.pow(2.0, (double)(i1 - 48)) + (double)l2 * package$.MODULE$.pow(2.0, (double)(i1 - 64))) * (double)package$.MODULE$.signum(l1);
                        chunkLen -= 18;
                        if (isAIFC) {
                            chunkLen -= 4;
                            int n3 = din.readInt();
                            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$NONE_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)this.intSampleFormat(bitsPerSample));
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Int16$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in24_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Int24$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in32_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Int32$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl32_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Float$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FL32_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Float$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl64_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Double$.MODULE$);
                            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FL64_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) {
                                tuple22 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)SampleFormat$Double$.MODULE$);
                            } else {
                                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16LE_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n3))) throw new IOException(new StringBuilder().append((Object)"Unsupported AIFF encoding (").append((Object)BoxesRunTime.boxToInteger((int)n3)).append((Object)")").toString());
                                tuple22 = new Tuple2((Object)ByteOrder.LITTLE_ENDIAN, (Object)SampleFormat$Int16$.MODULE$);
                            }
                        } else {
                            tuple22 = tuple2 = new Tuple2((Object)ByteOrder.BIG_ENDIAN, (Object)this.intSampleFormat(bitsPerSample));
                        }
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
                        ByteOrder byteOrder2 = (ByteOrder)tuple23._1();
                        SampleFormat sampleFormat = (SampleFormat)tuple23._2();
                        AudioFileSpec spec = new AudioFileSpec(AudioFileType$AIFF$.MODULE$, sampleFormat, numChannels, sampleRate, (Option<ByteOrder>)new Some((Object)byteOrder2), numFrames);
                        afh = new ReadableAudioFileHeader(spec, byteOrder2);
                        continue;
                    }
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$INST_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2)) || BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$MARK_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2))) continue;
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$SSND_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2))) {
                        int i1 = din.readInt();
                        din.readInt();
                        din.skipBytes(i1);
                        ssndFound = true;
                        continue;
                    }
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$APPL_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2)) || BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$COMT_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2)) || BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$ANNO_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n2))) continue;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (afh == null) {
                throw new IOException("AIFF header misses COMM chunk");
            }
            if (!ssndFound) throw new IOException("AIFF header misses SSND chunk");
            return afh;
        }

        private SampleFormat intSampleFormat(int bitsPerSample) {
            SampleFormat sampleFormat;
            int n = bitsPerSample;
            switch (n) {
                default: {
                    throw new IOException(new StringBuilder().append((Object)"Unsupported AIFF encoding (").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" bits-per-sample)").toString());
                }
                case 32: {
                    sampleFormat = SampleFormat$Int32$.MODULE$;
                    break;
                }
                case 24: {
                    sampleFormat = SampleFormat$Int24$.MODULE$;
                    break;
                }
                case 8: {
                    sampleFormat = SampleFormat$Int8$.MODULE$;
                    break;
                }
                case 16: {
                    sampleFormat = SampleFormat$Int16$.MODULE$;
                }
            }
            return sampleFormat;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Writer
    implements AudioFileHeaderWriter,
    ScalaObject {
        @Override
        public WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
            Tuple3<Object, Object, AudioFileSpec> tuple3 = this.writeDataOutput(raf, spec);
            if (tuple3 != null) {
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                int otherLen = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int commLen = BoxesRunTime.unboxToInt((Object)tuple32._2());
                AudioFileSpec spec1 = (AudioFileSpec)tuple32._3();
                return new WritableFileHeader(raf, spec1, otherLen, commLen);
            }
            throw new MatchError(tuple3);
        }

        @Override
        public WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
            Tuple3<Object, Object, AudioFileSpec> tuple3 = this.writeDataOutput(dos, spec);
            if (tuple3 != null) {
                AudioFileSpec spec1 = (AudioFileSpec)tuple3._3();
                return new WritableStreamHeader(spec1);
            }
            throw new MatchError(tuple3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Tuple3<Object, Object, AudioFileSpec> writeDataOutput(DataOutput dout, AudioFileSpec spec) throws IOException {
            Object object;
            boolean bl;
            ByteOrder byteOrder2;
            SampleFormat smpForm = spec.sampleFormat();
            int bitsPerSample = smpForm.bitsPerSample();
            double sr = spec.sampleRate();
            long numFrames = spec.numFrames();
            int numChannels = spec.numChannels();
            ByteOrder byteOrder3 = byteOrder2 = (ByteOrder)spec.byteOrder().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteOrder apply() {
                    return ByteOrder.BIG_ENDIAN;
                }
            });
            ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null)) {
                SampleFormat sampleFormat = spec.sampleFormat();
                SampleFormat$Int16$ sampleFormat$Int16$ = SampleFormat$Int16$.MODULE$;
                if (sampleFormat != null ? !sampleFormat.equals(sampleFormat$Int16$) : sampleFormat$Int16$ != null) throw new IOException("AIFF little endian only supported for Int16");
                bl = true;
            } else {
                bl = false;
            }
            boolean le16 = bl;
            SampleFormat sampleFormat = smpForm;
            SampleFormat$Float$ sampleFormat$Float$ = SampleFormat$Float$.MODULE$;
            if (!(sampleFormat != null ? !sampleFormat.equals(sampleFormat$Float$) : sampleFormat$Float$ != null)) {
                object = AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl32_HUMAN();
            } else {
                SampleFormat sampleFormat2 = smpForm;
                SampleFormat$Double$ sampleFormat$Double$ = SampleFormat$Double$.MODULE$;
                object = !(sampleFormat2 != null ? !sampleFormat2.equals(sampleFormat$Double$) : sampleFormat$Double$ != null) ? AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$fl64_HUMAN() : (Object)(le16 ? AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$in16_HUMAN() : null);
            }
            byte[] aifcExt = object;
            boolean isAIFC = aifcExt != null;
            int otherLen = isAIFC ? 24 : 12;
            int commLen = isAIFC ? 26 + Predef$.MODULE$.byteArrayOps(aifcExt).size() : 26;
            long ssndLen = (long)(bitsPerSample >> 3) * numFrames * (long)numChannels + 16L;
            long fileLen = (long)(otherLen + commLen) + ssndLen;
            dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FORM_MAGIC());
            dout.writeInt((int)(fileLen - 8L));
            if (isAIFC) {
                dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFC_MAGIC());
                dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$FVER_MAGIC());
                dout.writeInt(4);
                dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFCVersion1());
            } else {
                dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$AIFF_MAGIC());
            }
            dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$COMM_MAGIC());
            dout.writeInt(commLen - 8);
            dout.writeShort(numChannels);
            dout.writeInt((int)numFrames);
            dout.writeShort(isAIFC ? 16 : bitsPerSample);
            int srs = sr < 0.0 ? 128 : 0;
            double sra = package$.MODULE$.abs(sr);
            int srl = (int)(package$.MODULE$.log(sra) * AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$LN2R() + (double)16383) & 0xFFFF;
            double sre = sra * (double)(1 << 16414 - srl);
            dout.writeShort(((srs | srl >> 8) & 0xFF) << 8 | srl & 0xFF);
            dout.writeInt((int)sre);
            dout.writeInt((int)(sre % 1.0 * (double)0x100000000L));
            if (isAIFC) {
                dout.write(aifcExt);
            }
            dout.writeInt(AIFFHeader$.MODULE$.de$sciss$synth$io$impl$AIFFHeader$$SSND_MAGIC());
            dout.writeInt((int)(ssndLen - 8L));
            dout.writeInt(0);
            dout.writeInt(0);
            Some x$3 = new Some((Object)byteOrder2);
            AudioFileType x$4 = spec.copy$default$1();
            SampleFormat x$5 = spec.copy$default$2();
            int x$6 = spec.copy$default$3();
            double x$7 = spec.copy$default$4();
            long x$8 = spec.copy$default$6();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)otherLen), (Object)BoxesRunTime.boxToInteger((int)commLen), (Object)spec.copy(x$4, x$5, x$6, x$7, (Option)x$3, x$8));
        }
    }

    public static class WritableFileHeader
    implements WritableAudioFileHeader,
    ScalaObject {
        private final RandomAccessFile raf;
        private final AudioFileSpec spec0;
        private final int otherLen;
        private final int commLen;
        private long numFrames0;

        private long numFrames0() {
            return this.numFrames0;
        }

        private void numFrames0_$eq(long l) {
            this.numFrames0 = l;
        }

        public void update(long numFrames) throws IOException {
            if (numFrames == this.spec().numFrames()) {
                return;
            }
            long ssndLen = (long)(this.spec().sampleFormat().bitsPerSample() >> 3) * numFrames * (long)this.spec().numChannels() + 16L;
            long oldPos = this.raf.getFilePointer();
            this.raf.seek(4L);
            long fileLen = (long)(this.otherLen + this.commLen) + ssndLen;
            this.raf.writeInt((int)(fileLen - 8L));
            this.raf.seek(this.otherLen + 10);
            this.raf.writeInt((int)numFrames);
            this.raf.seek(this.otherLen + this.commLen + 4);
            this.raf.writeInt((int)(ssndLen - 8L));
            this.raf.seek(oldPos);
            this.numFrames0_$eq(numFrames);
        }

        public AudioFileSpec spec() {
            long x$9 = this.numFrames0();
            AudioFileType x$10 = this.spec0.copy$default$1();
            SampleFormat x$11 = this.spec0.copy$default$2();
            int x$12 = this.spec0.copy$default$3();
            double x$13 = this.spec0.copy$default$4();
            Option x$14 = this.spec0.copy$default$5();
            return this.spec0.copy(x$10, x$11, x$12, x$13, x$14, x$9);
        }

        public ByteOrder byteOrder() {
            return (ByteOrder)this.spec0.byteOrder().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteOrder apply() {
                    return ByteOrder.BIG_ENDIAN;
                }
            });
        }

        public WritableFileHeader(RandomAccessFile raf, AudioFileSpec spec0, int otherLen, int commLen) {
            this.raf = raf;
            this.spec0 = spec0;
            this.otherLen = otherLen;
            this.commLen = commLen;
            this.numFrames0 = spec0.numFrames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WritableStreamHeader
    implements WritableAudioFileHeader,
    Product,
    Serializable {
        private final AudioFileSpec spec;

        public Iterator<Object> productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Iterator<Object> productElements() {
            return Product.class.productElements((Product)this);
        }

        @Override
        public AudioFileSpec spec() {
            return this.spec;
        }

        @Override
        public void update(long numFrames) throws IOException {
            if (numFrames == this.spec().numFrames()) {
                return;
            }
            throw ScalaAudioFile$.MODULE$.opNotSupported();
        }

        @Override
        public ByteOrder byteOrder() {
            return (ByteOrder)this.spec().byteOrder().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteOrder apply() {
                    return ByteOrder.BIG_ENDIAN;
                }
            });
        }

        public AudioFileSpec copy$default$1() {
            return this.spec();
        }

        public WritableStreamHeader copy(AudioFileSpec spec) {
            return new WritableStreamHeader(spec);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof WritableStreamHeader)) return false;
            WritableStreamHeader writableStreamHeader = (WritableStreamHeader)object2;
            AudioFileSpec audioFileSpec = writableStreamHeader.spec();
            AudioFileSpec spec$1 = audioFileSpec;
            if (!this.gd1$1(spec$1)) return false;
            boolean bl = ((WritableStreamHeader)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "WritableStreamHeader";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (n2 == 0) {
                return this.spec();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        }

        public boolean canEqual(Object object) {
            return object instanceof WritableStreamHeader;
        }

        private final boolean gd1$1(AudioFileSpec audioFileSpec) {
            AudioFileSpec audioFileSpec2 = audioFileSpec;
            AudioFileSpec audioFileSpec3 = this.spec();
            return !(audioFileSpec2 != null ? !((Object)audioFileSpec2).equals(audioFileSpec3) : audioFileSpec3 != null);
        }

        public WritableStreamHeader(AudioFileSpec spec) {
            this.spec = spec;
            Product.class.$init$((Product)this);
        }
    }
}

