/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.io.impl;

import de.sciss.synth.io.AudioFileHeader;
import de.sciss.synth.io.AudioFileHeader$;
import de.sciss.synth.io.AudioFileHeaderReader;
import de.sciss.synth.io.AudioFileHeaderWriter;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.AudioFileType;
import de.sciss.synth.io.AudioFileType$IRCAM$;
import de.sciss.synth.io.ReadableAudioFileHeader;
import de.sciss.synth.io.SampleFormat;
import de.sciss.synth.io.SampleFormat$Double$;
import de.sciss.synth.io.SampleFormat$Float$;
import de.sciss.synth.io.SampleFormat$Int16$;
import de.sciss.synth.io.SampleFormat$Int24$;
import de.sciss.synth.io.SampleFormat$Int32$;
import de.sciss.synth.io.SampleFormat$Int8$;
import de.sciss.synth.io.WritableAudioFileHeader;
import de.sciss.synth.io.impl.IRCAMHeader$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import scala.Function0;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005UwAB\u0001\u0003\u0011\u000b!A\"A\u0006J%\u000e\u000bU\nS3bI\u0016\u0014(BA\u0002\u0005\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"A\u0003ts:$\bN\u0003\u0002\n\u0015\u0005)1oY5tg*\t1\"\u0001\u0002eKB\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0003\tA\u00111\"\u0013*D\u00036CU-\u00193feN!a\"E\r\u001e!\t\u0011r#D\u0001\u0014\u0015\t!R#\u0001\u0003mC:<'\"\u0001\f\u0002\t)\fg/Y\u0005\u00031M\u0011aa\u00142kK\u000e$\bC\u0001\u000e\u001c\u001b\u0005!\u0011B\u0001\u000f\u0005\u0005Y\tU\u000fZ5p\r&dW\rS3bI\u0016\u0014h)Y2u_JL\bC\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"aC*dC2\fwJ\u00196fGRDQ\u0001\n\b\u0005\u0002\u0019\na\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0019!9\u0001F\u0004b\u0001\n\u0013I\u0013!E%S\u0007\u0006kuLV!Y\u0019\u0016{V*Q$J\u0007V\t!\u0006\u0005\u0002\u001fW%\u0011Af\b\u0002\u0004\u0013:$\bB\u0002\u0018\u000fA\u0003%!&\u0001\nJ%\u000e\u000bUj\u0018,B12+u,T!H\u0013\u000e\u0003\u0003b\u0002\u0019\u000f\u0005\u0004%I!K\u0001\u0012\u0013J\u001b\u0015)T0W\u0003b\u0013UiX'B\u000f&\u001b\u0005B\u0002\u001a\u000fA\u0003%!&\u0001\nJ%\u000e\u000bUj\u0018,B1\n+u,T!H\u0013\u000e\u0003\u0003b\u0002\u001b\u000f\u0005\u0004%I!K\u0001\u0012\u0013J\u001b\u0015)T0T+:\u0013UiX'B\u000f&\u001b\u0005B\u0002\u001c\u000fA\u0003%!&\u0001\nJ%\u000e\u000bUjX*V\u001d\n+u,T!H\u0013\u000e\u0003\u0003b\u0002\u001d\u000f\u0005\u0004%I!K\u0001\u0012\u0013J\u001b\u0015)T0T+:cUiX'B\u000f&\u001b\u0005B\u0002\u001e\u000fA\u0003%!&\u0001\nJ%\u000e\u000bUjX*V\u001d2+u,T!H\u0013\u000e\u0003\u0003b\u0002\u001f\u000f\u0005\u0004%I!K\u0001\u0013\u0013J\u001b\u0015)T0N\u0013B\u001bF*R0N\u0003\u001eK5\t\u0003\u0004?\u001d\u0001\u0006IAK\u0001\u0014\u0013J\u001b\u0015)T0N\u0013B\u001bF*R0N\u0003\u001eK5\t\t\u0005\b\u0001:\u0011\r\u0011\"\u0003*\u0003II%kQ!N?6K\u0005k\u0015\"F?6\u000bu)S\"\t\r\ts\u0001\u0015!\u0003+\u0003MI%kQ!N?6K\u0005k\u0015\"F?6\u000bu)S\"!\u0011\u001d!eB1A\u0005\n%\n!#\u0013*D\u00036{f*\u0012-U\u0005\u0016{V*Q$J\u0007\"1aI\u0004Q\u0001\n)\n1#\u0013*D\u00036{f*\u0012-U\u0005\u0016{V*Q$J\u0007\u0002Bq\u0001\u0013\bC\u0002\u0013%\u0011&A\u0005C\u0013\u000e\u001bfiX#O\t\"1!J\u0004Q\u0001\n)\n!BQ%D'\u001a{VI\u0014#!\u0011\u001daeB1A\u0005\n%\naBQ%D'\u001a{F*\u0013(L\u0007>#U\t\u0003\u0004O\u001d\u0001\u0006IAK\u0001\u0010\u0005&\u001b5KR0M\u0013:[5i\u0014#FA!9\u0001K\u0004b\u0001\n\u0013I\u0013!\u0005\"J\u0007N3uLV%S)V\u000bEjQ(E\u000b\"1!K\u0004Q\u0001\n)\n!CQ%D'\u001a{f+\u0013*U+\u0006c5i\u0014#FA!)AK\u0004C\u0001+\u0006\u00112M]3bi\u0016DU-\u00193feJ+\u0017\rZ3s+\u00051\u0006c\u0001\u0010X3&\u0011\u0001l\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005iQ\u0016BA.\u0005\u0005U\tU\u000fZ5p\r&dW\rS3bI\u0016\u0014(+Z1eKJDQ!\u0018\b\u0005\u0002y\u000b!c\u0019:fCR,\u0007*Z1eKJ<&/\u001b;feV\tq\fE\u0002\u001f/\u0002\u0004\"AG1\n\u0005\t$!!F!vI&|g)\u001b7f\u0011\u0016\fG-\u001a:Xe&$XM\u001d\u0005\u0006I:!\t!Z\u0001\tS\u0012,g\u000e^5gsR\u0011a-\u001b\t\u0003=\u001dL!\u0001[\u0010\u0003\u000f\t{w\u000e\\3b]\")!n\u0019a\u0001W\u0006\u0019A-[:\u0011\u00051tW\"A7\u000b\u0005\u0015)\u0012BA8n\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007fA2riB\u0011aD]\u0005\u0003g~\u0011a\u0001\u001e5s_^\u001c8%A;\u0011\u000514\u0018BA<n\u0005-Iu*\u0012=dKB$\u0018n\u001c8\u0007\tetAA\u001f\u0002\u0007%\u0016\fG-\u001a:\u0014\ta\f\u0012,\b\u0005\u0006Ia$\t\u0001 \u000b\u0002{B\u0011a\u0010_\u0007\u0002\u001d!9\u0011\u0011\u0001=\u0005\u0002\u0005\r\u0011\u0001\u0002:fC\u0012$B!!\u0002\u0002\fA\u0019!$a\u0002\n\u0007\u0005%AAA\bBk\u0012LwNR5mK\"+\u0017\rZ3s\u0011\u001d\tia a\u0001\u0003\u001f\t1A]1g!\ra\u0017\u0011C\u0005\u0004\u0003'i'\u0001\u0005*b]\u0012|W.Q2dKN\u001ch)\u001b7fQ\ry\u0018\u000f\u001e\u0005\b\u0003\u0003AH\u0011AA\r)\u0011\t)!a\u0007\t\r)\f9\u00021\u0001lQ\u0011\t9\"\u001d;\t\u000f\u0005\u0005\u0002\u0010\"\u0003\u0002$\u0005i!/Z1e\t\u0006$\u0018-\u00138qkR$b!!\u0002\u0002&\u0005=\u0002\u0002CA\u0014\u0003?\u0001\r!!\u000b\u0002\u0007\u0011Lg\u000eE\u0002m\u0003WI1!!\fn\u0005%!\u0015\r^1J]B,H\u000f\u0003\u0005\u00022\u0005}\u0001\u0019AA\u001a\u0003\u001d1\u0017\u000e\\3MK:\u00042AHA\u001b\u0013\r\t9d\b\u0002\u0005\u0019>tw\r\u000b\u0003\u0002 E$hABA\u001f\u001d\u0011\tyD\u0001\u0004Xe&$XM]\n\u0006\u0003w\t\u0002-\b\u0005\bI\u0005mB\u0011AA\")\t\t)\u0005E\u0002\u007f\u0003wA\u0001\"!\u0013\u0002<\u0011\u0005\u00111J\u0001\u0006oJLG/\u001a\u000b\u0007\u0003\u001b\n\u0019&!\u0016\u0011\u0007i\ty%C\u0002\u0002R\u0011\u0011qc\u0016:ji\u0006\u0014G.Z!vI&|g)\u001b7f\u0011\u0016\fG-\u001a:\t\u0011\u00055\u0011q\ta\u0001\u0003\u001fA\u0001\"a\u0016\u0002H\u0001\u0007\u0011\u0011L\u0001\u0005gB,7\rE\u0002\u001b\u00037J1!!\u0018\u0005\u00055\tU\u000fZ5p\r&dWm\u00159fG\"\"\u0011qI9u\u0011!\tI%a\u000f\u0005\u0002\u0005\rDCBA'\u0003K\ny\u0007\u0003\u0005\u0002h\u0005\u0005\u0004\u0019AA5\u0003\r!wn\u001d\t\u0004Y\u0006-\u0014bAA7[\n\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003/\n\t\u00071\u0001\u0002Z!\"\u0011\u0011M9u\u0011!\t)(a\u000f\u0005\n\u0005]\u0014aD<sSR,G)\u0019;b\u001fV$\b/\u001e;\u0015\r\u0005e\u0013\u0011PAB\u0011!\tY(a\u001dA\u0002\u0005u\u0014\u0001\u00023pkR\u00042\u0001\\A@\u0013\r\t\t)\u001c\u0002\u000b\t\u0006$\u0018mT;uaV$\b\u0002CA,\u0003g\u0002\r!!\u0017)\t\u0005M\u0014\u000f\u001e\u0004\u0007\u0003\u0013sA!a#\u0003\u001d]\u0013\u0018\u000e^1cY\u0016DU-\u00193feN1\u0011qQ\t\u0002NuA1\"a$\u0002\b\n\u0005\t\u0015!\u0003\u0002Z\u0005)1\u000f]3da!9A%a\"\u0005\u0002\u0005ME\u0003BAK\u0003/\u00032A`AD\u0011!\ty)!%A\u0002\u0005e\u0003BCAN\u0003\u000f\u0003\r\u0011\"\u0003\u0002\u001e\u0006Qa.^7Ge\u0006lWm\u001d\u0019\u0016\u0005\u0005M\u0002BCAQ\u0003\u000f\u0003\r\u0011\"\u0003\u0002$\u0006qa.^7Ge\u0006lWm\u001d\u0019`I\u0015\fH\u0003BAS\u0003W\u00032AHAT\u0013\r\tIk\b\u0002\u0005+:LG\u000f\u0003\u0006\u0002.\u0006}\u0015\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u0011%\t\t,a\"!B\u0013\t\u0019$A\u0006ok64%/Y7fgB\u0002\u0003\u0002CA[\u0003\u000f#\t!a.\u0002\rU\u0004H-\u0019;f)\u0011\t)+!/\t\u0011\u0005m\u00161\u0017a\u0001\u0003g\t\u0011B\\;n\rJ\fW.Z:)\t\u0005M\u0016\u000f\u001e\u0005\t\u0003/\n9\t\"\u0001\u0002BV\u0011\u0011\u0011\f\u0005\t\u0003\u000b\f9\t\"\u0001\u0002H\u0006I!-\u001f;f\u001fJ$WM]\u000b\u0003\u0003\u0013\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f,\u0012a\u00018j_&!\u00111[Ag\u0005%\u0011\u0015\u0010^3Pe\u0012,'\u000f")
public final class IRCAMHeader {
    public static final boolean identify(DataInputStream dataInputStream) throws IOException {
        return IRCAMHeader$.MODULE$.identify(dataInputStream);
    }

    public static final Option<AudioFileHeaderWriter> createHeaderWriter() {
        return IRCAMHeader$.MODULE$.createHeaderWriter();
    }

    public static final Option<AudioFileHeaderReader> createHeaderReader() {
        return IRCAMHeader$.MODULE$.createHeaderReader();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$BICSF_VIRTUALCODE() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_VIRTUALCODE();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$BICSF_LINKCODE() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_LINKCODE();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$BICSF_END() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_END();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_NEXTBE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_NEXTBE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSBE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSBE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSLE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSLE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNLE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNLE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNBE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNBE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXBE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXBE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXLE_MAGIC() {
        return IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXLE_MAGIC();
    }

    public static class Reader
    implements AudioFileHeaderReader,
    ScalaObject {
        public AudioFileHeader read(RandomAccessFile raf) throws IOException {
            return this.readDataInput(raf, raf.length());
        }

        public AudioFileHeader read(DataInputStream dis) throws IOException {
            return this.readDataInput(dis, dis.available());
        }

        private AudioFileHeader readDataInput(DataInput din, long fileLen) throws IOException {
            block19: {
                SampleFormat sampleFormat;
                AudioFileHeader.DataInputReader dataInputReader;
                block18: {
                    int magic;
                    block17: {
                        magic = din.readInt();
                        if (magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXLE_MAGIC() && magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNLE_MAGIC() && magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSLE_MAGIC()) break block17;
                        dataInputReader = new AudioFileHeader.LittleDataInputReader(din);
                        break block18;
                    }
                    if (magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXBE_MAGIC() && magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNBE_MAGIC() && magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_MIPSBE_MAGIC() && magic != IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_NEXTBE_MAGIC()) break block19;
                    dataInputReader = new AudioFileHeader.BigDataInputReader(din);
                }
                AudioFileHeader.LittleDataInputReader reader = dataInputReader;
                float sampleRate = ((AudioFileHeader.DataInputReader)reader).readFloat();
                int numChannels = ((AudioFileHeader.DataInputReader)reader).readInt();
                int n = ((AudioFileHeader.DataInputReader)reader).readInt();
                switch (n) {
                    default: {
                        throw new IOException(new StringBuilder().append((Object)"Unsupported IRCAM encoding (").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)")").toString());
                    }
                    case 4: {
                        sampleFormat = SampleFormat$Float$.MODULE$;
                        break;
                    }
                    case 8: {
                        sampleFormat = SampleFormat$Double$.MODULE$;
                        break;
                    }
                    case 3: {
                        sampleFormat = SampleFormat$Int24$.MODULE$;
                        break;
                    }
                    case 2: {
                        sampleFormat = SampleFormat$Int16$.MODULE$;
                        break;
                    }
                    case 262148: {
                        sampleFormat = SampleFormat$Int32$.MODULE$;
                        break;
                    }
                    case 1: {
                        sampleFormat = SampleFormat$Int8$.MODULE$;
                    }
                }
                SampleFormat sampleFormat2 = sampleFormat;
                boolean done = false;
                long pos = 16L;
                while (true) {
                    if (done) {
                        long dataOffset = pos + 1023L & (0x3FFL ^ 0xFFFFFFFFFFFFFFFFL);
                        int skp = (int)(dataOffset - pos);
                        Object object = skp > 0 ? BoxesRunTime.boxToInteger((int)din.skipBytes(skp)) : BoxedUnit.UNIT;
                        int frameSize = (sampleFormat2.bitsPerSample() + 7 >> 3) * numChannels;
                        long numFrames = package$.MODULE$.max(0L, fileLen - dataOffset) / (long)frameSize;
                        AudioFileSpec spec = new AudioFileSpec(AudioFileType$IRCAM$.MODULE$, sampleFormat2, numChannels, sampleRate, (Option<ByteOrder>)new Some((Object)((AudioFileHeader.DataInputReader)reader).byteOrder()), numFrames);
                        return new ReadableAudioFileHeader(spec, ((AudioFileHeader.DataInputReader)reader).byteOrder());
                    }
                    int i = ((AudioFileHeader.DataInputReader)reader).readInt();
                    int sz = i & 0xFFFF;
                    int id = i >> 16;
                    if (id == IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_END()) {
                        done = true;
                    } else {
                        if (id == IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_LINKCODE()) {
                            throw new IOException("Unsupported IRCAM feature (LINKCODE)");
                        }
                        if (id == IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_VIRTUALCODE()) {
                            throw new IOException("Unsupported IRCAM feature (VIRTUALCODE)");
                        }
                    }
                    Object object = sz > 0 ? BoxesRunTime.boxToInteger((int)din.skipBytes(sz)) : BoxedUnit.UNIT;
                    pos += (long)(4 + sz);
                }
            }
            throw AudioFileHeader$.MODULE$.formatError();
        }
    }

    public static class Writer
    implements AudioFileHeaderWriter,
    ScalaObject {
        public WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
            AudioFileSpec spec1 = this.writeDataOutput(raf, spec);
            return new WritableHeader(spec1);
        }

        public WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
            AudioFileSpec spec1 = this.writeDataOutput(dos, spec);
            return new WritableHeader(spec1);
        }

        private AudioFileSpec writeDataOutput(DataOutput dout, AudioFileSpec spec) throws IOException {
            ByteOrder byteOrder2;
            AudioFileHeader.DataOutputWriter writer = AudioFileHeader$.MODULE$.dataOutputWriter(dout, (ByteOrder)spec.byteOrder().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteOrder apply() {
                    return ByteOrder.nativeOrder();
                }
            }));
            ByteOrder byteOrder3 = byteOrder2 = (ByteOrder)spec.byteOrder().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteOrder apply() {
                    return ByteOrder.nativeOrder();
                }
            });
            ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
            dout.writeInt(!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null) ? IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_VAXLE_MAGIC() : IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$IRCAM_SUNBE_MAGIC());
            writer.writeFloat((float)spec.sampleRate());
            writer.writeInt(spec.numChannels());
            SampleFormat sampleFormat = spec.sampleFormat();
            SampleFormat$Float$ sampleFormat$Float$ = SampleFormat$Float$.MODULE$;
            writer.writeInt(!(sampleFormat != null ? !sampleFormat.equals(sampleFormat$Float$) : sampleFormat$Float$ != null) ? 262148 : spec.sampleFormat().bitsPerSample() >> 3);
            long pos = 16L;
            writer.writeInt(IRCAMHeader$.MODULE$.de$sciss$synth$io$impl$IRCAMHeader$$BICSF_END() << 16);
            long dataOffset = (pos += 4L) + 1023L & (0x3FFL ^ 0xFFFFFFFFFFFFFFFFL);
            int skp = (int)(dataOffset - pos);
            if (skp > 0) {
                dout.write(new byte[skp]);
            }
            Some x$1 = new Some((Object)byteOrder2);
            AudioFileType x$2 = spec.copy$default$1();
            SampleFormat x$3 = spec.copy$default$2();
            int x$4 = spec.copy$default$3();
            double x$5 = spec.copy$default$4();
            long x$6 = spec.copy$default$6();
            return spec.copy(x$2, x$3, x$4, x$5, (Option)x$1, x$6);
        }
    }

    public static class WritableHeader
    implements WritableAudioFileHeader,
    ScalaObject {
        private final AudioFileSpec spec0;
        private long numFrames0;

        private long numFrames0() {
            return this.numFrames0;
        }

        private void numFrames0_$eq(long l) {
            this.numFrames0 = l;
        }

        public void update(long numFrames) throws IOException {
            this.numFrames0_$eq(numFrames);
        }

        public AudioFileSpec spec() {
            long x$7 = this.numFrames0();
            AudioFileType x$8 = this.spec0.copy$default$1();
            SampleFormat x$9 = this.spec0.copy$default$2();
            int x$10 = this.spec0.copy$default$3();
            double x$11 = this.spec0.copy$default$4();
            Option x$12 = this.spec0.copy$default$5();
            return this.spec0.copy(x$8, x$9, x$10, x$11, x$12, x$7);
        }

        public ByteOrder byteOrder() {
            return (ByteOrder)this.spec0.byteOrder().get();
        }

        public WritableHeader(AudioFileSpec spec0) {
            this.spec0 = spec0;
            this.numFrames0 = spec0.numFrames();
        }
    }
}

