/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.synth.io.impl;

import de.sciss.synth.io.AudioFileHeader;
import de.sciss.synth.io.AudioFileHeader$;
import de.sciss.synth.io.AudioFileHeaderReader;
import de.sciss.synth.io.AudioFileHeaderWriter;
import de.sciss.synth.io.AudioFileSpec;
import de.sciss.synth.io.AudioFileType$Wave$;
import de.sciss.synth.io.ReadableAudioFileHeader;
import de.sciss.synth.io.SampleFormat;
import de.sciss.synth.io.SampleFormat$Double$;
import de.sciss.synth.io.SampleFormat$Float$;
import de.sciss.synth.io.SampleFormat$Int16$;
import de.sciss.synth.io.SampleFormat$Int24$;
import de.sciss.synth.io.SampleFormat$Int32$;
import de.sciss.synth.io.SampleFormat$Int8$;
import de.sciss.synth.io.SampleFormat$UInt8$;
import de.sciss.synth.io.impl.WaveHeader$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]rAB\u0001\u0003\u0011\u000b!A\"\u0001\u0006XCZ,\u0007*Z1eKJT!a\u0001\u0003\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011!B:z]RD'BA\u0005\u000b\u0003\u0015\u00198-[:t\u0015\u0005Y\u0011A\u00013f!\tia\"D\u0001\u0003\r\u0019y!\u0001#\u0002\u0005!\tQq+\u0019<f\u0011\u0016\fG-\u001a:\u0014\u000b9\t\u0012$\b\u0011\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012\u0001\u00027b]\u001eT\u0011AF\u0001\u0005U\u00064\u0018-\u0003\u0002\u0019'\t1qJ\u00196fGR\u0004\"AG\u000e\u000e\u0003\u0011I!\u0001\b\u0003\u0003-\u0005+H-[8GS2,\u0007*Z1eKJ4\u0015m\u0019;pef\u0004\"!\u0004\u0010\n\u0005}\u0011!AE!cgR\u0014\u0018m\u0019;S\u0013\u001a3\u0005*Z1eKJ\u0004\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121bU2bY\u0006|%M[3di\")qE\u0004C\u0001S\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\r\u0011\u001dYcB1A\u0005\n1\n!BU%G\r~k\u0015iR%D+\u0005i\u0003CA\u0011/\u0013\ty#EA\u0002J]RDa!\r\b!\u0002\u0013i\u0013a\u0003*J\r\u001a{V*Q$J\u0007\u0002Bqa\r\bC\u0002\u0013%A&\u0001\u0006X\u0003Z+u,T!H\u0013\u000eCa!\u000e\b!\u0002\u0013i\u0013aC,B-\u0016{V*Q$J\u0007\u0002Bqa\u000e\bC\u0002\u0013%A&A\u0005G\u001bR{V*Q$J\u0007\"1\u0011H\u0004Q\u0001\n5\n!BR'U?6\u000bu)S\"!\u0011\u001dYdB1A\u0005\n1\n!BR!D)~k\u0015iR%D\u0011\u0019id\u0002)A\u0005[\u0005Ya)Q\"U?6\u000bu)S\"!\u0011\u001dydB1A\u0005\n1\n!\u0002R!U\u0003~k\u0015iR%D\u0011\u0019\te\u0002)A\u0005[\u0005YA)\u0011+B?6\u000bu)S\"!\u0011\u001d\u0019eB1A\u0005\n1\n\u0011bQ+F?6\u000bu)S\"\t\r\u0015s\u0001\u0015!\u0003.\u0003)\u0019U+R0N\u0003\u001eK5\t\t\u0005\b\u000f:\u0011\r\u0011\"\u0003-\u0003)\u0019V\n\u0015'`\u001b\u0006;\u0015j\u0011\u0005\u0007\u0013:\u0001\u000b\u0011B\u0017\u0002\u0017Mk\u0005\u000bT0N\u0003\u001eK5\t\t\u0005\b\u0017:\u0011\r\u0011\"\u0003-\u0003)Iej\u0015+`\u001b\u0006;\u0015j\u0011\u0005\u0007\u001b:\u0001\u000b\u0011B\u0017\u0002\u0017%s5\u000bV0N\u0003\u001eK5\t\t\u0005\b\u001f:\u0011\r\u0011\"\u0003-\u0003)a\u0015j\u0015+`\u001b\u0006;\u0015j\u0011\u0005\u0007#:\u0001\u000b\u0011B\u0017\u0002\u00171K5\u000bV0N\u0003\u001eK5\t\t\u0005\b':\u0011\r\u0011\"\u0003-\u0003-a\u0015j\u0015+`\u001b\u0006;\u0015j\u0011\u001a\t\rUs\u0001\u0015!\u0003.\u00031a\u0015j\u0015+`\u001b\u0006;\u0015j\u0011\u001a!\u0011\u00159f\u0002\"\u0001Y\u0003I\u0019'/Z1uK\"+\u0017\rZ3s%\u0016\fG-\u001a:\u0016\u0003e\u00032!\t.]\u0013\tY&E\u0001\u0004PaRLwN\u001c\t\u00035uK!A\u0018\u0003\u0003+\u0005+H-[8GS2,\u0007*Z1eKJ\u0014V-\u00193fe\")\u0001M\u0004C\u0001C\u0006\u00112M]3bi\u0016DU-\u00193fe^\u0013\u0018\u000e^3s+\u0005\u0011\u0007cA\u0011[GB\u0011!\u0004Z\u0005\u0003K\u0012\u0011Q#Q;eS>4\u0015\u000e\\3IK\u0006$WM],sSR,'\u000fC\u0003h\u001d\u0011\u0005\u0001.\u0001\u0005jI\u0016tG/\u001b4z)\tIG\u000e\u0005\u0002\"U&\u00111N\t\u0002\b\u0005>|G.Z1o\u0011\u0015ig\r1\u0001o\u0003\r!\u0017n\u001d\t\u0003_Fl\u0011\u0001\u001d\u0006\u0003\u000bUI!A\u001d9\u0003\u001f\u0011\u000bG/Y%oaV$8\u000b\u001e:fC6D3A\u001a;x!\t\tS/\u0003\u0002wE\t1A\u000f\u001b:poN\u001c\u0013\u0001\u001f\t\u0003_fL!A\u001f9\u0003\u0017%{U\t_2faRLwN\u001c\u0004\u0005y:!QP\u0001\u0004SK\u0006$WM]\n\u0005wFa\u0006\u0005C\u0003(w\u0012\u0005q\u0010\u0006\u0002\u0002\u0002A\u0019\u00111A>\u000e\u00039Aq!a\u0002|\t\u0003\tI!\u0001\u0003sK\u0006$G\u0003BA\u0006\u0003#\u00012AGA\u0007\u0013\r\ty\u0001\u0002\u0002\u0010\u0003V$\u0017n\u001c$jY\u0016DU-\u00193fe\"A\u00111CA\u0003\u0001\u0004\t)\"A\u0002sC\u001a\u00042a\\A\f\u0013\r\tI\u0002\u001d\u0002\u0011%\u0006tGm\\7BG\u000e,7o\u001d$jY\u0016DC!!\u0002uo\"9\u0011qA>\u0005\u0002\u0005}A\u0003BA\u0006\u0003CAa!\\A\u000f\u0001\u0004q\u0007\u0006BA\u000fi^Dq!a\n|\t\u0013\tI#A\u0007sK\u0006$G)\u0019;b\u0013:\u0004X\u000f\u001e\u000b\u0005\u0003\u0017\tY\u0003\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u0003\r!\u0017N\u001c\t\u0004_\u0006E\u0012bAA\u001aa\nIA)\u0019;b\u0013:\u0004X\u000f\u001e\u0015\u0005\u0003K!x\u000f")
public final class WaveHeader {
    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_EXT_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_EXT_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_FLOAT_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_FLOAT_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_PCM_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$FORMAT_PCM_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$RGN_MAGIC_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$RGN_MAGIC_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$LTXT_MAGIC_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$LTXT_MAGIC_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$LABL_MAGIC_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$LABL_MAGIC_$eq(n);
    }

    public static final void de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$ADTL_MAGIC_$eq(int n) {
        WaveHeader$.MODULE$.de$sciss$synth$io$impl$AbstractRIFFHeader$_setter_$ADTL_MAGIC_$eq(n);
    }

    public static final int FORMAT_EXT() {
        return WaveHeader$.MODULE$.FORMAT_EXT();
    }

    public static final int FORMAT_FLOAT() {
        return WaveHeader$.MODULE$.FORMAT_FLOAT();
    }

    public static final int FORMAT_PCM() {
        return WaveHeader$.MODULE$.FORMAT_PCM();
    }

    public static final int RGN_MAGIC() {
        return WaveHeader$.MODULE$.RGN_MAGIC();
    }

    public static final int LTXT_MAGIC() {
        return WaveHeader$.MODULE$.LTXT_MAGIC();
    }

    public static final int LABL_MAGIC() {
        return WaveHeader$.MODULE$.LABL_MAGIC();
    }

    public static final int ADTL_MAGIC() {
        return WaveHeader$.MODULE$.ADTL_MAGIC();
    }

    public static final boolean identify(DataInputStream dataInputStream) throws IOException {
        return WaveHeader$.MODULE$.identify(dataInputStream);
    }

    public static final Option<AudioFileHeaderWriter> createHeaderWriter() {
        return WaveHeader$.MODULE$.createHeaderWriter();
    }

    public static final Option<AudioFileHeaderReader> createHeaderReader() {
        return WaveHeader$.MODULE$.createHeaderReader();
    }

    public static final int de$sciss$synth$io$impl$WaveHeader$$DATA_MAGIC() {
        return WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$DATA_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$WaveHeader$$FMT_MAGIC() {
        return WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$FMT_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$WaveHeader$$WAVE_MAGIC() {
        return WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$WAVE_MAGIC();
    }

    public static final int de$sciss$synth$io$impl$WaveHeader$$RIFF_MAGIC() {
        return WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$RIFF_MAGIC();
    }

    public static class Reader
    implements AudioFileHeaderReader,
    ScalaObject {
        public AudioFileHeader read(RandomAccessFile raf) throws IOException {
            return this.readDataInput(raf);
        }

        public AudioFileHeader read(DataInputStream dis) throws IOException {
            return this.readDataInput(dis);
        }

        /*
         * WARNING - void declaration
         */
        private AudioFileHeader readDataInput(DataInput din) throws IOException {
            void var3_3;
            if (din.readInt() != WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$RIFF_MAGIC()) {
                throw AudioFileHeader$.MODULE$.formatError();
            }
            din.readInt();
            if (din.readInt() != WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$WAVE_MAGIC()) {
                throw AudioFileHeader$.MODULE$.formatError();
            }
            int chunkLen = 0;
            ReadableAudioFileHeader afh = null;
            int bpf = -1;
            int sampleRate = -1;
            SampleFormat sampleFormat = null;
            int numChannels = -1;
            try {
                while (afh == null) {
                    int n;
                    block27: {
                        block31: {
                            SampleFormat sampleFormat2;
                            boolean isPCM;
                            boolean unsignedPCM;
                            int bitsPerSample;
                            block29: {
                                boolean bl;
                                int n2;
                                block30: {
                                    block28: {
                                        Object object = chunkLen != 0 ? BoxesRunTime.boxToInteger((int)din.skipBytes(chunkLen)) : BoxedUnit.UNIT;
                                        int magic = din.readInt();
                                        chunkLen = AudioFileHeader$.MODULE$.readLittleInt(din) + 1 & 0xFFFFFFFE;
                                        n = magic;
                                        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$FMT_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n))) break block27;
                                        int form = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                        numChannels = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                        sampleRate = AudioFileHeader$.MODULE$.readLittleInt(din);
                                        int bps = AudioFileHeader$.MODULE$.readLittleInt(din);
                                        bpf = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                        bitsPerSample = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                        if ((bitsPerSample & 7) != 0 || (bitsPerSample >> 3) * numChannels != bpf || (bitsPerSample >> 3) * numChannels * sampleRate != bps) {
                                            throw AudioFileHeader$.MODULE$.encodingError();
                                        }
                                        unsignedPCM = bpf == 1;
                                        chunkLen -= 16;
                                        n2 = form;
                                        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)WaveHeader$.MODULE$.FORMAT_PCM()), (Object)BoxesRunTime.boxToInteger((int)n2))) break block28;
                                        bl = true;
                                        break block29;
                                    }
                                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)WaveHeader$.MODULE$.FORMAT_FLOAT()), (Object)BoxesRunTime.boxToInteger((int)n2))) break block30;
                                    bl = false;
                                    break block29;
                                }
                                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)WaveHeader$.MODULE$.FORMAT_EXT()), (Object)BoxesRunTime.boxToInteger((int)n2))) break block31;
                                if (chunkLen < 24) {
                                    throw AudioFileHeader$.MODULE$.incompleteError();
                                }
                                int i1 = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                if (i1 < 22) {
                                    throw AudioFileHeader$.MODULE$.incompleteError();
                                }
                                int i2 = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                din.readInt();
                                int i3 = AudioFileHeader$.MODULE$.readLittleUShort(din);
                                if (i2 != bitsPerSample || i3 != WaveHeader$.MODULE$.FORMAT_PCM() && i3 != WaveHeader$.MODULE$.FORMAT_FLOAT()) {
                                    throw AudioFileHeader$.MODULE$.encodingError();
                                }
                                chunkLen -= 10;
                                bl = isPCM = i3 == WaveHeader$.MODULE$.FORMAT_PCM();
                            }
                            if (isPCM) {
                                int n3 = bitsPerSample;
                                switch (n3) {
                                    default: {
                                        throw AudioFileHeader$.MODULE$.encodingError();
                                    }
                                    case 32: {
                                        sampleFormat2 = SampleFormat$Int32$.MODULE$;
                                        break;
                                    }
                                    case 24: {
                                        sampleFormat2 = SampleFormat$Int24$.MODULE$;
                                        break;
                                    }
                                    case 8: {
                                        if (unsignedPCM) {
                                            sampleFormat2 = SampleFormat$UInt8$.MODULE$;
                                            break;
                                        }
                                        sampleFormat2 = SampleFormat$Int8$.MODULE$;
                                        break;
                                    }
                                    case 16: {
                                        sampleFormat2 = SampleFormat$Int16$.MODULE$;
                                        break;
                                    }
                                }
                            } else {
                                int n4 = bitsPerSample;
                                switch (n4) {
                                    default: {
                                        throw AudioFileHeader$.MODULE$.encodingError();
                                    }
                                    case 32: {
                                        sampleFormat2 = SampleFormat$Float$.MODULE$;
                                        break;
                                    }
                                    case 64: {
                                        sampleFormat2 = SampleFormat$Double$.MODULE$;
                                    }
                                }
                            }
                            sampleFormat = sampleFormat2;
                            continue;
                        }
                        throw AudioFileHeader$.MODULE$.encodingError();
                    }
                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)WaveHeader$.MODULE$.de$sciss$synth$io$impl$WaveHeader$$DATA_MAGIC()), (Object)BoxesRunTime.boxToInteger((int)n))) continue;
                    if (bpf == -1) {
                        throw new IOException("WAVE header misses fmt chunk");
                    }
                    int numFrames = chunkLen / bpf;
                    AudioFileSpec spec = new AudioFileSpec(AudioFileType$Wave$.MODULE$, sampleFormat, numChannels, sampleRate, (Option<ByteOrder>)new Some((Object)ByteOrder.LITTLE_ENDIAN), numFrames);
                    afh = new ReadableAudioFileHeader(spec, ByteOrder.LITTLE_ENDIAN);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (afh == null) {
                throw new IOException("AIFF header misses data chunk");
            }
            return var3_3;
        }
    }
}

