/* The following code was generated by JFlex 1.4.3 on 12/24/11 1:16 PM */

/*
 * Copyright 2008 Ayman Al-Sairafi ayman.alsairafi@gmail.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License
 *       at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * --
 *
 * The original .flex file is full of errors. With my inexisting JFlex
 * knowledge, I try to fix the problems based on the Scala Language
 * Specification (SLS) v2.9 (published draft May 24, 2011). (H. H. Rutz)
 */

package de.sciss.scalainterpreter;

import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.lexers.DefaultJFlexLexer;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/24/11 1:16 PM from the specification file
 * <tt>/Users/hhrutz/Documents/devel/jsyntaxpane/src/main/jflex/jsyntaxpane/lexers/scala.flex</tt>
 */
public final class ScalaLexer extends DefaultJFlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int JDOC_TAG = 8;
  public static final int JDOC = 6;
  public static final int YYINITIAL = 0;
  public static final int CHARLITERAL = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4, 4
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\7\1\3\1\2\1\0\1\3\1\1\16\7\4\0\1\3\1\105"+
    "\1\24\1\0\1\6\1\105\1\107\1\25\1\73\1\74\1\5\1\111"+
    "\1\101\1\23\1\21\1\4\1\10\1\16\2\15\4\17\2\11\1\106"+
    "\1\101\1\104\1\102\1\103\1\101\1\112\1\14\1\62\1\63\1\65"+
    "\1\22\1\20\1\71\1\113\1\64\2\113\1\12\1\113\1\70\1\72"+
    "\2\113\1\66\1\47\1\113\1\61\1\113\1\67\1\13\2\113\1\77"+
    "\1\26\1\100\1\105\1\6\1\0\1\27\1\30\1\34\1\40\1\35"+
    "\1\41\1\60\1\36\1\45\1\55\1\57\1\37\1\50\1\44\1\42"+
    "\1\51\1\113\1\33\1\31\1\32\1\54\1\56\1\53\1\43\1\46"+
    "\1\52\1\75\1\110\1\76\1\101\41\7\2\0\4\6\4\0\1\113"+
    "\2\0\1\7\7\0\1\113\4\0\1\113\5\0\27\113\1\0\37\113"+
    "\1\0\u013f\113\31\0\162\113\4\0\14\113\16\0\5\113\11\0\1\113"+
    "\21\0\130\7\5\0\23\7\12\0\1\113\13\0\1\113\1\0\3\113"+
    "\1\0\1\113\1\0\24\113\1\0\54\113\1\0\46\113\1\0\5\113"+
    "\4\0\202\113\1\0\4\7\3\0\105\113\1\0\46\113\2\0\2\113"+
    "\6\0\20\113\41\0\46\113\2\0\1\113\7\0\47\113\11\0\21\7"+
    "\1\0\27\7\1\0\3\7\1\0\1\7\1\0\2\7\1\0\1\7"+
    "\13\0\33\113\5\0\3\113\15\0\4\7\14\0\6\7\13\0\32\113"+
    "\5\0\13\113\16\7\7\0\12\7\4\0\2\113\1\7\143\113\1\0"+
    "\1\113\10\7\1\0\6\7\2\113\2\7\1\0\4\7\2\113\12\7"+
    "\3\113\2\0\1\113\17\0\1\7\1\113\1\7\36\113\33\7\2\0"+
    "\3\113\60\0\46\113\13\7\1\113\u014f\0\3\7\66\113\2\0\1\7"+
    "\1\113\20\7\2\0\1\113\4\7\3\0\12\113\2\7\2\0\12\7"+
    "\21\0\3\7\1\0\10\113\2\0\2\113\2\0\26\113\1\0\7\113"+
    "\1\0\1\113\3\0\4\113\2\0\1\7\1\113\7\7\2\0\2\7"+
    "\2\0\3\7\11\0\1\7\4\0\2\113\1\0\3\113\2\7\2\0"+
    "\12\7\2\113\2\6\15\0\3\7\1\0\6\113\4\0\2\113\2\0"+
    "\26\113\1\0\7\113\1\0\2\113\1\0\2\113\1\0\2\113\2\0"+
    "\1\7\1\0\5\7\4\0\2\7\2\0\3\7\13\0\4\113\1\0"+
    "\1\113\7\0\14\7\3\113\14\0\3\7\1\0\11\113\1\0\3\113"+
    "\1\0\26\113\1\0\7\113\1\0\2\113\1\0\5\113\2\0\1\7"+
    "\1\113\10\7\1\0\3\7\1\0\3\7\2\0\1\113\17\0\2\113"+
    "\2\7\2\0\12\7\1\0\1\6\17\0\3\7\1\0\10\113\2\0"+
    "\2\113\2\0\26\113\1\0\7\113\1\0\2\113\1\0\5\113\2\0"+
    "\1\7\1\113\6\7\3\0\2\7\2\0\3\7\10\0\2\7\4\0"+
    "\2\113\1\0\3\113\4\0\12\7\1\0\1\113\20\0\1\7\1\113"+
    "\1\0\6\113\3\0\3\113\1\0\4\113\3\0\2\113\1\0\1\113"+
    "\1\0\2\113\3\0\2\113\3\0\3\113\3\0\10\113\1\0\3\113"+
    "\4\0\5\7\3\0\3\7\1\0\4\7\11\0\1\7\17\0\11\7"+
    "\11\0\1\6\7\0\3\7\1\0\10\113\1\0\3\113\1\0\27\113"+
    "\1\0\12\113\1\0\5\113\4\0\7\7\1\0\3\7\1\0\4\7"+
    "\7\0\2\7\11\0\2\113\4\0\12\7\22\0\2\7\1\0\10\113"+
    "\1\0\3\113\1\0\27\113\1\0\12\113\1\0\5\113\2\0\1\7"+
    "\1\113\7\7\1\0\3\7\1\0\4\7\7\0\2\7\7\0\1\113"+
    "\1\0\2\113\4\0\12\7\22\0\2\7\1\0\10\113\1\0\3\113"+
    "\1\0\27\113\1\0\20\113\4\0\6\7\2\0\3\7\1\0\4\7"+
    "\11\0\1\7\10\0\2\113\4\0\12\7\22\0\2\7\1\0\22\113"+
    "\3\0\30\113\1\0\11\113\1\0\1\113\2\0\7\113\3\0\1\7"+
    "\4\0\6\7\1\0\1\7\1\0\10\7\22\0\2\7\15\0\60\113"+
    "\1\7\2\113\7\7\4\0\1\6\7\113\10\7\1\0\12\7\47\0"+
    "\2\113\1\0\1\113\2\0\2\113\1\0\1\113\2\0\1\113\6\0"+
    "\4\113\1\0\7\113\1\0\3\113\1\0\1\113\1\0\1\113\2\0"+
    "\2\113\1\0\4\113\1\7\2\113\6\7\1\0\2\7\1\113\2\0"+
    "\5\113\1\0\1\113\1\0\6\7\2\0\12\7\2\0\2\113\42\0"+
    "\1\113\27\0\2\7\6\0\12\7\13\0\1\7\1\0\1\7\1\0"+
    "\1\7\4\0\2\7\10\113\1\0\42\113\6\0\24\7\1\0\2\7"+
    "\4\113\4\0\10\7\1\0\44\7\11\0\1\7\71\0\42\113\1\0"+
    "\5\113\1\0\2\113\1\0\7\7\3\0\4\7\6\0\12\7\6\0"+
    "\6\113\4\7\106\0\46\113\12\0\51\113\7\0\132\113\5\0\104\113"+
    "\5\0\122\113\6\0\7\113\1\0\77\113\1\0\1\113\1\0\4\113"+
    "\2\0\7\113\1\0\1\113\1\0\4\113\2\0\47\113\1\0\1\113"+
    "\1\0\4\113\2\0\37\113\1\0\1\113\1\0\4\113\2\0\7\113"+
    "\1\0\1\113\1\0\4\113\2\0\7\113\1\0\7\113\1\0\27\113"+
    "\1\0\37\113\1\0\1\113\1\0\4\113\2\0\7\113\1\0\47\113"+
    "\1\0\23\113\16\0\11\7\56\0\125\113\14\0\u026c\113\2\0\10\113"+
    "\12\0\32\113\5\0\113\113\3\0\3\6\17\0\15\113\1\0\4\113"+
    "\3\7\13\0\22\113\3\7\13\0\22\113\2\7\14\0\15\113\1\0"+
    "\3\113\1\0\2\7\14\0\64\113\40\7\3\0\1\113\3\0\1\6"+
    "\1\113\1\7\2\0\12\7\41\0\3\7\2\0\12\7\6\0\130\113"+
    "\10\0\51\113\1\7\126\0\35\113\3\0\14\7\4\0\14\7\12\0"+
    "\12\7\36\113\2\0\5\113\u038b\0\154\113\224\0\234\113\4\0\132\113"+
    "\6\0\26\113\2\0\6\113\2\0\46\113\2\0\6\113\2\0\10\113"+
    "\1\0\1\113\1\0\1\113\1\0\1\113\1\0\37\113\2\0\65\113"+
    "\1\0\7\113\1\0\1\113\3\0\3\113\1\0\7\113\3\0\4\113"+
    "\2\0\6\113\4\0\15\113\5\0\3\113\1\0\7\113\17\0\4\7"+
    "\32\0\5\7\20\0\2\6\23\0\1\6\13\0\4\7\6\0\6\7"+
    "\1\0\1\113\15\0\1\113\40\0\22\6\36\0\15\7\4\0\1\7"+
    "\3\0\6\7\27\0\1\113\4\0\1\113\2\0\12\113\1\0\1\113"+
    "\3\0\5\113\6\0\1\113\1\0\1\113\1\0\1\113\1\0\4\113"+
    "\1\0\3\113\1\0\7\113\3\0\3\113\5\0\5\113\26\0\44\6"+
    "\u0e81\0\2\113\1\6\31\0\11\6\6\7\1\0\5\113\2\0\3\6"+
    "\2\113\4\0\126\113\2\0\2\7\2\0\3\113\1\0\132\113\1\6"+
    "\4\113\5\0\50\113\4\0\136\113\21\0\30\113\70\0\20\113\u0200\0"+
    "\u19b6\113\112\0\u51a6\113\132\0\u048d\113\u0773\0\u2ba4\113\u215c\0\u012e\113\2\0"+
    "\73\113\225\0\7\113\14\0\5\113\5\0\1\113\1\7\12\113\1\0"+
    "\15\113\1\0\5\113\1\0\1\113\1\0\2\113\1\0\2\113\1\0"+
    "\154\113\41\0\u016b\113\22\0\100\113\2\0\66\113\50\0\14\113\1\6"+
    "\3\0\20\7\20\0\4\7\17\0\2\6\30\0\3\6\31\0\1\6"+
    "\6\0\5\113\1\0\207\113\2\0\1\7\4\0\1\6\13\0\12\7"+
    "\7\0\32\113\4\0\1\6\1\0\32\113\12\0\1\6\131\113\3\0"+
    "\6\113\2\0\6\113\2\0\6\113\2\0\3\113\3\0\2\6\3\0"+
    "\2\6\22\0\3\7\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\3\1\2\2\1\3\2\4\3\3\1\2\1\3"+
    "\1\2\1\5\1\6\30\3\1\7\1\10\1\11\1\12"+
    "\1\13\1\14\6\2\1\15\2\16\1\17\1\1\1\15"+
    "\1\1\2\20\1\21\2\22\1\15\1\23\1\0\3\4"+
    "\1\0\3\4\1\0\21\3\1\24\30\3\1\2\1\25"+
    "\2\15\1\26\1\15\2\23\1\0\1\27\4\4\1\0"+
    "\1\3\1\30\16\3\1\24\20\3\1\30\2\3\2\0"+
    "\2\4\25\3\2\4\1\3\1\31\4\3\1\24\7\3"+
    "\2\4\4\3\2\4\1\32\6\4\1\0\1\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\1\4\1\0"+
    "\1\4\1\0\1\4\1\0\5\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[249];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\114\0\230\0\344\0\u0130\0\u017c\0\u01c8\0\u0214"+
    "\0\u0260\0\u02ac\0\u02f8\0\u0344\0\u0390\0\u03dc\0\u0428\0\u0474"+
    "\0\u04c0\0\u050c\0\u0558\0\u017c\0\u017c\0\u05a4\0\u05f0\0\u063c"+
    "\0\u0688\0\u06d4\0\u0720\0\u076c\0\u07b8\0\u0804\0\u0850\0\u089c"+
    "\0\u08e8\0\u0934\0\u0980\0\u09cc\0\u0a18\0\u0a64\0\u0ab0\0\u0afc"+
    "\0\u0b48\0\u0b94\0\u0be0\0\u0c2c\0\u0c78\0\u017c\0\u017c\0\u017c"+
    "\0\u017c\0\u017c\0\u017c\0\u017c\0\u0cc4\0\u0d10\0\u0d5c\0\u0da8"+
    "\0\u0df4\0\u0e40\0\u0e8c\0\u017c\0\u017c\0\u0ed8\0\u0f24\0\u0f70"+
    "\0\u017c\0\u0fbc\0\u017c\0\u017c\0\u0fbc\0\u1008\0\u1054\0\u10a0"+
    "\0\u10ec\0\u1138\0\u017c\0\u1184\0\u11d0\0\u121c\0\u1268\0\u12b4"+
    "\0\u1300\0\u134c\0\u1398\0\u13e4\0\u1430\0\u147c\0\u14c8\0\u1514"+
    "\0\u1560\0\u15ac\0\u15f8\0\u1644\0\u1690\0\u16dc\0\u1728\0\u1774"+
    "\0\u17c0\0\u02f8\0\u180c\0\u1858\0\u18a4\0\u18f0\0\u193c\0\u1988"+
    "\0\u19d4\0\u1a20\0\u1a6c\0\u1ab8\0\u1b04\0\u1b50\0\u1b9c\0\u1be8"+
    "\0\u1c34\0\u1c80\0\u1ccc\0\u1d18\0\u1d64\0\u1db0\0\u1dfc\0\u1e48"+
    "\0\u1e94\0\u1ee0\0\u1f2c\0\u017c\0\u1f78\0\u1fc4\0\u017c\0\u017c"+
    "\0\u2010\0\u017c\0\u205c\0\u20a8\0\u20f4\0\u2140\0\u218c\0\u21d8"+
    "\0\u2224\0\u2270\0\u22bc\0\u2308\0\u2354\0\u23a0\0\u23ec\0\u2438"+
    "\0\u2484\0\u24d0\0\u251c\0\u2568\0\u25b4\0\u2600\0\u264c\0\u2698"+
    "\0\u26e4\0\u2730\0\u277c\0\u27c8\0\u2814\0\u2860\0\u28ac\0\u28f8"+
    "\0\u2944\0\u2990\0\u29dc\0\u2a28\0\u2a74\0\u2ac0\0\u2b0c\0\u2b58"+
    "\0\u2ba4\0\u2bf0\0\u02f8\0\u2c3c\0\u2c88\0\u2cd4\0\u20a8\0\u2d20"+
    "\0\u2d6c\0\u2db8\0\u2e04\0\u2e50\0\u2e9c\0\u2ee8\0\u2f34\0\u2f80"+
    "\0\u2fcc\0\u3018\0\u3064\0\u30b0\0\u30fc\0\u3148\0\u3194\0\u31e0"+
    "\0\u322c\0\u3278\0\u32c4\0\u3310\0\u335c\0\u33a8\0\u33f4\0\u3440"+
    "\0\u348c\0\u02f8\0\u34d8\0\u3524\0\u3570\0\u35bc\0\u3608\0\u3654"+
    "\0\u36a0\0\u36ec\0\u3738\0\u3784\0\u37d0\0\u381c\0\u3868\0\u38b4"+
    "\0\u3900\0\u394c\0\u3998\0\u39e4\0\u3a30\0\u3a7c\0\u02f8\0\u3ac8"+
    "\0\u3b14\0\u3b60\0\u3bac\0\u3bf8\0\u3c44\0\u3c90\0\u3cdc\0\u3d28"+
    "\0\u3d74\0\u3dc0\0\u3e0c\0\u3e58\0\u3ea4\0\u3ef0\0\u3f3c\0\u3f88"+
    "\0\u3fd4\0\u4020\0\u406c\0\u40b8\0\u4104\0\u4150\0\u419c\0\u41e8"+
    "\0\u4234";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[249];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\1\6\1\10\1\11\1\12\1\13\1\6"+
    "\1\14\1\15\1\16\1\13\1\17\3\15\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\6\1\26\1\13\1\27"+
    "\1\30\1\31\1\32\1\33\1\13\1\34\1\35\1\36"+
    "\1\37\1\13\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\13\1\46\2\13\1\47\2\13\1\50\1\51\1\52"+
    "\1\53\1\54\1\13\1\55\3\13\1\56\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\12\1\65\1\66\1\12"+
    "\1\64\1\67\1\70\1\71\1\6\1\13\1\72\1\73"+
    "\1\74\21\72\1\75\1\72\1\76\65\72\1\77\1\73"+
    "\1\74\22\77\1\75\1\100\65\77\5\101\1\102\104\101"+
    "\1\103\1\101\5\104\1\105\4\104\3\106\3\104\1\106"+
    "\1\104\1\106\4\104\44\106\20\104\1\106\116\0\1\6"+
    "\114\0\1\10\114\0\1\107\1\110\74\0\1\64\113\0"+
    "\1\64\17\0\13\13\1\0\1\13\4\0\44\13\20\0"+
    "\1\13\10\0\1\111\1\112\1\113\1\114\1\0\1\115"+
    "\1\116\1\115\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\1\0\1\114\21\0\1\113\36\0\2\15\1\113"+
    "\2\0\3\15\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\23\0\1\113\34\0\13\13\1\0\1\13\4\0"+
    "\13\13\1\121\30\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\15\13\1\122\26\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\10\13\1\123\33\13\20\0"+
    "\1\13\10\0\2\117\3\0\3\117\102\0\13\13\1\0"+
    "\1\13\4\0\37\13\1\124\4\13\20\0\1\13\23\0"+
    "\1\64\56\0\1\64\17\0\13\13\1\0\1\13\4\0"+
    "\1\13\1\125\42\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\6\13\1\126\16\13\1\127\16\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\4\13\1\130"+
    "\2\13\1\131\7\13\1\132\24\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\6\13\1\133\35\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\1\134\7\13"+
    "\1\135\33\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\10\13\1\136\3\13\1\137\27\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\1\140\43\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\6\13\1\141"+
    "\4\13\1\142\30\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\1\143\12\13\1\144\2\13\1\145\25\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\1\13"+
    "\1\146\25\13\1\147\14\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\6\13\1\150\16\13\1\151\16\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\12\13"+
    "\1\142\6\13\1\152\22\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\16\13\1\153\25\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\3\13\1\154\3\13"+
    "\1\155\34\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\1\156\43\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\1\157\3\13\1\160\37\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\7\13\1\161\6\13"+
    "\1\162\25\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\1\163\43\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\15\13\1\164\26\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\13\13\1\165\3\13\1\166"+
    "\24\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\7\13\1\167\34\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\15\13\1\170\26\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\13\13\1\171\30\13\20\0"+
    "\1\13\6\0\6\13\1\172\4\13\1\0\1\13\4\0"+
    "\44\13\20\0\1\13\102\0\1\64\1\173\112\0\1\64"+
    "\1\0\1\12\111\0\1\64\4\0\1\64\106\0\1\64"+
    "\5\0\1\64\105\0\1\64\6\0\1\64\2\0\1\72"+
    "\2\0\21\72\1\0\1\72\1\0\65\72\2\0\1\74"+
    "\111\0\2\174\1\0\5\174\1\175\4\174\2\175\1\176"+
    "\74\174\1\77\2\0\22\77\2\0\65\77\2\174\1\0"+
    "\111\174\4\0\1\177\121\0\3\106\3\0\1\106\1\0"+
    "\1\106\4\0\44\106\13\0\1\200\4\0\1\106\1\107"+
    "\1\201\1\202\111\107\5\203\1\204\106\203\10\0\1\111"+
    "\1\112\1\113\2\0\1\115\1\116\1\115\1\113\1\117"+
    "\1\120\12\0\1\120\1\0\3\113\23\0\1\113\36\0"+
    "\2\112\3\0\3\112\1\113\1\117\1\120\12\0\1\120"+
    "\2\0\2\113\23\0\1\113\36\0\1\205\1\206\2\0"+
    "\5\206\1\0\1\206\4\0\2\206\3\0\2\206\2\0"+
    "\2\206\20\0\2\206\1\0\1\206\36\0\1\207\1\112"+
    "\1\113\2\0\3\207\1\113\1\117\1\120\12\0\1\120"+
    "\1\0\3\113\23\0\1\113\36\0\1\115\1\112\1\113"+
    "\2\0\3\115\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\23\0\1\113\36\0\2\117\3\0\3\117\1\113"+
    "\1\0\1\120\12\0\1\120\2\0\2\113\23\0\1\113"+
    "\36\0\2\210\3\0\3\210\3\0\1\211\65\0\1\211"+
    "\10\0\13\13\1\0\1\13\4\0\15\13\1\212\26\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\17\13"+
    "\1\213\24\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\13\13\1\214\30\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\37\13\1\215\4\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\2\13\1\216\41\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\1\217"+
    "\43\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\22\13\1\220\21\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\1\221\16\13\1\142\5\13\1\222\16\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\4\13"+
    "\1\223\11\13\1\224\25\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\22\13\1\222\21\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\3\13\1\225\40\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\2\13"+
    "\1\222\1\226\40\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\1\227\43\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\2\13\1\222\41\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\3\13\1\230\40\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\23\13"+
    "\1\231\20\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\12\13\1\142\31\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\10\13\1\136\33\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\4\13\1\232\37\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\15\13"+
    "\1\233\26\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\26\13\1\234\15\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\6\13\1\235\35\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\24\13\1\142\17\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\10\13"+
    "\1\236\33\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\22\13\1\237\21\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\6\13\1\240\35\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\4\13\1\241\37\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\13\13"+
    "\1\242\30\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\3\13\1\226\40\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\5\13\1\243\36\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\13\13\1\244\2\13"+
    "\1\245\25\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\16\13\1\246\25\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\3\13\1\247\40\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\4\13\1\142\3\13"+
    "\1\142\33\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\16\13\1\170\25\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\13\13\1\250\30\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\3\13\1\251\40\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\1\252"+
    "\43\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\3\13\1\253\40\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\25\13\1\254\16\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\37\13\1\255\4\13\20\0"+
    "\1\13\102\0\1\64\1\12\20\0\1\176\4\0\3\176"+
    "\104\0\1\200\4\0\3\200\76\0\1\202\111\0\5\203"+
    "\1\256\106\203\4\0\1\202\1\257\116\0\1\205\1\206"+
    "\1\113\1\0\5\206\1\0\1\206\4\0\2\206\3\0"+
    "\2\206\1\0\1\113\2\206\20\0\2\206\1\0\1\206"+
    "\36\0\2\260\1\113\1\0\5\260\1\0\1\260\4\0"+
    "\2\260\3\0\2\260\1\0\1\113\2\260\20\0\2\260"+
    "\1\0\1\260\36\0\1\261\1\112\1\113\2\0\3\261"+
    "\1\113\1\117\1\120\12\0\1\120\1\0\3\113\23\0"+
    "\1\113\36\0\2\210\3\0\3\210\1\113\17\0\2\113"+
    "\23\0\1\113\36\0\2\210\3\0\3\210\102\0\13\13"+
    "\1\0\1\13\4\0\31\13\1\253\12\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\37\13\1\262\4\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\1\170"+
    "\43\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\43\13\1\263\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\3\13\1\264\40\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\10\13\1\265\33\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\6\13\1\266\35\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\16\13"+
    "\1\267\25\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\6\13\1\142\35\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\13\13\1\150\30\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\2\13\1\142\41\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\25\13"+
    "\1\270\16\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\5\13\1\247\36\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\2\13\1\224\41\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\6\13\1\271\35\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\17\13"+
    "\1\142\24\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\20\13\1\272\23\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\1\273\43\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\6\13\1\274\35\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\4\13\1\275"+
    "\37\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\10\13\1\142\33\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\10\13\1\276\2\13\1\277\30\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\10\13\1\300"+
    "\33\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\16\13\1\121\25\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\4\13\1\170\37\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\30\13\1\301\13\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\3\13\1\302"+
    "\40\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\27\13\1\303\14\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\10\13\1\222\33\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\7\13\1\142\34\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\10\13\1\304"+
    "\33\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\6\13\1\253\35\13\20\0\1\13\6\0\13\13\1\0"+
    "\1\13\4\0\4\13\1\253\37\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\1\13\1\305\42\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\41\13\1\306"+
    "\2\13\20\0\1\13\4\203\1\202\1\256\106\203\10\0"+
    "\2\307\1\113\1\0\5\307\1\0\1\307\4\0\2\307"+
    "\3\0\2\307\1\0\1\113\2\307\20\0\2\307\1\0"+
    "\1\307\36\0\1\310\1\112\1\113\2\0\3\310\1\113"+
    "\1\117\1\120\12\0\1\120\1\0\3\113\23\0\1\113"+
    "\34\0\13\13\1\0\1\13\4\0\6\13\1\311\35\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\37\13"+
    "\1\312\4\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\4\13\1\313\37\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\6\13\1\300\35\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\4\13\1\142\37\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\3\13"+
    "\1\142\40\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\4\13\1\314\37\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\15\13\1\315\26\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\13\13\1\316\30\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\10\13"+
    "\1\317\33\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\5\13\1\267\36\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\4\13\1\320\37\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\16\13\1\321\25\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\4\13"+
    "\1\267\37\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\11\13\1\142\32\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\1\322\43\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\6\13\1\323\35\13\20\0"+
    "\1\13\6\0\13\13\1\0\1\13\4\0\1\324\43\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\6\13"+
    "\1\325\35\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\10\13\1\251\33\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\35\13\1\326\6\13\20\0\1\13"+
    "\10\0\2\327\1\113\1\0\5\327\1\0\1\327\4\0"+
    "\2\327\3\0\2\327\1\0\1\113\2\327\20\0\2\327"+
    "\1\0\1\327\36\0\1\330\1\112\1\113\2\0\3\330"+
    "\1\113\1\117\1\120\12\0\1\120\1\0\3\113\23\0"+
    "\1\113\34\0\13\13\1\0\1\13\4\0\12\13\1\253"+
    "\31\13\20\0\1\13\6\0\13\13\1\0\1\13\4\0"+
    "\1\274\43\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\15\13\1\142\26\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\11\13\1\224\32\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\21\13\1\222\22\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\10\13"+
    "\1\231\33\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\16\13\1\331\25\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\5\13\1\221\36\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\31\13\1\222\12\13"+
    "\20\0\1\13\6\0\13\13\1\0\1\13\4\0\5\13"+
    "\1\332\36\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\3\13\1\222\40\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\1\333\43\13\20\0\1\13\6\0"+
    "\13\13\1\0\1\13\4\0\41\13\1\334\2\13\20\0"+
    "\1\13\10\0\2\335\1\113\1\0\5\335\1\0\1\335"+
    "\4\0\2\335\3\0\2\335\1\0\1\113\2\335\20\0"+
    "\2\335\1\0\1\335\36\0\1\336\1\112\1\113\2\0"+
    "\3\336\1\113\1\117\1\120\12\0\1\120\1\0\3\113"+
    "\23\0\1\113\34\0\13\13\1\0\1\13\4\0\11\13"+
    "\1\222\32\13\20\0\1\13\6\0\13\13\1\0\1\13"+
    "\4\0\3\13\1\265\40\13\20\0\1\13\6\0\13\13"+
    "\1\0\1\13\4\0\15\13\1\253\26\13\20\0\1\13"+
    "\6\0\13\13\1\0\1\13\4\0\42\13\1\337\1\13"+
    "\20\0\1\13\10\0\2\340\1\113\1\0\5\340\1\0"+
    "\1\340\4\0\2\340\3\0\2\340\1\0\1\113\2\340"+
    "\20\0\2\340\1\0\1\340\36\0\1\341\1\112\1\113"+
    "\2\0\3\341\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\23\0\1\113\36\0\2\342\1\113\1\0\5\342"+
    "\1\0\1\342\4\0\2\342\3\0\2\342\1\0\1\113"+
    "\2\342\20\0\2\342\1\0\1\342\36\0\1\343\1\112"+
    "\1\113\2\0\3\343\1\113\1\117\1\120\12\0\1\120"+
    "\1\0\3\113\23\0\1\113\36\0\2\344\1\113\1\0"+
    "\5\344\1\0\1\344\4\0\2\344\3\0\2\344\1\0"+
    "\1\113\2\344\20\0\2\344\1\0\1\344\36\0\1\345"+
    "\1\112\1\113\2\0\3\345\1\113\1\117\1\120\12\0"+
    "\1\120\1\0\3\113\23\0\1\113\36\0\2\346\1\113"+
    "\1\0\5\346\1\0\1\346\4\0\2\346\3\0\2\346"+
    "\1\0\1\113\2\346\20\0\2\346\1\0\1\346\36\0"+
    "\1\347\1\112\1\113\2\0\3\347\1\113\1\117\1\120"+
    "\12\0\1\120\1\0\3\113\23\0\1\113\36\0\2\350"+
    "\1\113\1\0\5\350\1\0\1\350\4\0\2\350\3\0"+
    "\2\350\1\0\1\113\2\350\20\0\2\350\1\0\1\350"+
    "\36\0\1\351\1\112\1\113\2\0\3\351\1\113\1\117"+
    "\1\120\12\0\1\120\1\0\3\113\23\0\1\113\36\0"+
    "\2\352\1\113\1\0\5\352\1\0\1\352\4\0\2\352"+
    "\3\0\2\352\1\0\1\113\2\352\20\0\2\352\1\0"+
    "\1\352\36\0\1\353\1\112\1\113\2\0\3\353\1\113"+
    "\1\117\1\120\12\0\1\120\1\0\3\113\23\0\1\113"+
    "\36\0\2\354\1\113\1\0\5\354\1\0\1\354\4\0"+
    "\2\354\3\0\2\354\1\0\1\113\2\354\20\0\2\354"+
    "\1\0\1\354\36\0\1\355\1\112\1\113\2\0\3\355"+
    "\1\113\1\117\1\120\12\0\1\120\1\0\3\113\23\0"+
    "\1\113\36\0\2\356\1\113\1\0\5\356\1\0\1\356"+
    "\4\0\2\356\3\0\2\356\1\0\1\113\2\356\20\0"+
    "\2\356\1\0\1\356\36\0\1\357\1\112\1\113\2\0"+
    "\3\357\1\113\1\117\1\120\12\0\1\120\1\0\3\113"+
    "\23\0\1\113\36\0\2\360\1\113\1\0\5\360\1\0"+
    "\1\360\4\0\2\360\3\0\2\360\1\0\1\113\2\360"+
    "\20\0\2\360\1\0\1\360\36\0\1\361\1\112\1\113"+
    "\2\0\3\361\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\23\0\1\113\36\0\2\362\1\113\1\0\5\362"+
    "\1\0\1\362\4\0\2\362\3\0\2\362\1\0\1\113"+
    "\2\362\20\0\2\362\1\0\1\362\36\0\1\363\1\112"+
    "\1\113\2\0\3\363\1\113\1\117\1\120\12\0\1\120"+
    "\1\0\3\113\23\0\1\113\36\0\2\364\1\113\1\0"+
    "\5\364\1\0\1\364\4\0\2\364\3\0\2\364\1\0"+
    "\1\113\2\364\20\0\2\364\1\0\1\364\36\0\1\365"+
    "\1\112\1\113\2\0\3\365\1\113\1\117\1\120\12\0"+
    "\1\120\1\0\3\113\23\0\1\113\40\0\1\113\24\0"+
    "\1\113\64\0\1\366\1\112\1\113\2\0\3\366\1\113"+
    "\1\117\1\120\12\0\1\120\1\0\3\113\23\0\1\113"+
    "\36\0\1\367\1\112\1\113\2\0\3\367\1\113\1\117"+
    "\1\120\12\0\1\120\1\0\3\113\23\0\1\113\36\0"+
    "\1\370\1\112\1\113\2\0\3\370\1\113\1\117\1\120"+
    "\12\0\1\120\1\0\3\113\23\0\1\113\36\0\1\371"+
    "\1\112\1\113\2\0\3\371\1\113\1\117\1\120\12\0"+
    "\1\120\1\0\3\113\23\0\1\113\36\0\2\112\1\113"+
    "\2\0\3\112\1\113\1\117\1\120\12\0\1\120\1\0"+
    "\3\113\23\0\1\113\26\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[17024];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\11\15\1\2\11\30\1\7\11\7\1\2\11"+
    "\3\1\1\11\1\1\2\11\3\1\1\0\2\1\1\11"+
    "\1\0\3\1\1\0\53\1\1\11\2\1\2\11\1\1"+
    "\1\11\1\0\5\1\1\0\44\1\2\0\66\1\1\0"+
    "\1\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\1\1\0\1\1\1\0\5\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[249];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    /**
     * Create an empty lexer, yyrset will be called later to reset and assign
     * the reader
     */
    public ScalaLexer() {
        super();
    }

    @Override
    public int yychar() {
        return yychar;
    }

    private static final byte PARAN     = 1;
    private static final byte BRACKET   = 2;
    private static final byte CURLY     = 3;



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ScalaLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ScalaLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1828) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 8: 
          { return token(TokenType.OPERATOR, -PARAN);
          }
        case 27: break;
        case 20: 
          { return token(TokenType.KEYWORD);
          }
        case 28: break;
        case 4: 
          { return token(TokenType.NUMBER);
          }
        case 29: break;
        case 18: 
          { yybegin(JDOC); 
                                     // length also includes the trailing quote
                                     int start = tokenStart;
                                     tokenStart = yychar;
                                     int len = tokenLength;
                                     tokenLength = 1;
                                     return token(TokenType.COMMENT2, start, len);
          }
        case 30: break;
        case 22: 
          { yybegin(YYINITIAL); 
                                     return token(TokenType.COMMENT, tokenStart, tokenLength + 2);
          }
        case 31: break;
        case 2: 
          { return token(TokenType.OPERATOR);
          }
        case 32: break;
        case 9: 
          { return token(TokenType.OPERATOR,  CURLY);
          }
        case 33: break;
        case 10: 
          { return token(TokenType.OPERATOR, -CURLY);
          }
        case 34: break;
        case 17: 
          { yybegin(JDOC_TAG); 
                                     int start = tokenStart;
                                     tokenStart = yychar;
                                     int len = tokenLength;
                                     tokenLength = 1;
                                     return token(TokenType.COMMENT, start, len);
          }
        case 35: break;
        case 13: 
          { tokenLength += yylength();
          }
        case 36: break;
        case 14: 
          { yybegin(YYINITIAL);
          }
        case 37: break;
        case 6: 
          { yybegin(CHARLITERAL); 
                                    tokenStart = yychar; 
                                    tokenLength = 1;
          }
        case 38: break;
        case 23: 
          { yybegin(JDOC); 
                                    tokenStart = yychar; 
                                    tokenLength = 3;
          }
        case 39: break;
        case 15: 
          { yybegin(YYINITIAL); 
                                     // length also includes the trailing quote
                                     return token(TokenType.STRING, tokenStart, tokenLength + 1);
          }
        case 40: break;
        case 24: 
          { return token(TokenType.TYPE);
          }
        case 41: break;
        case 26: 
          { return token(TokenType.WARNING);
          }
        case 42: break;
        case 12: 
          { return token(TokenType.OPERATOR, -BRACKET);
          }
        case 43: break;
        case 7: 
          { return token(TokenType.OPERATOR,  PARAN);
          }
        case 44: break;
        case 3: 
          { return token(TokenType.IDENTIFIER);
          }
        case 45: break;
        case 21: 
          { tokenLength += 2;
          }
        case 46: break;
        case 25: 
          { return token(TokenType.ERROR);
          }
        case 47: break;
        case 16: 
          { tokenLength ++;
          }
        case 48: break;
        case 11: 
          { return token(TokenType.OPERATOR,  BRACKET);
          }
        case 49: break;
        case 19: 
          { return token(TokenType.COMMENT);
          }
        case 50: break;
        case 5: 
          { yybegin(STRING); 
                                    tokenStart = yychar; 
                                    tokenLength = 1;
          }
        case 51: break;
        case 1: 
          { 
          }
        case 52: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return null;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
