/*
 *  StopSelfResponder.scala
 *  (SoundProcesses)
 *
 *  Copyright (c) 2010-2022 Hanns Holger Rutz. All rights reserved.
 *
 *	This software is published under the GNU Affero General Public License v3+
 *
 *
 *  For further information, please contact Hanns Holger Rutz at
 *  contact@sciss.de
 */

package de.sciss.synth.proc.graph.impl

import de.sciss.lucre.Cursor
import de.sciss.lucre.synth.{RT, Synth, Txn}
import de.sciss.osc
import de.sciss.proc.SoundProcesses
import de.sciss.proc.impl.AuralProcImpl
import de.sciss.synth.proc.graph.{DoneSelf, StopSelf}

final class StopSelfResponder[T <: Txn[T]](view: AuralProcImpl[T], protected val synth: Synth, done: Boolean)
                                          (implicit cursor: Cursor[T])
  extends SendReplyResponder {

  private[this] val NodeId    = synth.peer.id
  private[this] val ReplyName = if (done) DoneSelf.replyName else StopSelf.replyName

  protected val body: Body = {
    case osc.Message(ReplyName, NodeId, 0, _) =>
      SoundProcesses.step[T](s"StopSelfResponder($synth)") { implicit tx: T =>
        if (done) view.done() else view.stop()
      }
  }

  protected def added()(implicit tx: RT): Unit = ()
}
