/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.proc.impl;

import de.sciss.lucre.DataStore;
import de.sciss.lucre.StringObj;
import de.sciss.lucre.StringObj$;
import de.sciss.lucre.Sys;
import de.sciss.lucre.Txn;
import de.sciss.lucre.confluent.Access$;
import de.sciss.lucre.confluent.Source;
import de.sciss.proc.Confluent;
import de.sciss.proc.Confluent$;
import de.sciss.proc.Cursors;
import de.sciss.proc.Cursors$;
import de.sciss.proc.Durable;
import de.sciss.proc.Durable$;
import de.sciss.proc.Workspace;
import de.sciss.proc.WorkspacePlatform;
import de.sciss.proc.impl.WorkspaceImpl;
import de.sciss.proc.impl.WorkspaceImpl$;
import de.sciss.proc.impl.WorkspaceImpl$Data$;
import de.sciss.proc.impl.WorkspacePlatformImpl;
import de.sciss.serial.TFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.sys.package$;

public final class WorkspacePlatformImpl$ {
    public static final WorkspacePlatformImpl$ MODULE$ = new WorkspacePlatformImpl$();

    private WorkspaceImpl.Fmt<Confluent.Txn> ConfluentFmt() {
        return WorkspaceImpl$.MODULE$.fmt();
    }

    private void requireExists(File dir) {
        if (!new File(dir, "open").isFile()) {
            throw new FileNotFoundException(new StringBuilder(25).append("Workspace ").append(dir.getPath()).append(" does not exist").toString());
        }
    }

    private void requireExistsNot(File dir) {
        if (new File(dir, "open").exists()) {
            throw new IOException(new StringBuilder(25).append("Workspace ").append(dir.getPath()).append(" already exists").toString());
        }
    }

    public Workspace<?> read(URI dir, DataStore.Factory ds, Map<String, String> meta) {
        Workspace<Confluent.Txn> workspace;
        boolean bl;
        block6: {
            File dirF = new File(dir);
            this.requireExists(dirF);
            FileInputStream fis = new FileInputStream(new File(dirF, "open"));
            Properties prop = new Properties();
            prop.load(fis);
            fis.close();
            String string = prop.getProperty("type");
            switch (string == null ? 0 : string.hashCode()) {
                case -801256930: {
                    if (!"confluent".equals(string)) break;
                    bl = true;
                    break block6;
                }
                case 563386781: {
                    if (!"ephemeral".equals(string)) break;
                    bl = false;
                    break block6;
                }
            }
            throw package$.MODULE$.error(new StringBuilder(25).append("Invalid property 'type': ").append(string).toString());
        }
        boolean confluent = bl;
        if (confluent) {
            WorkspacePlatform.Confluent _res;
            workspace = _res = this.readConfluent(dir, ds, meta);
        } else {
            WorkspacePlatform.Durable _res = this.readDurable(dir, ds, meta);
            workspace = _res;
        }
        Workspace<Confluent.Txn> res = workspace;
        return res;
    }

    public WorkspacePlatform.Confluent readConfluent(URI dir, DataStore.Factory ds, Map<String, String> meta) {
        File dirF = new File(dir);
        this.requireExists(dirF);
        return this.applyConfluent(dirF, ds, meta);
    }

    public WorkspacePlatform.Confluent emptyConfluent(URI dir, DataStore.Factory ds, Map<String, String> meta) {
        File dirF = new File(dir);
        this.requireExistsNot(dirF);
        return this.applyConfluent(dirF, ds, meta);
    }

    public WorkspacePlatform.Durable readDurable(URI dir, DataStore.Factory ds, Map<String, String> meta) {
        File dirF = new File(dir);
        this.requireExists(dirF);
        return this.applyDurable(dirF, ds, meta);
    }

    public WorkspacePlatform.Durable emptyDurable(URI dir, DataStore.Factory ds, Map<String, String> meta) {
        File dirF = new File(dir);
        this.requireExistsNot(dirF);
        return this.applyDurable(dirF, ds, meta);
    }

    private Tuple2<DataStore.Factory, Map<String, String>> openDataStore(File dir, DataStore.Factory ds, boolean confluent, Map<String, String> meta) {
        Properties prop = new Properties();
        File fOpen = new File(dir, "open");
        if (fOpen.isFile()) {
            try (FileInputStream fis = new FileInputStream(fOpen);){
                prop.load(fis);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(fOpen);){
            prop.setProperty("type", confluent ? "confluent" : "ephemeral");
            meta.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Object object = prop.setProperty(key, value);
                return object;
            });
            prop.store(fos, "Mellite Workspace Meta-Info");
        }
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.sizeHint(prop.size());
        Set keys = (Set)JavaConverters$.MODULE$.asScalaSetConverter(prop.stringPropertyNames()).asScala();
        keys.foreach((Function1 & Serializable)key -> {
            String value = prop.getProperty((String)key);
            return (Builder)mb.$plus$eq((Object)new Tuple2(key, (Object)value));
        });
        Map metaNew = (Map)mb.result();
        return new Tuple2((Object)ds, (Object)metaNew);
    }

    private WorkspacePlatform.Confluent applyConfluent(File dir, DataStore.Factory ds, Map<String, String> meta) {
        Tuple2<DataStore.Factory, Map<String, String>> tuple2 = this.openDataStore(dir, ds, true, meta);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DataStore.Factory fact = (DataStore.Factory)tuple2._1();
        Map metaNew = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fact, (Object)metaNew);
        Tuple2 tuple23 = tuple22;
        DataStore.Factory fact2 = (DataStore.Factory)tuple23._1();
        Map metaNew2 = (Map)tuple23._2();
        Confluent system = Confluent$.MODULE$.apply(fact2);
        TFormat fmt = Cursors$.MODULE$.format();
        Tuple2 tuple24 = system.rootWithDurable((Function1 & Serializable)tx -> WorkspaceImpl$Data$.MODULE$.apply(tx), (Function1 & Serializable)tx -> {
            void var1_1;
            Cursors c = Cursors$.MODULE$.apply(Access$.MODULE$.root(), tx);
            c.name_$eq((StringObj<Durable.Txn>)((StringObj)StringObj$.MODULE$.newConst((Object)"root", (Txn)tx)), (Durable.Txn)tx);
            return var1_1;
        }, this.ConfluentFmt(), fmt);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Source access = (Source)tuple24._1();
        Cursors cursors = (Cursors)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)access, (Object)cursors);
        Tuple2 tuple26 = tuple25;
        Source access2 = (Source)tuple26._1();
        Cursors cursors2 = (Cursors)tuple26._2();
        return new WorkspacePlatformImpl.ConfluentImpl(dir, system, (Map<String, String>)metaNew2, (de.sciss.lucre.Source<Confluent.Txn, WorkspaceImpl.Data<Confluent.Txn>>)access2, cursors2);
    }

    private WorkspacePlatform.Durable applyDurable(File dir, DataStore.Factory ds, Map<String, String> meta) {
        Tuple2<DataStore.Factory, Map<String, String>> tuple2 = this.openDataStore(dir, ds, false, meta);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DataStore.Factory fact = (DataStore.Factory)tuple2._1();
        Map metaNew = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fact, (Object)metaNew);
        Tuple2 tuple23 = tuple22;
        DataStore.Factory fact2 = (DataStore.Factory)tuple23._1();
        Map metaNew2 = (Map)tuple23._2();
        Durable system = Durable$.MODULE$.apply(fact2, Durable$.MODULE$.apply$default$2());
        de.sciss.lucre.Source access = WorkspaceImpl$.MODULE$.initAccess((Sys)system);
        return new WorkspacePlatformImpl.DurableImpl(dir, system, (Map<String, String>)metaNew2, access);
    }

    public String de$sciss$proc$impl$WorkspacePlatformImpl$$fileBase(File f) {
        String n = f.getName();
        int i = n.lastIndexOf(46);
        return i < 0 ? n : n.substring(0, i);
    }

    private WorkspacePlatformImpl$() {
    }
}

