/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.FileChooserViewType;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.managers.style.StyleId;
import com.alee.utils.FileUtils;
import com.alee.utils.SystemUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SubminFileChooserPanel
extends WebFileChooserPanel {
    public SubminFileChooserPanel(FileChooserType chooserType, boolean showControlButtons) {
        super(chooserType, showControlButtons);
        this.setViewType(FileChooserViewType.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> getFavourites() {
        File userHome;
        File fGtkBookMarks;
        ArrayList<File> list = new ArrayList<File>(16);
        if (!SystemUtils.isWindows() && !SystemUtils.isMac() && SystemUtils.isUnix() && (fGtkBookMarks = new File(new File(new File(userHome = FileUtils.getUserHome(), ".config"), "gtk-3.0"), "bookmarks")).isFile()) {
            String[] children;
            list.add(userHome);
            for (String aChildren : children = new String[]{"Documents", "Downloads", "Music", "Pictures", "Videos"}) {
                File f = new File(userHome, aChildren);
                if (!f.isDirectory()) continue;
                list.add(f);
            }
            try {
                FileInputStream fis = new FileInputStream(fGtkBookMarks);
                try {
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                    BufferedReader r = new BufferedReader(isr);
                    while (r.ready()) {
                        URI uri;
                        File f;
                        int stop;
                        String line = r.readLine();
                        if (!line.startsWith("file://") || (stop = line.indexOf(32)) <= 0 || list.contains(f = new File(uri = new URI(line.substring(0, stop))))) continue;
                        list.add(f);
                    }
                }
                finally {
                    ((InputStream)fis).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    protected void createFileTree() {
        this.treeScroll = new WebScrollPane(StyleId.filechooserNavScroll.at((JComponent)this.centralSplit));
        this.treeScroll.setPreferredSize(new Dimension(this.dividerLocation, 1));
        final List rootsFav = this.getFavourites();
        boolean hasFav = !rootsFav.isEmpty();
        List roots = hasFav ? rootsFav : FileTreeRootType.drives.getRoots();
        this.fileTree = new WebFileTree(StyleId.filechooserFileTree.at((JComponent)this.treeScroll), roots);
        this.fileTree.setAutoExpandSelectedNode(!hasFav);
        if (hasFav) {
            this.fileTree.setComparator((Comparator)new Comparator<FileTreeNode>(){

                @Override
                public int compare(FileTreeNode n1, FileTreeNode n2) {
                    int idx2;
                    int idx1 = rootsFav.indexOf(n1.getFile());
                    return idx1 < (idx2 = rootsFav.indexOf(n2.getFile())) ? -1 : (idx1 > idx2 ? 1 : 0);
                }
            });
        }
        this.fileTree.setSelectionMode(1);
        this.treeScroll.setViewportView((Component)this.fileTree);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SubminFileChooserPanel.this.fileTree.getSelectionCount() > 0) {
                    SubminFileChooserPanel.this.updateCurrentFolder(SubminFileChooserPanel.this.fileTree.getSelectedFile(), WebFileChooserPanel.UpdateSource.tree);
                }
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
    }
}

