/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.laf.slider.SliderPainter;
import com.alee.laf.slider.WebSliderUI;
import com.alee.utils.GraphicsUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JSlider;

public class SubminSliderPainter<E extends JSlider, U extends WebSliderUI>
extends SliderPainter<E, U> {
    protected Color focusColor;
    protected Color tickColor;
    protected Color shadeColor;
    protected Color borderColor;
    protected Color darkBorderColor;
    protected Color disabledBorderColor;

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getDarkBorderColor() {
        return this.darkBorderColor;
    }

    public void setDarkBorderColor(Color darkBorderColor) {
        this.darkBorderColor = darkBorderColor;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        this.disabledBorderColor = disabledBorderColor;
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        g.setColor(this.tickColor);
        if (((JSlider)this.component).getOrientation() == 0) {
            int xPos;
            int value;
            g.translate(0, tickBounds.y);
            if (((JSlider)this.component).getMinorTickSpacing() > 0) {
                for (value = ((JSlider)this.component).getMinimum(); value <= ((JSlider)this.component).getMaximum(); value += ((JSlider)this.component).getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizontalSlider(g, tickBounds, xPos);
                }
            }
            if (((JSlider)this.component).getMajorTickSpacing() > 0) {
                for (value = ((JSlider)this.component).getMinimum(); value <= ((JSlider)this.component).getMaximum(); value += ((JSlider)this.component).getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizontalSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            int yPos;
            g.translate(tickBounds.x, 0);
            int value = ((JSlider)this.component).getMinimum();
            if (((JSlider)this.component).getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!this.ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= ((JSlider)this.component).getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVerticalSlider(g, tickBounds, yPos);
                    value += ((JSlider)this.component).getMinorTickSpacing();
                }
                if (!this.ltr) {
                    g.translate(-offset, 0);
                }
            }
            if (((JSlider)this.component).getMajorTickSpacing() > 0) {
                value = ((JSlider)this.component).getMinimum();
                if (!this.ltr) {
                    g.translate(2, 0);
                }
                while (value <= ((JSlider)this.component).getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVerticalSlider(g, tickBounds, yPos);
                    value += ((JSlider)this.component).getMajorTickSpacing();
                }
                if (!this.ltr) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    public void paintTrack(Graphics2D g2d) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Shape ss = this.getTrackShape();
        if (((JSlider)this.component).isEnabled()) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)ss, (Color)(((JSlider)this.component).isFocusOwner() ? this.focusColor : this.shadeColor), (int)this.trackShadeWidth);
        }
        if (((JSlider)this.component).getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(0.0f, this.trackRect.y, this.trackBgTop, 0.0f, this.trackRect.y + this.trackRect.height, this.trackBgBottom));
        } else {
            g2d.setPaint(new GradientPaint(this.trackRect.x, 0.0f, this.trackBgTop, this.trackRect.x + this.trackRect.width, 0.0f, this.trackBgBottom));
        }
        g2d.fill(ss);
        if (this.drawProgress) {
            Shape ps = this.getProgressShape();
            if (((JSlider)this.component).isEnabled()) {
                GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)ps, (Color)this.shadeColor, (int)this.progressShadeWidth);
            }
            Rectangle bounds = ss.getBounds();
            if (((JSlider)this.component).getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, bounds.y + this.progressShadeWidth, this.progressTrackBgTop, 0.0f, bounds.y + bounds.height - this.progressShadeWidth, this.progressTrackBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(bounds.x + this.progressShadeWidth, 0.0f, this.progressTrackBgTop, bounds.x + bounds.width - this.progressShadeWidth, 0.0f, this.progressTrackBgBottom));
            }
            g2d.fill(ps);
            g2d.setPaint(((JSlider)this.component).isEnabled() ? this.progressBorderColor : this.disabledBorderColor);
            g2d.draw(ps);
        }
        g2d.setPaint(((JSlider)this.component).isEnabled() ? (this.rolloverDarkBorderOnly && !this.dragging ? this.getBorderColor() : this.darkBorderColor) : this.disabledBorderColor);
        g2d.draw(ss);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public void paintThumb(Graphics2D g2d) {
        if (this.drawThumb) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Shape ts = this.getThumbShape();
            if (((JSlider)this.component).getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, this.thumbRect.y, this.thumbBgTop, 0.0f, this.thumbRect.y + this.thumbRect.height, this.thumbBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(this.thumbRect.x, 0.0f, this.thumbBgTop, this.thumbRect.x + this.thumbRect.width, 0.0f, this.thumbBgBottom));
            }
            g2d.fill(ts);
            g2d.setPaint(((JSlider)this.component).isEnabled() ? this.darkBorderColor : this.disabledBorderColor);
            g2d.draw(ts);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
    }
}

