
package de.softwareforge.jsonschema;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_JsonSchemaGeneratorConfiguration extends JsonSchemaGeneratorConfiguration {

  private final JsonNodeFactory nodeFactory;
  private final boolean addSchemaVersion;
  private final boolean sortSchemaProperties;
  private final boolean processProperties;
  private final boolean processFields;

  private AutoValue_JsonSchemaGeneratorConfiguration(
      JsonNodeFactory nodeFactory,
      boolean addSchemaVersion,
      boolean sortSchemaProperties,
      boolean processProperties,
      boolean processFields) {
    this.nodeFactory = nodeFactory;
    this.addSchemaVersion = addSchemaVersion;
    this.sortSchemaProperties = sortSchemaProperties;
    this.processProperties = processProperties;
    this.processFields = processFields;
  }

  @Override
  public JsonNodeFactory nodeFactory() {
    return nodeFactory;
  }

  @Override
  public boolean addSchemaVersion() {
    return addSchemaVersion;
  }

  @Override
  public boolean sortSchemaProperties() {
    return sortSchemaProperties;
  }

  @Override
  public boolean processProperties() {
    return processProperties;
  }

  @Override
  public boolean processFields() {
    return processFields;
  }

  @Override
  public String toString() {
    return "JsonSchemaGeneratorConfiguration{"
        + "nodeFactory=" + nodeFactory + ", "
        + "addSchemaVersion=" + addSchemaVersion + ", "
        + "sortSchemaProperties=" + sortSchemaProperties + ", "
        + "processProperties=" + processProperties + ", "
        + "processFields=" + processFields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JsonSchemaGeneratorConfiguration) {
      JsonSchemaGeneratorConfiguration that = (JsonSchemaGeneratorConfiguration) o;
      return (this.nodeFactory.equals(that.nodeFactory()))
           && (this.addSchemaVersion == that.addSchemaVersion())
           && (this.sortSchemaProperties == that.sortSchemaProperties())
           && (this.processProperties == that.processProperties())
           && (this.processFields == that.processFields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.nodeFactory.hashCode();
    h *= 1000003;
    h ^= this.addSchemaVersion ? 1231 : 1237;
    h *= 1000003;
    h ^= this.sortSchemaProperties ? 1231 : 1237;
    h *= 1000003;
    h ^= this.processProperties ? 1231 : 1237;
    h *= 1000003;
    h ^= this.processFields ? 1231 : 1237;
    return h;
  }

  static final class Builder extends JsonSchemaGeneratorConfiguration.Builder {
    private JsonNodeFactory nodeFactory;
    private Boolean addSchemaVersion;
    private Boolean sortSchemaProperties;
    private Boolean processProperties;
    private Boolean processFields;
    Builder() {
    }
    @Override
    JsonSchemaGeneratorConfiguration.Builder setNodeFactory(JsonNodeFactory nodeFactory) {
      if (nodeFactory == null) {
        throw new NullPointerException("Null nodeFactory");
      }
      this.nodeFactory = nodeFactory;
      return this;
    }
    @Override
    JsonSchemaGeneratorConfiguration.Builder setAddSchemaVersion(boolean addSchemaVersion) {
      this.addSchemaVersion = addSchemaVersion;
      return this;
    }
    @Override
    JsonSchemaGeneratorConfiguration.Builder setSortSchemaProperties(boolean sortSchemaProperties) {
      this.sortSchemaProperties = sortSchemaProperties;
      return this;
    }
    @Override
    JsonSchemaGeneratorConfiguration.Builder setProcessProperties(boolean processProperties) {
      this.processProperties = processProperties;
      return this;
    }
    @Override
    JsonSchemaGeneratorConfiguration.Builder setProcessFields(boolean processFields) {
      this.processFields = processFields;
      return this;
    }
    @Override
    public JsonSchemaGeneratorConfiguration build() {
      String missing = "";
      if (this.nodeFactory == null) {
        missing += " nodeFactory";
      }
      if (this.addSchemaVersion == null) {
        missing += " addSchemaVersion";
      }
      if (this.sortSchemaProperties == null) {
        missing += " sortSchemaProperties";
      }
      if (this.processProperties == null) {
        missing += " processProperties";
      }
      if (this.processFields == null) {
        missing += " processFields";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JsonSchemaGeneratorConfiguration(
          this.nodeFactory,
          this.addSchemaVersion,
          this.sortSchemaProperties,
          this.processProperties,
          this.processFields);
    }
  }

}
