/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven;

import de.softwareforge.testing.maven.MavenArtifactLoader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public final class TestMavenArtifactLoader {
    static final String GROUP_ID = "de.softwareforge.testing";
    static final String ARTIFACT_ID = "maven-loader";

    @Test
    void testFindVersion21X() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).includeSnapshots(false).partialMatch("2.1").findAll();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)results).isNotEmpty()).contains((Object[])new String[]{"2.1.0", "2.1.1"})).doesNotContain((Object[])new String[]{"2.1.0-SNAPSHOT"});
    }

    @Test
    void testFindVersion210() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).includeSnapshots(false).exactMatch("2.1.0").findAll();
        ((ListAssert)Assertions.assertThat((List)results).isNotEmpty()).containsExactly((Object[])new String[]{"2.1.0"});
    }

    @Test
    void testFindSnapshotVersion210() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).includeSnapshots(true).partialMatch("2.1").findAll();
        ((ListAssert)Assertions.assertThat((List)results).isNotEmpty()).contains((Object[])new String[]{"2.1.0-SNAPSHOT"});
    }

    @Test
    void testSemVerMajor() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).semVerMajor(1).includeSnapshots(false).findAll();
        ((ListAssert)Assertions.assertThat((List)results).contains((Object[])new String[]{"1.0", "1.1"})).doesNotContain((Object[])new String[]{"2.0", "2.1.0"});
    }

    @Test
    void testSemVerMajorBest() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        Optional result = loader.builder(GROUP_ID, ARTIFACT_ID).semVerMajor(1).includeSnapshots(false).findBestMatch();
        ((OptionalAssert)Assertions.assertThat((Optional)result).isNotEmpty()).contains((Object)"1.2");
    }

    @Test
    void testSemVerMajor0OnlySnapshot() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        Optional result = loader.builder(GROUP_ID, ARTIFACT_ID).semVerMajor(0).findBestMatch();
        ((OptionalAssert)Assertions.assertThat((Optional)result).isNotEmpty()).contains((Object)"0.1-SNAPSHOT");
    }

    @Test
    void testSemVerMajorNotFound() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        Optional result = loader.builder(GROUP_ID, ARTIFACT_ID).semVerMajor(0).includeSnapshots(false).findBestMatch();
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void testSemVerMinor() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).semVerMinor(2, 1).includeSnapshots(false).findAll();
        ((ListAssert)Assertions.assertThat((List)results).doesNotContain((Object[])new String[]{"1.0", "1.1", "2.0"})).contains((Object[])new String[]{"2.1.0", "2.1.1"});
    }

    @Test
    void testFindLatestVersion() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        LinkedList results = loader.builder(GROUP_ID, ARTIFACT_ID).findAll();
        String latestVersion = loader.findLatestVersion(GROUP_ID, ARTIFACT_ID, "");
        Assertions.assertThat((List)results).isNotEmpty();
        Assertions.assertThat((String)latestVersion).isEqualTo((String)results.getLast());
    }

    @Test
    void testLoadArtifact() throws IOException {
        MavenArtifactLoader loader = new MavenArtifactLoader();
        Optional result = loader.builder(GROUP_ID, ARTIFACT_ID).includeSnapshots(false).partialMatch("2.1").findBestMatch();
        Assertions.assertThat((Optional)result).isPresent();
        File artifactFile = loader.getArtifactFile(GROUP_ID, ARTIFACT_ID, (String)result.get());
        Assertions.assertThat((File)artifactFile).exists();
    }
}

