/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.rest.action.suggest;

import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsAction;
import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsRequest;
import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsResponse;
import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestStatisticsAction
extends BaseRestHandler {
    @Inject
    public RestStatisticsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/__suggestStatistics", (RestHandler)this);
    }

    public void handleRequest(final RestRequest request, final RestChannel channel) {
        SuggestStatisticsRequest suggestStatisticsRequest = new SuggestStatisticsRequest();
        this.client.execute((Action)SuggestStatisticsAction.INSTANCE, (ActionRequest)suggestStatisticsRequest, (ActionListener)new ActionListener<SuggestStatisticsResponse>(){

            public void onResponse(SuggestStatisticsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder((RestRequest)request);
                    builder.startObject();
                    RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (BroadcastOperationResponse)response);
                    response.fstStats().toXContent(builder, null);
                    builder.endObject();
                    channel.sendResponse((RestResponse)new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestStatisticsAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                }
            }
        });
    }
}

