/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.service.suggest;

import de.spinscale.elasticsearch.action.suggest.refresh.ShardSuggestRefreshRequest;
import de.spinscale.elasticsearch.action.suggest.refresh.ShardSuggestRefreshResponse;
import de.spinscale.elasticsearch.action.suggest.statistics.FstStats;
import de.spinscale.elasticsearch.action.suggest.statistics.ShardSuggestStatisticsResponse;
import de.spinscale.elasticsearch.action.suggest.suggest.ShardSuggestRequest;
import de.spinscale.elasticsearch.action.suggest.suggest.ShardSuggestResponse;
import de.spinscale.elasticsearch.service.suggest.AbstractCacheLoaderSuggester;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.FuzzySuggester;
import org.apache.lucene.search.suggest.fst.FSTCompletionLookup;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.base.Joiner;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.LoadingCache;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;

public class ShardSuggestService
extends AbstractIndexShardComponent {
    private final IndexShard indexShard;
    private final ReentrantLock lock = new ReentrantLock();
    private IndexReader indexReader;
    private final LoadingCache<String, FSTCompletionLookup> lookupCache;
    private final LoadingCache<FieldType, AnalyzingSuggester> analyzingSuggesterCache;
    private final LoadingCache<FieldType, FuzzySuggester> fuzzySuggesterCache;
    private final LoadingCache<String, HighFrequencyDictionary> dictCache;
    private final LoadingCache<String, SpellChecker> spellCheckerCache;
    private final LoadingCache<String, RAMDirectory> ramDirectoryCache;

    @Inject
    public ShardSuggestService(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard, AnalysisService analysisService, MapperService mapperService) {
        super(shardId, indexSettings);
        this.indexShard = indexShard;
        this.ramDirectoryCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, RAMDirectory>(){

            public RAMDirectory load(String field) throws Exception {
                return new RAMDirectory();
            }
        });
        this.dictCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, HighFrequencyDictionary>(){

            public HighFrequencyDictionary load(String field) throws Exception {
                return new HighFrequencyDictionary(ShardSuggestService.this.createOrGetIndexReader(), field, 1.0E-5f);
            }
        });
        this.spellCheckerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SpellChecker>(){

            public SpellChecker load(String field) throws Exception {
                SpellChecker spellChecker = new SpellChecker((Directory)ShardSuggestService.this.ramDirectoryCache.get((Object)field));
                IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_43, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_43));
                spellChecker.indexDictionary((Dictionary)ShardSuggestService.this.dictCache.getUnchecked((Object)field), indexWriterConfig, false);
                return spellChecker;
            }
        });
        this.lookupCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, FSTCompletionLookup>(){

            public FSTCompletionLookup load(String field) throws Exception {
                FSTCompletionLookup lookup = new FSTCompletionLookup();
                lookup.build((Dictionary)ShardSuggestService.this.dictCache.getUnchecked((Object)field));
                return lookup;
            }
        });
        this.analyzingSuggesterCache = CacheBuilder.newBuilder().build((CacheLoader)new AbstractCacheLoaderSuggester.CacheLoaderAnalyzingSuggester(mapperService, analysisService, this.dictCache));
        this.fuzzySuggesterCache = CacheBuilder.newBuilder().build((CacheLoader)new AbstractCacheLoaderSuggester.CacheLoaderFuzzySuggester(mapperService, analysisService, this.dictCache));
    }

    public ShardSuggestRefreshResponse refresh(ShardSuggestRefreshRequest shardSuggestRefreshRequest) {
        String field = shardSuggestRefreshRequest.field();
        if (!Strings.hasLength((String)field)) {
            this.update();
        } else {
            FSTCompletionLookup lookup;
            SpellChecker spellChecker;
            RAMDirectory ramDirectory;
            this.resetIndexReader();
            HighFrequencyDictionary dict = (HighFrequencyDictionary)this.dictCache.getIfPresent((Object)field);
            if (dict != null) {
                this.dictCache.refresh((Object)field);
            }
            if ((ramDirectory = (RAMDirectory)this.ramDirectoryCache.getIfPresent((Object)field)) != null) {
                ramDirectory.close();
                this.ramDirectoryCache.invalidate((Object)field);
            }
            if ((spellChecker = (SpellChecker)this.spellCheckerCache.getIfPresent((Object)field)) != null) {
                this.spellCheckerCache.refresh((Object)field);
                try {
                    spellChecker.close();
                }
                catch (IOException e) {
                    this.logger.error("Could not close spellchecker in indexshard [{}] for field [{}]", (Throwable)e, new Object[]{this.indexShard, field});
                }
            }
            if ((lookup = (FSTCompletionLookup)this.lookupCache.getIfPresent((Object)field)) != null) {
                this.lookupCache.refresh((Object)field);
            }
            for (FieldType fieldType : this.analyzingSuggesterCache.asMap().keySet()) {
                if (!fieldType.field().equals(shardSuggestRefreshRequest.field())) continue;
                this.analyzingSuggesterCache.refresh((Object)fieldType);
            }
            for (FieldType fieldType : this.fuzzySuggesterCache.asMap().keySet()) {
                if (!fieldType.field().equals(shardSuggestRefreshRequest.field())) continue;
                this.fuzzySuggesterCache.refresh((Object)fieldType);
            }
        }
        return new ShardSuggestRefreshResponse(this.shardId.index().name(), this.shardId.id());
    }

    public void shutDown() {
        this.resetIndexReader();
        this.dictCache.invalidateAll();
        for (Map.Entry entry : this.spellCheckerCache.asMap().entrySet()) {
            try {
                ((RAMDirectory)this.ramDirectoryCache.getUnchecked(entry.getKey())).close();
                ((SpellChecker)entry.getValue()).close();
            }
            catch (IOException e) {
                this.logger.error("Could not close spellchecker in indexshard [{}] for field [{}]", (Throwable)e, new Object[]{this.indexShard, entry.getKey()});
            }
        }
        this.spellCheckerCache.invalidateAll();
        this.ramDirectoryCache.invalidateAll();
        this.lookupCache.invalidateAll();
        this.analyzingSuggesterCache.invalidateAll();
        this.fuzzySuggesterCache.invalidateAll();
    }

    public void update() {
        this.resetIndexReader();
        for (String field : this.dictCache.asMap().keySet()) {
            this.dictCache.refresh((Object)field);
        }
        try {
            for (String field : this.spellCheckerCache.asMap().keySet()) {
                SpellChecker oldSpellchecker = (SpellChecker)this.spellCheckerCache.getUnchecked((Object)field);
                RAMDirectory oldRamDirectory = (RAMDirectory)this.ramDirectoryCache.getUnchecked((Object)field);
                this.ramDirectoryCache.refresh((Object)field);
                this.spellCheckerCache.refresh((Object)field);
                oldRamDirectory.close();
                oldSpellchecker.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error refreshing spell checker cache [{}]", (Throwable)e, new Object[]{this.shardId});
        }
        for (String field : this.lookupCache.asMap().keySet()) {
            this.lookupCache.refresh((Object)field);
        }
        for (FieldType fieldType : this.analyzingSuggesterCache.asMap().keySet()) {
            this.analyzingSuggesterCache.refresh((Object)fieldType);
        }
        for (FieldType fieldType : this.fuzzySuggesterCache.asMap().keySet()) {
            this.fuzzySuggesterCache.refresh((Object)fieldType);
        }
    }

    public ShardSuggestResponse suggest(ShardSuggestRequest shardSuggestRequest) {
        ArrayList suggestions = Lists.newArrayList(this.getSuggestions(shardSuggestRequest));
        return new ShardSuggestResponse(this.shardId.index().name(), this.shardId.id(), suggestions);
    }

    private Collection<String> getSimilarSuggestions(ShardSuggestRequest shardSuggestRequest) {
        String field = shardSuggestRequest.field();
        String term = shardSuggestRequest.term();
        Integer limit = shardSuggestRequest.size();
        Float similarity = Float.valueOf(shardSuggestRequest.similarity());
        try {
            String[] suggestSimilar = ((SpellChecker)this.spellCheckerCache.getUnchecked((Object)field)).suggestSimilar(term, limit.intValue(), similarity.floatValue());
            return Arrays.asList(suggestSimilar);
        }
        catch (IOException e) {
            this.logger.error("Error getting spellchecker suggestions for shard [{}] field [{}] term [{}] limit [{}] similarity [{}]", (Throwable)e, new Object[]{this.shardId, field, term, limit, similarity});
            return Collections.emptyList();
        }
    }

    private Collection<String> getSuggestions(ShardSuggestRequest shardSuggestRequest) {
        ArrayList lookupResults = Lists.newArrayList();
        if ("full".equals(shardSuggestRequest.suggestType())) {
            lookupResults.addAll(((AnalyzingSuggester)this.analyzingSuggesterCache.getUnchecked((Object)new FieldType(shardSuggestRequest))).lookup((CharSequence)shardSuggestRequest.term(), false, shardSuggestRequest.size()));
        } else if ("fuzzy".equals(shardSuggestRequest.suggestType())) {
            lookupResults.addAll(((FuzzySuggester)this.fuzzySuggesterCache.getUnchecked((Object)new FieldType(shardSuggestRequest))).lookup((CharSequence)shardSuggestRequest.term(), false, shardSuggestRequest.size()));
        } else {
            lookupResults.addAll(((FSTCompletionLookup)this.lookupCache.getUnchecked((Object)shardSuggestRequest.field())).lookup((CharSequence)shardSuggestRequest.term(), true, shardSuggestRequest.size() + 1));
            Collection suggestions = Collections2.transform((Collection)lookupResults, (Function)new LookupResultToStringFunction());
            float similarity = shardSuggestRequest.similarity();
            if (similarity < 1.0f && suggestions.size() < shardSuggestRequest.size()) {
                suggestions = Lists.newArrayList((Iterable)suggestions);
                suggestions.addAll(this.getSimilarSuggestions(shardSuggestRequest));
            }
            return suggestions;
        }
        return Collections2.transform((Collection)lookupResults, (Function)new LookupResultToStringFunction());
    }

    public void resetIndexReader() {
        IndexReader currentIndexReader = null;
        if (this.indexShard.state() == IndexShardState.STARTED) {
            Engine.Searcher currentIndexSearcher = this.indexShard.searcher();
            currentIndexReader = currentIndexSearcher.reader();
            currentIndexSearcher.release();
        }
        if (this.indexReader != null && this.indexReader.getRefCount() > 0 && !this.indexReader.equals((Object)currentIndexReader)) {
            try {
                this.indexReader.decRef();
            }
            catch (IOException e) {
                this.logger.error("Error decreasing indexreader ref count [{}] of shard [{}]", (Throwable)e, new Object[]{this.indexReader.getRefCount(), this.shardId});
            }
        }
        this.indexReader = null;
    }

    public ShardSuggestStatisticsResponse getStatistics() {
        FstStats.FstIndexShardStats fstIndexShardStats;
        long sizeInBytes;
        ShardSuggestStatisticsResponse shardSuggestStatisticsResponse = new ShardSuggestStatisticsResponse(this.shardId());
        for (FieldType fieldType : this.analyzingSuggesterCache.asMap().keySet()) {
            sizeInBytes = ((AnalyzingSuggester)this.analyzingSuggesterCache.getIfPresent((Object)fieldType)).sizeInBytes();
            fstIndexShardStats = new FstStats.FstIndexShardStats(this.shardId, "analyzingsuggester", fieldType, sizeInBytes);
            shardSuggestStatisticsResponse.getFstIndexShardStats().add(fstIndexShardStats);
        }
        for (FieldType fieldType : this.fuzzySuggesterCache.asMap().keySet()) {
            sizeInBytes = ((FuzzySuggester)this.fuzzySuggesterCache.getIfPresent((Object)fieldType)).sizeInBytes();
            fstIndexShardStats = new FstStats.FstIndexShardStats(this.shardId, "fuzzysuggester", fieldType, sizeInBytes);
            shardSuggestStatisticsResponse.getFstIndexShardStats().add(fstIndexShardStats);
        }
        return shardSuggestStatisticsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader createOrGetIndexReader() {
        try {
            if (this.indexReader == null) {
                this.lock.lock();
                if (this.indexReader == null) {
                    Engine.Searcher indexSearcher = this.indexShard.searcher();
                    this.indexReader = indexSearcher.reader();
                    indexSearcher.release();
                    this.indexReader.addReaderClosedListener(new IndexReader.ReaderClosedListener(){

                        public void onClose(IndexReader reader) {
                            ShardSuggestService.this.update();
                        }
                    });
                }
            }
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return this.indexReader;
    }

    public static class FieldType
    implements Streamable,
    Serializable,
    ToXContent {
        private String field;
        private List<String> types = Lists.newArrayList();
        private String queryAnalyzer;
        private String indexAnalyzer;

        public FieldType() {
        }

        public FieldType(ShardSuggestRequest shardSuggestRequest) {
            this.field = shardSuggestRequest.field();
            this.types = Arrays.asList(shardSuggestRequest.types());
            this.queryAnalyzer = shardSuggestRequest.queryAnalyzer();
            this.indexAnalyzer = shardSuggestRequest.indexAnalyzer();
        }

        public String field() {
            return this.field;
        }

        public String[] types() {
            return this.types.toArray(new String[0]);
        }

        public String queryAnalyzer() {
            return this.queryAnalyzer;
        }

        public String indexAnalyzer() {
            return this.indexAnalyzer;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldType other = (FieldType)obj;
            return Objects.equal((Object)this.field(), (Object)other.field()) && Objects.equal((Object)this.queryAnalyzer(), (Object)other.queryAnalyzer()) && Objects.equal((Object)this.indexAnalyzer(), (Object)other.indexAnalyzer()) && Objects.equal(this.types, other.types);
        }

        public int hashCode() {
            int hashCode = this.field().hashCode();
            hashCode += ((Object)this.types).hashCode();
            if (this.queryAnalyzer != null) {
                hashCode += this.queryAnalyzer.hashCode();
            }
            if (this.indexAnalyzer != null) {
                hashCode += this.indexAnalyzer.hashCode();
            }
            return hashCode;
        }

        public String toString() {
            ToStringBuilder toStringBuilder = new ToStringBuilder(this.getClass()).add("field", (Object)this.field());
            if (this.queryAnalyzer != null && this.queryAnalyzer.equals(this.indexAnalyzer)) {
                toStringBuilder.add("analyzer", (Object)this.queryAnalyzer);
            } else {
                if (this.queryAnalyzer != null) {
                    toStringBuilder.add("queryAnalyzer", (Object)this.queryAnalyzer);
                }
                if (this.indexAnalyzer != null) {
                    toStringBuilder.add("indexAnalyzer", (Object)this.indexAnalyzer);
                }
            }
            if (this.types.size() > 0) {
                toStringBuilder.add("types", (Object)Joiner.on((String)"-").join(this.types));
            }
            return toStringBuilder.toString();
        }

        public void readFrom(StreamInput in) throws IOException {
            this.field = in.readString();
            this.queryAnalyzer = in.readOptionalString();
            this.indexAnalyzer = in.readOptionalString();
            this.types = (List)in.readGenericValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.field);
            out.writeOptionalString(this.queryAnalyzer);
            out.writeOptionalString(this.indexAnalyzer);
            out.writeGenericValue(this.types);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("field", this.field);
            if (this.queryAnalyzer != null && this.queryAnalyzer.equals(this.indexAnalyzer)) {
                builder.field("analyzer", this.queryAnalyzer);
            } else {
                if (this.queryAnalyzer != null) {
                    builder.field("queryAnalyzer", this.queryAnalyzer);
                }
                if (this.indexAnalyzer != null) {
                    builder.field("indexAnalyzer", this.indexAnalyzer);
                }
            }
            if (this.types.size() > 0) {
                builder.field("types", this.types());
            }
            return builder;
        }
    }

    private class LookupResultToStringFunction
    implements Function<Lookup.LookupResult, String> {
        private LookupResultToStringFunction() {
        }

        public String apply(Lookup.LookupResult result) {
            return ((Object)result.key).toString();
        }
    }
}

