/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.embeddedmongodb;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.transitions.Start;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedMongoDB {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedMongoDB.class);
    private TransitionWalker.ReachedState<RunningMongodProcess> runningMongodProcess;
    private Version.Main version = Version.Main.V7_0;
    private String host = "localhost";
    private int port = 29019;
    private boolean active;
    private boolean ipv6;

    public static EmbeddedMongoDB create() {
        return new EmbeddedMongoDB();
    }

    public static EmbeddedMongoDB createAndStart() {
        return new EmbeddedMongoDB().start();
    }

    public static EmbeddedMongoDB create(String string, int n) {
        return new EmbeddedMongoDB().withHost(string).withPort(n);
    }

    public EmbeddedMongoDB withPort(int n) {
        Preconditions.checkArgument((n > 1024 ? 1 : 0) != 0, (String)"Port needs to be greater than 1024", (Object[])new Object[0]);
        this.port = n;
        return this;
    }

    public EmbeddedMongoDB withHost(String string) {
        Objects.requireNonNull(string, "host can not be null");
        this.host = string;
        return this;
    }

    public EmbeddedMongoDB enableIPv6() {
        this.ipv6 = true;
        return this;
    }

    public EmbeddedMongoDB withVersion(Version.Main main) {
        Objects.requireNonNull(main, "version can not be null");
        this.version = main;
        return this;
    }

    public EmbeddedMongoDB start() {
        if (!this.active && !this.inUse(this.port)) {
            Mongod mongod = new Mongod(){

                public Transition<Net> net() {
                    return Start.to(Net.class).initializedWith((Object)Net.of((String)EmbeddedMongoDB.this.host, (int)EmbeddedMongoDB.this.port, (boolean)EmbeddedMongoDB.this.ipv6));
                }

                public Transition<ProcessOutput> processOutput() {
                    return Start.to(ProcessOutput.class).initializedWith((Object)ProcessOutput.silent());
                }

                public Transition<MongodArguments> mongodArguments() {
                    return Start.to(MongodArguments.class).initializedWith((Object)MongodArguments.defaults().withIsQuiet(true));
                }
            };
            try {
                this.runningMongodProcess = mongod.start((Version)this.version, new Listener[0]);
                this.active = true;
                Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
                LOG.info("Successfully started EmbeddedMongoDB @ {}:{}", (Object)this.host, (Object)this.port);
            }
            catch (Exception exception) {
                LOG.error("Failed to start EmbeddedMongoDB @ {}:{}", new Object[]{this.host, this.port, exception});
            }
        } else {
            LOG.error("Could not start EmbeddedMongoDB. Either already active or port '{}' in use", (Object)this.port);
        }
        return this;
    }

    public void stop() {
        if (this.active) {
            this.runningMongodProcess.close();
            this.active = false;
            LOG.info("Closed EmbeddedMongoDB @ {}:{}", (Object)this.host, (Object)this.port);
        }
    }

    public String getHost() {
        return this.host;
    }

    public Version.Main getVersion() {
        return this.version;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isIPv6() {
        return this.ipv6;
    }

    private boolean inUse(int n) {
        boolean bl = false;
        try (ServerSocket serverSocket = new ServerSocket(n, 0, InetAddress.getByName(this.host));){
            bl = serverSocket == null;
        }
        catch (IOException iOException) {
            bl = true;
            LOG.warn("Port ist not available for starting EmbeddedMongoDB @ {}:{}", new Object[]{this.host, n, iOException});
        }
        return bl;
    }
}

