/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class CsvReader {
    private CsvReader() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    @NotNull
    private static FileSystem getZipFileSystem(@NotNull String zipLocation) throws IOException, IllegalArgumentException {
        URI uri = URI.create(zipLocation);
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            return FileSystems.newFileSystem(uri, env);
        }
    }

    private static Path getPath(String location) throws URISyntaxException {
        ClassLoader classLoader = CsvReader.class.getClassLoader();
        URL url = classLoader.getResource(location);
        if (url == null) {
            return null;
        }
        URI uri = url.toURI();
        if (uri.toString().contains("jar:file:")) {
            try {
                String[] jar_path_elements = uri.toString().split("!");
                FileSystem zipfs = CsvReader.getZipFileSystem(jar_path_elements[0]);
                return zipfs.getPath(jar_path_elements[1], new String[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return Paths.get(uri);
    }

    public static <T> List<T> from(Path path, Class<T> clazz) {
        List list;
        block8: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            CsvMapper mapper = new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY);
            CsvSchema schema = CsvSchema.emptySchema().withColumnSeparator(';').withQuoteChar('\"').withNullValue("").withHeader();
            MappingIterator it = mapper.readerFor(clazz).with((FormatSchema)schema).readValues(inputStream);
            try {
                list = it.readAll();
                if (it == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new ArrayList();
                }
            }
            it.close();
        }
        return list;
    }

    public static <T> List<T> fromResource(String location, Class<T> clazz) {
        try {
            Path path = CsvReader.getPath(location);
            return CsvReader.from(path, clazz);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> fromResourceWithEmptyValues(String location, Class<T> clazz) {
        Path path;
        try {
            path = CsvReader.getPath(location);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new ArrayList();
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            List list;
            block16: {
                CsvMapper mapper = new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY);
                CsvSchema schema = CsvSchema.emptySchema().withColumnSeparator(';').withQuoteChar('\"').withHeader();
                MappingIterator it = mapper.readerFor(clazz).with((FormatSchema)schema).readValues(inputStream);
                try {
                    list = it.readAll();
                    if (it == null) break block16;
                }
                catch (Throwable throwable) {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                it.close();
            }
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }
}

