/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public final class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static String file2UTF8(File file) {
        String string;
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)istream).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            string = result.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)istream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | IndexOutOfBoundsException | NullPointerException | SecurityException e) {
                return null;
            }
        }
        ((InputStream)istream).close();
        return string;
    }

    public static String file2UTF8(String filename) {
        try {
            File file = new File(filename);
            return FileUtils.file2UTF8(file);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static byte[] file2ByteArray(File file) throws IOException {
        byte[] byArray;
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)istream).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            byArray = result.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)istream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | IndexOutOfBoundsException | NullPointerException | SecurityException e) {
                throw new IOException("Fehler beim Lesen der Datei " + file.getName(), e);
            }
        }
        ((InputStream)istream).close();
        return byArray;
    }

    public static byte[] file2ByteArray(String filename) throws IOException {
        File file;
        try {
            file = new File(filename);
        }
        catch (NullPointerException e) {
            throw new IOException("filename darf nicht null sein.", e);
        }
        return FileUtils.file2ByteArray(file);
    }

    public static void move(File file, OutputStream ostream) throws IOException {
        try (BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));){
            byte[] buf = new byte[65536];
            int bytes_read = -1;
            while ((bytes_read = ((InputStream)istream).read(buf)) > -1) {
                ostream.write(buf, 0, bytes_read);
            }
        }
        Files.delete(file.toPath());
    }

    public static void move(String filename, OutputStream ostream) throws IOException {
        File file = new File(filename);
        FileUtils.move(file, ostream);
    }

    public static void copy(File file, OutputStream ostream) throws IOException {
        try (BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));){
            byte[] buf = new byte[65536];
            int bytes_read = -1;
            while ((bytes_read = ((InputStream)istream).read(buf)) > -1) {
                ostream.write(buf, 0, bytes_read);
            }
        }
    }

    public static void copy(String filename, OutputStream ostream) throws IOException {
        File file = new File(filename);
        FileUtils.copy(file, ostream);
    }
}

