/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ResourceUtils {
    private static final HashMap<String, FileSystem> jarFS = new HashMap();
    private static final String FILE_EXTENSION_JSON = ".json";

    private ResourceUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    private static List<Path> getFilesInPath(FileSystem fs, String path, String packagePath, String fileextension) throws IOException {
        ArrayList<Path> classes = new ArrayList<Path>();
        Path fullPath = fs.getPath(path + (path.endsWith("/") ? "" : "/") + packagePath, new String[0]);
        if (!Files.isDirectory(fullPath, new LinkOption[0])) {
            return classes;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(fullPath);){
            for (Path p : dirStream) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    classes.addAll(ResourceUtils.getFilesInPath(fs, path, packagePath + "/" + String.valueOf(p.getFileName()), fileextension));
                    continue;
                }
                if (!Files.isRegularFile(p, new LinkOption[0]) || !p.toString().endsWith(fileextension)) continue;
                classes.add(p);
            }
        }
        catch (IOException e) {
            throw new IOException("Fehler beim Lesen der Dateien im Pfad " + path, e);
        }
        return classes;
    }

    private static FileSystem getJARFileSystem(URI uri) throws IOException {
        String[] array = uri.toString().split("!");
        FileSystem fs = jarFS.get(array[0]);
        if (fs != null) {
            return fs;
        }
        try {
            fs = FileSystems.getFileSystem(URI.create(array[0]));
            jarFS.put(array[0], fs);
            return fs;
        }
        catch (RuntimeException e) {
            HashMap env = new HashMap();
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
            jarFS.put(array[0], fs);
            return fs;
        }
    }

    public static Path getFile(String filename) {
        Path path = null;
        try {
            URL url = ResourceUtils.class.getClassLoader().getResource(filename);
            URI uri = url.toURI();
            if ("jar".equals(uri.getScheme())) {
                FileSystem fs = ResourceUtils.getJARFileSystem(uri);
                String[] array = uri.toString().split("!");
                path = fs.getPath(array[1], new String[0]);
            } else {
                path = Paths.get(uri);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return path;
    }

    public static String text(String filename) {
        try {
            Path path = ResourceUtils.getFile(filename);
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void getFilesInPackageFromURL(URL url, String packagePath, List<Path> result, String fileextension) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            return;
        }
        Path path = null;
        if ("jar".equals(uri.getScheme())) {
            FileSystem fs = ResourceUtils.getJARFileSystem(uri);
            String[] array = uri.toString().split("!");
            path = fs.getPath(array[1], new String[0]);
            int j = Paths.get(packagePath, new String[0]).getNameCount();
            for (int i = 0; i < j; ++i) {
                path = path.getParent();
            }
            result.addAll(ResourceUtils.getFilesInPath(fs, path.toString(), packagePath, fileextension));
        } else {
            path = Paths.get(uri);
            int j = Paths.get(packagePath, new String[0]).getNameCount();
            for (int i = 0; i < j; ++i) {
                path = path.getParent();
            }
            FileSystem fs = FileSystems.getDefault();
            result.addAll(ResourceUtils.getFilesInPath(fs, path.toString(), packagePath, fileextension));
        }
    }

    public static List<Path> getFilesInPackage(String packageName, String fileextension) {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            String packagePath = packageName.replace(".", "/");
            Enumeration<URL> res = ResourceUtils.class.getClassLoader().getResources(packagePath);
            while (res.hasMoreElements()) {
                ResourceUtils.getFilesInPackageFromURL(res.nextElement(), packagePath, result, fileextension);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    public static <T> Map<String, T> json2Classes(String resourcePackage, String prefix, Class<T> clazz) throws IOException {
        return ResourceUtils.json2Classes(resourcePackage, prefix, "", clazz);
    }

    public static <T> Map<String, T> json2Classes(String resourcePackage, String prefix, String suffix, Class<T> clazz) throws IOException {
        TreeMap<String, Object> classes = new TreeMap<String, Object>();
        List<Path> paths = ResourceUtils.getFilesInPackage(resourcePackage, FILE_EXTENSION_JSON);
        ObjectMapper mapper = new ObjectMapper();
        for (Path filePath : paths) {
            String filename = filePath.getFileName().toString();
            try {
                if (!filename.toLowerCase().startsWith(prefix.toLowerCase()) || !filename.toLowerCase().endsWith((suffix + FILE_EXTENSION_JSON).toLowerCase())) continue;
                String name = filename.substring(prefix.length(), filename.length() - (suffix + FILE_EXTENSION_JSON).length());
                String json = Files.readString(filePath, StandardCharsets.UTF_8);
                classes.put(name, mapper.readValue(json, clazz));
            }
            catch (IOException e) {
                throw new IOException("Fehler beim Lesen aus der Datei " + filename + "!", e);
            }
        }
        return classes;
    }

    public static <T> Map<String, List<T>> json2Lists(String resourcePackage, String prefix, String suffix, Class<T> clazz) throws IOException {
        TreeMap<String, List<T>> classes = new TreeMap<String, List<T>>();
        List<Path> paths = ResourceUtils.getFilesInPackage(resourcePackage, FILE_EXTENSION_JSON);
        ObjectMapper mapper = new ObjectMapper();
        for (Path filePath : paths) {
            String filename = filePath.getFileName().toString();
            try {
                if (!filename.toLowerCase().startsWith(prefix.toLowerCase()) || !filename.toLowerCase().endsWith((suffix + FILE_EXTENSION_JSON).toLowerCase())) continue;
                String name = filename.substring(prefix.length(), filename.length() - (suffix + FILE_EXTENSION_JSON).length());
                String json = Files.readString(filePath, StandardCharsets.UTF_8);
                List list = (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
                classes.put(name, list);
            }
            catch (IOException e) {
                throw new IOException("Fehler beim Lesen aus der Datei " + filename + "!", e);
            }
        }
        return classes;
    }
}

