/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.compression;

import de.svws_nrw.base.compression.CompressionException;
import de.svws_nrw.base.compression.GZipWriterFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class GZip {
    private GZip() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static byte[] encodeData(GZipWriterFunction writer) throws CompressionException {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(output);){
                writer.write(gzipOut);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CompressionException("Fehler beim Komprimieren der Daten. ", e);
            }
        }
        output.close();
        return byArray;
    }

    public static byte[] decodeData(InputStream input) throws CompressionException {
        byte[] byArray;
        GZIPInputStream gzipIn = new GZIPInputStream(input);
        try {
            byArray = gzipIn.readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CompressionException("Fehler beim Dekomprimieren der Daten. ", e);
            }
        }
        gzipIn.close();
        return byArray;
    }

    public static byte[] encode(byte[] data) throws CompressionException {
        return GZip.encodeData(gzipOut -> gzipOut.write(data));
    }

    public static byte[] decode(byte[] data) throws CompressionException {
        byte[] byArray;
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            byArray = GZip.decodeData(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (e instanceof CompressionException) {
                    CompressionException ce = (CompressionException)e;
                    throw ce;
                }
                throw new CompressionException("Fehler beim Dekomprimieren der Daten. ", e);
            }
        }
        input.close();
        return byArray;
    }

    public static String encodeBase64(byte[] data) throws CompressionException {
        return Base64.getEncoder().encodeToString(GZip.encode(data));
    }

    public static byte[] decodeBase64(String data) throws CompressionException {
        return GZip.decode(Base64.getDecoder().decode(data));
    }
}

