/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.crypto;

import de.svws_nrw.base.crypto.AESAlgo;
import de.svws_nrw.base.crypto.AESException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static SecureRandom random = new SecureRandom();
    private final AESAlgo algo;
    private final SecretKey key;

    public AES(AESAlgo algo, SecretKey key) {
        this.algo = algo;
        this.key = key;
    }

    public byte[] encrypt(byte[] input) throws AESException {
        try {
            IvParameterSpec iv = AES.getRandomIV();
            Cipher cipher = Cipher.getInstance(this.algo.value());
            cipher.init(1, (Key)this.key, iv);
            int len = cipher.getOutputSize(input.length + 16);
            byte[] output = new byte[len];
            byte[] ivData = iv.getIV();
            System.arraycopy(ivData, 0, output, 0, 16);
            cipher.doFinal(input, 0, input.length, output, 16);
            return output;
        }
        catch (Exception e) {
            throw new AESException("Fehler beim Verschl\u00fcsseln der Daten.", e);
        }
    }

    public byte[] decrypt(byte[] input) throws AESException {
        try {
            if (input.length < 16) {
                throw new ArrayIndexOutOfBoundsException("Das \u00fcbegebene Array ist zu klein und kann noch nicht einmal einen Initialisierungsvbektor enthalten.");
            }
            IvParameterSpec iv = new IvParameterSpec(input, 0, 16);
            Cipher cipher = Cipher.getInstance(this.algo.value());
            cipher.init(2, (Key)this.key, iv);
            return cipher.doFinal(input, 16, input.length - 16);
        }
        catch (Exception e) {
            throw new AESException("Fehler beim Entschl\u00fcsseln der Daten.", e);
        }
    }

    public String encryptBase64(byte[] input) throws AESException {
        return Base64.getEncoder().encodeToString(this.encrypt(input));
    }

    public byte[] decryptBase64(String input) throws AESException {
        return this.decrypt(Base64.getDecoder().decode(input));
    }

    public static SecretKey getRandomKey256() throws AESException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw new AESException("Fehler beim Erstellen eines zuf\u00e4lligen AES-Schl\u00fcssels.", e);
        }
    }

    public static SecretKey getKey256(String password, String salt) throws AESException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 256);
            byte[] key = factory.generateSecret(spec).getEncoded();
            return new SecretKeySpec(key, "AES");
        }
        catch (Exception e) {
            throw new AESException("Fehler beim Erstellen eines des AES-Schl\u00fcssels aus dem Kennwort und dem Salt.", e);
        }
    }

    public static SecretKey getKeyFromByteArray(byte[] input) {
        return new SecretKeySpec(input, "AES");
    }

    private static IvParameterSpec getRandomIV() {
        byte[] result = new byte[16];
        random.nextBytes(result);
        return new IvParameterSpec(result);
    }
}

