/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.crypto;

import de.svws_nrw.base.crypto.AES;
import de.svws_nrw.base.crypto.AESAlgo;
import de.svws_nrw.base.crypto.RSAException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class RSA {
    public static final int DEFAULT_KEY_LENGTH = 8192;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public byte[] encrypt(byte[] input) throws RSAException {
        if (this.publicKey == null) {
            throw new RSAException("Fehler beim Verschl\u00fcsseln der Daten: Es steht kein \u00f6ffentlicher Schl\u00fcssel zur Verf\u00fcgung.");
        }
        try {
            SecretKey aeskey = AES.getRandomKey256();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, this.publicKey);
            byte[] aeskeyEncoded = cipher.doFinal(aeskey.getEncoded());
            AES aes = new AES(AESAlgo.CBC_PKCS5PADDING, aeskey);
            byte[] tmp = aes.encrypt(input);
            byte[] result = new byte[aeskeyEncoded.length + tmp.length];
            System.arraycopy(aeskeyEncoded, 0, result, 0, aeskeyEncoded.length);
            System.arraycopy(tmp, 0, result, aeskeyEncoded.length, tmp.length);
            return result;
        }
        catch (Exception e) {
            throw new RSAException("Fehler beim Verschl\u00fcsseln der Daten.", e);
        }
    }

    public byte[] decrypt(byte[] input) throws RSAException {
        if (this.privateKey == null) {
            throw new RSAException("Fehler beim Entschl\u00fcsseln der Daten: Es steht kein privater Schl\u00fcssel zur Verf\u00fcgung.");
        }
        try {
            int aeskeyEncodedLength = 1024;
            if (input.length < 1024) {
                throw new RSAException("Die Daten enthalten keinen mit RSA verschl\u00fcsselten AES-Schl\u00fcssel.");
            }
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, this.privateKey);
            byte[] aeskeyDecoded = cipher.doFinal(input, 0, 1024);
            int dataLength = input.length - 1024;
            byte[] tmp = new byte[dataLength];
            System.arraycopy(input, 1024, tmp, 0, dataLength);
            AES aes = new AES(AESAlgo.CBC_PKCS5PADDING, AES.getKeyFromByteArray(aeskeyDecoded));
            return aes.decrypt(tmp);
        }
        catch (Exception e) {
            throw new RSAException("Fehler beim Entschl\u00fcsseln der Daten.", e);
        }
    }

    public String encryptBase64(byte[] input) throws RSAException {
        return Base64.getEncoder().encodeToString(this.encrypt(input));
    }

    public byte[] decryptBase64(String input) throws RSAException {
        return this.decrypt(Base64.getDecoder().decode(input));
    }

    public static KeyPair createKey() throws RSAException {
        try {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
            keyGenerator.initialize(8192);
            return keyGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RSAException("Fehler beim Erstellen eines zuf\u00e4lligen RSA-Schl\u00fcssels.", e);
        }
    }

    public static KeyPair createKeyWithLength(int length) throws RSAException {
        try {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
            keyGenerator.initialize(length);
            return keyGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RSAException("Fehler beim Erstellen eines zuf\u00e4lligen RSA-Schl\u00fcssels.", e);
        }
    }

    public static String encodeKey(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public String encodePublicKey() throws RSAException {
        if (this.publicKey == null) {
            throw new RSAException("Der \u00f6ffentliche Schl\u00fcssel ist nicht vorhanden.");
        }
        return RSA.encodeKey(this.publicKey);
    }

    public String encodePrivateKey() throws RSAException {
        if (this.privateKey == null) {
            throw new RSAException("Der private Schl\u00fcssel ist nicht vorhanden.");
        }
        return RSA.encodeKey(this.privateKey);
    }

    public static PublicKey decodePublicKey(String key) throws RSAException {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(key);
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RSAException("Fehler beim Dekodieren des \u00f6ffentlichen RSA-Schl\u00fcssels.", e);
        }
    }

    public static PrivateKey decodePrivateKey(String key) throws RSAException {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(key);
            return KeyFactory.getInstance("RSA").generatePrivate(new X509EncodedKeySpec(keyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RSAException("Fehler beim Dekodieren des privaten RSA-Schl\u00fcssels.", e);
        }
    }
}

