/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.kurs42;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public final class Kurs42DataBlockung {
    public String Jahrgang;
    public int Jahr;
    public int Abschnitt;
    public String Bezeichnung;
    public String Schulnummer;

    public Kurs42DataBlockung(Path path) throws IOException {
        List<String> data;
        try {
            data = Files.readAllLines(path);
        }
        catch (IOException e) {
            data = Files.readAllLines(path, StandardCharsets.ISO_8859_1);
        }
        for (String line : data) {
            String[] parts;
            if (line.startsWith("[") || (parts = line.split("=")).length != 2) continue;
            try {
                switch (parts[0]) {
                    case "Jahrgang": {
                        this.Jahrgang = parts[1];
                        break;
                    }
                    case "Jahr": {
                        this.Jahr = Integer.parseInt(parts[1]);
                        break;
                    }
                    case "Abschnitt": {
                        this.Abschnitt = Integer.parseInt(parts[1]);
                        break;
                    }
                    case "Bezeichnung": {
                        this.Bezeichnung = parts[1];
                        break;
                    }
                    case "Schulnummer": {
                        this.Schulnummer = parts[1];
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String toString() {
        return "Kurs42DataBlockung [Jahrgang=" + this.Jahrgang + ", Jahr=" + this.Jahr + ", Abschnitt=" + this.Abschnitt + ", Bezeichnung=" + this.Bezeichnung + ", Schulnummer=" + this.Schulnummer + "]";
    }
}

