/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.kurs42;

import de.svws_nrw.base.CsvReader;
import de.svws_nrw.base.kurs42.Kurs42DataBlockplan;
import de.svws_nrw.base.kurs42.Kurs42DataBlockung;
import de.svws_nrw.base.kurs42.Kurs42DataFachwahlen;
import de.svws_nrw.base.kurs42.Kurs42DataFaecher;
import de.svws_nrw.base.kurs42.Kurs42DataKurse;
import de.svws_nrw.base.kurs42.Kurs42DataSchienen;
import de.svws_nrw.base.kurs42.Kurs42DataSchueler;
import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostBlockungKurs;
import de.svws_nrw.core.data.gost.GostBlockungKursLehrer;
import de.svws_nrw.core.data.gost.GostBlockungRegel;
import de.svws_nrw.core.data.gost.GostBlockungSchiene;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.kursblockung.GostKursblockungRegelTyp;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Kurs42Import {
    private final Logger logger;
    private final Set<Long> setSchueler;
    private final Kurs42DataBlockung k42Blockung;
    private final List<Kurs42DataSchueler> k42Schueler;
    private final List<Kurs42DataFaecher> k42Faecher;
    private final List<Kurs42DataKurse> k42Kurse;
    private final List<Kurs42DataSchienen> k42Schienen;
    private final List<Kurs42DataBlockplan> k42Blockplan;
    private final List<Kurs42DataFachwahlen> k42Fachwahlen;
    public final String name;
    public final int abiturjahrgang;
    public final GostHalbjahr halbjahr;
    public final List<GostBlockungRegel> regeln = new ArrayList<GostBlockungRegel>();
    public final List<GostBlockungKurs> kurse = new ArrayList<GostBlockungKurs>();
    public final List<GostBlockungSchiene> schienen = new ArrayList<GostBlockungSchiene>();
    public final HashMap2D<Long, Long, Pair<Long, Long>> zuordnung_kurs_schiene = new HashMap2D();
    public final HashMap2D<Long, Long, Pair<Long, Long>> zuordnung_kurs_schueler = new HashMap2D();
    private final Map<Long, Kurs42DataSchueler> mapSchuelerByID = new HashMap<Long, Kurs42DataSchueler>();
    private final Map<String, Kurs42DataSchueler> mapSchuelerByKey = new HashMap<String, Kurs42DataSchueler>();
    private final Map<String, Long> mapSchuelerKeyToID = new HashMap<String, Long>();
    private final Map<Long, String> mapSchuelerIDToKey = new HashMap<Long, String>();
    private final Map<String, Long> mapFachKuerzelToID = new HashMap<String, Long>();
    private final Map<Long, Kurs42DataKurse> mapKursByID = new HashMap<Long, Kurs42DataKurse>();
    private final Map<String, Kurs42DataKurse> mapKursByName = new HashMap<String, Kurs42DataKurse>();
    private final Map<String, Long> mapKursNameToID = new HashMap<String, Long>();
    private final Map<Long, Kurs42DataSchienen> mapSchieneByID = new HashMap<Long, Kurs42DataSchienen>();
    private final Map<Integer, Long> mapSchieneNrToID = new HashMap<Integer, Long>();
    private final Map<Long, String> mapSchieneIDToName = new HashMap<Long, String>();
    private final Map<String, Integer> counterKurse = new HashMap<String, Integer>();
    private static final Function<Kurs42DataSchueler, String> getSchuelerKey = schueler -> schueler.Name + ";" + schueler.Vorname + ";" + schueler.GebDat + ";" + schueler.Geschlecht;
    private static final Function<Kurs42DataFachwahlen, String> getSchuelerKeyFW = schuelerFW -> schuelerFW.Name + ";" + schuelerFW.Vorname + ";" + schuelerFW.GebDat + ";" + schuelerFW.Geschlecht;

    public Kurs42Import(Path parent, int schulnummer, Map<String, Long> mapLehrer, Set<Long> setSchueler, Logger logger) throws IOException {
        this.logger = logger;
        this.setSchueler = setSchueler;
        this.k42Blockung = new Kurs42DataBlockung(parent.resolve("Blockung.txt"));
        this.k42Schueler = CsvReader.from(parent.resolve("Schueler.txt"), Kurs42DataSchueler.class);
        this.k42Faecher = CsvReader.from(parent.resolve("Faecher.txt"), Kurs42DataFaecher.class);
        this.k42Kurse = CsvReader.from(parent.resolve("Kurse.txt"), Kurs42DataKurse.class);
        this.k42Schienen = CsvReader.from(parent.resolve("Schienen.txt"), Kurs42DataSchienen.class);
        this.k42Blockplan = CsvReader.from(parent.resolve("Blockplan.txt"), Kurs42DataBlockplan.class);
        this.k42Fachwahlen = CsvReader.from(parent.resolve("Fachwahlen.txt"), Kurs42DataFachwahlen.class);
        if (!("" + schulnummer).equals(this.k42Blockung.Schulnummer)) {
            throw new IOException("Die Schulnummer der Schule stimmt nicht mit der Schulnummer des Kurs42-Exportes \u00fcberein. Die Daten k\u00f6nnen daher nicht importiert werden.");
        }
        this.name = this.k42Blockung.Bezeichnung == null || "".equals(this.k42Blockung.Bezeichnung) ? "Blockung importiert aus Kurs42" : this.k42Blockung.Bezeichnung;
        int abschnitt = this.k42Blockung.Abschnitt > 2 ? 2 : this.k42Blockung.Abschnitt;
        this.halbjahr = GostHalbjahr.fromJahrgangUndHalbjahr(this.k42Blockung.Jahrgang, abschnitt);
        this.abiturjahrgang = this.halbjahr.getAbiturjahrFromSchuljahr(this.k42Blockung.Jahr);
        for (Kurs42DataSchueler schueler : this.k42Schueler) {
            long id = schueler.DB_IdNr;
            String key = getSchuelerKey.apply(schueler);
            this.mapSchuelerByID.put(id, schueler);
            this.mapSchuelerByKey.put(key, schueler);
            this.mapSchuelerIDToKey.put(id, key);
            this.mapSchuelerKeyToID.put(key, id);
        }
        for (Kurs42DataFaecher fach : this.k42Faecher) {
            this.mapFachKuerzelToID.put(fach.Krz, fach.IDNr);
        }
        long curRegelID = 0L;
        curRegelID = this.initKurse(curRegelID, mapLehrer);
        this.initSchienen();
        curRegelID = this.initBlockplan(curRegelID);
        this.initFachwahlen();
    }

    private long initKurse(long firstRegelID, Map<String, Long> mapLehrer) throws IOException {
        long curRegelID = firstRegelID;
        long curKursID = 0L;
        for (Kurs42DataKurse k42Kurs : this.k42Kurse) {
            long id;
            ++curKursID;
            Long fachID = this.mapFachKuerzelToID.get(k42Kurs.Fach);
            if (fachID == null) {
                throw new IOException("Das bei den Kursen angegeben Fach mit dem K\u00fcrzel " + k42Kurs.Fach + " existiert nicht in der Liste der F\u00e4cher. Die zu importierenden Daten sind inkonsistent. Der Import wird abgebrochen.");
            }
            GostKursart kursart = GostKursart.fromKuerzel(k42Kurs.Kursart);
            String kursartKey = fachID + ";" + kursart.id;
            int kursnummer = this.counterKurse.getOrDefault(kursartKey, 0) + 1;
            this.counterKurse.put(kursartKey, kursnummer);
            GostBlockungKurs kurs = new GostBlockungKurs();
            kurs.id = id;
            kurs.fach_id = fachID;
            kurs.kursart = kursart.id;
            try {
                kurs.nummer = Integer.parseInt(k42Kurs.ParallelKursNr);
            }
            catch (NumberFormatException nfe) {
                kurs.nummer = kursnummer;
            }
            kurs.istKoopKurs = false;
            kurs.suffix = "";
            kurs.wochenstunden = k42Kurs.Std;
            kurs.anzahlSchienen = k42Kurs.Schienenzahl;
            if (k42Kurs.Lehrer != null && !"".equals(k42Kurs.Lehrer) && !"--".equals(k42Kurs.Lehrer)) {
                Long lehrerID = mapLehrer.get(k42Kurs.Lehrer);
                if (lehrerID == null) {
                    this.logger.logLn("Das bei den Kursen angegeben Lehrer-K\u00fcrzel %s existiert nicht in der Lehrer-Liste. Die zu importierenden Daten sind inkonsistent. Dem Kurs wird kein Lehrer zugeordnet.".formatted(k42Kurs.Lehrer));
                    continue;
                }
                GostBlockungKursLehrer kl = new GostBlockungKursLehrer();
                kl.id = lehrerID;
                kl.kuerzel = k42Kurs.Lehrer;
                kl.reihenfolge = 1;
                kl.wochenstunden = k42Kurs.Std;
                kurs.lehrer.add(kl);
            }
            this.kurse.add(kurs);
            this.mapKursByID.put(id, k42Kurs);
            this.mapKursByName.put(k42Kurs.Name, k42Kurs);
            this.mapKursNameToID.put(k42Kurs.Name, id);
            if (k42Kurs.Gesperrt != null && k42Kurs.Gesperrt.startsWith("[") && k42Kurs.Gesperrt.endsWith("]")) {
                try {
                    String[] tmpSchienen;
                    for (String schiene : tmpSchienen = k42Kurs.Gesperrt.substring(1, k42Kurs.Gesperrt.length() - 1).split(",")) {
                        if ("".equals(schiene.trim())) continue;
                        GostBlockungRegel regel = new GostBlockungRegel();
                        ++curRegelID;
                        regel.id = regel.id;
                        regel.typ = GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE.typ;
                        regel.parameter.add(id);
                        regel.parameter.add(Long.parseLong(schiene.trim()) + 1L);
                        this.regeln.add(regel);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(nfe);
                }
            }
            if (k42Kurs.FixiertInSchiene == null || "".equals(k42Kurs.FixiertInSchiene)) continue;
            try {
                GostBlockungRegel regel = new GostBlockungRegel();
                ++curRegelID;
                regel.id = regel.id;
                regel.typ = GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ;
                regel.parameter.add(id);
                regel.parameter.add(Long.parseLong(k42Kurs.FixiertInSchiene) + 1L);
                this.regeln.add(regel);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        }
        return curRegelID;
    }

    private void initSchienen() {
        long curSchienenID = 0L;
        for (Kurs42DataSchienen k42Schiene : this.k42Schienen) {
            long id;
            ++curSchienenID;
            this.mapSchieneByID.put(id, k42Schiene);
            this.mapSchieneIDToName.put(id, k42Schiene.Bezeichnung);
            this.mapSchieneNrToID.put(k42Schiene.Id, id);
            GostBlockungSchiene schiene = new GostBlockungSchiene();
            schiene.id = id;
            schiene.nummer = k42Schiene.Id;
            schiene.bezeichnung = k42Schiene.Bezeichnung;
            this.schienen.add(schiene);
        }
    }

    private long initBlockplan(long firstRegelID) throws IOException {
        long curRegelID = firstRegelID;
        for (Kurs42DataBlockplan bp : this.k42Blockplan) {
            Long id = this.mapKursNameToID.get(bp.Kursbezeichnung);
            int schienenNr = bp.Schiene + 1;
            if (id == null) {
                this.logger.logLn("Der im Blockplan angegebene Kurs '%s' existiert nicht in der Liste der Kurse. Die zu importierenden Daten sind inkonsistent. Dem Kurs wird nicht die Schiene %d zugeordnet.".formatted(bp.Kursbezeichnung, schienenNr));
                continue;
            }
            Long schienenID = this.mapSchieneNrToID.get(schienenNr);
            if (schienenID == null) {
                throw new IOException("Die im Blockplan angegebene Schienennummer " + bp.Schiene + " existiert nicht in der Schienen-Liste. Die zu importierenden Daten sind inkonsistent. Der Import wird abgebrochen.");
            }
            this.zuordnung_kurs_schiene.put(id, schienenID, new Pair<Long, Long>(id, schienenID));
            if (bp.Fixiert == 0) continue;
            GostBlockungRegel regel = new GostBlockungRegel();
            ++curRegelID;
            regel.id = regel.id;
            regel.typ = GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ;
            regel.parameter.add(id);
            regel.parameter.add(Long.valueOf(schienenNr));
            this.regeln.add(regel);
        }
        return curRegelID;
    }

    private void initFachwahlen() throws IOException {
        for (Kurs42DataFachwahlen fw : this.k42Fachwahlen) {
            String schuelerKey = getSchuelerKeyFW.apply(fw);
            Long kursID = this.mapKursNameToID.get(fw.Kurs);
            if (kursID == null) {
                this.logger.logLn("Der bei den Fachwahlen angegebene Kurs (%s) existiert nicht in der Liste der Kurse. Die zu importierenden Daten sind inkonsistent.".formatted(fw.Kurs));
                continue;
            }
            Long schuelerID = this.mapSchuelerKeyToID.get(schuelerKey);
            if (schuelerID == null) {
                throw new IOException("Der bei den Fachwahlen angegebene Datensatz enth\u00e4lt Sch\u00fclerdaten (" + schuelerKey + "), die in der Sch\u00fclerliste nicht existieren. Die zu importierenden Daten sind inkonsistent. Der Import wird abgebrochen.");
            }
            if (!this.setSchueler.contains(schuelerID)) {
                this.logger.logLn("Der Sch\u00fcler mit der ID %d existiert nicht in der SVWS-DB. Die Kurs-Sch\u00fcler-Zuordnung wird beim Import ignoriert.".formatted(schuelerID));
                continue;
            }
            this.zuordnung_kurs_schueler.put(kursID, schuelerID, new Pair<Long, Long>(kursID, schuelerID));
        }
    }
}

