/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.base.shell;

import de.svws_nrw.base.shell.CommandLineException;
import de.svws_nrw.base.shell.CommandLineExceptionType;
import de.svws_nrw.base.shell.CommandLineOption;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public class CommandLineParser {
    private boolean parsed = false;
    private final String[] args;
    @NotNull
    private final Logger logger;
    private final HashMap<String, CommandLineOption> options = new HashMap();
    private final HashMap<String, CommandLineOption> optionsLong = new HashMap();
    private final HashMap<String, String> values = new HashMap();

    public CommandLineParser(String[] args, @NotNull Logger logger) {
        this.args = args;
        this.logger = logger;
    }

    private void parse() throws CommandLineException {
        if (this.options.isEmpty()) {
            throw new CommandLineException(CommandLineExceptionType.NO_OPTIONS);
        }
        CommandLineOption current = this.options.entrySet().iterator().next().getValue();
        boolean isArgument = false;
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (isArgument) {
                this.values.put(current.getShortTag(), arg);
                isArgument = false;
                continue;
            }
            if (arg.startsWith("--")) {
                current = this.optionsLong.get(arg.substring(2));
            } else if (arg.startsWith("-")) {
                current = this.options.get(arg.substring(1));
            } else {
                throw new CommandLineException(CommandLineExceptionType.UNKNOWN_OPTION);
            }
            if (current == null) {
                throw new CommandLineException(CommandLineExceptionType.UNKNOWN_OPTION);
            }
            if (current.hasArgument()) {
                isArgument = true;
                continue;
            }
            this.values.put(current.getShortTag(), "");
        }
        this.parsed = true;
    }

    public void addOption(CommandLineOption option) throws CommandLineException {
        if (this.options.get(option.getShortTag()) != null) {
            throw new CommandLineException(CommandLineExceptionType.SHORT_TAG_ALREADY_DEFINED);
        }
        if (this.optionsLong.get(option.getLongTag()) != null) {
            throw new CommandLineException(CommandLineExceptionType.LONG_TAG_ALREADY_DEFINED);
        }
        this.options.put(option.getShortTag(), option);
        this.optionsLong.put(option.getLongTag(), option);
    }

    public String getValue(String tag) throws CommandLineException {
        if (!this.options.containsKey(tag)) {
            throw new CommandLineException(CommandLineExceptionType.UNKNOWN_OPTION);
        }
        if (!this.parsed) {
            this.parse();
        }
        return this.values.get(tag);
    }

    public String getValue(String tag, String def) {
        try {
            String result = this.getValue(tag);
            if (result != null) {
                return result;
            }
            return def;
        }
        catch (CommandLineException e) {
            return def;
        }
    }

    public boolean isSet(String tag) {
        if (!this.options.containsKey(tag)) {
            return false;
        }
        if (!this.parsed) {
            try {
                this.parse();
            }
            catch (CommandLineException e) {
                return false;
            }
        }
        return this.values.containsKey(tag);
    }

    public void printOptions(String error) {
        if (error != null) {
            this.logger.logLn(error);
        }
        this.logger.logLn("G\u00fcltige Kommandozeilen-Optionen sind:");
        for (CommandLineOption option : this.options.values()) {
            this.logger.logLn("  -" + option.getShortTag());
            this.logger.logLn("  --" + option.getLongTag());
            this.logger.logLn("        " + option.getDescription());
        }
    }

    public void printOptionsAndExit(int code, String error) {
        this.printOptions(error);
        System.exit(code);
    }
}

