/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss;

import de.svws_nrw.core.data.abschluss.AbschlussErgebnis;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.data.abschluss.GEAbschlussFaecher;
import de.svws_nrw.core.types.ge.GELeistungsdifferenzierteKursart;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class AbschlussManager {
    private AbschlussManager() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    @NotNull
    public static AbschlussErgebnis getErgebnis(SchulabschlussAllgemeinbildend abschluss, boolean erworben) {
        @NotNull AbschlussErgebnis ergebnis = new AbschlussErgebnis();
        ergebnis.abschluss = abschluss == null ? null : abschluss.toString();
        ergebnis.erworben = erworben;
        ergebnis.npFaecher = null;
        ergebnis.log = null;
        return ergebnis;
    }

    @NotNull
    public static AbschlussErgebnis getErgebnisNachpruefung(SchulabschlussAllgemeinbildend abschluss, List<@NotNull String> npFaecher) {
        @NotNull AbschlussErgebnis ergebnis = new AbschlussErgebnis();
        ergebnis.abschluss = abschluss == null ? null : abschluss.toString();
        ergebnis.erworben = false;
        ergebnis.npFaecher = npFaecher == null || npFaecher.isEmpty() ? null : npFaecher;
        ergebnis.log = null;
        return ergebnis;
    }

    public static boolean hatNachpruefungsmoeglichkeit(@NotNull AbschlussErgebnis ergebnis) {
        return ergebnis.npFaecher != null && !ergebnis.npFaecher.isEmpty();
    }

    @NotNull
    public static String getNPFaecherString(@NotNull AbschlussErgebnis ergebnis) {
        if (ergebnis.npFaecher == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String fach : ergebnis.npFaecher) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fach);
        }
        return sb.toString();
    }

    public static boolean equalsAbschluesse(String a, String b) {
        if (a == null || SchulabschlussAllgemeinbildend.OA.is(a)) {
            return b == null || SchulabschlussAllgemeinbildend.OA.is(b);
        }
        return a.equals(b);
    }

    @NotNull
    public static String getAbschluss(@NotNull AbschlussErgebnis ergebnis) {
        return ergebnis.abschluss == null ? SchulabschlussAllgemeinbildend.OA.toString() : ergebnis.abschluss;
    }

    @NotNull
    public static GEAbschlussFach erstelleAbschlussFach(@NotNull String kuerzel, String bezeichnung, int note, @NotNull GELeistungsdifferenzierteKursart kursart, Boolean istFremdsprache) {
        @NotNull GEAbschlussFach fach = new GEAbschlussFach();
        fach.kuerzel = kuerzel;
        fach.bezeichnung = bezeichnung == null || "".equals(bezeichnung) ? "---" : bezeichnung;
        fach.note = note;
        fach.kursart = kursart.kuerzel;
        fach.istFremdsprache = istFremdsprache != null && istFremdsprache != false;
        return fach;
    }

    @NotNull
    public static @NotNull List<@NotNull String> getKuerzel(@NotNull @NotNull List<@NotNull GEAbschlussFach> faecher) {
        @NotNull ArrayList<@NotNull String> result = new ArrayList<String>();
        for (int i = 0; i < faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = faecher.get(i);
            if (fach == null || fach.kuerzel == null || result.contains(fach.kuerzel)) continue;
            result.add(fach.kuerzel);
        }
        return result;
    }

    public static boolean pruefeHat4LeistungsdifferenzierteFaecher(@NotNull GEAbschlussFaecher abschlussFaecher) {
        if (abschlussFaecher.faecher == null) {
            return false;
        }
        int count = 0;
        @NotNull List<@NotNull GEAbschlussFach> faecher = abschlussFaecher.faecher;
        for (GEAbschlussFach fach : faecher) {
            GELeistungsdifferenzierteKursart kursart;
            if (fach == null || (kursart = GELeistungsdifferenzierteKursart.from(fach.kursart)) != GELeistungsdifferenzierteKursart.E && kursart != GELeistungsdifferenzierteKursart.G) continue;
            ++count;
        }
        return count == 4;
    }

    public static boolean pruefeKuerzelDuplikate(@NotNull GEAbschlussFaecher abschlussFaecher) {
        if (abschlussFaecher.faecher == null) {
            return true;
        }
        @NotNull HashSet<@NotNull String> kuerzel = new HashSet<String>();
        @NotNull List<@NotNull GEAbschlussFach> faecher = abschlussFaecher.faecher;
        for (GEAbschlussFach fach : faecher) {
            if (fach == null || fach.kuerzel == null || kuerzel.add(fach.kuerzel)) continue;
            return false;
        }
        return true;
    }
}

