/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss;

import de.svws_nrw.core.abschluss.bk.a.BKAnlageAFach;
import de.svws_nrw.core.abschluss.bk.a.BKAnlageAFaecher;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnisBerufsbildend;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;

public final class AbschlussManagerBerufsbildend {
    private AbschlussManagerBerufsbildend() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    @NotNull
    public static AbschlussErgebnisBerufsbildend getErgebnis(boolean hatBSA, double note, Boolean hatBA, SchulabschlussAllgemeinbildend abschlussAllgemeinbildend) {
        @NotNull AbschlussErgebnisBerufsbildend ergebnis = new AbschlussErgebnisBerufsbildend();
        ergebnis.hatBSA = hatBSA;
        ergebnis.note = note;
        ergebnis.hatBA = hatBA;
        ergebnis.abschlussAllgemeinbildend = abschlussAllgemeinbildend == null ? null : abschlussAllgemeinbildend.toString();
        ergebnis.log = null;
        return ergebnis;
    }

    public static double getDurchschnitt(@NotNull BKAnlageAFaecher abschlussFaecher) {
        if (abschlussFaecher.faecher == null || abschlussFaecher.faecher.isEmpty()) {
            return Double.NaN;
        }
        int sum = 0;
        for (BKAnlageAFach fach : abschlussFaecher.faecher) {
            sum += fach.note;
        }
        return (double)sum / (double)abschlussFaecher.faecher.size();
    }

    public static int getAnzahlDefizite(@NotNull BKAnlageAFaecher abschlussFaecher) {
        if (abschlussFaecher.faecher == null || abschlussFaecher.faecher.isEmpty()) {
            return -1;
        }
        int sum = 0;
        for (BKAnlageAFach fach : abschlussFaecher.faecher) {
            if (fach.note < 5) continue;
            ++sum;
        }
        return sum;
    }

    public static int getAnzahlUngenuegend(@NotNull BKAnlageAFaecher abschlussFaecher) {
        if (abschlussFaecher.faecher == null || abschlussFaecher.faecher.isEmpty()) {
            return -1;
        }
        int sum = 0;
        for (BKAnlageAFach fach : abschlussFaecher.faecher) {
            if (fach.note < 6) continue;
            ++sum;
        }
        return sum;
    }
}

