/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.bk.a;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.abschluss.AbschlussManagerBerufsbildend;
import de.svws_nrw.core.abschluss.bk.a.BKAnlageAFaecher;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnisBerufsbildend;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.types.fach.Sprachreferenzniveau;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;

public class BKAnlageA01Abschluss
extends Service<BKAnlageAFaecher, AbschlussErgebnisBerufsbildend> {
    @Override
    @NotNull
    public AbschlussErgebnisBerufsbildend handle(@NotNull BKAnlageAFaecher input) {
        this.logger.log(LogLevel.INFO, "Pr\u00fcfe BSA:");
        if (AbschlussManagerBerufsbildend.getAnzahlUngenuegend(input) > 0) {
            this.logger.logLn(LogLevel.INFO, " nicht erreicht (kein ungen\u00fcgend erlaubt, insgesamt " + AbschlussManagerBerufsbildend.getAnzahlUngenuegend(input) + ").");
            return AbschlussManagerBerufsbildend.getErgebnis(false, AbschlussManagerBerufsbildend.getDurchschnitt(input), false, SchulabschlussAllgemeinbildend.OA);
        }
        if (AbschlussManagerBerufsbildend.getAnzahlDefizite(input) > 1) {
            this.logger.logLn(LogLevel.INFO, " nicht erreicht (mehr als 1 Defizit, insgesamt " + AbschlussManagerBerufsbildend.getAnzahlDefizite(input) + ").");
            return AbschlussManagerBerufsbildend.getErgebnis(false, AbschlussManagerBerufsbildend.getDurchschnitt(input), false, SchulabschlussAllgemeinbildend.OA);
        }
        this.logger.logLn(LogLevel.INFO, " erreicht.");
        if (input.englischGeR == null || Sprachreferenzniveau.B1.vergleiche(input.englischGeR) < 0) {
            if (input.englischGeR == null) {
                this.logger.logLn(LogLevel.INFO, "Das Sprachreferenzniveau in Englisch wurde nicht angegeben. Eine Pr\u00fcfung auf MSA ist daher nicht m\u00f6glich.");
            } else {
                this.logger.logLn(LogLevel.INFO, "Das Sprachreferenzniveau in Englisch ist f\u00fcr den MSA nicht ausreichend.");
            }
            this.logger.logLn(LogLevel.INFO, "HSA10 wurde erreicht.");
            return AbschlussManagerBerufsbildend.getErgebnis(true, AbschlussManagerBerufsbildend.getDurchschnitt(input), input.hatBestandenBerufsAbschlussPruefung, SchulabschlussAllgemeinbildend.HA10);
        }
        if (AbschlussManagerBerufsbildend.getDurchschnitt(input) <= 2.5) {
            this.logger.logLn(LogLevel.INFO, "Die Durschnittsnote ist besser als oder gleich 2,5.");
            this.logger.logLn(LogLevel.INFO, "MSA-Q wurde erreicht.");
            return AbschlussManagerBerufsbildend.getErgebnis(false, AbschlussManagerBerufsbildend.getDurchschnitt(input), input.hatBestandenBerufsAbschlussPruefung, SchulabschlussAllgemeinbildend.MSA_Q);
        }
        if (AbschlussManagerBerufsbildend.getDurchschnitt(input) <= 3.5) {
            this.logger.logLn(LogLevel.INFO, "Die Durschnittsnote ist besser als oder gleich 3,5, aber schlechter als 2,5.");
            this.logger.logLn(LogLevel.INFO, "MSA wurde erreicht.");
            return AbschlussManagerBerufsbildend.getErgebnis(false, AbschlussManagerBerufsbildend.getDurchschnitt(input), input.hatBestandenBerufsAbschlussPruefung, SchulabschlussAllgemeinbildend.MSA);
        }
        this.logger.logLn(LogLevel.INFO, "Die Durschnittsnote ist schlechter als 3,5.");
        this.logger.logLn(LogLevel.INFO, "HSA10 wurde erreicht.");
        return AbschlussManagerBerufsbildend.getErgebnis(false, AbschlussManagerBerufsbildend.getDurchschnitt(input), input.hatBestandenBerufsAbschlussPruefung, SchulabschlussAllgemeinbildend.HA10);
    }
}

