/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.abschluss.AbschlussManager;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.types.ge.GELeistungsdifferenzierteKursart;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

@XmlRootElement(name="AbschlussFaecherGruppe")
@Schema(name="AbschlussFaecherGruppe", description="die Fachinformationen f\u00fcr die Abschlussberechnung, welche den jeweiligen F\u00e4chergruppen zugeordnet ist.")
public class AbschlussFaecherGruppe {
    @NotNull
    private final @NotNull ArrayList<@NotNull GEAbschlussFach> faecher = new ArrayList();

    public AbschlussFaecherGruppe(@NotNull @NotNull List<@NotNull GEAbschlussFach> faecherAlle, List<@NotNull String> faecherNutzen, List<@NotNull String> faecherFiltern) {
        if (faecherAlle == null) {
            return;
        }
        for (int i = 0; i < faecherAlle.size(); ++i) {
            @NotNull GEAbschlussFach fach = faecherAlle.get(i);
            if (fach.kuerzel == null || faecherFiltern != null && faecherFiltern.contains(fach.kuerzel) || faecherNutzen != null && !faecherNutzen.contains(fach.kuerzel)) continue;
            this.faecher.add(AbschlussManager.erstelleAbschlussFach(fach.kuerzel, fach.bezeichnung, fach.note, GELeistungsdifferenzierteKursart.from(fach.kursart), fach.istFremdsprache));
        }
    }

    public boolean istVollstaendig(List<@NotNull String> faecherAbgleich) {
        if (faecherAbgleich == null) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        for (String kuerzel : faecherAbgleich) {
            if (this.contains(kuerzel)) continue;
            return false;
        }
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (faecherAbgleich.contains(fach.kuerzel)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.faecher.isEmpty();
    }

    public boolean contains(String kuerzel) {
        if (kuerzel == null) {
            return false;
        }
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (fach == null || !fach.kuerzel.equals(kuerzel)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull GEAbschlussFach> entferneFaecher(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull ArrayList<@NotNull GEAbschlussFach> selected = new ArrayList<GEAbschlussFach>();
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach)) continue;
            selected.add(fach);
        }
        this.faecher.removeAll(selected);
        return selected;
    }

    public GEAbschlussFach getFach(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach)) continue;
            return fach;
        }
        return null;
    }

    @NotNull
    public @NotNull List<@NotNull GEAbschlussFach> getFaecher(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull ArrayList<@NotNull GEAbschlussFach> result = new ArrayList<GEAbschlussFach>();
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach)) continue;
            result.add(fach);
        }
        return result;
    }

    public long getFaecherAnzahl(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        long count = 0L;
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public @NotNull List<@NotNull String> getKuerzel(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull ArrayList<@NotNull String> result = new ArrayList<String>();
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach) || fach.kuerzel == null) continue;
            result.add(fach.kuerzel);
        }
        return result;
    }

    @NotNull
    public String getKuerzelListe(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (!filter.test(fach)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fach.kuerzel);
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        @NotNull StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.faecher.size(); ++i) {
            @NotNull GEAbschlussFach fach = this.faecher.get(i);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            @NotNull Object diffkursinfo = "";
            if (fach.kursart == null || fach.kuerzel == null) continue;
            if (!GELeistungsdifferenzierteKursart.Sonstige.hat(fach.kursart)) {
                diffkursinfo = (String)diffkursinfo + fach.kursart + ",";
            }
            sb.append(fach.kuerzel + "(" + (String)diffkursinfo + fach.note + ")");
        }
        return sb.toString();
    }
}

