/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppe;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.function.Predicate;

public class AbschlussFaecherGruppen {
    @NotNull
    public final AbschlussFaecherGruppe fg1;
    @NotNull
    public final AbschlussFaecherGruppe fg2;

    public AbschlussFaecherGruppen(@NotNull AbschlussFaecherGruppe fg1, @NotNull AbschlussFaecherGruppe fg2) {
        this.fg1 = fg1;
        this.fg2 = fg2;
    }

    public boolean isEmpty() {
        return this.fg1 == null || this.fg2 == null || this.fg1.isEmpty() || this.fg2.isEmpty();
    }

    public boolean contains(String kuerzel) {
        return this.fg1.contains(kuerzel) || this.fg2.contains(kuerzel);
    }

    @NotNull
    public @NotNull List<@NotNull GEAbschlussFach> getFaecher(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull List<@NotNull GEAbschlussFach> faecher = this.fg1.getFaecher(filter);
        faecher.addAll(this.fg2.getFaecher(filter));
        return faecher;
    }

    public long getFaecherAnzahl(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        return this.fg1.getFaecherAnzahl(filter) + this.fg2.getFaecherAnzahl(filter);
    }

    @NotNull
    public @NotNull List<@NotNull String> getKuerzel(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull List<@NotNull String> faecher = this.fg1.getKuerzel(filter);
        faecher.addAll(this.fg2.getKuerzel(filter));
        return faecher;
    }

    @NotNull
    public String getKuerzelListe(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filter) {
        @NotNull StringBuilder sb = new StringBuilder();
        @NotNull List<@NotNull String> faecher = this.getKuerzel(filter);
        for (String fach : faecher) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fach);
        }
        return sb.toString();
    }

    @NotNull
    public String getKuerzelListe(@NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filterFG1, @NotNull @NotNull Predicate<@NotNull GEAbschlussFach> filterFG2) {
        @NotNull StringBuilder sb = new StringBuilder();
        @NotNull List<@NotNull String> faecherFG1 = this.fg1.getKuerzel(filterFG1);
        @NotNull List<@NotNull String> faecherFG2 = this.fg2.getKuerzel(filterFG2);
        for (String fach : faecherFG1) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fach);
        }
        for (String fach : faecherFG2) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(fach);
        }
        return sb.toString();
    }
}

