/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.abschluss.AbschlussManager;
import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppe;
import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppen;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnis;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.data.abschluss.GEAbschlussFaecher;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.types.ge.GELeistungsdifferenzierteKursart;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ServiceAbschlussHA10
extends Service<GEAbschlussFaecher, AbschlussErgebnis> {
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizit = f -> f.note > 4 && f.ausgeglichen == false;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterMangelhaft = f -> f.note == 5;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterMangelhaftOhneZP10Faecher = f -> f.note == 5 && !"D".equals(f.kuerzel) && !"E".equals(f.kuerzel) && !"M".equals(f.kuerzel);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterUngenuegend = f -> f.note == 6;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterEKurse = f -> GELeistungsdifferenzierteKursart.E.hat(f.kursart);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterWeitereFremdsprachen = f -> !"E".equals(f.kuerzel) && f.istFremdsprache != null && f.istFremdsprache != false;
    @NotNull
    private static final String LOG_SEPERATOR = "______________________________";

    @Override
    @NotNull
    public AbschlussErgebnis handle(@NotNull GEAbschlussFaecher input) {
        this.logger.logLn(LogLevel.INFO, "Pr\u00fcfe HA10:");
        this.logger.logLn(LogLevel.DEBUG, "==========");
        if (input.faecher == null || !AbschlussManager.pruefeHat4LeistungsdifferenzierteFaecher(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht gen\u00fcgend leistungsdiffernzierte F\u00e4cher gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (!AbschlussManager.pruefeKuerzelDuplikate(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden F\u00e4cher mit dem gleichen K\u00fcrzel zur Abschlusspr\u00fcfung \u00fcbergeben. Dies ist nicht zul\u00e4ssig.");
            return AbschlussManager.getErgebnis(null, false);
        }
        @NotNull AbschlussFaecherGruppen faecher = new AbschlussFaecherGruppen(new AbschlussFaecherGruppe(input.faecher, Arrays.asList("D", "M", "LBNW", "LBAL"), null), new AbschlussFaecherGruppe(input.faecher, null, Arrays.asList("D", "M", "LBNW", "LBAL", "BI", "PH", "CH", "AT", "AW", "AH")));
        if (!faecher.fg1.istVollstaendig(Arrays.asList("D", "M", "LBNW", "LBAL"))) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht alle n\u00f6tigen Leistungen f\u00fcr die F\u00e4chergruppe 1 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (faecher.fg2.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Keine Leistungen f\u00fcr die F\u00e4chergruppe 2 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        @NotNull List<@NotNull GEAbschlussFach> weitereFS = faecher.fg2.entferneFaecher(filterWeitereFremdsprachen);
        if (!weitereFS.isEmpty()) {
            for (GEAbschlussFach gEAbschlussFach : weitereFS) {
                if (gEAbschlussFach.bezeichnung == null) continue;
                this.logger.logLn(LogLevel.DEBUG, " -> Ignoriere weitere Fremdsprache: " + gEAbschlussFach.bezeichnung + "(" + gEAbschlussFach.note + ")");
            }
        }
        this.logger.logLn(LogLevel.DEBUG, " - ggf. Verbessern der E-Kurs-Noten f\u00fcr die Defizitberechnung:");
        @NotNull List<@NotNull GEAbschlussFach> tmpFaecher = faecher.getFaecher(filterEKurse);
        for (GEAbschlussFach f : tmpFaecher) {
            if (f.kuerzel == null) continue;
            int note = f.note;
            int note_neu = note == 1 ? 1 : note - 1;
            this.logger.logLn(LogLevel.DEBUG, "   " + f.kuerzel + "(E):" + note + "->" + note_neu);
            f.note = note_neu;
        }
        this.logger.logLn(LogLevel.DEBUG, " -> FG1: F\u00e4cher " + faecher.fg1.toString());
        this.logger.logLn(LogLevel.DEBUG, " -> FG2: F\u00e4cher " + faecher.fg2.toString());
        @NotNull AbschlussErgebnis abschlussErgebnis = this.pruefeDefizite(faecher, "");
        if (abschlussErgebnis.erworben) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.INFO, " => HA 10: APO-SI \u00a741 (1)");
        } else if (AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussErgebnis)) {
            this.logger.logLn(LogLevel.INFO, " => kein HA10 - Nachpr\u00fcfungsm\u00f6glichkeite(en) in " + AbschlussManager.getNPFaecherString(abschlussErgebnis));
        } else {
            this.logger.logLn(LogLevel.INFO, " => kein HA10 - KEINE Nachpr\u00fcfungsm\u00f6glichkeiten!");
        }
        return abschlussErgebnis;
    }

    @NotNull
    private AbschlussErgebnis pruefeDefizite(@NotNull AbschlussFaecherGruppen faecher, @NotNull String logIndent) {
        boolean hatNP;
        long fg1_defizite = faecher.fg1.getFaecherAnzahl(filterDefizit);
        long fg2_defizite = faecher.fg2.getFaecherAnzahl(filterDefizit);
        long ges_defizite = fg1_defizite + fg2_defizite;
        long fg1_mangelhaft = faecher.fg1.getFaecherAnzahl(filterMangelhaft);
        long fg1_ungenuegend = faecher.fg1.getFaecherAnzahl(filterUngenuegend);
        long fg2_ungenuegend = faecher.fg2.getFaecherAnzahl(filterUngenuegend);
        if (fg1_defizite > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG1: Defizit" + (fg1_defizite > 1L ? "e" : "") + ": " + faecher.fg1.getKuerzelListe(filterDefizit));
        }
        if (fg2_defizite > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG2: Defizit" + (fg2_defizite > 1L ? "e" : "") + ": " + faecher.fg2.getKuerzelListe(filterDefizit));
        }
        if (fg1_ungenuegend > 0L || fg2_ungenuegend > 1L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu oft ungen\u00fcgend (6) - 0x6 in FG1 und max. 1x6 in FG2 erlaubt.");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, false);
        }
        this.logger.logLn(LogLevel.DEBUG, logIndent + " -> " + (fg2_ungenuegend == 1L ? "1x6 in FG2 erlaubt" : "0x6 in FG1 und FG2") + " -> pr\u00fcfe weitere Defizite");
        if (fg1_mangelhaft > 2L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite: Mehr als 2x5 in FG1");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, false);
        }
        if (fg1_mangelhaft == 2L && fg2_defizite > 1L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite: 2x5 in FG1 und mind. ein weiteres Defizit in FG2");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, false);
        }
        if (ges_defizite > 3L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite: Insgesamt mehr als 3 Defizite");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, false);
        }
        boolean bl = hatNP = fg1_mangelhaft == 2L || ges_defizite == 3L;
        if (hatNP) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite: " + (fg1_mangelhaft == 2L ? "2x5 in FG1, aber kein weiteres Defizit in FG2" : "3 Defizite nicht erlaubt"));
            this.logger.logLn(LogLevel.INFO, " -> Hinweis: Nachpr\u00fcfungen in ZP10-F\u00e4chern nicht m\u00f6glich");
            @NotNull List<@NotNull String> np_faecher = fg1_mangelhaft == 2L ? faecher.fg1.getKuerzel(filterMangelhaftOhneZP10Faecher) : faecher.getKuerzel(filterMangelhaftOhneZP10Faecher);
            @NotNull AbschlussErgebnis abschlussergebnis = AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.HA10, np_faecher);
            this.logger.logLn(LogLevel.INFO, (String)(AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussergebnis) ? " -> Nachpr\u00fcfungsm\u00f6glichkeit(en) in " + AbschlussManager.getNPFaecherString(abschlussergebnis) : " -> also: kein Nachpr\u00fcfungsm\u00f6glichkeit."));
            return abschlussergebnis;
        }
        if (fg1_defizite == 0L && fg2_defizite == 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> keine Defizite in FG1 und FG2");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, true);
        }
        this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zwei Defizite erlaubt (solange nicht beide in FG1)");
        return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.HA10, true);
    }
}

