/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.abschluss.AbschlussManager;
import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppe;
import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppen;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnis;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.data.abschluss.GEAbschlussFaecher;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.types.ge.GELeistungsdifferenzierteKursart;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ServiceAbschlussMSA
extends Service<GEAbschlussFaecher, AbschlussErgebnis> {
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite = f -> f.ausgeglichen == false && (f.note > 4 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 3);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite1NS = f -> f.ausgeglichen == false && (!GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 5 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 4);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite2NS = f -> f.ausgeglichen == false && (!GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 6 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 5);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefiziteMehrAls1NS = f -> f.ausgeglichen == false && (!GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 6 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note >= 5);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefiziteMehrAls2NS = f -> f.ausgeglichen == false && GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 6;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefiziteMitNPOption = f -> f.ausgeglichen == false && !GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 5;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizitWP = f -> f.ausgeglichen == false && f.note > 4 && "WP".equalsIgnoreCase(f.kuerzel);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizitNichtWP = f -> f.ausgeglichen == false && f.note > 4 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 3 && !"WP".equalsIgnoreCase(f.kuerzel);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterBenoetigte3er = f -> f.ausgleich == false && f.note <= 3 && GELeistungsdifferenzierteKursart.Sonstige.hat(f.kursart);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefiziteBenoetigte3erMitNPOption = f -> f.ausgleich == false && f.note == 4 && GELeistungsdifferenzierteKursart.Sonstige.hat(f.kursart);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterAusgleiche = f -> f.ausgleich == false && (f.note < 3 || !GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note < 4);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterAusgleiche3er = f -> f.ausgleich == false && f.note < 3;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterEKurse = f -> GELeistungsdifferenzierteKursart.E.hat(f.kursart);
    @NotNull
    private static final String LOG_SEPERATOR = "______________________________";

    @NotNull
    public static AbschlussFaecherGruppen getFaechergruppen(@NotNull @NotNull List<@NotNull GEAbschlussFach> input) {
        @NotNull AbschlussFaecherGruppen faecher = new AbschlussFaecherGruppen(new AbschlussFaecherGruppe(input, Arrays.asList("D", "M", "E", "WP"), null), new AbschlussFaecherGruppe(input, null, Arrays.asList("D", "M", "E", "WP", "LBNW", "LBAL")));
        return faecher;
    }

    @Override
    @NotNull
    public AbschlussErgebnis handle(@NotNull GEAbschlussFaecher input) {
        this.logger.logLn(LogLevel.INFO, "Pr\u00fcfe MSA:");
        this.logger.logLn(LogLevel.DEBUG, "==========");
        if (input.faecher == null || !AbschlussManager.pruefeHat4LeistungsdifferenzierteFaecher(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht gen\u00fcgend leistungsdiffernzierte F\u00e4cher gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (!AbschlussManager.pruefeKuerzelDuplikate(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden F\u00e4cher mit dem gleichen K\u00fcrzel zur Abschlusspr\u00fcfung \u00fcbergeben. Dies ist nicht zul\u00e4ssig.");
            return AbschlussManager.getErgebnis(null, false);
        }
        @NotNull AbschlussFaecherGruppen faecher = ServiceAbschlussMSA.getFaechergruppen(input.faecher);
        if (!faecher.fg1.istVollstaendig(Arrays.asList("D", "M", "E", "WP"))) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht alle n\u00f6tigen Leistungen f\u00fcr die F\u00e4chergruppe 1 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (faecher.fg2.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Keine Leistungen f\u00fcr die F\u00e4chergruppe 2 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        long anzahlEKurse = faecher.getFaecherAnzahl(filterEKurse);
        if (anzahlEKurse < 2L) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.INFO, " => kein MSA (FOR) - nicht gen\u00fcgend E-Kurse belegt");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
        }
        if (anzahlEKurse > 2L) {
            long zuviel = anzahlEKurse - 2L;
            GEAbschlussFach eKursFG2 = faecher.fg2.getFach(filterEKurse);
            if (eKursFG2 != null) {
                int note = eKursFG2.note;
                int note_neu = note == 1 ? 1 : note - 1;
                this.logger.logLn(LogLevel.DEBUG, "   " + eKursFG2.kuerzel + ":(E)" + note + "->(G)" + note_neu);
                eKursFG2.note = note_neu;
                eKursFG2.kursart = GELeistungsdifferenzierteKursart.G.kuerzel;
                --zuviel;
            }
            while (zuviel > 0L) {
                GEAbschlussFach eKursFG1 = faecher.fg1.getFach(filterEKurse);
                if (eKursFG1 != null) {
                    int note = eKursFG1.note;
                    int note_neu = note == 1 ? 1 : note - 1;
                    this.logger.logLn(LogLevel.DEBUG, "   " + eKursFG1.kuerzel + ":(E)" + note + "->(G)" + note_neu);
                    eKursFG1.note = note_neu;
                    eKursFG1.kursart = GELeistungsdifferenzierteKursart.G.kuerzel;
                    --zuviel;
                }
                --zuviel;
            }
        }
        this.logger.logLn(LogLevel.DEBUG, " -> FG1: F\u00e4cher " + faecher.fg1.toString());
        this.logger.logLn(LogLevel.DEBUG, " -> FG2: F\u00e4cher " + faecher.fg2.toString());
        @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeDefizite(faecher, "");
        if (abschlussergebnis.erworben) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.INFO, " => MSA (FOR): APO-SI \u00a742 (3)");
        } else if (AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussergebnis)) {
            this.logger.logLn(LogLevel.INFO, " => kein MSA (FOR) - Nachpr\u00fcfungsm\u00f6glichkeite(en) in " + AbschlussManager.getNPFaecherString(abschlussergebnis));
        } else {
            this.logger.logLn(LogLevel.INFO, " => kein MSA (FOR) - KEINE Nachpr\u00fcfungsm\u00f6glichkeiten!");
        }
        return abschlussergebnis;
    }

    @NotNull
    private AbschlussErgebnis pruefeDefizite(@NotNull AbschlussFaecherGruppen faecher, @NotNull String logIndent) {
        GEAbschlussFach ausgleichsFach;
        GEAbschlussFach defizitFach;
        boolean ignorieren_genutzt = false;
        boolean ausgleich_genutzt = false;
        boolean nachpruefung_genutzt = false;
        @NotNull ArrayList<@NotNull GEAbschlussFach> npFaecher = new ArrayList<GEAbschlussFach>();
        long fg1_defizite = faecher.fg1.getFaecherAnzahl(filterDefizite);
        long fg2_defizite = faecher.fg2.getFaecherAnzahl(filterDefizite);
        long fg1_anzahlAusgleiche = faecher.fg1.getFaecherAnzahl(filterAusgleiche);
        if (fg1_defizite > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG1: Defizit" + (fg1_defizite > 1L ? "e" : "") + ": " + faecher.fg1.getKuerzelListe(filterDefizite));
        }
        if (fg2_defizite > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG2: Defizit" + (fg2_defizite > 1L ? "e" : "") + ": " + faecher.fg2.getKuerzelListe(filterDefizite));
        }
        if (faecher.fg1.getFaecherAnzahl(filterDefiziteMehrAls1NS) > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> in FG1 unzul\u00e4ssig: mind. 1x6 oder bei einem G-Kurs 1x5");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
        }
        if (faecher.fg2.getFaecherAnzahl(filterDefiziteMehrAls2NS) > 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> in FG2 unzul\u00e4ssig: in einem G-Kurs 1x6");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
        }
        @NotNull List<@NotNull GEAbschlussFach> sonstige_ungenuegend = faecher.fg2.getFaecher(filterDefizite2NS);
        if (sonstige_ungenuegend.size() > 1) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite, kann nicht mehr als eine Note mit 6 (bzw. 5 bei einem G-Kurs) in FG2 unber\u00fccksichtigt lassen");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
        }
        if (sonstige_ungenuegend.size() == 1) {
            @NotNull GEAbschlussFach defizitFach2 = sonstige_ungenuegend.get(0);
            if (GELeistungsdifferenzierteKursart.Sonstige.hat(defizitFach2.kursart)) {
                defizitFach2.ausgeglichen = true;
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> unber\u00fccksichtigt: Defizit in " + defizitFach2.kuerzel + " (2 Notenstufen)");
                ignorieren_genutzt = true;
            } else {
                if (GELeistungsdifferenzierteKursart.E.hat(defizitFach2.kursart) && defizitFach2.note == 6) {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> Ein ungen\u00fcgend in dem E-Kurs " + defizitFach2.kuerzel + " kann nicht ausgelichen werden und eine Nachpr\u00fcfung ist nicht zul\u00e4ssig!");
                    return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
                }
                this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> Nachpr\u00fcfung muss falls m\u00f6glich in " + defizitFach2.kuerzel + " stattfinden!");
                nachpruefung_genutzt = true;
                npFaecher.add(defizitFach2);
                --defizitFach2.note;
            }
        }
        GEAbschlussFach wp_defizit = faecher.fg1.getFach(filterDefizitWP);
        if (fg1_defizite > 2L || fg1_defizite == 2L && wp_defizit == null || fg1_defizite == 2L && fg1_anzahlAusgleiche == 0L || fg1_defizite == 1L && wp_defizit == null && fg1_anzahlAusgleiche == 0L) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG1");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
        }
        if (fg1_defizite == 2L && wp_defizit != null) {
            if (nachpruefung_genutzt) {
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG1, eine Nachpr\u00fcfung in mehreren F\u00e4chern (WP, " + sonstige_ungenuegend.get((int)0).kuerzel + ") ist nicht m\u00f6glich!");
                return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
            }
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> WP-Defizite in FG1, eine Nachpr\u00fcfung ist, sofern m\u00f6glich, in WP n\u00f6tig!");
            npFaecher.add(wp_defizit);
            nachpruefung_genutzt = true;
        }
        if (fg1_defizite == 2L || fg1_defizite == 1L && wp_defizit == null) {
            ausgleich_genutzt = true;
            defizitFach = faecher.fg1.getFach(filterDefizitNichtWP);
            if (defizitFach == null) {
                throw new NullPointerException();
            }
            defizitFach.ausgeglichen = true;
            ausgleichsFach = faecher.fg1.getFach(filterAusgleiche);
            if (ausgleichsFach == null) {
                throw new NullPointerException();
            }
            ausgleichsFach.ausgleich = true;
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Gleiche das Defizit (FG1) in " + defizitFach.kuerzel + " mit " + ausgleichsFach.kuerzel + " (FG1) aus.");
        }
        if (fg1_defizite == 1L && wp_defizit != null) {
            defizitFach = wp_defizit;
            ausgleichsFach = faecher.fg1.getFach(filterAusgleiche);
            if (ausgleichsFach != null) {
                ausgleich_genutzt = true;
                defizitFach.ausgeglichen = true;
                ausgleichsFach.ausgleich = true;
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe mit Ausgleich: Gleiche das Defizit (FG1) in " + defizitFach.kuerzel + " mit " + ausgleichsFach.kuerzel + " (FG1) aus. " + defizitFach.kuerzel + " alternativ als Nachpr\u00fcfungsfach denkbar.");
                @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, 2L, ignorieren_genutzt, ausgleich_genutzt, nachpruefung_genutzt);
                if (!abschlussergebnis.erworben && abschlussergebnis.npFaecher != null && AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussergebnis) && wp_defizit.kuerzel != null) {
                    abschlussergebnis.npFaecher.add(wp_defizit.kuerzel);
                }
                return abschlussergebnis;
            }
            if (sonstige_ungenuegend.size() == 1 && !sonstige_ungenuegend.get((int)0).ausgeglichen.booleanValue()) {
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> das Defizit in WP kann nicht ausgeglichen werden und eine Nachpr\u00fcfung in mehreren F\u00e4chern (WP, " + sonstige_ungenuegend.get((int)0).kuerzel + ") ist nicht m\u00f6glich!");
                return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
            }
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> WP-Defizite in FG1 ohne Ausgleichsm\u00f6glichkeit, eine Nachpr\u00fcfung ist, sofern m\u00f6glich, in WP n\u00f6tig!");
            npFaecher.add(wp_defizit);
            nachpruefung_genutzt = true;
        }
        @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent, npFaecher, 2L, ignorieren_genutzt, ausgleich_genutzt, nachpruefung_genutzt);
        if (nachpruefung_genutzt && abschlussergebnis.erworben) {
            return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA, AbschlussManager.getKuerzel(npFaecher));
        }
        return abschlussergebnis;
    }

    @NotNull
    private AbschlussErgebnis pruefeFG2(@NotNull AbschlussFaecherGruppen faecher, @NotNull String logIndent, @NotNull @NotNull List<@NotNull GEAbschlussFach> npFaecher, long benoetige3er, boolean ignorierenGenutzt, boolean ausgleichGenutzt, boolean nachpruefungGenutzt) {
        boolean hat_defizit_sonstige_3er;
        @NotNull List<@NotNull GEAbschlussFach> defizite = faecher.fg2.getFaecher(filterDefizite);
        @NotNull List<@NotNull GEAbschlussFach> mangelhaft = faecher.fg2.getFaecher(filterDefizite1NS);
        boolean hat_defizit = !defizite.isEmpty();
        boolean bl = hat_defizit_sonstige_3er = faecher.fg2.getFaecherAnzahl(filterBenoetigte3er) < benoetige3er;
        if (!hat_defizit && !hat_defizit_sonstige_3er) {
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, true);
        }
        if (!ignorierenGenutzt) {
            for (GEAbschlussFach defizitFach : mangelhaft) {
                if (!GELeistungsdifferenzierteKursart.Sonstige.hat(defizitFach.kursart)) continue;
                defizitFach.ausgeglichen = true;
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe: Defizit unber\u00fccksichtigt in " + defizitFach.kuerzel);
                @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, benoetige3er, true, ausgleichGenutzt, nachpruefungGenutzt);
                if (abschlussergebnis.erworben) {
                    return abschlussergebnis;
                }
                defizitFach.ausgeglichen = false;
            }
        }
        if (!ausgleichGenutzt) {
            if (hat_defizit_sonstige_3er) {
                GEAbschlussFach ausgleichsFach = faecher.fg2.getFach(filterAusgleiche3er);
                if (ausgleichsFach == null) {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Kein Ausgleich f\u00fcr eine fehlende 3 vorhanden. ");
                } else {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe: Ausgleich einer fehlende 3 durch " + ausgleichsFach.kuerzel);
                    ausgleichsFach.ausgleich = true;
                    @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, benoetige3er - 1L, ignorierenGenutzt, true, nachpruefungGenutzt);
                    if (abschlussergebnis.erworben) {
                        return abschlussergebnis;
                    }
                    ausgleichsFach.ausgleich = false;
                }
            } else {
                @NotNull List<@NotNull GEAbschlussFach> ausgleichsFaecher = faecher.getFaecher(filterAusgleiche);
                if ((long)ausgleichsFaecher.size() <= benoetige3er) {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + " -> kann Ausgleichsregelung nicht nutzen, da nicht gen\u00fcgend 3er-F\u00e4cher vorhanden sind.");
                } else {
                    long anzahlSonstigeFaecherMind3 = faecher.fg2.getFaecherAnzahl(filterBenoetigte3er);
                    for (GEAbschlussFach defizitFach : defizite) {
                        for (GEAbschlussFach ausgleichsFach : ausgleichsFaecher) {
                            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe: Ausgleich von " + defizitFach.kuerzel + " durch " + ausgleichsFach.kuerzel);
                            if (GELeistungsdifferenzierteKursart.Sonstige.hat(ausgleichsFach.kursart) && anzahlSonstigeFaecherMind3 <= benoetige3er) {
                                this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> " + ausgleichsFach.kuerzel + " nicht als Ausgleich m\u00f6glich, da f\u00fcr die Mindestanforderung mind. " + benoetige3er + "x3 ben\u00f6tigt wird, aber nur " + anzahlSonstigeFaecherMind3 + "x3 zur Verf\u00fcgung steht.");
                                continue;
                            }
                            defizitFach.ausgeglichen = true;
                            ausgleichsFach.ausgleich = true;
                            @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, benoetige3er, ignorierenGenutzt, true, nachpruefungGenutzt);
                            if (abschlussergebnis.erworben) {
                                return abschlussergebnis;
                            }
                            defizitFach.ausgeglichen = false;
                            ausgleichsFach.ausgleich = false;
                        }
                    }
                }
            }
        }
        if (!nachpruefungGenutzt) {
            if (hat_defizit_sonstige_3er) {
                npKandidaten = faecher.fg2.getFaecher(filterDefiziteBenoetigte3erMitNPOption);
                for (GEAbschlussFach defizitFach : npKandidaten) {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe: Nachpr\u00fcfung in " + defizitFach.kuerzel + " auf befriedigend m\u00f6glich?");
                    defizitFach.ausgeglichen = true;
                    --defizitFach.note;
                    abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, benoetige3er, ignorierenGenutzt, ausgleichGenutzt, true);
                    this.logger.logLn(LogLevel.DEBUG, logIndent + (abschlussergebnis.erworben ? "   -> Ja!" : "   -> Nein!"));
                    if (abschlussergebnis.erworben) {
                        npFaecher.add(defizitFach);
                    }
                    ++defizitFach.note;
                    defizitFach.ausgeglichen = false;
                }
            } else {
                npKandidaten = faecher.fg2.getFaecher(filterDefiziteMitNPOption);
                for (GEAbschlussFach defizitFach : npKandidaten) {
                    this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe: Nachpr\u00fcfung in " + defizitFach.kuerzel + " m\u00f6glich?");
                    defizitFach.ausgeglichen = true;
                    --defizitFach.note;
                    abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, benoetige3er, ignorierenGenutzt, ausgleichGenutzt, true);
                    this.logger.logLn(LogLevel.DEBUG, logIndent + (abschlussergebnis.erworben ? "   -> Ja!" : "   -> Nein!"));
                    if (abschlussergebnis.erworben) {
                        npFaecher.add(defizitFach);
                    }
                    ++defizitFach.note;
                    defizitFach.ausgeglichen = false;
                }
            }
        }
        if (!nachpruefungGenutzt && !npFaecher.isEmpty()) {
            return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA, AbschlussManager.getKuerzel(npFaecher));
        }
        return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA, false);
    }
}

