/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.abschluss.AbschlussManager;
import de.svws_nrw.core.abschluss.ge.AbschlussFaecherGruppen;
import de.svws_nrw.core.abschluss.ge.ServiceAbschlussMSA;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnis;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.data.abschluss.GEAbschlussFaecher;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.types.ge.GELeistungsdifferenzierteKursart;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ServiceBerechtigungMSAQ
extends Service<GEAbschlussFaecher, AbschlussErgebnis> {
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite = f -> f.note > 3 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 2;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite1NS = f -> !GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 4 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 3;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizite2NS = f -> !GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 5 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note == 4;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizitWP = f -> f.note > 3 && "WP".equalsIgnoreCase(f.kuerzel);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterDefizitNichtWP = f -> f.note > 3 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 2 && !"WP".equalsIgnoreCase(f.kuerzel);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterFG1NichtAusgleichbar = f -> f.note > 4 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 3;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterFG2NichtAusgleichbar = f -> f.note > 5 || GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note > 3;
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterAusgleiche = f -> f.ausgleich == false && (f.note < 2 || !GELeistungsdifferenzierteKursart.G.hat(f.kursart) && f.note < 3);
    @NotNull
    private static final @NotNull Predicate<@NotNull GEAbschlussFach> filterEKurse = f -> GELeistungsdifferenzierteKursart.E.hat(f.kursart);
    @NotNull
    private static final String LOG_SEPERATOR = "______________________________";

    @Override
    @NotNull
    public AbschlussErgebnis handle(@NotNull GEAbschlussFaecher input) {
        this.logger.logLn(LogLevel.INFO, "Pr\u00fcfe MSA-Q:");
        this.logger.logLn(LogLevel.DEBUG, "============");
        if (input.faecher == null || !AbschlussManager.pruefeHat4LeistungsdifferenzierteFaecher(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht gen\u00fcgend leistungsdifferenzierte F\u00e4cher gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (!AbschlussManager.pruefeKuerzelDuplikate(input)) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden F\u00e4cher mit dem gleichen K\u00fcrzel zur Abschlusspr\u00fcfung \u00fcbergeben. Dies ist nicht zul\u00e4ssig.");
            return AbschlussManager.getErgebnis(null, false);
        }
        @NotNull AbschlussFaecherGruppen faecher = ServiceAbschlussMSA.getFaechergruppen(input.faecher);
        if (!faecher.fg1.istVollstaendig(Arrays.asList("D", "M", "E", "WP"))) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Es wurden nicht alle n\u00f6tigen Leistungen f\u00fcr die F\u00e4chergruppe 1 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        if (faecher.fg2.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.DEBUG, " => Fehler: Keine Leistungen f\u00fcr die F\u00e4chergruppe 2 gefunden.");
            return AbschlussManager.getErgebnis(null, false);
        }
        long anzahlEKurse = faecher.getFaecherAnzahl(filterEKurse);
        if (anzahlEKurse < 3L) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.INFO, " => kein MSA-Q (FOR-Q) - nicht gen\u00fcgend E-Kurse belegt");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (anzahlEKurse > 3L) {
            this.logger.logLn(LogLevel.DEBUG, " - Verbessern der E-Kurs-Noten f\u00fcr die Defizitberechnung, falls mehr als 3 E-Kurse vorhanden sind:");
            @NotNull List<@NotNull GEAbschlussFach> tmpFaecher = faecher.fg2.getFaecher(filterEKurse);
            for (GEAbschlussFach f : tmpFaecher) {
                int note = f.note;
                int note_neu = note == 1 ? 1 : note - 1;
                this.logger.logLn(LogLevel.DEBUG, "   " + f.kuerzel + ":(E)" + note + "->(G)" + note_neu);
                f.note = note_neu;
                f.kursart = GELeistungsdifferenzierteKursart.G.kuerzel;
            }
        }
        this.logger.logLn(LogLevel.DEBUG, " -> FG1: F\u00e4cher " + faecher.fg1.toString());
        this.logger.logLn(LogLevel.DEBUG, " -> FG2: F\u00e4cher " + faecher.fg2.toString());
        @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeDefizite(faecher, "");
        if (abschlussergebnis.erworben) {
            this.logger.logLn(LogLevel.DEBUG, LOG_SEPERATOR);
            this.logger.logLn(LogLevel.INFO, " => MSA-Q (FOR-Q): APO-SI \u00a743 (4)");
        } else if (AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussergebnis)) {
            this.logger.logLn(LogLevel.INFO, " => kein MSA-Q (FOR-Q) - Nachpr\u00fcfungsm\u00f6glichkeite(en) in " + AbschlussManager.getNPFaecherString(abschlussergebnis));
        } else {
            this.logger.logLn(LogLevel.INFO, " => kein MSA-Q (FOR-Q) - KEINE Nachpr\u00fcfungsm\u00f6glichkeiten!");
        }
        return abschlussergebnis;
    }

    @NotNull
    private AbschlussErgebnis pruefeDefizite(@NotNull AbschlussFaecherGruppen faecher, @NotNull String logIndent) {
        GEAbschlussFach ausgleichsFach;
        GEAbschlussFach defizitFach;
        @NotNull List<@NotNull GEAbschlussFach> fg1_defizite = faecher.fg1.getFaecher(filterDefizite);
        @NotNull List<@NotNull GEAbschlussFach> fg2_defizite = faecher.fg2.getFaecher(filterDefizite);
        if (!fg1_defizite.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG1: Defizit" + (fg1_defizite.size() > 1 ? "e" : "") + ": " + faecher.fg1.getKuerzelListe(filterDefizite));
        }
        if (!fg2_defizite.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> FG2: Defizit" + (fg2_defizite.size() > 1 ? "e" : "") + ": " + faecher.fg2.getKuerzelListe(filterDefizite));
        }
        boolean nachpruefung_genutzt = false;
        @NotNull ArrayList<@NotNull GEAbschlussFach> npFaecher = new ArrayList<GEAbschlussFach>();
        @NotNull List<@NotNull GEAbschlussFach> fg1_nicht_ausgleichbar = faecher.fg1.getFaecher(filterFG1NichtAusgleichbar);
        @NotNull List<@NotNull GEAbschlussFach> fg2_nicht_ausgleichbar = faecher.fg2.getFaecher(filterFG2NichtAusgleichbar);
        if (!fg1_nicht_ausgleichbar.isEmpty() || !fg2_nicht_ausgleichbar.isEmpty()) {
            @NotNull String str_faecher = faecher.getKuerzelListe(filterFG1NichtAusgleichbar, filterFG2NichtAusgleichbar);
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Defizit(e) in " + str_faecher + " aufgrund zu hoher Abweichungen nicht ausgleichbar.");
            if (fg1_nicht_ausgleichbar.isEmpty() && fg2_nicht_ausgleichbar.size() == 1 && GELeistungsdifferenzierteKursart.G.hat(fg2_nicht_ausgleichbar.get((int)0).kursart) && fg2_nicht_ausgleichbar.get((int)0).note == 4) {
                this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> Nachpr\u00fcfung muss falls m\u00f6glich in " + fg2_nicht_ausgleichbar.get((int)0).kuerzel + " stattfinden!");
                nachpruefung_genutzt = true;
                npFaecher.add(fg2_nicht_ausgleichbar.get(0));
            } else {
                return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
            }
        }
        @NotNull List<@NotNull GEAbschlussFach> fg1_ausgleichsfaecher = faecher.fg1.getFaecher(filterAusgleiche);
        GEAbschlussFach wp_defizit = faecher.fg1.getFach(filterDefizitWP);
        if (fg1_defizite.size() > 2 || fg1_defizite.size() == 2 && wp_defizit == null) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG1");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (fg1_defizite.size() == 2 && wp_defizit != null && fg1_ausgleichsfaecher.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG1 - kein Ausgleich m\u00f6glich");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (fg1_defizite.size() == 2 && wp_defizit != null && !fg1_ausgleichsfaecher.isEmpty() && !nachpruefung_genutzt) {
            GEAbschlussFach defizitFach2 = faecher.fg1.getFach(filterDefizitNichtWP);
            if (defizitFach2 == null) {
                throw new NullPointerException();
            }
            @NotNull GEAbschlussFach ausgleichsFach2 = fg1_ausgleichsfaecher.get(0);
            defizitFach2.ausgeglichen = true;
            ausgleichsFach2.ausgleich = true;
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Ausgleich von " + defizitFach2.kuerzel + " durch " + ausgleichsFach2.kuerzel);
            nachpruefung_genutzt = true;
            npFaecher.add(wp_defizit);
            @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent, npFaecher, nachpruefung_genutzt);
            if (abschlussergebnis.erworben) {
                return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA_Q, AbschlussManager.getKuerzel(npFaecher));
            }
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (fg1_defizite.size() == 1 && wp_defizit == null && fg1_ausgleichsfaecher.isEmpty()) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> kein Defizit-Ausgleich in FG1");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (fg1_defizite.size() == 1 && wp_defizit == null) {
            defizitFach = faecher.fg1.getFach(filterDefizitNichtWP);
            if (defizitFach == null) {
                throw new NullPointerException();
            }
            ausgleichsFach = fg1_ausgleichsfaecher.get(0);
            defizitFach.ausgeglichen = true;
            ausgleichsFach.ausgleich = true;
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Ausgleich von " + defizitFach.kuerzel + " durch " + ausgleichsFach.kuerzel);
        }
        if (fg1_defizite.size() == 1 && wp_defizit != null) {
            if (!fg1_ausgleichsfaecher.isEmpty()) {
                defizitFach = wp_defizit;
                ausgleichsFach = fg1_ausgleichsfaecher.get(0);
                defizitFach.ausgeglichen = true;
                ausgleichsFach.ausgleich = true;
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe FG2 mit der Option Ausgleich von " + defizitFach.kuerzel + " durch " + ausgleichsFach.kuerzel);
                @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, nachpruefung_genutzt);
                if (abschlussergebnis.erworben) {
                    return abschlussergebnis;
                }
                defizitFach.ausgeglichen = false;
                ausgleichsFach.ausgleich = false;
            }
            if (nachpruefung_genutzt) {
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Eine Nachpr\u00fcfung im WP-Fach und in dem leistungsdifferenzierten Fach der FG2 ist nicht gleichzeitig m\u00f6glich.");
                return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
            }
            wp_defizit.ausgleich = true;
            --wp_defizit.note;
            @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent, npFaecher, true);
            ++wp_defizit.note;
            wp_defizit.ausgleich = false;
            if (abschlussergebnis.erworben) {
                nachpruefung_genutzt = true;
                npFaecher.add(wp_defizit);
            }
            return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA_Q, AbschlussManager.getKuerzel(npFaecher));
        }
        Object log_fg2_indent = logIndent;
        if (fg2_nicht_ausgleichbar.size() == 1) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe FG2 mit Nachpr\u00fcfung in " + fg2_nicht_ausgleichbar.get((int)0).kuerzel);
            log_fg2_indent = (String)log_fg2_indent + "  ";
        }
        @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, (String)log_fg2_indent, npFaecher, nachpruefung_genutzt);
        if (fg2_nicht_ausgleichbar.size() == 1 && abschlussergebnis.erworben || !abschlussergebnis.erworben && AbschlussManager.hatNachpruefungsmoeglichkeit(abschlussergebnis)) {
            return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA_Q, AbschlussManager.getKuerzel(npFaecher));
        }
        return abschlussergebnis;
    }

    @NotNull
    private AbschlussErgebnis pruefeFG2(@NotNull AbschlussFaecherGruppen faecher, @NotNull String logIndent, @NotNull @NotNull List<@NotNull GEAbschlussFach> npFaecher, boolean nachpruefungGenutzt) {
        @NotNull List<@NotNull GEAbschlussFach> ges_ausgleichsfaecher = faecher.getFaecher(filterAusgleiche);
        @NotNull List<@NotNull GEAbschlussFach> fg2_defizite_1NS = faecher.fg2.getFaecher(filterDefizite1NS);
        @NotNull List<@NotNull GEAbschlussFach> fg2_defizite_2NS = faecher.fg2.getFaecher(filterDefizite2NS);
        int fg2_defizit_anzahl = fg2_defizite_1NS.size() + fg2_defizite_2NS.size();
        if (fg2_defizit_anzahl == 0) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> keine Defizite in FG2");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, true);
        }
        if (fg2_defizite_2NS.size() > 2 || fg2_defizit_anzahl > (nachpruefungGenutzt ? 3 : 4)) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG2 - mit Ausgleich und Nachpr\u00fcfung kein Abschluss m\u00f6glich");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (ges_ausgleichsfaecher.size() < fg2_defizit_anzahl - (nachpruefungGenutzt ? 0 : 1)) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> zu viele Defizite in FG2 - nicht gen\u00fcgend Ausgleichsf\u00e4cher vorhanden");
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, false);
        }
        if (fg2_defizite_2NS.size() == 2) {
            for (GEAbschlussFach defizitFach : fg2_defizite_2NS) {
                defizitFach.ausgeglichen = true;
                defizitFach.ausgleich = true;
                --defizitFach.note;
                this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe erneut mit Nachpr\u00fcfung in " + defizitFach.kuerzel);
                @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, true);
                this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> Nachpr\u00fcfung in " + defizitFach.kuerzel + (abschlussergebnis.erworben ? " m\u00f6glich" : " nicht m\u00f6glich"));
                if (abschlussergebnis.erworben) {
                    npFaecher.add(defizitFach);
                }
                defizitFach.ausgeglichen = true;
                defizitFach.ausgleich = true;
                ++defizitFach.note;
            }
            return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA_Q, AbschlussManager.getKuerzel(npFaecher));
        }
        if (ges_ausgleichsfaecher.size() >= fg2_defizit_anzahl) {
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> genug Ausgleichsf\u00e4cher vorhanden." + (nachpruefungGenutzt ? "" : " Nachpr\u00fcfung nicht n\u00f6tig."));
            return AbschlussManager.getErgebnis(SchulabschlussAllgemeinbildend.MSA_Q, true);
        }
        for (GEAbschlussFach defizitFach : fg2_defizite_1NS) {
            defizitFach.ausgeglichen = true;
            defizitFach.ausgleich = true;
            --defizitFach.note;
            this.logger.logLn(LogLevel.DEBUG, logIndent + " -> Pr\u00fcfe erneut mit Nachpr\u00fcfung in " + defizitFach.kuerzel);
            @NotNull AbschlussErgebnis abschlussergebnis = this.pruefeFG2(faecher, logIndent + "  ", npFaecher, true);
            this.logger.logLn(LogLevel.DEBUG, logIndent + "   -> Nachpr\u00fcfung in " + defizitFach.kuerzel + (abschlussergebnis.erworben ? " m\u00f6glich" : " nicht m\u00f6glich"));
            if (abschlussergebnis.erworben) {
                npFaecher.add(defizitFach);
            }
            defizitFach.ausgeglichen = true;
            defizitFach.ausgleich = true;
            ++defizitFach.note;
        }
        return AbschlussManager.getErgebnisNachpruefung(SchulabschlussAllgemeinbildend.MSA_Q, AbschlussManager.getKuerzel(npFaecher));
    }
}

