/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.ge;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.abschluss.AbschlussManager;
import de.svws_nrw.core.abschluss.ge.ServiceAbschlussHA10;
import de.svws_nrw.core.abschluss.ge.ServiceAbschlussHA9;
import de.svws_nrw.core.abschluss.ge.ServiceAbschlussMSA;
import de.svws_nrw.core.abschluss.ge.ServiceBerechtigungMSAQ;
import de.svws_nrw.core.data.abschluss.AbschlussErgebnis;
import de.svws_nrw.core.data.abschluss.GEAbschlussFach;
import de.svws_nrw.core.data.abschluss.GEAbschlussFaecher;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public class ServicePrognose
extends Service<GEAbschlussFaecher, AbschlussErgebnis> {
    private static boolean hatLernbereichsnoten(@NotNull GEAbschlussFaecher faecher) {
        boolean hatLBNW = false;
        boolean hatLBAL = false;
        if (faecher.faecher == null) {
            return false;
        }
        @NotNull List<@NotNull GEAbschlussFach> tmp = faecher.faecher;
        for (GEAbschlussFach fach : tmp) {
            if (fach == null) continue;
            hatLBNW = hatLBNW || "LBNW".equals(fach.kuerzel);
            hatLBAL = hatLBAL || "LBAL".equals(fach.kuerzel);
        }
        return hatLBNW && hatLBAL;
    }

    @Override
    @NotNull
    public AbschlussErgebnis handle(@NotNull GEAbschlussFaecher input) {
        if (!AbschlussManager.pruefeHat4LeistungsdifferenzierteFaecher(input)) {
            this.logger.logLn(LogLevel.DEBUG, "Fehler: Es wurden nicht gen\u00fcgend leistungsdiffernzierte F\u00e4cher gefunden.");
            @NotNull AbschlussErgebnis prognose = AbschlussManager.getErgebnis(null, false);
            prognose.log = this.log.getStrings();
            return prognose;
        }
        if (!AbschlussManager.pruefeKuerzelDuplikate(input)) {
            this.logger.logLn(LogLevel.DEBUG, "Fehler: Es wurden F\u00e4cher mit dem gleichen K\u00fcrzel zur Abschlusspr\u00fcfung \u00fcbergeben. Dies ist nicht zul\u00e4ssig.");
            @NotNull AbschlussErgebnis prognose = AbschlussManager.getErgebnis(null, false);
            prognose.log = this.log.getStrings();
            return prognose;
        }
        @NotNull SchulabschlussAllgemeinbildend abschluss = SchulabschlussAllgemeinbildend.OA;
        List<@NotNull String> np_faecher = null;
        if (!"10".equals(input.jahrgang)) {
            @NotNull ServiceAbschlussHA9 ha9 = new ServiceAbschlussHA9();
            @NotNull AbschlussErgebnis ha9output = ha9.handle(input);
            np_faecher = ha9output.npFaecher;
            if (ha9output.erworben) {
                abschluss = SchulabschlussAllgemeinbildend.HA9;
            }
            this.log.append(ha9.getLog());
            this.logger.logLn(LogLevel.INFO, "");
        } else if ("10".equals(input.jahrgang)) {
            abschluss = SchulabschlussAllgemeinbildend.HA9;
        }
        @NotNull ServiceAbschlussHA10 ha10 = new ServiceAbschlussHA10();
        @NotNull AbschlussErgebnis ha10output = ha10.handle(input);
        if (ha10output.erworben) {
            abschluss = SchulabschlussAllgemeinbildend.HA10;
        } else if ("10".equals(input.jahrgang) || SchulabschlussAllgemeinbildend.HA9.equals((Object)abschluss)) {
            np_faecher = ha10output.npFaecher;
        }
        this.log.append(ha10.getLog());
        if (!SchulabschlussAllgemeinbildend.OA.equals((Object)abschluss) || !ServicePrognose.hatLernbereichsnoten(input)) {
            @NotNull ServiceAbschlussMSA msa = new ServiceAbschlussMSA();
            @NotNull AbschlussErgebnis msaOutput = msa.handle(input);
            this.logger.logLn(LogLevel.INFO, "");
            this.log.append(msa.getLog());
            if (msaOutput.erworben) {
                abschluss = SchulabschlussAllgemeinbildend.MSA;
                @NotNull ServiceBerechtigungMSAQ msaq = new ServiceBerechtigungMSAQ();
                @NotNull AbschlussErgebnis msaqOutput = msaq.handle(input);
                if (msaqOutput.erworben) {
                    abschluss = SchulabschlussAllgemeinbildend.MSA_Q;
                } else {
                    np_faecher = msaqOutput.npFaecher;
                }
                this.logger.logLn(LogLevel.INFO, "");
                this.log.append(msaq.getLog());
            } else {
                np_faecher = msaOutput.npFaecher;
            }
        }
        @NotNull AbschlussErgebnis prognose = AbschlussManager.getErgebnisNachpruefung(abschluss, np_faecher);
        prognose.erworben = !SchulabschlussAllgemeinbildend.OA.equals((Object)abschluss);
        prognose.log = this.log.getStrings();
        return prognose;
    }
}

