/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungErgebnis;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungErgebnisFehler;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.abschluss.gost.belegpruefung.AbiFaecher;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Allgemeines;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Deutsch;
import de.svws_nrw.core.abschluss.gost.belegpruefung.FachWaehlbar;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Fachkombinationen;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Fremdsprachen;
import de.svws_nrw.core.abschluss.gost.belegpruefung.GesellschaftswissenschaftenUndReligion;
import de.svws_nrw.core.abschluss.gost.belegpruefung.KurszahlenUndWochenstunden;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Latinum;
import de.svws_nrw.core.abschluss.gost.belegpruefung.LiterarischKuenstlerisch;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Mathematik;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Naturwissenschaften;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Projektkurse;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Schwerpunkt;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Sport;
import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.Abiturdaten;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostJahrgangFachkombination;
import de.svws_nrw.core.data.gost.GostJahrgangsdaten;
import de.svws_nrw.core.data.gost.GostSchuelerFachwahl;
import de.svws_nrw.core.data.schueler.Sprachendaten;
import de.svws_nrw.core.types.Note;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.gost.GostAbiturFach;
import de.svws_nrw.core.types.gost.GostBesondereLernleistung;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import de.svws_nrw.core.utils.gost.GostFachUtils;
import de.svws_nrw.core.utils.gost.GostFaecherManager;
import de.svws_nrw.core.utils.schueler.SprachendatenUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbiturdatenManager {
    @NotNull
    private final Abiturdaten abidaten;
    private final GostJahrgangsdaten _jahrgangsdaten;
    @NotNull
    private final GostFaecherManager faecherManager;
    @NotNull
    private final GostBelegpruefungsArt pruefungsArt;
    @NotNull
    private final @NotNull Map<@NotNull GostFachbereich, @NotNull ArrayList<@NotNull AbiturFachbelegung>> mapFachbereiche = new ArrayMap<GostFachbereich, ArrayList<AbiturFachbelegung>>(GostFachbereich.values());
    @NotNull
    private @NotNull List<@NotNull GostBelegpruefung> belegpruefungen = new ArrayList<GostBelegpruefung>();
    private KurszahlenUndWochenstunden belegpruefungKurszahlenUndWochenstunden = null;
    @NotNull
    private @NotNull List<@NotNull GostBelegungsfehler> belegpruefungsfehler = new ArrayList<GostBelegungsfehler>();
    private boolean belegpruefungErfolgreich = false;

    public AbiturdatenManager(@NotNull Abiturdaten abidaten, GostJahrgangsdaten gostJahrgang, @NotNull GostFaecherManager faecherManager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        this.abidaten = abidaten;
        this._jahrgangsdaten = gostJahrgang;
        this.faecherManager = faecherManager;
        this.pruefungsArt = pruefungsArt;
        this.init();
    }

    @NotNull
    public @NotNull List<@NotNull GostBelegpruefung> getPruefungen(@NotNull GostBelegpruefungsArt pruefungsArt) {
        @NotNull ArrayList<@NotNull GostBelegpruefung> pruefungen = new ArrayList<GostBelegpruefung>();
        pruefungen.add(new Deutsch(this, pruefungsArt));
        @NotNull Fremdsprachen pruefungFremdsprachen = new Fremdsprachen(this, pruefungsArt);
        pruefungen.add(pruefungFremdsprachen);
        pruefungen.add(new Latinum(this, pruefungsArt));
        pruefungen.add(new LiterarischKuenstlerisch(this, pruefungsArt));
        pruefungen.add(new GesellschaftswissenschaftenUndReligion(this, pruefungsArt));
        pruefungen.add(new Mathematik(this, pruefungsArt));
        @NotNull Naturwissenschaften pruefungNaturwissenschaften = new Naturwissenschaften(this, pruefungsArt);
        pruefungen.add(pruefungNaturwissenschaften);
        pruefungen.add(new Sport(this, pruefungsArt));
        @NotNull Projektkurse pruefungProjektkurse = new Projektkurse(this, pruefungsArt);
        pruefungen.add(pruefungProjektkurse);
        pruefungen.add(new Schwerpunkt(this, pruefungsArt, pruefungFremdsprachen, pruefungNaturwissenschaften));
        pruefungen.add(new AbiFaecher(this, pruefungsArt));
        this.belegpruefungKurszahlenUndWochenstunden = new KurszahlenUndWochenstunden(this, pruefungsArt, (GostBelegpruefung)pruefungProjektkurse);
        pruefungen.add(this.belegpruefungKurszahlenUndWochenstunden);
        pruefungen.add(new Allgemeines(this, pruefungsArt));
        pruefungen.add(new Fachkombinationen(this, pruefungsArt));
        pruefungen.add(new FachWaehlbar(this, pruefungsArt));
        return pruefungen;
    }

    public void init() {
        if (this.abidaten == null) {
            return;
        }
        this.initMapFachbereiche();
        this.belegpruefungen = this.getPruefungen(this.pruefungsArt);
        for (int i = 0; i < this.belegpruefungen.size(); ++i) {
            @NotNull GostBelegpruefung belegpruefung = this.belegpruefungen.get(i);
            belegpruefung.pruefe();
        }
        this.belegpruefungsfehler = GostBelegpruefung.getBelegungsfehlerAlle(this.belegpruefungen);
        this.belegpruefungErfolgreich = GostBelegpruefung.istErfolgreich(this.belegpruefungsfehler);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initMapFachbereiche() {
        this.mapFachbereiche.clear();
        for (GostFachbereich fachbereich : GostFachbereich.values()) {
            this.mapFachbereiche.put(fachbereich, new ArrayList());
        }
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (this.zaehleBelegung(fachbelegung) <= 0) continue;
            GostFach fach = this.getFach(fachbelegung);
            @NotNull List<@NotNull GostFachbereich> fachbereiche = GostFachbereich.getBereiche(fach);
            for (GostFachbereich fachbereich : fachbereiche) {
                @NotNull List listFachbelegungen = this.mapFachbereiche.get((Object)fachbereich);
                if (listFachbelegungen == null) continue;
                listFachbelegungen.add(fachbelegung);
            }
        }
    }

    @NotNull
    public GostFaecherManager faecher() {
        return this.faecherManager;
    }

    @NotNull
    public GostBelegpruefungsArt getPruefungsArt() {
        return this.pruefungsArt;
    }

    public boolean istBewertet(@NotNull GostHalbjahr halbjahr) {
        return this.abidaten.bewertetesHalbjahr[halbjahr.id];
    }

    @NotNull
    public Sprachendaten getSprachendaten() {
        return this.abidaten.sprachendaten;
    }

    public static boolean istNullPunkteBelegungInQPhase(@NotNull AbiturFachbelegungHalbjahr halbjahresbelegung) {
        GostHalbjahr hj = GostHalbjahr.fromKuerzel(halbjahresbelegung.halbjahrKuerzel);
        if (hj == null || hj.istEinfuehrungsphase()) {
            return false;
        }
        return Note.fromKuerzel(halbjahresbelegung.notenkuerzel) == Note.UNGENUEGEND;
    }

    private static String getSchuelerFachwahlFromBelegung(@NotNull AbiturFachbelegung belegung, @NotNull GostHalbjahr halbjahr) {
        GostKursart kursart;
        AbiturFachbelegungHalbjahr halbjahresbelegung = belegung.belegungen[halbjahr.id];
        if (halbjahresbelegung == null) {
            halbjahresbelegung = new AbiturFachbelegungHalbjahr();
            halbjahresbelegung.halbjahrKuerzel = halbjahr.kuerzel;
            belegung.belegungen[halbjahr.id] = halbjahresbelegung;
        }
        if ((kursart = GostKursart.fromKuerzel(halbjahresbelegung.kursartKuerzel)) == null) {
            return "".equals(halbjahresbelegung.kursartKuerzel) ? null : halbjahresbelegung.kursartKuerzel;
        }
        if (AbiturdatenManager.istNullPunkteBelegungInQPhase(halbjahresbelegung)) {
            return null;
        }
        if (kursart == GostKursart.ZK || kursart == GostKursart.LK) {
            return kursart.kuerzel;
        }
        return halbjahresbelegung.schriftlich ? "S" : "M";
    }

    @NotNull
    public GostSchuelerFachwahl getSchuelerFachwahl(long fachID) {
        AbiturFachbelegung belegung = this.getFachbelegungByID(fachID);
        if (belegung == null) {
            return new GostSchuelerFachwahl();
        }
        @NotNull GostSchuelerFachwahl wahl = new GostSchuelerFachwahl();
        wahl.halbjahre[0] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.EF1);
        wahl.halbjahre[1] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.EF2);
        wahl.halbjahre[2] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.Q11);
        wahl.halbjahre[3] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.Q12);
        wahl.halbjahre[4] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.Q21);
        wahl.halbjahre[5] = AbiturdatenManager.getSchuelerFachwahlFromBelegung(belegung, GostHalbjahr.Q22);
        wahl.abiturFach = belegung.abiturFach;
        return wahl;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull GostSchuelerFachwahl> getSchuelerFachwahlen() {
        @NotNull HashMap<@NotNull Long, @NotNull GostSchuelerFachwahl> fachwahlen = new HashMap<Long, GostSchuelerFachwahl>();
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            fachwahlen.put(fb.fachID, this.getSchuelerFachwahl(fb.fachID));
        }
        return fachwahlen;
    }

    public GostFach getFach(AbiturFachbelegung belegung) {
        if (belegung == null) {
            return null;
        }
        return this.faecherManager.get(belegung.fachID);
    }

    public boolean pruefeBelegung(AbiturFachbelegung fachbelegung, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr == null || belegungHalbjahr.kursartKuerzel == null) {
                return false;
            }
            if (!AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            return false;
        }
        return true;
    }

    public int zaehleBelegung(AbiturFachbelegung fachbelegung) {
        if (fachbelegung == null) {
            return 0;
        }
        int anzahl = 0;
        for (int i = 0; i < 6; ++i) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[i];
            if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            ++anzahl;
        }
        return anzahl;
    }

    public int zaehleBelegungInHalbjahren(List<@NotNull AbiturFachbelegung> fachbelegungen, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return 0;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return 0;
        }
        int anzahl = 0;
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            for (GostHalbjahr halbjahr : halbjahre) {
                AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
                if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                ++anzahl;
            }
        }
        return anzahl;
    }

    public boolean pruefeBelegungMitKursart(AbiturFachbelegung fachbelegung, @NotNull GostKursart kursart, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr != null && kursart == GostKursart.fromKuerzel(belegungHalbjahr.kursartKuerzel) && !AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            return false;
        }
        return true;
    }

    public boolean pruefeBelegungExistiertMitKursart(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostKursart kursart, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null || fachbelegungen.isEmpty()) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungMitKursart(fachbelegung, kursart, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungHatMindestensEinmalKursart(AbiturFachbelegung fachbelegung, @NotNull GostKursart kursart, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return false;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr == null || kursart != GostKursart.fromKuerzel(belegungHalbjahr.kursartKuerzel) || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungMitSchriftlichkeitEinzeln(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, @NotNull GostHalbjahr halbjahr) {
        if (fachbelegung == null) {
            return false;
        }
        AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
        if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) {
            return false;
        }
        switch (schriftlichkeit) {
            case BELIEBIG: {
                return true;
            }
            case SCHRIFTLICH: {
                return belegungHalbjahr.schriftlich;
            }
            case MUENDLICH: {
                return !belegungHalbjahr.schriftlich;
            }
        }
        return false;
    }

    public boolean pruefeBelegungMitSchriftlichkeit(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            if (this.pruefeBelegungMitSchriftlichkeitEinzeln(fachbelegung, schriftlichkeit, halbjahr)) continue;
            return false;
        }
        return true;
    }

    public boolean pruefeBelegungErfuelltNicht(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr != null && !AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) && (schriftlichkeit == GostSchriftlichkeit.BELIEBIG || (schriftlichkeit != GostSchriftlichkeit.SCHRIFTLICH || belegungHalbjahr.schriftlich) && (schriftlichkeit != GostSchriftlichkeit.MUENDLICH || !belegungHalbjahr.schriftlich))) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungErfuelltNichtFallsBelegt(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) || schriftlichkeit == GostSchriftlichkeit.BELIEBIG || (schriftlichkeit != GostSchriftlichkeit.SCHRIFTLICH || belegungHalbjahr.schriftlich) && (schriftlichkeit != GostSchriftlichkeit.MUENDLICH || !belegungHalbjahr.schriftlich)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungHatMindestensEinmalSchriftlichkeit(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return false;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) || schriftlichkeit.istSchriftlich != null && !schriftlichkeit.istSchriftlich.equals(belegungHalbjahr.schriftlich)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertHatMindestensEinmalSchriftlichkeit(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null || fachbelegungen.isEmpty()) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungHatMindestensEinmalSchriftlichkeit(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiert(List<@NotNull AbiturFachbelegung> fachbelegungen, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        if (halbjahre == null || halbjahre.length == 0) {
            return true;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            List<AbiturFachbelegung> alleBelegungen;
            GostFach fach = this.faecherManager.get(fachbelegung.fachID);
            if (fach == null || (alleBelegungen = this.getFachbelegungByFachkuerzel(fach.kuerzel)) == null || alleBelegungen.isEmpty()) continue;
            boolean hatBelegung = true;
            for (GostHalbjahr halbjahr : halbjahre) {
                boolean hatHalbjahresBelegung = false;
                for (AbiturFachbelegung aktFachbelegung : alleBelegungen) {
                    AbiturFachbelegungHalbjahr belegungHalbjahr = aktFachbelegung.belegungen[halbjahr.id];
                    if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                    hatHalbjahresBelegung = true;
                    break;
                }
                if (hatHalbjahresBelegung) continue;
                hatBelegung = false;
                break;
            }
            if (!hatBelegung) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertEinzeln(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostHalbjahr halbjahr) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            List<AbiturFachbelegung> alleBelegungen;
            GostFach fach = this.faecherManager.get(fachbelegung.fachID);
            if (fach == null || (alleBelegungen = this.getFachbelegungByFachkuerzel(fach.kuerzel)) == null || alleBelegungen.isEmpty()) continue;
            for (AbiturFachbelegung aktFachbelegung : alleBelegungen) {
                AbiturFachbelegungHalbjahr belegungHalbjahr = aktFachbelegung.belegungen[halbjahr.id];
                if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean pruefeBelegungExistiertDurchgehendSchriftlich(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            List<AbiturFachbelegung> alleBelegungen;
            GostFach fach = this.faecherManager.get(fachbelegung.fachID);
            if (fach == null || (alleBelegungen = this.getFachbelegungByFachkuerzel(fach.kuerzel)) == null || alleBelegungen.isEmpty()) continue;
            boolean hatBelegung = true;
            for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
                boolean hatHalbjahresBelegung = false;
                for (AbiturFachbelegung aktFachbelegung : alleBelegungen) {
                    AbiturFachbelegungHalbjahr belegungHalbjahr = aktFachbelegung.belegungen[halbjahr.id];
                    if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) || (halbjahr == GostHalbjahr.Q11 || halbjahr == GostHalbjahr.Q12 || halbjahr == GostHalbjahr.Q21) && !belegungHalbjahr.schriftlich) continue;
                    hatHalbjahresBelegung = true;
                }
                if (hatHalbjahresBelegung) continue;
                hatBelegung = false;
                break;
            }
            if (!hatBelegung) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertMitSchriftlichkeitEinzeln(List<AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, @NotNull GostHalbjahr halbjahr) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungMitSchriftlichkeitEinzeln(fachbelegung, schriftlichkeit, halbjahr)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertMitSchriftlichkeit(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungMitSchriftlichkeit(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertHatMindestensEinmalKursart(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostKursart kursart, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungHatMindestensEinmalKursart(fachbelegung, kursart, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertErfuelltNicht(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungErfuelltNicht(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungExistiertErfuelltNichtFallsBelegt(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungErfuelltNichtFallsBelegt(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungDurchgehendBelegbar(AbiturFachbelegung fachbelegung, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegung == null) {
            return false;
        }
        if (!GostFachUtils.istDurchgehendBelegbarBisQ22(this.getFach(fachbelegung))) {
            return false;
        }
        return this.pruefeBelegungMitSchriftlichkeit(fachbelegung, schriftlichkeit, halbjahre);
    }

    public boolean pruefeBelegungDurchgehendBelegbarExistiert(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegungDurchgehendBelegbar(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeBelegungDurchgehendBelegtExistiert(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeBelegung(fachbelegung, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22) || !this.pruefeBelegungMitSchriftlichkeit(fachbelegung, schriftlichkeit, halbjahre)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefeAufKursart(AbiturFachbelegung fachbelegung, @NotNull GostKursart kursart) {
        if (fachbelegung == null) {
            return false;
        }
        for (AbiturFachbelegungHalbjahr belegunghalbjahr : fachbelegung.belegungen) {
            if (belegunghalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegunghalbjahr) || GostKursart.fromKuerzel(belegunghalbjahr.kursartKuerzel) != kursart) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterBelegungKursartExistiert(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostKursart kursart) {
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        if (fachbelegungen == null || fachbelegungen.isEmpty()) {
            return result;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            if (!this.pruefeAufKursart(fachbelegung, kursart)) continue;
            result.add(fachbelegung);
        }
        return result;
    }

    public boolean pruefeDurchgaengigkeit(AbiturFachbelegung fachbelegung) {
        if (fachbelegung == null || this.pruefeAufKursart(fachbelegung, GostKursart.ZK)) {
            return false;
        }
        return this.pruefeBelegung(fachbelegung, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22);
    }

    public int zaehleDurchgaengigeBelegungen(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return 0;
        }
        int anzahl = 0;
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            GostHalbjahr[] halbjahre;
            List<AbiturFachbelegung> alleBelegungen;
            GostFach fach = this.faecherManager.get(fachbelegung.fachID);
            if (fach == null || fachbelegung.belegungen[GostHalbjahr.EF1.id] == null || (alleBelegungen = this.getFachbelegungByFachkuerzel(fach.kuerzel)) == null || alleBelegungen.isEmpty()) continue;
            boolean hatBelegung = true;
            for (GostHalbjahr halbjahr : halbjahre = new GostHalbjahr[]{GostHalbjahr.EF1, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22}) {
                boolean hatHalbjahresBelegung = false;
                for (AbiturFachbelegung aktFachbelegung : alleBelegungen) {
                    AbiturFachbelegungHalbjahr belegungHalbjahr = aktFachbelegung.belegungen[halbjahr.id];
                    if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                    hatHalbjahresBelegung = true;
                    break;
                }
                if (hatHalbjahresBelegung) continue;
                hatBelegung = false;
                break;
            }
            if (!hatBelegung) continue;
            ++anzahl;
        }
        return anzahl;
    }

    public boolean pruefeDurchgaengigkeitSchriftlich(AbiturFachbelegung fachbelegung) {
        if (!this.pruefeDurchgaengigkeit(fachbelegung)) {
            return false;
        }
        return this.pruefeBelegungMitSchriftlichkeit(fachbelegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21);
    }

    public boolean pruefeExistiertAbiFach(List<@NotNull AbiturFachbelegung> fachbelegungen, GostAbiturFach ... arten) {
        if (arten == null || arten.length == 0) {
            return true;
        }
        if (fachbelegungen == null) {
            return false;
        }
        for (AbiturFachbelegung fachbelegung : fachbelegungen) {
            for (GostAbiturFach art : arten) {
                GostAbiturFach abiturFach = GostAbiturFach.fromID(fachbelegung.abiturFach);
                if (abiturFach != art) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hatAbiFach(@NotNull GostAbiturFach art) {
        for (AbiturFachbelegung fachbelegung : this.abidaten.fachbelegungen) {
            GostAbiturFach abiturFach = GostAbiturFach.fromID(fachbelegung.abiturFach);
            if (abiturFach != art) continue;
            return true;
        }
        return false;
    }

    public boolean hatDoppelteFachbelegungInHalbjahr(@NotNull GostHalbjahr halbjahr) {
        @NotNull HashSet<@NotNull String> set = new HashSet<String>();
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            AbiturFachbelegungHalbjahr belegungHalbjahr;
            GostFach fach = this.getFach(fb);
            if (fach == null || (belegungHalbjahr = this.getBelegungHalbjahr(fb, halbjahr, GostSchriftlichkeit.BELIEBIG)) == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            String kuerzel = GostFachUtils.getFremdsprache(fach);
            if (kuerzel == null) {
                String string = kuerzel = fach.kuerzel == null ? "" : fach.kuerzel;
            }
            if (set.add(kuerzel) || "VX".equals(kuerzel)) continue;
            return true;
        }
        return false;
    }

    public boolean hatDoppelteFachbelegung(GostHalbjahr ... halbjahre) {
        if (halbjahre == null || halbjahre.length == 0) {
            return false;
        }
        for (GostHalbjahr halbjahr : halbjahre) {
            if (!this.hatDoppelteFachbelegungInHalbjahr(halbjahr)) continue;
            return true;
        }
        return false;
    }

    public boolean istProjektKursBesondereLernleistung() {
        return GostBesondereLernleistung.PROJEKTKURS.is(this.abidaten.besondereLernleistung);
    }

    public AbiturFachbelegung getFachbelegungByID(long fachID) {
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (fach == null || fachID != fach.id) continue;
            return fb;
        }
        return null;
    }

    public AbiturFachbelegung getFachbelegungByKuerzel(String kuerzel) {
        if (kuerzel == null || "".equals(kuerzel)) {
            return null;
        }
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (fach == null || !kuerzel.equals(fach.kuerzel)) continue;
            return fb;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> getFachbelegungen(GostFachbereich ... fachbereiche) {
        if (fachbereiche == null || fachbereiche.length == 0) {
            return this.abidaten.fachbelegungen;
        }
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        for (GostFachbereich fachbereich : fachbereiche) {
            @NotNull List fachbelegungen = this.mapFachbereiche.get((Object)fachbereich);
            if (fachbelegungen == null) continue;
            result.addAll(fachbelegungen);
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> getFachbelegungenBilingual() {
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach;
            if (this.zaehleBelegung(fb) <= 0 || (fach = this.getFach(fb)) == null || GostFachbereich.FREMDSPRACHE.hat(fach) || GostFachbereich.DEUTSCH.hat(fach) || fach.biliSprache == null || "D".equals(fach.biliSprache)) continue;
            result.add(fb);
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterFremdspracheNeuEinsetzend(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return Collections.emptyList();
        }
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (fach == null || !fach.istFremdsprache || !fach.istFremdSpracheNeuEinsetzend) continue;
            result.add(fb);
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterFremdspracheFortgefuehrt(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return Collections.emptyList();
        }
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (fach == null || !fach.istFremdsprache || fach.istFremdSpracheNeuEinsetzend) continue;
            result.add(fb);
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterDurchgehendBelegbar(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        if (fachbelegungen == null) {
            return result;
        }
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (!GostFachUtils.istDurchgehendBelegbarBisQ22(fach)) continue;
            result.add(fb);
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterBelegungen(List<@NotNull AbiturFachbelegung> fachbelegungen, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return Collections.emptyList();
        }
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        for (AbiturFachbelegung fb : fachbelegungen) {
            if (!this.pruefeBelegung(fb, halbjahre)) continue;
            result.add(fb);
        }
        return result;
    }

    @NotNull
    private Set<ZulaessigesFach> getMengeStatistikFaecher(@NotNull @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen) {
        @NotNull HashSet<ZulaessigesFach> faecher = new HashSet<ZulaessigesFach>();
        for (AbiturFachbelegung fb : fachbelegungen) {
            ZulaessigesFach zulFach;
            GostFach fach = this.faecherManager.get(fb.fachID);
            if (fach == null || (zulFach = ZulaessigesFach.getByKuerzelASD(fach.kuerzel)) == ZulaessigesFach.DEFAULT) continue;
            faecher.add(zulFach);
        }
        return faecher;
    }

    public int zaehleBelegungenDurchgaengig(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return 0;
        }
        @NotNull Set<ZulaessigesFach> faecher = this.getMengeStatistikFaecher(fachbelegungen);
        int count = 0;
        for (ZulaessigesFach zulFach : faecher) {
            boolean vorhanden = true;
            for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
                boolean belegung_vorhanden = false;
                for (AbiturFachbelegung fb : fachbelegungen) {
                    GostFach fbFach = this.faecherManager.get(fb.fachID);
                    if (fbFach == null) continue;
                    @NotNull ZulaessigesFach fbZulFach = ZulaessigesFach.getByKuerzelASD(fbFach.kuerzel);
                    AbiturFachbelegungHalbjahr belegungHalbjahr = fb.belegungen[halbjahr.id];
                    if (zulFach != fbZulFach || belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                    belegung_vorhanden = true;
                    break;
                }
                if (belegung_vorhanden) continue;
                vorhanden = false;
                break;
            }
            if (!vorhanden) continue;
            ++count;
        }
        return count;
    }

    public int zaehleBelegungenDurchgaengigSchriftlichInQPhase(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        if (fachbelegungen == null) {
            return 0;
        }
        @NotNull Set<ZulaessigesFach> faecher = this.getMengeStatistikFaecher(fachbelegungen);
        int count = 0;
        for (ZulaessigesFach zulFach : faecher) {
            boolean vorhanden = true;
            for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
                boolean belegung_vorhanden = false;
                for (AbiturFachbelegung fb : fachbelegungen) {
                    AbiturFachbelegungHalbjahr belegungHalbjahr;
                    ZulaessigesFach fbZulFach;
                    GostFach fbFach = this.faecherManager.get(fb.fachID);
                    if (fbFach == null || zulFach != (fbZulFach = ZulaessigesFach.getByKuerzelASD(fbFach.kuerzel)) || (belegungHalbjahr = fb.belegungen[halbjahr.id]) == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
                    boolean istSchriftlichkeitOK = true;
                    if (!(halbjahr != GostHalbjahr.Q11 && halbjahr != GostHalbjahr.Q12 && halbjahr != GostHalbjahr.Q21 || belegungHalbjahr.schriftlich)) {
                        istSchriftlichkeitOK = false;
                    }
                    if (!istSchriftlichkeitOK) continue;
                    belegung_vorhanden = true;
                    break;
                }
                if (belegung_vorhanden) continue;
                vorhanden = false;
                break;
            }
            if (!vorhanden) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> filterBelegungenMitSchriftlichkeit(List<@NotNull AbiturFachbelegung> fachbelegungen, @NotNull GostSchriftlichkeit schriftlichkeit, GostHalbjahr ... halbjahre) {
        if (fachbelegungen == null) {
            return Collections.emptyList();
        }
        @NotNull ArrayList<@NotNull AbiturFachbelegung> result = new ArrayList<AbiturFachbelegung>();
        for (AbiturFachbelegung fb : fachbelegungen) {
            if (!this.pruefeBelegungMitSchriftlichkeit(fb, schriftlichkeit, halbjahre)) continue;
            result.add(fb);
        }
        return result;
    }

    public AbiturFachbelegung getFachbelegung(@NotNull GostFachbereich fachbereich) {
        ArrayList<AbiturFachbelegung> faecher = this.mapFachbereiche.get((Object)fachbereich);
        if (faecher == null || faecher.isEmpty()) {
            return null;
        }
        return faecher.get(0);
    }

    @NotNull
    public @NotNull List<@NotNull AbiturFachbelegung> getFachbelegungByFachkuerzel(String kuerzel) {
        @NotNull ArrayList<@NotNull AbiturFachbelegung> fachbelegungen = new ArrayList<AbiturFachbelegung>();
        if (kuerzel == null) {
            return fachbelegungen;
        }
        @NotNull List<@NotNull AbiturFachbelegung> tmpFachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fachbelegung : tmpFachbelegungen) {
            GostFach fach = this.faecherManager.get(fachbelegung.fachID);
            if (fach == null || !kuerzel.equals(fach.kuerzel)) continue;
            fachbelegungen.add(fachbelegung);
        }
        return fachbelegungen;
    }

    public AbiturFachbelegungHalbjahr getBelegungHalbjahr(@NotNull AbiturFachbelegung fachbelegung, @NotNull GostHalbjahr halbjahr, @NotNull GostSchriftlichkeit schriftlich) {
        AbiturFachbelegungHalbjahr belegungHalbjahr = fachbelegung.belegungen[halbjahr.id];
        return belegungHalbjahr != null && !AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) && (schriftlich == GostSchriftlichkeit.BELIEBIG || schriftlich == GostSchriftlichkeit.SCHRIFTLICH && belegungHalbjahr.schriftlich || schriftlich == GostSchriftlichkeit.MUENDLICH && !belegungHalbjahr.schriftlich) ? belegungHalbjahr : null;
    }

    public AbiturFachbelegung getSprachbelegung(String sprache) {
        if (sprache == null) {
            return null;
        }
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = this.abidaten.fachbelegungen;
        for (AbiturFachbelegung fb : fachbelegungen) {
            GostFach fach = this.getFach(fb);
            if (fach == null || !GostFachUtils.istFremdsprachenfach(fach, sprache) || !sprache.equals(GostFachUtils.getFremdsprache(fach))) continue;
            return fb;
        }
        return null;
    }

    public GostKursart getMoeglicheKursartAlsAbiturfach(long id) {
        GostFach fach = this.faecherManager.get(id);
        if (fach == null) {
            return null;
        }
        AbiturFachbelegung belegung = this.getFachbelegungByID(id);
        if (belegung == null || belegung.letzteKursart == null) {
            return null;
        }
        GostKursart kursart = GostKursart.fromKuerzel(belegung.letzteKursart);
        if (kursart == null || kursart == GostKursart.LK && !fach.istMoeglichAbiLK || kursart == GostKursart.GK && !fach.istMoeglichAbiGK || kursart != GostKursart.GK && kursart != GostKursart.LK) {
            return null;
        }
        if (kursart == GostKursart.LK) {
            return this.pruefeBelegungMitKursart(belegung, kursart, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22) ? kursart : null;
        }
        if (belegung.belegungen[GostHalbjahr.Q22.id] == null) {
            return null;
        }
        @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = GostFachbereich.RELIGION.hat(fach) ? this.getFachbelegungen(GostFachbereich.RELIGION) : this.getFachbelegungByFachkuerzel(fach.kuerzel);
        return this.pruefeBelegungExistiertMitSchriftlichkeit(fachbelegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q11) && this.pruefeBelegungExistiertMitSchriftlichkeit(fachbelegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q12) && this.pruefeBelegungExistiertMitSchriftlichkeit(fachbelegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q21) ? kursart : null;
    }

    @NotNull
    public @NotNull List<@NotNull GostHalbjahr> getHalbjahreKursart(AbiturFachbelegung fachbelegung, GostKursart ... kursarten) {
        @NotNull ArrayList<@NotNull GostHalbjahr> halbjahre = new ArrayList<GostHalbjahr>();
        if (fachbelegung != null) {
            block0: for (AbiturFachbelegungHalbjahr belegungHalbjahr : fachbelegung.belegungen) {
                GostHalbjahr halbjahr;
                if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr) || (halbjahr = GostHalbjahr.fromKuerzel(belegungHalbjahr.halbjahrKuerzel)) == null) continue;
                if (kursarten == null || kursarten.length == 0) {
                    halbjahre.add(halbjahr);
                    continue;
                }
                for (GostKursart kursart : kursarten) {
                    if (!kursart.equals((Object)GostKursart.fromKuerzel(belegungHalbjahr.kursartKuerzel))) continue;
                    halbjahre.add(halbjahr);
                    continue block0;
                }
            }
        }
        return halbjahre;
    }

    public String getBiligualenBildungsgang() {
        return this.abidaten.bilingualeSprache;
    }

    public boolean hatFortgefuehrteFremdspracheInSprachendaten(List<@NotNull AbiturFachbelegung> fremdsprachen) {
        if (fremdsprachen == null) {
            return false;
        }
        if (this.abidaten.sprachendaten == null) {
            return false;
        }
        for (AbiturFachbelegung fs : fremdsprachen) {
            GostFach fach = this.getFach(fs);
            if (fach == null || !fach.istFremdsprache || !SprachendatenUtils.istFortfuehrbareSpracheInGOSt(this.abidaten.sprachendaten, GostFachUtils.getFremdsprache(fach))) continue;
            return true;
        }
        return false;
    }

    public boolean hatNeuEinsetzendeFremdspracheInSprachendaten(List<@NotNull AbiturFachbelegung> fremdsprachen) {
        if (fremdsprachen == null) {
            return false;
        }
        if (this.abidaten.sprachendaten == null) {
            return false;
        }
        for (AbiturFachbelegung fs : fremdsprachen) {
            GostFach fach = this.getFach(fs);
            if (fach == null || !fach.istFremdsprache || !SprachendatenUtils.istNeueinsetzbareSpracheInGOSt(this.abidaten.sprachendaten, GostFachUtils.getFremdsprache(fach))) continue;
            return true;
        }
        return false;
    }

    public boolean istBelegtSeitEF(@NotNull AbiturFachbelegung fachbelegung) {
        GostFach fach = this.getFach(fachbelegung);
        if (fach == null) {
            return false;
        }
        if (GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ.hat(fach)) {
            return true;
        }
        if (GostFachbereich.RELIGION.hat(fach)) {
            return true;
        }
        if ("PL".equals(fach.kuerzel)) {
            return true;
        }
        for (AbiturFachbelegungHalbjahr belegungHalbjahr : fachbelegung.belegungen) {
            AbiturFachbelegungHalbjahr belegungHalbjahrVorher;
            GostHalbjahr prevHalbjahr;
            if (belegungHalbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahr)) continue;
            GostHalbjahr halbjahr = GostHalbjahr.fromKuerzel(belegungHalbjahr.halbjahrKuerzel);
            GostKursart kursart = GostKursart.fromKuerzel(belegungHalbjahr.kursartKuerzel);
            if (halbjahr == null || kursart == null || kursart == GostKursart.ZK || kursart == GostKursart.PJK || kursart == GostKursart.VTF || (prevHalbjahr = halbjahr.previous()) == null || (belegungHalbjahrVorher = fachbelegung.belegungen[prevHalbjahr.id]) != null && !AbiturdatenManager.istNullPunkteBelegungInQPhase(belegungHalbjahrVorher)) continue;
            List<@NotNull AbiturFachbelegung> alleBelegungen = this.getFachbelegungByFachkuerzel(fach.kuerzel);
            if (alleBelegungen == null || alleBelegungen.size() <= 1) {
                return false;
            }
            if (this.pruefeBelegungExistiert(alleBelegungen, prevHalbjahr)) continue;
            return false;
        }
        return true;
    }

    public boolean istErlaubtZusatzkursGE() {
        if (this._jahrgangsdaten == null) {
            return true;
        }
        return this._jahrgangsdaten.hatZusatzkursGE;
    }

    @NotNull
    public GostHalbjahr getBeginnZusatzkursGE() {
        if (this._jahrgangsdaten == null) {
            return GostHalbjahr.Q21;
        }
        GostHalbjahr hj = GostHalbjahr.fromKuerzel(this._jahrgangsdaten.beginnZusatzkursGE);
        if (hj == null) {
            return GostHalbjahr.Q21;
        }
        return hj;
    }

    public boolean istErlaubtZusatzkursSW() {
        if (this._jahrgangsdaten == null) {
            return true;
        }
        return this._jahrgangsdaten.hatZusatzkursSW;
    }

    @NotNull
    public GostHalbjahr getBeginnZusatzkursSW() {
        if (this._jahrgangsdaten == null) {
            return GostHalbjahr.Q21;
        }
        GostHalbjahr hj = GostHalbjahr.fromKuerzel(this._jahrgangsdaten.beginnZusatzkursSW);
        if (hj == null) {
            return GostHalbjahr.Q21;
        }
        return hj;
    }

    @NotNull
    public @NotNull List<@NotNull GostJahrgangFachkombination> getFachkombinationenEF1() {
        @NotNull ArrayList<@NotNull GostJahrgangFachkombination> kombis = new ArrayList<GostJahrgangFachkombination>();
        for (GostJahrgangFachkombination kombi : this.faecherManager.getFachkombinationen()) {
            if (!kombi.gueltigInHalbjahr[GostHalbjahr.EF1.id]) continue;
            kombis.add(kombi);
        }
        return kombis;
    }

    @NotNull
    public @NotNull List<@NotNull GostJahrgangFachkombination> getFachkombinationenGesamt() {
        return this.faecherManager.getFachkombinationen();
    }

    @JsonIgnore
    @NotNull
    public GostBelegpruefungErgebnis getBelegpruefungErgebnis() {
        @NotNull GostBelegpruefungErgebnis ergebnis = new GostBelegpruefungErgebnis();
        ergebnis.erfolgreich = this.belegpruefungErfolgreich;
        for (int i = 0; i < this.belegpruefungsfehler.size(); ++i) {
            @NotNull GostBelegungsfehler fehler = this.belegpruefungsfehler.get(i);
            ergebnis.fehlercodes.add(new GostBelegpruefungErgebnisFehler(fehler, this.pruefungsArt));
        }
        return ergebnis;
    }

    @NotNull
    private KurszahlenUndWochenstunden getKurszahlenUndWochenstunden() {
        if (this.belegpruefungKurszahlenUndWochenstunden == null) {
            throw new NullPointerException("Die Belegpr\u00fcfung zu Kurszahlen und Wochenstunden wurde noch nicht erstellt und durchgef\u00fchrt.");
        }
        return this.belegpruefungKurszahlenUndWochenstunden;
    }

    @NotNull
    public int[] getWochenstunden() {
        @NotNull KurszahlenUndWochenstunden kuw = this.getKurszahlenUndWochenstunden();
        @NotNull int[] stunden = new int[]{0, 0, 0, 0, 0, 0};
        for (GostHalbjahr hj : GostHalbjahr.values()) {
            stunden[hj.id] = kuw.getWochenstunden(hj);
        }
        return stunden;
    }

    @NotNull
    public int[] getAnrechenbareKurse() {
        @NotNull KurszahlenUndWochenstunden kuw = this.getKurszahlenUndWochenstunden();
        @NotNull int[] anzahl = new int[]{0, 0, 0, 0, 0, 0};
        for (GostHalbjahr hj : GostHalbjahr.values()) {
            anzahl[hj.id] = kuw.getKurszahlenAnrechenbar(hj);
        }
        return anzahl;
    }
}

