/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public abstract class GostBelegpruefung {
    @NotNull
    protected final @NotNull GostBelegpruefung @NotNull [] pruefungen_vorher;
    @NotNull
    protected final AbiturdatenManager manager;
    @NotNull
    protected final GostBelegpruefungsArt pruefungs_art;
    @NotNull
    private final @NotNull List<@NotNull GostBelegungsfehler> belegungsfehler = new ArrayList<GostBelegungsfehler>();

    protected GostBelegpruefung(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt, GostBelegpruefung ... pruefungenVorher) {
        this.pruefungen_vorher = pruefungenVorher;
        this.manager = manager;
        this.pruefungs_art = pruefungsArt;
    }

    public void pruefe() {
        this.init();
        if (this.pruefungs_art == GostBelegpruefungsArt.EF1) {
            this.pruefeEF1();
        } else if (this.pruefungs_art == GostBelegpruefungsArt.GESAMT) {
            this.pruefeGesamt();
        }
    }

    protected void addFehler(@NotNull GostBelegungsfehler fehler) {
        if (!this.belegungsfehler.contains((Object)fehler)) {
            this.belegungsfehler.add(fehler);
        }
    }

    @NotNull
    public @NotNull List<@NotNull GostBelegungsfehler> getBelegungsfehler() {
        return this.belegungsfehler;
    }

    public boolean hatBelegungsfehler() {
        for (int i = 0; i < this.belegungsfehler.size(); ++i) {
            @NotNull GostBelegungsfehler fehler = this.belegungsfehler.get(i);
            if (fehler.istInfo()) continue;
            return false;
        }
        return true;
    }

    protected abstract void init();

    protected abstract void pruefeEF1();

    protected abstract void pruefeGesamt();

    public static boolean istErfolgreich(@NotNull @NotNull List<@NotNull GostBelegungsfehler> alleFehler) {
        for (int i = 0; i < alleFehler.size(); ++i) {
            @NotNull GostBelegungsfehler fehler = alleFehler.get(i);
            if (fehler.istInfo()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static @NotNull List<@NotNull GostBelegungsfehler> getBelegungsfehlerAlle(@NotNull @NotNull List<@NotNull GostBelegpruefung> pruefungen) {
        @NotNull ArrayList<@NotNull GostBelegungsfehler> fehler = new ArrayList<GostBelegungsfehler>();
        for (int i = 0; i < pruefungen.size(); ++i) {
            @NotNull GostBelegpruefung pruefung = pruefungen.get(i);
            fehler.addAll(pruefung.getBelegungsfehler());
        }
        return fehler;
    }
}

