/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.gost.GostAbiturFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.List;

public final class AbiFaecher
extends GostBelegpruefung {
    private ArrayMap<@NotNull GostAbiturFach, @NotNull AbiturFachbelegung> mapAbiturFachbelegungen;
    private int anzahlAbiFaecher;
    private int anzahlDeutschMatheFremdsprache;
    private int anzahlFremdsprachen;
    private int anzahlSportReligion;
    private boolean hatAufgabenfeldI;
    private boolean hatAufgabenfeldII;
    private boolean hatAufgabenfeldIII;

    public AbiFaecher(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this.mapAbiturFachbelegungen = new ArrayMap(GostAbiturFach.values());
        this.anzahlAbiFaecher = 0;
        this.anzahlDeutschMatheFremdsprache = 0;
        this.anzahlFremdsprachen = 0;
        this.anzahlSportReligion = 0;
        this.hatAufgabenfeldI = false;
        this.hatAufgabenfeldII = false;
        this.hatAufgabenfeldIII = false;
        @NotNull List<@NotNull AbiturFachbelegung> alleFachbelegungen = this.manager.getFachbelegungen(new GostFachbereich[0]);
        for (int i = 0; i < alleFachbelegungen.size(); ++i) {
            AbiturFachbelegung fachbelegung = alleFachbelegungen.get(i);
            GostAbiturFach abiturFach = GostAbiturFach.fromID(fachbelegung.abiturFach);
            if (abiturFach == null) continue;
            this.mapAbiturFachbelegungen.put(abiturFach, fachbelegung);
            ++this.anzahlAbiFaecher;
            GostFach fach = this.manager.getFach(fachbelegung);
            if (fach == null) continue;
            if (GostFachbereich.FREMDSPRACHE.hat(fach) || GostFachbereich.DEUTSCH.hat(fach)) {
                this.hatAufgabenfeldI = true;
            }
            if (GostFachbereich.GESELLSCHAFTSWISSENSCHAFTLICH_MIT_RELIGION.hat(fach)) {
                this.hatAufgabenfeldII = true;
            }
            if (GostFachbereich.MATHEMATISCH_NATURWISSENSCHAFTLICH.hat(fach)) {
                this.hatAufgabenfeldIII = true;
            }
            if (GostFachbereich.FREMDSPRACHE.hat(fach) || GostFachbereich.DEUTSCH.hat(fach) || GostFachbereich.MATHEMATIK.hat(fach)) {
                ++this.anzahlDeutschMatheFremdsprache;
            }
            if (GostFachbereich.FREMDSPRACHE.hat(fach)) {
                ++this.anzahlFremdsprachen;
            }
            if (!GostFachbereich.SPORT.hat(fach) && !GostFachbereich.RELIGION.hat(fach)) continue;
            ++this.anzahlSportReligion;
        }
    }

    @Override
    protected void pruefeEF1() {
    }

    @Override
    protected void pruefeGesamt() {
        this.pruefeLK1();
        this.pruefeAnzahlUndAufgabenfelderAbiFaecher();
        this.pruefeMehrfacheAbiturfaecher();
        this.pruefeSchriftlichkeitAB3undAB4();
    }

    private void pruefeLK1() {
        AbiturFachbelegung lk1 = this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)GostAbiturFach.LK1);
        GostFach lk1fach = this.manager.getFach(lk1);
        if (!(lk1 != null && lk1fach != null && (GostFachbereich.DEUTSCH.hat(lk1fach) || GostFachbereich.FREMDSPRACHE.hat(lk1fach) && !lk1.istFSNeu || GostFachbereich.MATHEMATIK.hat(lk1fach) || GostFachbereich.NATURWISSENSCHAFTLICH_KLASSISCH.hat(lk1fach)))) {
            this.addFehler(GostBelegungsfehler.LK1_11);
        }
    }

    private void pruefeAnzahlUndAufgabenfelderAbiFaecher() {
        if (!(this.anzahlAbiFaecher == 4 && this.hatAufgabenfeldI && this.hatAufgabenfeldII && this.hatAufgabenfeldIII)) {
            this.addFehler(GostBelegungsfehler.LK1_13);
        }
        if (this.anzahlDeutschMatheFremdsprache < 2) {
            this.addFehler(GostBelegungsfehler.ABI_10);
        }
        if (this.anzahlDeutschMatheFremdsprache < 3 && this.anzahlFremdsprachen > 1) {
            this.addFehler(GostBelegungsfehler.ABI_19);
        }
        if (this.anzahlSportReligion > 1) {
            this.addFehler(GostBelegungsfehler.ABI_11);
        }
        AbiturFachbelegung lk1 = this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)GostAbiturFach.LK1);
        GostFach lk1fach = this.manager.getFach(lk1);
        AbiturFachbelegung ab3 = this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)GostAbiturFach.AB3);
        GostFach ab3fach = this.manager.getFach(ab3);
        if (lk1fach != null && GostFachbereich.SPORT.hat(lk1fach.kuerzel) || ab3fach != null && GostFachbereich.SPORT.hat(ab3fach.kuerzel)) {
            this.addFehler(GostBelegungsfehler.ABI_15);
        }
    }

    private void pruefeMehrfacheAbiturfaecher() {
        @NotNull HashSet<@NotNull GostAbiturFach> abiFaecher = new HashSet<GostAbiturFach>();
        @NotNull List<@NotNull AbiturFachbelegung> alleFachbelegungen = this.manager.getFachbelegungen(new GostFachbereich[0]);
        block6: for (int i = 0; i < alleFachbelegungen.size(); ++i) {
            AbiturFachbelegung fachbelegung = alleFachbelegungen.get(i);
            GostAbiturFach abiturFach = GostAbiturFach.fromID(fachbelegung.abiturFach);
            if (abiturFach == null) continue;
            if (!abiFaecher.contains((Object)abiturFach)) {
                abiFaecher.add(abiturFach);
                continue;
            }
            switch (abiturFach) {
                case LK1: {
                    this.addFehler(GostBelegungsfehler.ABI_21);
                    continue block6;
                }
                case LK2: {
                    this.addFehler(GostBelegungsfehler.ABI_22);
                    continue block6;
                }
                case AB3: {
                    this.addFehler(GostBelegungsfehler.ABI_23);
                    continue block6;
                }
                case AB4: {
                    this.addFehler(GostBelegungsfehler.ABI_24);
                }
            }
        }
    }

    private boolean pruefeSchriftlichkeitVorQ22(AbiturFachbelegung belegung) {
        if (this.manager.pruefeBelegungMitSchriftlichkeit(belegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            return true;
        }
        GostFach fach = this.manager.getFach(belegung);
        if (fach != null) {
            @NotNull List<@NotNull AbiturFachbelegung> belegungen = this.manager.getFachbelegungByFachkuerzel(fach.kuerzel);
            if (this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q11) && this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q12) && this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q21)) {
                return true;
            }
            if (GostFachbereich.RELIGION.hat(fach) && this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen = this.manager.getFachbelegungen(GostFachbereich.RELIGION), GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q11) && this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q12) && this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(belegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q21)) {
                return true;
            }
        }
        return false;
    }

    private void pruefeSchriftlichkeitAB3undAB4() {
        AbiturFachbelegung ab4;
        AbiturFachbelegung ab3;
        AbiturFachbelegung abiturFachbelegung = ab3 = this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)GostAbiturFach.AB3);
        if (ab3 != null) {
            if (!this.pruefeSchriftlichkeitVorQ22(ab3)) {
                this.addFehler(GostBelegungsfehler.ABI_17);
            }
            if (!this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(ab3, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q22)) {
                this.addFehler(GostBelegungsfehler.ABI_12);
            }
        }
        AbiturFachbelegung abiturFachbelegung2 = ab4 = this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)GostAbiturFach.AB4);
        if (ab4 != null) {
            if (!this.pruefeSchriftlichkeitVorQ22(ab4)) {
                this.addFehler(GostBelegungsfehler.ABI_18);
            }
            if (!this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(ab4, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.Q22)) {
                this.addFehler(GostBelegungsfehler.ABI_13);
            }
        }
    }

    public AbiturFachbelegung getAbiturfach(GostAbiturFach abifach) {
        return this.mapAbiturFachbelegungen == null ? null : this.mapAbiturFachbelegungen.get((Object)abifach);
    }
}

