/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.types.gost.GostAbiturFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public final class Allgemeines
extends GostBelegpruefung {
    public Allgemeines(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void pruefeEF1() {
        if (this.manager.zaehleBelegungInHalbjahren(this.manager.getFachbelegungen(GostFachbereich.RELIGION), GostHalbjahr.EF1) > 1) {
            this.addFehler(GostBelegungsfehler.IGF_10);
        }
        if (this.manager.hatDoppelteFachbelegungInHalbjahr(GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.IGF_10);
        }
    }

    @Override
    protected void pruefeGesamt() {
        AbiturFachbelegung fachbelegung;
        int i;
        @NotNull List<@NotNull AbiturFachbelegung> alleFachbelegungen = this.manager.getFachbelegungen(new GostFachbereich[0]);
        for (i = 0; i < alleFachbelegungen.size(); ++i) {
            fachbelegung = alleFachbelegungen.get(i);
            if (this.manager.istBelegtSeitEF(fachbelegung)) continue;
            this.addFehler(GostBelegungsfehler.E1BEL_10);
        }
        for (i = 0; i < alleFachbelegungen.size(); ++i) {
            fachbelegung = alleFachbelegungen.get(i);
            GostAbiturFach abiturFach = GostAbiturFach.fromID(fachbelegung.abiturFach);
            if (abiturFach != null || !this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(fachbelegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.Q22)) continue;
            this.addFehler(GostBelegungsfehler.ABI_16);
            break;
        }
        for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
            if (this.manager.zaehleBelegungInHalbjahren(this.manager.getFachbelegungen(GostFachbereich.RELIGION), halbjahr) <= 1) continue;
            this.addFehler(GostBelegungsfehler.IGF_10);
        }
        if (this.manager.hatDoppelteFachbelegung(GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.IGF_10);
        }
    }
}

