/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import jakarta.validation.constraints.NotNull;

public final class Deutsch
extends GostBelegpruefung {
    private AbiturFachbelegung _deutsch;

    public Deutsch(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this._deutsch = this.manager.getFachbelegung(GostFachbereich.DEUTSCH);
    }

    @Override
    protected void pruefeEF1() {
        if (this._deutsch == null || !this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(this._deutsch, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.D_10);
            return;
        }
        if (!this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(this._deutsch, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.D_11);
        }
    }

    @Override
    protected void pruefeGesamt() {
        if (this._deutsch == null) {
            this.addFehler(GostBelegungsfehler.D_10);
            return;
        }
        if (!this.manager.pruefeBelegung(this._deutsch, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.D_10);
        }
        if (!this.manager.pruefeBelegungMitSchriftlichkeit(this._deutsch, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            this.addFehler(GostBelegungsfehler.D_11);
        }
    }
}

