/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import jakarta.validation.constraints.NotNull;

public final class FachWaehlbar
extends GostBelegpruefung {
    public FachWaehlbar(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
    }

    private void pruefeFachbelegungHalbjahr(@NotNull GostFach fach, @NotNull AbiturFachbelegung fachbelegung, @NotNull GostHalbjahr halbjahr) {
        boolean istwaehlbar;
        AbiturFachbelegungHalbjahr fbHalbjahr = fachbelegung.belegungen[halbjahr.id];
        if (fbHalbjahr == null) {
            return;
        }
        switch (halbjahr) {
            case EF1: {
                boolean bl = fach.istMoeglichEF1;
                break;
            }
            case EF2: {
                boolean bl = fach.istMoeglichEF2;
                break;
            }
            case Q11: {
                boolean bl = fach.istMoeglichQ11;
                break;
            }
            case Q12: {
                boolean bl = fach.istMoeglichQ12;
                break;
            }
            case Q21: {
                boolean bl = fach.istMoeglichQ21;
                break;
            }
            case Q22: {
                boolean bl = fach.istMoeglichQ22;
                break;
            }
            default: {
                boolean bl = istwaehlbar = false;
            }
        }
        if (!istwaehlbar) {
            this.addFehler(GostBelegungsfehler.WAEHLBARKEIT_1);
        }
    }

    private static boolean hatLKFachbelegung(@NotNull AbiturFachbelegung fachbelegung) {
        for (GostHalbjahr halbjahr : GostHalbjahr.getQualifikationsphase()) {
            AbiturFachbelegungHalbjahr fbHalbjahr = fachbelegung.belegungen[halbjahr.id];
            if (fbHalbjahr == null || !"LK".equals(fbHalbjahr.kursartKuerzel)) continue;
            return true;
        }
        return false;
    }

    private void pruefeFachbelegungAbitur(@NotNull GostFach fach, @NotNull AbiturFachbelegung fachbelegung) {
        if (fachbelegung.abiturFach == null) {
            return;
        }
        if (!fach.istMoeglichAbiLK && (fachbelegung.abiturFach == 1 || fachbelegung.abiturFach == 2 || FachWaehlbar.hatLKFachbelegung(fachbelegung))) {
            this.addFehler(GostBelegungsfehler.WAEHLBARKEIT_3);
        }
        if (!(fach.istMoeglichAbiGK || fachbelegung.abiturFach != 3 && fachbelegung.abiturFach != 4)) {
            this.addFehler(GostBelegungsfehler.WAEHLBARKEIT_2);
        }
    }

    @Override
    protected void pruefeEF1() {
        for (AbiturFachbelegung fachbelegung : this.manager.getFachbelegungen(new GostFachbereich[0])) {
            GostFach fach = this.manager.faecher().get(fachbelegung.fachID);
            if (fach == null) {
                this.addFehler(GostBelegungsfehler.WAEHLBARKEIT_0);
                continue;
            }
            this.pruefeFachbelegungHalbjahr(fach, fachbelegung, GostHalbjahr.EF1);
        }
    }

    @Override
    protected void pruefeGesamt() {
        for (AbiturFachbelegung fachbelegung : this.manager.getFachbelegungen(new GostFachbereich[0])) {
            GostFach fach = this.manager.faecher().get(fachbelegung.fachID);
            if (fach == null) {
                this.addFehler(GostBelegungsfehler.WAEHLBARKEIT_0);
                continue;
            }
            for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
                this.pruefeFachbelegungHalbjahr(fach, fachbelegung, halbjahr);
            }
            this.pruefeFachbelegungAbitur(fach, fachbelegung);
        }
    }
}

