/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.GostJahrgangFachkombination;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.gost.GostLaufbahnplanungFachkombinationTyp;
import jakarta.validation.constraints.NotNull;

public final class Fachkombinationen
extends GostBelegpruefung {
    public Fachkombinationen(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
    }

    private static boolean pruefeHatBelegungFach2InHalbjahr(@NotNull GostJahrgangFachkombination kombi, AbiturFachbelegung belegung2, @NotNull GostHalbjahr halbjahr) {
        if (belegung2 == null) {
            return false;
        }
        AbiturFachbelegungHalbjahr belegung2Halbjahr = belegung2.belegungen[halbjahr.id];
        return belegung2Halbjahr != null && !AbiturdatenManager.istNullPunkteBelegungInQPhase(belegung2Halbjahr) && (kombi.kursart2 == null || GostKursart.fromKuerzel(belegung2Halbjahr.kursartKuerzel) == GostKursart.fromKuerzel(kombi.kursart2));
    }

    private void pruefeHatFachkombination(@NotNull GostJahrgangFachkombination kombi, GostHalbjahr ... halbjahre) {
        AbiturFachbelegung belegung1 = this.manager.getFachbelegungByID(kombi.fachID1);
        if (belegung1 == null) {
            return;
        }
        AbiturFachbelegung belegung2 = this.manager.getFachbelegungByID(kombi.fachID2);
        for (GostHalbjahr halbjahr : halbjahre) {
            AbiturFachbelegungHalbjahr belegung1Halbjahr = belegung1.belegungen[halbjahr.id];
            if (belegung1Halbjahr == null || AbiturdatenManager.istNullPunkteBelegungInQPhase(belegung1Halbjahr) || kombi.kursart1 != null && GostKursart.fromKuerzel(belegung1Halbjahr.kursartKuerzel) != GostKursart.fromKuerzel(kombi.kursart1)) continue;
            if (kombi.typ == GostLaufbahnplanungFachkombinationTyp.VERBOTEN.getValue() && Fachkombinationen.pruefeHatBelegungFach2InHalbjahr(kombi, belegung2, halbjahr)) {
                this.addFehler(GostBelegungsfehler.KOMBI_1);
                return;
            }
            if (kombi.typ != GostLaufbahnplanungFachkombinationTyp.ERFORDERLICH.getValue() || Fachkombinationen.pruefeHatBelegungFach2InHalbjahr(kombi, belegung2, halbjahr)) continue;
            this.addFehler(GostBelegungsfehler.KOMBI_2);
            return;
        }
    }

    @Override
    protected void pruefeEF1() {
        for (GostJahrgangFachkombination kombi : this.manager.getFachkombinationenEF1()) {
            this.pruefeHatFachkombination(kombi, GostHalbjahr.EF1);
        }
    }

    @Override
    protected void pruefeGesamt() {
        for (GostJahrgangFachkombination kombi : this.manager.getFachkombinationenGesamt()) {
            this.pruefeHatFachkombination(kombi, GostHalbjahr.values());
        }
    }
}

