/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.gost.GostAbiturFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import de.svws_nrw.core.utils.gost.GostFachUtils;
import de.svws_nrw.core.utils.schueler.SprachendatenUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public final class Fremdsprachen
extends GostBelegpruefung {
    @NotNull
    private @NotNull List<@NotNull AbiturFachbelegung> _fremdsprachen = new ArrayList<AbiturFachbelegung>();
    @NotNull
    private @NotNull List<@NotNull AbiturFachbelegung> _fremdsprachenNeu = new ArrayList<AbiturFachbelegung>();
    @NotNull
    private @NotNull List<@NotNull AbiturFachbelegung> _fremdsprachenFortgefuehrt = new ArrayList<AbiturFachbelegung>();
    @NotNull
    private @NotNull List<@NotNull AbiturFachbelegung> _biliSachfaecher = new ArrayList<AbiturFachbelegung>();
    private int _anzahlDurchgehendSchriftlich;

    public Fremdsprachen(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this._fremdsprachen = this.manager.getFachbelegungen(GostFachbereich.FREMDSPRACHE);
        this._fremdsprachenNeu = this.manager.filterFremdspracheNeuEinsetzend(this._fremdsprachen);
        this._fremdsprachenFortgefuehrt = this.manager.filterFremdspracheFortgefuehrt(this._fremdsprachen);
        this._biliSachfaecher = this.manager.getFachbelegungenBilingual();
        this._anzahlDurchgehendSchriftlich = 0;
    }

    @Override
    protected void pruefeEF1() {
        this.pruefeEF1Sprachenfolge();
        this.pruefeEF1Fremdsprache1();
        this.pruefeEF1FremdsprachenfolgeZweiteFremdsprache();
        this.pruefeEF1Schriftlichkeit();
        this.pruefeEF1AnzahlDurchgehenedeSprachen();
        this.pruefeEF1BilingualeSachfaecher();
        this.pruefeEF1BilingualenBildungsgang();
    }

    private void pruefeEF1Sprachenfolge() {
        if (this.manager.hatFortgefuehrteFremdspracheInSprachendaten(this._fremdsprachenNeu)) {
            this.addFehler(GostBelegungsfehler.FS_20);
        }
        if (this.manager.hatNeuEinsetzendeFremdspracheInSprachendaten(this._fremdsprachenFortgefuehrt)) {
            this.addFehler(GostBelegungsfehler.FS_21);
        }
        if (!SprachendatenUtils.hatSprachbelegung(this.manager.getSprachendaten(), "E")) {
            this.addFehler(GostBelegungsfehler.FS_22_INFO);
        }
    }

    private void pruefeEF1Fremdsprache1() {
        boolean gefundenFremdsprachenbelegung = false;
        boolean gefundenFortgefuehrteFremdsprachenbelegungOhneSprachenfolge = false;
        boolean gefundenFortgefuehrteFremdspracheAlsNeueinsetzende = false;
        int anzahlFortgefuehrteFremdsprachen = 0;
        int anzahlFortgefuehrteFremdsprachenEFBelegbar = 0;
        int anzahlFortgefuehrteFremdsprachenEFBelegbarFehlerMuendlich = 0;
        int anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar = 0;
        int anzahlFortgefuehrteFremdsprachenDurchgehendBelegbarFehlerMuendlich = 0;
        int anzahlFortfuehrbareFremdsprachen = SprachendatenUtils.getFortfuehrbareSprachenInGOSt(this.manager.getSprachendaten()).size();
        for (AbiturFachbelegung abiFachbelegung : this._fremdsprachenFortgefuehrt) {
            if (!this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1)) continue;
            gefundenFremdsprachenbelegung = true;
            GostFach gostFach = this.manager.getFach(abiFachbelegung);
            if (gostFach == null || gostFach.kuerzel.equals("")) continue;
            if (SprachendatenUtils.istFortfuehrbareSpracheInGOSt(this.manager.getSprachendaten(), gostFach.kuerzel.substring(0, 1))) {
                ++anzahlFortgefuehrteFremdsprachen;
                if (this.manager.pruefeBelegungDurchgehendBelegbar(abiFachbelegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
                    ++anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar;
                    continue;
                }
                if (this.manager.pruefeBelegungDurchgehendBelegbar(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1)) {
                    ++anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar;
                    ++anzahlFortgefuehrteFremdsprachenDurchgehendBelegbarFehlerMuendlich;
                    continue;
                }
                if (!gostFach.istMoeglichEF1 || !gostFach.istMoeglichEF2) continue;
                ++anzahlFortgefuehrteFremdsprachenEFBelegbar;
                if (!this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1)) continue;
                ++anzahlFortgefuehrteFremdsprachenEFBelegbarFehlerMuendlich;
                continue;
            }
            gefundenFortgefuehrteFremdsprachenbelegungOhneSprachenfolge = true;
            this.addFehler(GostBelegungsfehler.FS_23);
        }
        if (anzahlFortgefuehrteFremdsprachenDurchgehendBelegbarFehlerMuendlich + anzahlFortgefuehrteFremdsprachenEFBelegbarFehlerMuendlich > 0) {
            this.addFehler(GostBelegungsfehler.FS_12);
        }
        if (anzahlFortgefuehrteFremdsprachen > 0 && anzahlFortgefuehrteFremdsprachen == anzahlFortgefuehrteFremdsprachenDurchgehendBelegbarFehlerMuendlich + anzahlFortgefuehrteFremdsprachenEFBelegbarFehlerMuendlich) {
            this.addFehler(GostBelegungsfehler.FS_16);
        }
        if (anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar > 0) {
            return;
        }
        int anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar = 0;
        int anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbarFehlerMuendlich = 0;
        for (AbiturFachbelegung abiFachbelegung : this._fremdsprachenNeu) {
            if (!this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1)) continue;
            gefundenFremdsprachenbelegung = true;
            GostFach gostFach = this.manager.getFach(abiFachbelegung);
            if (gostFach == null || gostFach.kuerzel.equals("")) continue;
            if (SprachendatenUtils.istNeueinsetzbareSpracheInGOSt(this.manager.getSprachendaten(), gostFach.kuerzel.substring(0, 1))) {
                if (this.manager.pruefeBelegungDurchgehendBelegbar(abiFachbelegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
                    ++anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar;
                    continue;
                }
                if (!this.manager.pruefeBelegungDurchgehendBelegbar(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1)) continue;
                ++anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar;
                ++anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbarFehlerMuendlich;
                continue;
            }
            this.addFehler(GostBelegungsfehler.FS_20);
            gefundenFortgefuehrteFremdspracheAlsNeueinsetzende = true;
        }
        if (anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbarFehlerMuendlich > 0) {
            this.addFehler(GostBelegungsfehler.FS_12);
        }
        if (gefundenFremdsprachenbelegung && !gefundenFortgefuehrteFremdsprachenbelegungOhneSprachenfolge && !gefundenFortgefuehrteFremdspracheAlsNeueinsetzende && anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar + anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar == 0) {
            this.addFehler(GostBelegungsfehler.FS_11);
        }
        if (anzahlFortgefuehrteFremdsprachenEFBelegbar > 0) {
            if (anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar == 0) {
                this.addFehler(GostBelegungsfehler.FS_10);
            }
            return;
        }
        if (anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar == 0) {
            this.addFehler(GostBelegungsfehler.FS_18);
            return;
        }
        if (anzahlFortgefuehrteFremdsprachenDurchgehendBelegbar + anzahlFortgefuehrteFremdsprachenEFBelegbar == 0 && anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbar > 0) {
            if (anzahlNeueinsetzendeFremdsprachenDurchgehendBelegbarFehlerMuendlich > 0) {
                this.addFehler(GostBelegungsfehler.FS_18);
            }
            if (SprachendatenUtils.hatSprachfeststellungspruefungAufEFNiveau(this.manager.getSprachendaten())) {
                this.addFehler(GostBelegungsfehler.FS_19_INFO);
            } else if (anzahlFortfuehrbareFremdsprachen == 0) {
                this.addFehler(GostBelegungsfehler.FS_25);
            } else {
                this.addFehler(GostBelegungsfehler.FS_18);
                if (!SprachendatenUtils.hatZweiSprachenAb5Bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
                    this.addFehler(GostBelegungsfehler.FS_24);
                }
            }
        }
    }

    private void pruefeEF1FremdsprachenfolgeZweiteFremdsprache() {
        if (SprachendatenUtils.hatZweiSprachenAb5Bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
            return;
        }
        if (SprachendatenUtils.hatEineSpracheAb5bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
            if (this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this._fremdsprachenNeu, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
                return;
            }
            if (SprachendatenUtils.hatEineSpracheAb8MitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
                AbiturFachbelegung zweiteFremdsprache = this.manager.getSprachbelegung(SprachendatenUtils.getEineSpracheAb8MitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten()));
                if (!this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(zweiteFremdsprache, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
                    this.addFehler(GostBelegungsfehler.FS_13);
                }
                return;
            }
        }
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this._fremdsprachenNeu, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.FS_14);
        }
    }

    private void pruefeEF1Schriftlichkeit() {
        if (this._fremdsprachen == null) {
            return;
        }
        for (AbiturFachbelegung fachbelegung : this._fremdsprachen) {
            if (!this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(fachbelegung, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1) || this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(fachbelegung, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) continue;
            this.addFehler(GostBelegungsfehler.FS_12);
            break;
        }
    }

    private void pruefeEF1AnzahlDurchgehenedeSprachen() {
        List<AbiturFachbelegung> fremdsprachenDurchgehend = this.manager.filterBelegungenMitSchriftlichkeit(this.manager.filterDurchgehendBelegbar(this._fremdsprachen), GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1);
        this._anzahlDurchgehendSchriftlich = fremdsprachenDurchgehend.size();
        if (this._anzahlDurchgehendSchriftlich != 1) {
            return;
        }
        GostFach fsDurchgehend = this.manager.getFach(fremdsprachenDurchgehend.get(0));
        if (fsDurchgehend == null) {
            return;
        }
        String fremdspracheDurchgehend = GostFachUtils.getFremdsprache(fsDurchgehend);
        if (fremdspracheDurchgehend == null) {
            return;
        }
        List<AbiturFachbelegung> biliSachfaecherDurchgehendSchriftlich = this.manager.filterBelegungenMitSchriftlichkeit(this.manager.filterDurchgehendBelegbar(this._biliSachfaecher), GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1);
        for (AbiturFachbelegung biliSachfach : biliSachfaecherDurchgehendSchriftlich) {
            GostFach fach = this.manager.getFach(biliSachfach);
            if (fach == null || fremdspracheDurchgehend.equals(fach.biliSprache)) continue;
            ++this._anzahlDurchgehendSchriftlich;
            return;
        }
    }

    private void pruefeEF1BilingualeSachfaecher() {
        if (this._biliSachfaecher == null) {
            return;
        }
        for (AbiturFachbelegung biliSachfach : this._biliSachfaecher) {
            GostFach fach = this.manager.getFach(biliSachfach);
            if (fach == null) continue;
            String biliSprache = fach.biliSprache;
            if (!SprachendatenUtils.hatSprachbelegungMitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten(), biliSprache)) {
                this.addFehler(GostBelegungsfehler.BIL_14);
                continue;
            }
            AbiturFachbelegung fremdsprache = this.manager.getSprachbelegung(biliSprache);
            if (this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(fremdsprache, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1) || this.manager.pruefeBelegungMitSchriftlichkeitEinzeln(biliSachfach, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) continue;
            this.addFehler(GostBelegungsfehler.BIL_4_INFO);
        }
    }

    private void pruefeEF1BilingualenBildungsgang() {
        String biligualeSprache = this.manager.getBiligualenBildungsgang();
        if (biligualeSprache == null) {
            return;
        }
        AbiturFachbelegung biliSprache = this.manager.getSprachbelegung(biligualeSprache);
        if (!this.manager.pruefeBelegungDurchgehendBelegbar(biliSprache, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.BIL_10);
        }
        if (this._biliSachfaecher == null || this._biliSachfaecher.isEmpty()) {
            this.addFehler(GostBelegungsfehler.BIL_15);
            return;
        }
        if (this._biliSachfaecher.size() < 2) {
            this.addFehler(GostBelegungsfehler.BIL_11_INFO);
        }
    }

    @Override
    protected void pruefeGesamt() {
        this.pruefeGesamtSprachenfolge();
        this.pruefeGesamtFremdsprache1();
        this.pruefeGesamtFremdsprachenfolgeZweiteFremdsprache();
        this.pruefeGesamtSchriftlichkeit();
        this.pruefeGesamtAnzahlDurchgehenedeSprachen();
        this.pruefeGesamtBilingualeSachfaecher();
        this.pruefeGesamtBilingualenBildungsgang();
    }

    private void pruefeGesamtSprachenfolge() {
        if (this.manager.hatFortgefuehrteFremdspracheInSprachendaten(this._fremdsprachenNeu)) {
            this.addFehler(GostBelegungsfehler.FS_20);
        }
        if (this.manager.hatNeuEinsetzendeFremdspracheInSprachendaten(this._fremdsprachenFortgefuehrt)) {
            this.addFehler(GostBelegungsfehler.FS_21);
        }
        if (!SprachendatenUtils.hatSprachbelegung(this.manager.getSprachendaten(), "E")) {
            this.addFehler(GostBelegungsfehler.FS_22_INFO);
        }
    }

    private void pruefeGesamtFremdsprache1() {
        int anzahlFortgefuehrteFremdsprachenEFBelegt = 0;
        int anzahlFortgefuehrteFremdsprachenDurchgehendBelegt = 0;
        int anzahlFortgefuehrteFremdsprachenBelegtFehlerMuendlichEF = 0;
        int anzahlFortgefuehrteFremdsprachenDurchgehendBelegtFehlerMuendlichEF = 0;
        int anzahlFortfuehrbareFremdsprachen = SprachendatenUtils.getFortfuehrbareSprachenInGOSt(this.manager.getSprachendaten()).size();
        for (AbiturFachbelegung abiFachbelegung : this._fremdsprachenFortgefuehrt) {
            GostFach gostFach;
            if (!this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1) || (gostFach = this.manager.getFach(abiFachbelegung)) == null || gostFach.kuerzel.equals("")) continue;
            if (SprachendatenUtils.istFortfuehrbareSpracheInGOSt(this.manager.getSprachendaten(), gostFach.kuerzel.substring(0, 1))) {
                if (this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1, GostHalbjahr.EF2)) {
                    ++anzahlFortgefuehrteFremdsprachenEFBelegt;
                }
                if (this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1) || this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF2)) {
                    ++anzahlFortgefuehrteFremdsprachenBelegtFehlerMuendlichEF;
                }
                if (!this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) continue;
                ++anzahlFortgefuehrteFremdsprachenDurchgehendBelegt;
                if (!this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1) && !this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF2)) continue;
                ++anzahlFortgefuehrteFremdsprachenDurchgehendBelegtFehlerMuendlichEF;
                continue;
            }
            this.addFehler(GostBelegungsfehler.FS_23);
        }
        if (anzahlFortgefuehrteFremdsprachenBelegtFehlerMuendlichEF > 0) {
            this.addFehler(GostBelegungsfehler.FS_12);
        }
        if (anzahlFortgefuehrteFremdsprachenDurchgehendBelegt > 0 && anzahlFortgefuehrteFremdsprachenDurchgehendBelegt == anzahlFortgefuehrteFremdsprachenDurchgehendBelegtFehlerMuendlichEF) {
            this.addFehler(GostBelegungsfehler.FS_16);
        }
        if (anzahlFortgefuehrteFremdsprachenDurchgehendBelegt > 0) {
            return;
        }
        int anzahlNeueinsetzendeFremdsprachenDurchgehendBelegt = 0;
        int anzahlNeueinsetzendeFremdsprachenBelegtFehlerMuendlichEF = 0;
        for (AbiturFachbelegung abiFachbelegung : this._fremdsprachenNeu) {
            GostFach gostFach;
            if (!this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1) || (gostFach = this.manager.getFach(abiFachbelegung)) == null || gostFach.kuerzel.equals("")) continue;
            if (SprachendatenUtils.istNeueinsetzbareSpracheInGOSt(this.manager.getSprachendaten(), gostFach.kuerzel.substring(0, 1))) {
                if (this.manager.pruefeBelegung(abiFachbelegung, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
                    ++anzahlNeueinsetzendeFremdsprachenDurchgehendBelegt;
                }
                if (!this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1) && !this.manager.pruefeBelegungMitSchriftlichkeit(abiFachbelegung, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF2)) continue;
                ++anzahlNeueinsetzendeFremdsprachenBelegtFehlerMuendlichEF;
                continue;
            }
            this.addFehler(GostBelegungsfehler.FS_20);
        }
        if (anzahlNeueinsetzendeFremdsprachenBelegtFehlerMuendlichEF > 0) {
            this.addFehler(GostBelegungsfehler.FS_12);
        }
        if (anzahlNeueinsetzendeFremdsprachenDurchgehendBelegt > 0) {
            if (SprachendatenUtils.hatSprachfeststellungspruefungAufEFNiveau(this.manager.getSprachendaten())) {
                this.addFehler(GostBelegungsfehler.FS_19_INFO);
                return;
            }
            if (anzahlFortgefuehrteFremdsprachenEFBelegt == 0) {
                this.addFehler(GostBelegungsfehler.FS_10);
                if (anzahlFortfuehrbareFremdsprachen == 0) {
                    this.addFehler(GostBelegungsfehler.FS_25);
                } else if (!SprachendatenUtils.hatZweiSprachenAb5Bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
                    this.addFehler(GostBelegungsfehler.FS_24);
                }
            }
        } else if (SprachendatenUtils.hatSprachfeststellungspruefungAufEFNiveau(this.manager.getSprachendaten())) {
            this.addFehler(GostBelegungsfehler.FS_18);
        } else {
            this.addFehler(GostBelegungsfehler.FS_10);
        }
    }

    private void pruefeGesamtFremdsprachenfolgeZweiteFremdsprache() {
        if (SprachendatenUtils.hatZweiSprachenAb5Bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
            return;
        }
        if (SprachendatenUtils.hatEineSpracheAb5bis7MitMin4JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
            if (this.manager.pruefeBelegungExistiert(this._fremdsprachenNeu, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
                return;
            }
            if (SprachendatenUtils.hatEineSpracheAb8MitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten())) {
                AbiturFachbelegung zweiteFremdsprache = this.manager.getSprachbelegung(SprachendatenUtils.getEineSpracheAb8MitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten()));
                if (!this.manager.pruefeBelegungMitSchriftlichkeit(zweiteFremdsprache, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2)) {
                    this.addFehler(GostBelegungsfehler.FS_13);
                }
                return;
            }
        }
        if (!this.manager.pruefeBelegungExistiert(this._fremdsprachenNeu, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.FS_14);
        }
    }

    private void pruefeGesamtSchriftlichkeit() {
        if (this.manager.pruefeBelegungExistiertHatMindestensEinmalSchriftlichkeit(this._fremdsprachenNeu, GostSchriftlichkeit.MUENDLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            this.addFehler(GostBelegungsfehler.FS_15);
        }
        if (this.manager.pruefeBelegungExistiertHatMindestensEinmalKursart(this._fremdsprachenNeu, GostKursart.LK, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.FS_17);
        }
        if (this.manager.pruefeBelegungExistiertErfuelltNichtFallsBelegt(this._fremdsprachenFortgefuehrt, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2)) {
            this.addFehler(GostBelegungsfehler.FS_12);
        }
        if (this.manager.pruefeBelegungDurchgehendBelegtExistiert(this._fremdsprachenFortgefuehrt, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            return;
        }
        if (!this.manager.pruefeBelegungDurchgehendBelegtExistiert(this._fremdsprachenNeu, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            this.addFehler(GostBelegungsfehler.FS_11);
            return;
        }
        if (SprachendatenUtils.hatSprachfeststellungspruefungAufEFNiveau(this.manager.getSprachendaten()) && this.manager.pruefeBelegungExistiertMitSchriftlichkeit(this._fremdsprachenFortgefuehrt, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2)) {
            return;
        }
        if (SprachendatenUtils.hatSprachfeststellungspruefungAufEFNiveau(this.manager.getSprachendaten()) && this.manager.pruefeBelegungDurchgehendBelegtExistiert(this._fremdsprachenNeu, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21)) {
            return;
        }
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeit(this._fremdsprachenFortgefuehrt, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2)) {
            this.addFehler(GostBelegungsfehler.FS_16);
        }
    }

    private void pruefeGesamtAnzahlDurchgehenedeSprachen() {
        @NotNull List<@NotNull AbiturFachbelegung> fremdsprachenDurchgehend = this.manager.filterBelegungen(this._fremdsprachen, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22);
        @NotNull List<@NotNull AbiturFachbelegung> fremdsprachenDurchgehendSchriftlich = this.manager.filterBelegungenMitSchriftlichkeit(fremdsprachenDurchgehend, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21);
        this._anzahlDurchgehendSchriftlich = fremdsprachenDurchgehendSchriftlich.size();
        if (this._anzahlDurchgehendSchriftlich != 1) {
            return;
        }
        GostFach fsDurchgehend = this.manager.getFach(fremdsprachenDurchgehendSchriftlich.get(0));
        if (fsDurchgehend == null) {
            return;
        }
        String fremdspracheDurchgehend = GostFachUtils.getFremdsprache(fsDurchgehend);
        if (fremdspracheDurchgehend == null) {
            return;
        }
        @NotNull List<@NotNull AbiturFachbelegung> biliSachfaecherDurchgehend = this.manager.filterBelegungen(this._biliSachfaecher, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22);
        @NotNull List<@NotNull AbiturFachbelegung> biliSachfaecherDurchgehendSchriftlich = this.manager.filterBelegungenMitSchriftlichkeit(biliSachfaecherDurchgehend, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21);
        for (AbiturFachbelegung biliSachfach : biliSachfaecherDurchgehendSchriftlich) {
            GostFach fach = this.manager.getFach(biliSachfach);
            if (fach == null || fremdspracheDurchgehend.equals(fach.biliSprache)) continue;
            ++this._anzahlDurchgehendSchriftlich;
            return;
        }
    }

    private void pruefeGesamtBilingualeSachfaecher() {
        if (this._biliSachfaecher == null) {
            return;
        }
        for (AbiturFachbelegung biliSachfach : this._biliSachfaecher) {
            GostFach biliFach = this.manager.getFach(biliSachfach);
            if (biliFach != null && SprachendatenUtils.hatSprachbelegungMitMin2JahrenDauerEndeSekI(this.manager.getSprachendaten(), biliFach.biliSprache)) continue;
            this.addFehler(GostBelegungsfehler.BIL_14);
        }
    }

    private void pruefeGesamtBilingualenBildungsgang() {
        List<AbiturFachbelegung> biliSachfaecherEF;
        String biligualeSprache = this.manager.getBiligualenBildungsgang();
        if (biligualeSprache == null) {
            return;
        }
        AbiturFachbelegung biliSprache = this.manager.getSprachbelegung(biligualeSprache);
        if (!this.manager.pruefeBelegungMitSchriftlichkeit(biliSprache, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1, GostHalbjahr.EF2) || !this.manager.pruefeBelegungMitKursart(biliSprache, GostKursart.LK, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.BIL_10);
        }
        if ((biliSachfaecherEF = this.manager.filterBelegungen(this._biliSachfaecher, GostHalbjahr.EF1, GostHalbjahr.EF2)).isEmpty()) {
            this.addFehler(GostBelegungsfehler.BIL_15);
            return;
        }
        if (biliSachfaecherEF.size() < 2) {
            this.addFehler(GostBelegungsfehler.BIL_11_INFO);
        }
        boolean hatBiliSachfaecherDurchgehendSchriftlich = false;
        if (this._biliSachfaecher != null) {
            for (AbiturFachbelegung fach : this._biliSachfaecher) {
                if (!this.manager.pruefeDurchgaengigkeitSchriftlich(fach)) continue;
                hatBiliSachfaecherDurchgehendSchriftlich = true;
                break;
            }
        }
        if (!hatBiliSachfaecherDurchgehendSchriftlich) {
            this.addFehler(GostBelegungsfehler.BIL_12);
        }
        if (!this.manager.pruefeExistiertAbiFach(this._biliSachfaecher, GostAbiturFach.AB3, GostAbiturFach.AB4)) {
            this.addFehler(GostBelegungsfehler.BIL_13);
        }
    }

    public int getAnzahlDurchgehendSchritflichBelegt() {
        return this._anzahlDurchgehendSchriftlich;
    }
}

