/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import de.svws_nrw.core.utils.gost.GostFachUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public final class GesellschaftswissenschaftenUndReligion
extends GostBelegpruefung {
    private List<@NotNull AbiturFachbelegung> gesellschaftswissenschaften;
    private List<@NotNull AbiturFachbelegung> geschichte;
    private List<@NotNull AbiturFachbelegung> sozialwissenschaften;
    private AbiturFachbelegung philosophie;
    private List<@NotNull AbiturFachbelegung> sonstige_gesellschaftswissenschaften;
    private List<@NotNull AbiturFachbelegung> religion;
    private ArrayList<@NotNull AbiturFachbelegung> zusatzkursFachbelegungen;

    public GesellschaftswissenschaftenUndReligion(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this.gesellschaftswissenschaften = this.manager.getFachbelegungen(GostFachbereich.GESELLSCHAFTSWISSENSCHAFTLICH);
        this.geschichte = this.manager.getFachbelegungen(GostFachbereich.GESCHICHTE);
        this.sozialwissenschaften = this.manager.getFachbelegungen(GostFachbereich.SOZIALWISSENSCHAFTEN);
        this.philosophie = this.manager.getFachbelegung(GostFachbereich.PHILOSOPHIE);
        this.sonstige_gesellschaftswissenschaften = this.manager.getFachbelegungen(GostFachbereich.GESELLSCHAFTSWISSENSCHAFTLICH_SONSTIGE);
        this.religion = this.manager.getFachbelegungen(GostFachbereich.RELIGION);
        this.zusatzkursFachbelegungen = new ArrayList();
    }

    @Override
    protected void pruefeEF1() {
        this.pruefeGesellschaftswissenschaftenEF1();
        this.pruefeReligionEF1();
    }

    private void pruefeGesellschaftswissenschaftenEF1() {
        if (!this.manager.pruefeBelegungDurchgehendBelegbarExistiert(this.gesellschaftswissenschaften, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.GW_10);
        }
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this.gesellschaftswissenschaften, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.GW_11);
        }
        if (this.manager.zaehleBelegungInHalbjahren(this.geschichte, GostHalbjahr.EF1) <= 0) {
            this.addFehler(GostBelegungsfehler.GE_1_INFO);
        }
        if (this.manager.zaehleBelegungInHalbjahren(this.sozialwissenschaften, GostHalbjahr.EF1) <= 0) {
            this.addFehler(GostBelegungsfehler.SW_1_INFO);
        }
    }

    private void pruefeReligionEF1() {
        if (this.manager.pruefeBelegungExistiert(this.religion, GostHalbjahr.EF1)) {
            return;
        }
        if (!this.manager.pruefeBelegung(this.philosophie, GostHalbjahr.EF1) || !this.manager.pruefeBelegungDurchgehendBelegbarExistiert(this.geschichte, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1) && !this.manager.pruefeBelegungDurchgehendBelegbarExistiert(this.sozialwissenschaften, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1) && !this.manager.pruefeBelegungDurchgehendBelegbarExistiert(this.sonstige_gesellschaftswissenschaften, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.RE_10);
        }
    }

    @Override
    protected void pruefeGesamt() {
        this.pruefeSchriftlichkeitEF();
        this.pruefeDurchgaengigeBelegung();
        this.pruefeDurchgaengigeBelegungUndSchriftlich();
        this.pruefeZusatzkurs(this.geschichte);
        this.pruefeBelegungGeschichte();
        this.pruefeZusatzkurs(this.sozialwissenschaften);
        this.pruefeBelegungSozialwissenschaften();
        this.pruefeReligionEF();
        this.pruefeReligionQ1();
        this.pruefeReligionKontinuitaet();
    }

    private void pruefeSchriftlichkeitEF() {
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this.gesellschaftswissenschaften, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1) || !this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this.gesellschaftswissenschaften, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF2)) {
            this.addFehler(GostBelegungsfehler.GW_11);
        }
    }

    private void pruefeDurchgaengigeBelegung() {
        if (!this.manager.pruefeBelegungExistiert(this.gesellschaftswissenschaften, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.GW_10);
        }
    }

    private void pruefeDurchgaengigeBelegungUndSchriftlich() {
        if (this.manager.pruefeBelegungExistiertDurchgehendSchriftlich(this.gesellschaftswissenschaften)) {
            return;
        }
        if (this.manager.pruefeBelegungExistiertDurchgehendSchriftlich(this.religion)) {
            return;
        }
        this.addFehler(GostBelegungsfehler.GW_12);
    }

    private void pruefeZusatzkurs(List<@NotNull AbiturFachbelegung> fachbelegungen) {
        GostHalbjahr prevHalbjahr;
        List<GostHalbjahr> halbjahre;
        ZulaessigesFach zFach;
        AbiturFachbelegung fachbelegung;
        GostFach fach;
        if (fachbelegungen == null || fachbelegungen.isEmpty()) {
            return;
        }
        List<@NotNull AbiturFachbelegung> fachbelegungenZK = this.manager.filterBelegungKursartExistiert(fachbelegungen, GostKursart.ZK);
        if (fachbelegungenZK.isEmpty()) {
            return;
        }
        if (fachbelegungenZK.size() > 1) {
            this.addFehler(GostBelegungsfehler.ZK_13);
        }
        if ((fach = this.manager.getFach(fachbelegung = fachbelegungenZK.get(0))) == null) {
            throw new NullPointerException();
        }
        if (GostFachUtils.istBilingual(fach)) {
            this.addFehler(GostBelegungsfehler.ZK_13);
        }
        if ((zFach = ZulaessigesFach.getByKuerzelASD(fach.kuerzel)) == ZulaessigesFach.GE && !this.manager.istErlaubtZusatzkursGE()) {
            this.addFehler(GostBelegungsfehler.ZK_14);
        }
        if (zFach == ZulaessigesFach.SW && !this.manager.istErlaubtZusatzkursSW()) {
            this.addFehler(GostBelegungsfehler.ZK_15);
        }
        if ((halbjahre = this.manager.getHalbjahreKursart(fachbelegung, GostKursart.ZK)).size() == 2) {
            boolean belegungQ11 = this.manager.pruefeBelegungMitKursart(fachbelegung, GostKursart.ZK, GostHalbjahr.Q11, GostHalbjahr.Q12);
            boolean belegungQ12 = this.manager.pruefeBelegungMitKursart(fachbelegung, GostKursart.ZK, GostHalbjahr.Q12, GostHalbjahr.Q21);
            boolean belegungQ21 = this.manager.pruefeBelegungMitKursart(fachbelegung, GostKursart.ZK, GostHalbjahr.Q21, GostHalbjahr.Q22);
            if (this.zusatzkursFachbelegungen != null && (belegungQ11 || belegungQ12 || belegungQ21)) {
                this.zusatzkursFachbelegungen.add(fachbelegung);
            }
            if (belegungQ11 && this.manager.zaehleBelegungInHalbjahren(fachbelegungenZK, GostHalbjahr.Q21, GostHalbjahr.Q22) > 0 || belegungQ12 && this.manager.zaehleBelegungInHalbjahren(fachbelegungenZK, GostHalbjahr.Q22) > 0) {
                this.addFehler(GostBelegungsfehler.ZK_18);
            }
        } else if (halbjahre.size() > 1) {
            this.addFehler(GostBelegungsfehler.ZK_12);
        }
        if (!halbjahre.isEmpty() && (prevHalbjahr = halbjahre.get(0).previous()) != null && this.manager.pruefeBelegung(fachbelegung, prevHalbjahr)) {
            this.addFehler(GostBelegungsfehler.ZK_10);
        }
        if (!halbjahre.isEmpty()) {
            if (zFach == ZulaessigesFach.GE && this.manager.getBeginnZusatzkursGE() != halbjahre.get(0)) {
                this.addFehler(GostBelegungsfehler.ZK_16);
            }
            if (zFach == ZulaessigesFach.SW && this.manager.getBeginnZusatzkursSW() != halbjahre.get(0)) {
                this.addFehler(GostBelegungsfehler.ZK_17);
            }
        }
    }

    private void pruefeBelegungGeschichte() {
        if (this.geschichte == null || this.geschichte.isEmpty()) {
            this.addFehler(GostBelegungsfehler.GE_10);
            return;
        }
        if (this.manager.pruefeBelegungExistiert(this.geschichte, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12)) {
            return;
        }
        if (this.zusatzkursFachbelegungen != null) {
            for (AbiturFachbelegung zkBelegung : this.zusatzkursFachbelegungen) {
                if (!this.geschichte.contains(zkBelegung)) continue;
                return;
            }
        }
        this.addFehler(GostBelegungsfehler.GE_10);
    }

    private void pruefeBelegungSozialwissenschaften() {
        if (this.sozialwissenschaften == null || this.sozialwissenschaften.isEmpty()) {
            this.addFehler(GostBelegungsfehler.SW_10);
            return;
        }
        if (this.manager.pruefeBelegungExistiert(this.sozialwissenschaften, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12)) {
            return;
        }
        if (this.zusatzkursFachbelegungen != null) {
            for (AbiturFachbelegung zkBelegung : this.zusatzkursFachbelegungen) {
                if (!this.sozialwissenschaften.contains(zkBelegung)) continue;
                return;
            }
        }
        this.addFehler(GostBelegungsfehler.SW_10);
    }

    private void pruefeReligionEF() {
        for (GostHalbjahr halbjahr : GostHalbjahr.getEinfuehrungsphase()) {
            if (this.manager.pruefeBelegungExistiertEinzeln(this.religion, halbjahr) || this.manager.pruefeBelegung(this.philosophie, halbjahr) && (!this.manager.pruefeDurchgaengigkeit(this.philosophie) || this.manager.zaehleBelegungInHalbjahren(this.gesellschaftswissenschaften, halbjahr) > 1)) continue;
            this.addFehler(GostBelegungsfehler.RE_10);
            break;
        }
    }

    private void pruefeReligionQ1() {
        for (GostHalbjahr halbjahr : GostHalbjahr.getHalbjahreFromJahrgang("Q1")) {
            if (this.manager.pruefeBelegungExistiertEinzeln(this.religion, halbjahr)) continue;
            if (!this.manager.pruefeBelegung(this.philosophie, halbjahr)) {
                this.addFehler(GostBelegungsfehler.RE_10);
                return;
            }
            if (this.manager.pruefeDurchgaengigkeit(this.philosophie) && this.manager.zaehleDurchgaengigeBelegungen(this.gesellschaftswissenschaften) > 1 || !this.manager.pruefeDurchgaengigkeit(this.philosophie) && this.manager.zaehleDurchgaengigeBelegungen(this.gesellschaftswissenschaften) > 0 || this.manager.zaehleBelegungInHalbjahren(this.sonstige_gesellschaftswissenschaften, halbjahr) > 0 || halbjahr == GostHalbjahr.Q11 && (this.manager.pruefeBelegungExistiertEinzeln(this.geschichte, GostHalbjahr.Q11) || this.manager.pruefeBelegungExistiertEinzeln(this.sozialwissenschaften, GostHalbjahr.Q11))) continue;
            this.addFehler(GostBelegungsfehler.RE_10);
            break;
        }
    }

    private void pruefeReligionKontinuitaet() {
        if (this.philosophie == null) {
            return;
        }
        for (AbiturFachbelegungHalbjahr belegung : this.philosophie.belegungen) {
            GostHalbjahr prevHalbjahr;
            GostHalbjahr halbjahr;
            if (belegung == null || (halbjahr = GostHalbjahr.fromKuerzel(belegung.halbjahrKuerzel)) == null || (prevHalbjahr = halbjahr.previous()) == null || this.manager.pruefeBelegung(this.philosophie, prevHalbjahr)) continue;
            if (this.manager.pruefeBelegungExistiertEinzeln(this.religion, halbjahr)) {
                this.addFehler(GostBelegungsfehler.E1BEL_10);
            }
            if (this.manager.pruefeBelegungExistiertEinzeln(this.religion, prevHalbjahr)) continue;
            this.addFehler(GostBelegungsfehler.E1BEL_10);
        }
    }
}

