/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.abschluss.gost.belegpruefung.Projektkurse;
import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.Note;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public final class KurszahlenUndWochenstunden
extends GostBelegpruefung {
    private ArrayMap<@NotNull GostHalbjahr, @NotNull ArrayMap<@NotNull GostKursart, @NotNull Integer>> kurszahlen;
    private ArrayMap<@NotNull GostHalbjahr, @NotNull Integer> kurszahlenGrundkurse;
    private ArrayMap<@NotNull GostHalbjahr, @NotNull Integer> kurszahlenLeistungskurse;
    private ArrayMap<@NotNull GostHalbjahr, @NotNull Integer> kurszahlenAnrechenbar;
    private ArrayMap<@NotNull GostKursart, @NotNull Integer> kurszahlenEinfuehrungsphase;
    private ArrayMap<@NotNull GostKursart, @NotNull Integer> kurszahlenQualifikationsphase;
    private int blockIAnzahlGrundkurse;
    private int anzahlLKFaecher;
    private int blockIAnzahlLeistungskurse;
    private int blockIAnzahlAnrechenbar;
    private ArrayMap<@NotNull GostHalbjahr, @NotNull Integer> wochenstunden;
    private int wochenstundenEinfuehrungsphase;
    private int wochenstundenQualifikationsphase;

    public KurszahlenUndWochenstunden(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt, @NotNull GostBelegpruefung pruefungProjektkurse) {
        super(manager, pruefungsArt, pruefungProjektkurse);
    }

    @Override
    protected void init() {
        this.kurszahlen = new ArrayMap(GostHalbjahr.values());
        this.kurszahlenGrundkurse = new ArrayMap(GostHalbjahr.values());
        this.kurszahlenLeistungskurse = new ArrayMap(GostHalbjahr.values());
        this.kurszahlenAnrechenbar = new ArrayMap(GostHalbjahr.values());
        this.kurszahlenEinfuehrungsphase = new ArrayMap(GostKursart.values());
        this.kurszahlenQualifikationsphase = new ArrayMap(GostKursart.values());
        this.blockIAnzahlGrundkurse = 0;
        this.anzahlLKFaecher = 0;
        this.blockIAnzahlLeistungskurse = 0;
        this.blockIAnzahlAnrechenbar = 0;
        this.wochenstunden = new ArrayMap(GostHalbjahr.values());
        this.wochenstundenEinfuehrungsphase = 0;
        this.wochenstundenQualifikationsphase = 0;
        @NotNull Projektkurse projektkurse = (Projektkurse)this.pruefungen_vorher[0];
        AbiturFachbelegung musik = this.manager.getFachbelegungByKuerzel(ZulaessigesFach.MU.daten.kuerzel);
        boolean blockIHatMusikLK = this.manager.pruefeBelegungHatMindestensEinmalKursart(musik, GostKursart.LK, GostHalbjahr.getQualifikationsphase());
        boolean blockIHatMusikGKAbitur = this.manager.pruefeBelegungHatMindestensEinmalKursart(musik, GostKursart.GK, GostHalbjahr.getQualifikationsphase()) && musik != null && musik.abiturFach != null && (musik.abiturFach == 3 || musik.abiturFach == 4);
        int blockIAnzahlMusik = 0;
        int blockIAnzahlErsatzfach = 0;
        @NotNull GostKursart @NotNull [] kursarten = GostKursart.values();
        for (GostHalbjahr gostHalbjahr : GostHalbjahr.values()) {
            @NotNull ArrayMap<@NotNull GostKursart, @NotNull Integer> kurszahlenHalbjahr = new ArrayMap<GostKursart, Integer>(GostKursart.values());
            this.kurszahlen.put(gostHalbjahr, kurszahlenHalbjahr);
            for (GostKursart kursart : kursarten) {
                kurszahlenHalbjahr.put(kursart, 0);
            }
            this.kurszahlenGrundkurse.put(gostHalbjahr, 0);
            this.kurszahlenLeistungskurse.put(gostHalbjahr, 0);
            this.kurszahlenAnrechenbar.put(gostHalbjahr, 0);
            this.wochenstunden.put(gostHalbjahr, 0);
        }
        for (Enum enum_ : kursarten) {
            this.kurszahlenEinfuehrungsphase.put((GostKursart)enum_, 0);
            this.kurszahlenQualifikationsphase.put((GostKursart)enum_, 0);
        }
        @NotNull List<@NotNull AbiturFachbelegung> alleFachbelegungen = this.manager.getFachbelegungen(new GostFachbereich[0]);
        for (int i = 0; i < alleFachbelegungen.size(); ++i) {
            AbiturFachbelegung fachbelegung = alleFachbelegungen.get(i);
            GostFach gostFach = this.manager.getFach(fachbelegung);
            if (gostFach == null) continue;
            ZulaessigesFach zulFach = ZulaessigesFach.getByKuerzelASD(gostFach.kuerzel);
            boolean istLKFach = false;
            for (AbiturFachbelegungHalbjahr fachbelegungHalbjahr : fachbelegung.belegungen) {
                Object kurszahlAnrechenbar;
                boolean istMusikErsatzfach;
                GostKursart kursart;
                GostHalbjahr halbjahr;
                if (fachbelegungHalbjahr == null) continue;
                Note note = Note.fromKuerzel(fachbelegungHalbjahr.notenkuerzel);
                if (GostFachbereich.SPORT.hat(gostFach) && Note.ATTEST.equals((Object)note) || (halbjahr = GostHalbjahr.fromKuerzel(fachbelegungHalbjahr.halbjahrKuerzel)) == null || (kursart = GostKursart.fromKuerzel(fachbelegungHalbjahr.kursartKuerzel)) == null) continue;
                boolean istAnrechenbar = true;
                boolean istNullPunkteBelegungInQPhase = false;
                boolean istMusik = zulFach == ZulaessigesFach.MU;
                boolean istErsatzfach = GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ.hat(gostFach);
                boolean bl = istMusikErsatzfach = istErsatzfach && (zulFach == ZulaessigesFach.IN || zulFach == ZulaessigesFach.VO);
                if (halbjahr.istQualifikationsphase()) {
                    if (istMusik || istMusikErsatzfach) {
                        ++blockIAnzahlMusik;
                        if (blockIHatMusikLK) {
                            boolean bl2 = istAnrechenbar = !istMusikErsatzfach;
                            if (!istAnrechenbar && this.pruefungs_art == GostBelegpruefungsArt.GESAMT) {
                                this.addFehler(GostBelegungsfehler.ANZ_21_INFO);
                            }
                        } else if (blockIHatMusikGKAbitur) {
                            boolean bl3 = istAnrechenbar = blockIAnzahlMusik <= 6;
                            if (!istAnrechenbar && this.pruefungs_art == GostBelegpruefungsArt.GESAMT) {
                                this.addFehler(GostBelegungsfehler.ANZ_22_INFO);
                            }
                        } else {
                            boolean bl4 = istAnrechenbar = blockIAnzahlMusik <= 5;
                            if (!istAnrechenbar && this.pruefungs_art == GostBelegpruefungsArt.GESAMT) {
                                this.addFehler(GostBelegungsfehler.ANZ_23_INFO);
                            }
                        }
                    }
                    if (istErsatzfach) {
                        boolean istAnrechenbarErsatzfach;
                        boolean bl5 = istAnrechenbarErsatzfach = ++blockIAnzahlErsatzfach <= 2;
                        if (!istAnrechenbarErsatzfach && this.pruefungs_art == GostBelegpruefungsArt.GESAMT) {
                            this.addFehler(GostBelegungsfehler.ANZ_20_INFO);
                        }
                        istAnrechenbar = istAnrechenbar && istAnrechenbarErsatzfach;
                    }
                    istNullPunkteBelegungInQPhase = AbiturdatenManager.istNullPunkteBelegungInQPhase(fachbelegungHalbjahr);
                }
                if (istAnrechenbar && !istNullPunkteBelegungInQPhase) {
                    Integer kurszahlAlt;
                    ArrayMap<@NotNull GostKursart, @NotNull Integer> kurszahlenHalbjahr = this.kurszahlen.get((Object)halbjahr);
                    if (kurszahlenHalbjahr == null) {
                        kurszahlenHalbjahr = new ArrayMap(GostKursart.values());
                    }
                    kurszahlenHalbjahr.put(kursart, (kurszahlAlt = kurszahlenHalbjahr.get((Object)kursart)) == null ? 1 : kurszahlAlt + 1);
                }
                if (istAnrechenbar && !istNullPunkteBelegungInQPhase && (kursart == GostKursart.GK || halbjahr.istQualifikationsphase() && (kursart == GostKursart.ZK || kursart == GostKursart.PJK && projektkurse.istAnrechenbar(fachbelegungHalbjahr)))) {
                    Integer kurszahlGK = this.kurszahlenGrundkurse.get((Object)halbjahr);
                    this.kurszahlenGrundkurse.put(halbjahr, kurszahlGK == null ? 1 : kurszahlGK + 1);
                    kurszahlAnrechenbar = this.kurszahlenAnrechenbar.get((Object)halbjahr);
                    this.kurszahlenAnrechenbar.put(halbjahr, kurszahlAnrechenbar == null ? 1 : (Integer)kurszahlAnrechenbar + 1);
                    if (halbjahr.istQualifikationsphase()) {
                        ++this.blockIAnzahlGrundkurse;
                        ++this.blockIAnzahlAnrechenbar;
                    }
                }
                if (halbjahr.istQualifikationsphase() && !istNullPunkteBelegungInQPhase && kursart == GostKursart.LK) {
                    istLKFach = true;
                    Integer kurszahlLK = this.kurszahlenLeistungskurse.get((Object)halbjahr);
                    this.kurszahlenLeistungskurse.put(halbjahr, kurszahlLK == null ? 1 : kurszahlLK + 1);
                    kurszahlAnrechenbar = this.kurszahlenAnrechenbar.get((Object)halbjahr);
                    this.kurszahlenAnrechenbar.put(halbjahr, kurszahlAnrechenbar == null ? 1 : (Integer)kurszahlAnrechenbar + 1);
                    ++this.blockIAnzahlLeistungskurse;
                    ++this.blockIAnzahlAnrechenbar;
                }
                int stunden = 0;
                switch (kursart.kuerzel) {
                    case "GK": {
                        stunden = gostFach.istFremdSpracheNeuEinsetzend ? 4 : 3;
                        break;
                    }
                    case "LK": {
                        stunden = 5;
                        break;
                    }
                    case "PJK": {
                        stunden = fachbelegungHalbjahr.wochenstunden == 3 ? 3 : 2;
                        break;
                    }
                    case "VTF": {
                        stunden = 2;
                        break;
                    }
                    case "ZK": {
                        stunden = 3;
                        break;
                    }
                    default: {
                        stunden = 3;
                    }
                }
                Integer wochenstundenAlt = this.wochenstunden.get((Object)halbjahr);
                this.wochenstunden.put(halbjahr, wochenstundenAlt == null ? stunden : wochenstundenAlt + stunden);
                if (halbjahr.istEinfuehrungsphase()) {
                    if (istAnrechenbar) {
                        Integer kurszahlEF = this.kurszahlenEinfuehrungsphase.get((Object)kursart);
                        this.kurszahlenEinfuehrungsphase.put(kursart, kurszahlEF == null ? 1 : kurszahlEF + 1);
                    }
                    this.wochenstundenEinfuehrungsphase += stunden;
                    continue;
                }
                if (istAnrechenbar && !istNullPunkteBelegungInQPhase) {
                    Integer kurszahlQ = this.kurszahlenQualifikationsphase.get((Object)kursart);
                    this.kurszahlenQualifikationsphase.put(kursart, kurszahlQ == null ? 1 : kurszahlQ + 1);
                }
                this.wochenstundenQualifikationsphase += stunden;
            }
            if (!istLKFach) continue;
            ++this.anzahlLKFaecher;
        }
    }

    @Override
    protected void pruefeEF1() {
        this.pruefeGrundkurseEF1();
        this.pruefeWochenstundenEF1();
    }

    private void pruefeGrundkurseEF1() {
        if (this.kurszahlenGrundkurse == null) {
            throw new NullPointerException();
        }
        Integer kurszahlGK = this.kurszahlenGrundkurse.get((Object)GostHalbjahr.EF1);
        if (kurszahlGK == null || kurszahlGK < 10) {
            this.addFehler(GostBelegungsfehler.ANZ_10);
        }
    }

    private void pruefeWochenstundenEF1() {
        if (this.wochenstunden == null) {
            throw new NullPointerException();
        }
        Integer stunden = this.wochenstunden.get((Object)GostHalbjahr.EF1);
        if (stunden == null || stunden < 32 || stunden > 36) {
            this.addFehler(GostBelegungsfehler.ANZ_11_INFO);
        }
    }

    @Override
    protected void pruefeGesamt() {
        this.pruefeGrundkurseEF();
        this.pruefeGrundkurseQ();
        this.pruefeLeistungskurse();
        this.pruefeVertiefungskurseEF();
        this.pruefeWochenstunden();
        this.pruefeVertiefungskurseQ();
        this.pruefeAnrechenbareKurse();
        this.pruefeKursstundenSummen();
    }

    private void pruefeGrundkurseEF() {
        if (this.kurszahlenGrundkurse == null) {
            throw new NullPointerException();
        }
        Integer kurszahlGK_EF1 = this.kurszahlenGrundkurse.get((Object)GostHalbjahr.EF1);
        Integer kurszahlGK_EF2 = this.kurszahlenGrundkurse.get((Object)GostHalbjahr.EF2);
        if (kurszahlGK_EF1 == null || kurszahlGK_EF1 < 10 || kurszahlGK_EF2 == null || kurszahlGK_EF2 < 10) {
            this.addFehler(GostBelegungsfehler.ANZ_10);
        }
    }

    private void pruefeWochenstunden() {
        if (this.wochenstunden == null) {
            throw new NullPointerException();
        }
        for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
            Integer stunden = this.wochenstunden.get((Object)halbjahr);
            if (stunden != null && stunden >= 32 && stunden <= 36) continue;
            this.addFehler(GostBelegungsfehler.ANZ_11_INFO);
        }
    }

    private void pruefeGrundkurseQ() {
        if (this.kurszahlenGrundkurse == null) {
            throw new NullPointerException();
        }
        for (GostHalbjahr halbjahr : GostHalbjahr.getQualifikationsphase()) {
            Integer kurszahlGK = this.kurszahlenGrundkurse.get((Object)halbjahr);
            if (kurszahlGK != null && kurszahlGK >= 7) continue;
            this.addFehler(GostBelegungsfehler.GKS_10);
        }
    }

    private void pruefeLeistungskurse() {
        if (this.anzahlLKFaecher != 2) {
            this.addFehler(GostBelegungsfehler.LK_10);
        }
        if (this.kurszahlenLeistungskurse == null) {
            throw new NullPointerException();
        }
        for (GostHalbjahr halbjahr : GostHalbjahr.getQualifikationsphase()) {
            Integer kurszahlLK = this.kurszahlenLeistungskurse.get((Object)halbjahr);
            if (kurszahlLK == null) continue;
            if (kurszahlLK < 2) {
                this.addFehler(GostBelegungsfehler.LK_10);
                continue;
            }
            if (kurszahlLK <= 2) continue;
            this.addFehler(GostBelegungsfehler.LK_11);
        }
    }

    private void pruefeVertiefungskurseEF() {
        if (this.kurszahlenEinfuehrungsphase == null) {
            throw new NullPointerException();
        }
        Integer kurszahlEF_VTF = this.kurszahlenEinfuehrungsphase.get((Object)GostKursart.VTF);
        if (kurszahlEF_VTF != null && kurszahlEF_VTF > 4) {
            this.addFehler(GostBelegungsfehler.VF_10);
        }
    }

    private void pruefeVertiefungskurseQ() {
        if (this.kurszahlenQualifikationsphase == null) {
            throw new NullPointerException();
        }
        Integer kurszahlQ_VTF = this.kurszahlenQualifikationsphase.get((Object)GostKursart.VTF);
        if (kurszahlQ_VTF != null && kurszahlQ_VTF > 2) {
            this.addFehler(GostBelegungsfehler.VF_11);
        }
    }

    private void pruefeAnrechenbareKurse() {
        if (this.blockIAnzahlAnrechenbar < 38) {
            this.addFehler(GostBelegungsfehler.ANZ_12);
        }
    }

    private void pruefeKursstundenSummen() {
        double summeKursstundenDurchschnitte;
        if ((double)this.wochenstundenEinfuehrungsphase / 2.0 < 34.0) {
            this.addFehler(GostBelegungsfehler.WST_20);
        }
        if ((double)this.wochenstundenQualifikationsphase / 4.0 < 34.0) {
            this.addFehler(GostBelegungsfehler.WST_21);
        }
        if ((summeKursstundenDurchschnitte = (double)this.wochenstundenEinfuehrungsphase / 2.0 + (double)this.wochenstundenQualifikationsphase / 4.0 * 2.0) < 102.0) {
            if (summeKursstundenDurchschnitte < 100.0) {
                this.addFehler(GostBelegungsfehler.STD_10);
            } else {
                this.addFehler(GostBelegungsfehler.STD_11_INFO);
            }
        }
    }

    public int getKurszahlen(@NotNull GostHalbjahr halbjahr, @NotNull GostKursart kursart) {
        if (this.kurszahlen == null) {
            return 0;
        }
        ArrayMap<@NotNull GostKursart, @NotNull Integer> kurszahlenHalbjahr = this.kurszahlen.get((Object)halbjahr);
        if (kurszahlenHalbjahr == null) {
            return 0;
        }
        Integer kurszahl = kurszahlenHalbjahr.get((Object)kursart);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getKurszahlenGrundkurse(@NotNull GostHalbjahr halbjahr) {
        if (this.kurszahlenGrundkurse == null) {
            return 0;
        }
        Integer kurszahl = this.kurszahlenGrundkurse.get((Object)halbjahr);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getKurszahlenLeistungskurse(@NotNull GostHalbjahr halbjahr) {
        if (this.kurszahlenLeistungskurse == null) {
            return 0;
        }
        Integer kurszahl = this.kurszahlenLeistungskurse.get((Object)halbjahr);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getKurszahlenAnrechenbar(@NotNull GostHalbjahr halbjahr) {
        if (this.kurszahlenAnrechenbar == null) {
            return 0;
        }
        Integer kurszahl = this.kurszahlenAnrechenbar.get((Object)halbjahr);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getKurszahlenEinfuehrungsphase(@NotNull GostKursart kursart) {
        if (this.kurszahlenEinfuehrungsphase == null) {
            return 0;
        }
        Integer kurszahl = this.kurszahlenEinfuehrungsphase.get((Object)kursart);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getKurszahlenQualifikationsphase(@NotNull GostKursart kursart) {
        if (this.kurszahlenQualifikationsphase == null) {
            return 0;
        }
        Integer kurszahl = this.kurszahlenQualifikationsphase.get((Object)kursart);
        if (kurszahl == null) {
            return 0;
        }
        return kurszahl;
    }

    public int getBlockIAnzahlGrundkurse() {
        return this.blockIAnzahlGrundkurse;
    }

    public int getBlockIAnzahlLeistungskurse() {
        return this.blockIAnzahlLeistungskurse;
    }

    public int getBlockIAnzahlAnrechenbar() {
        return this.blockIAnzahlAnrechenbar;
    }

    public int getWochenstunden(@NotNull GostHalbjahr halbjahr) {
        if (this.wochenstunden == null) {
            return 0;
        }
        Integer stunden = this.wochenstunden.get((Object)halbjahr);
        if (stunden == null) {
            stunden = 0;
        }
        return stunden;
    }

    public int getWochenstundenEinfuehrungsphase() {
        return this.wochenstundenEinfuehrungsphase;
    }

    public int getWochenstundenQualifikationsphase() {
        return this.wochenstundenQualifikationsphase;
    }
}

