/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public final class LiterarischKuenstlerisch
extends GostBelegpruefung {
    private List<@NotNull AbiturFachbelegung> kunst_musik;
    private List<@NotNull AbiturFachbelegung> kunst_musik_ersatz;

    public LiterarischKuenstlerisch(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this.kunst_musik = this.manager.getFachbelegungen(GostFachbereich.KUNST_MUSIK);
        this.kunst_musik_ersatz = this.manager.getFachbelegungen(GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ);
    }

    @Override
    protected void pruefeEF1() {
        if (this.manager.zaehleBelegungInHalbjahren(this.kunst_musik, GostHalbjahr.EF1) == 0) {
            this.addFehler(GostBelegungsfehler.KU_MU_10);
        }
    }

    @Override
    protected void pruefeGesamt() {
        boolean hatKuMuErsatz = false;
        if (this.kunst_musik_ersatz != null) {
            for (AbiturFachbelegung fach : this.kunst_musik_ersatz) {
                boolean tmpHatKuMuErsatz = this.manager.pruefeBelegung(fach, GostHalbjahr.Q11, GostHalbjahr.Q12) || this.manager.pruefeBelegung(fach, GostHalbjahr.Q12, GostHalbjahr.Q21) || this.manager.pruefeBelegung(fach, GostHalbjahr.Q21, GostHalbjahr.Q22);
                boolean bl = hatKuMuErsatz = hatKuMuErsatz || tmpHatKuMuErsatz;
                if (tmpHatKuMuErsatz && this.manager.zaehleBelegung(fach) == 2) continue;
                this.addFehler(GostBelegungsfehler.LI_IV_10);
            }
            if (this.kunst_musik_ersatz.size() > 1) {
                this.addFehler(GostBelegungsfehler.LI_IV_11);
            }
        }
        boolean hatKuMuBisQ12 = this.manager.pruefeBelegungExistiert(this.kunst_musik, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12);
        boolean hatKuMuBisEF2 = this.manager.pruefeBelegungExistiert(this.kunst_musik, GostHalbjahr.EF1, GostHalbjahr.EF2);
        if (!hatKuMuBisEF2 || !hatKuMuBisQ12 && !hatKuMuErsatz) {
            this.addFehler(GostBelegungsfehler.KU_MU_10);
        }
    }
}

