/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public final class Naturwissenschaften
extends GostBelegpruefung {
    private List<@NotNull AbiturFachbelegung> _naturwissenschaften;
    private List<@NotNull AbiturFachbelegung> _naturwissenschaftenKlassisch;
    private int _anzahlDurchgehend;
    private int _anzahlDurchgehendSchriftlich;

    public Naturwissenschaften(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this._naturwissenschaften = this.manager.getFachbelegungen(GostFachbereich.NATURWISSENSCHAFTLICH);
        this._naturwissenschaftenKlassisch = this.manager.getFachbelegungen(GostFachbereich.NATURWISSENSCHAFTLICH_KLASSISCH);
        this._anzahlDurchgehend = 0;
        this._anzahlDurchgehendSchriftlich = 0;
    }

    @Override
    protected void pruefeEF1() {
        if (!this.manager.pruefeBelegungDurchgehendBelegbarExistiert(this._naturwissenschaftenKlassisch, GostSchriftlichkeit.BELIEBIG, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.NW_10);
        }
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this._naturwissenschaftenKlassisch, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1)) {
            this.addFehler(GostBelegungsfehler.NW_11);
        }
        List<@NotNull AbiturFachbelegung> fachbelegungen = this.manager.filterDurchgehendBelegbar(this._naturwissenschaften);
        this._anzahlDurchgehend = (fachbelegungen = this.manager.filterBelegungen(fachbelegungen, GostHalbjahr.EF1)) == null ? 0 : fachbelegungen.size();
        fachbelegungen = this.manager.filterBelegungenMitSchriftlichkeit(fachbelegungen, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1);
        this._anzahlDurchgehendSchriftlich = fachbelegungen == null ? 0 : fachbelegungen.size();
    }

    @Override
    protected void pruefeGesamt() {
        if (!this.manager.pruefeBelegungExistiert(this._naturwissenschaftenKlassisch, GostHalbjahr.EF1, GostHalbjahr.EF2, GostHalbjahr.Q11, GostHalbjahr.Q12, GostHalbjahr.Q21, GostHalbjahr.Q22)) {
            this.addFehler(GostBelegungsfehler.NW_10);
        }
        if (!this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this._naturwissenschaftenKlassisch, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF1) || !this.manager.pruefeBelegungExistiertMitSchriftlichkeitEinzeln(this._naturwissenschaftenKlassisch, GostSchriftlichkeit.SCHRIFTLICH, GostHalbjahr.EF2)) {
            this.addFehler(GostBelegungsfehler.NW_11);
        }
        this._anzahlDurchgehend = this.manager.zaehleBelegungenDurchgaengig(this._naturwissenschaften);
        this._anzahlDurchgehendSchriftlich = this.manager.zaehleBelegungenDurchgaengigSchriftlichInQPhase(this._naturwissenschaften);
    }

    public int getAnzahlDurchgehendBelegt() {
        return this._anzahlDurchgehend;
    }

    public int getAnzahlDurchgehendSchritflichBelegt() {
        return this._anzahlDurchgehendSchriftlich;
    }
}

