/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.abschluss.gost.belegpruefung;

import de.svws_nrw.core.abschluss.gost.AbiturdatenManager;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefung;
import de.svws_nrw.core.abschluss.gost.GostBelegpruefungsArt;
import de.svws_nrw.core.abschluss.gost.GostBelegungsfehler;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.gost.AbiturFachbelegungHalbjahr;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.utils.gost.GostFachUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class Projektkurse
extends GostBelegpruefung {
    private ArrayList<@NotNull AbiturFachbelegung> projektkursBelegung;
    private AbiturFachbelegung projektkurs;
    private ArrayList<@NotNull GostHalbjahr> projektkursHalbjahre;

    public Projektkurse(@NotNull AbiturdatenManager manager, @NotNull GostBelegpruefungsArt pruefungsArt) {
        super(manager, pruefungsArt, new GostBelegpruefung[0]);
    }

    @Override
    protected void init() {
        this.projektkurs = null;
        this.projektkursBelegung = new ArrayList();
        this.projektkursHalbjahre = new ArrayList();
        @NotNull List<@NotNull AbiturFachbelegung> alleFachbelegungen = this.manager.getFachbelegungen(new GostFachbereich[0]);
        for (int i = 0; i < alleFachbelegungen.size(); ++i) {
            GostFach fach;
            AbiturFachbelegung fachbelegung = alleFachbelegungen.get(i);
            if (this.manager.zaehleBelegung(fachbelegung) <= 0 || (fach = this.manager.getFach(fachbelegung)) == null || !GostFachUtils.istProjektkurs(fach)) continue;
            this.projektkursBelegung.add(fachbelegung);
        }
    }

    @Override
    protected void pruefeEF1() {
        this.pruefeBelegungEF();
    }

    @Override
    protected void pruefeGesamt() {
        this.pruefeBelegungEF();
        this.pruefeAufAnrechenbarenProjektkurs();
        this.pruefeBelegungHalbjahre();
        this.pruefeBelegungLeitfaecher();
        if (this.manager.istProjektKursBesondereLernleistung()) {
            this.addFehler(this.projektkurs != null ? GostBelegungsfehler.PF_16_INFO : GostBelegungsfehler.PF_15);
        }
    }

    private void pruefeBelegungEF() {
        if (this.projektkursBelegung == null) {
            return;
        }
        for (AbiturFachbelegung fachbelegung : this.projektkursBelegung) {
            for (AbiturFachbelegungHalbjahr belegungHalbjahr : fachbelegung.belegungen) {
                GostHalbjahr halbjahr;
                if (belegungHalbjahr == null || (halbjahr = GostHalbjahr.fromKuerzel(belegungHalbjahr.halbjahrKuerzel)) != GostHalbjahr.EF1 && halbjahr != GostHalbjahr.EF2) continue;
                this.addFehler(GostBelegungsfehler.PF_10);
            }
        }
    }

    private void pruefeAufAnrechenbarenProjektkurs() {
        if (this.projektkursBelegung == null) {
            return;
        }
        block0: for (AbiturFachbelegung fachbelegung : this.projektkursBelegung) {
            for (AbiturFachbelegungHalbjahr belegungHalbjahr : fachbelegung.belegungen) {
                GostHalbjahr halbjahr;
                if (belegungHalbjahr == null || (halbjahr = GostHalbjahr.fromKuerzel(belegungHalbjahr.halbjahrKuerzel)) == null || halbjahr == GostHalbjahr.EF1 || halbjahr == GostHalbjahr.EF2) continue;
                GostHalbjahr nextHalbjahr = halbjahr.next();
                if (nextHalbjahr == null) {
                    this.addFehler(GostBelegungsfehler.PF_18);
                    continue;
                }
                if (!this.manager.pruefeBelegung(fachbelegung, nextHalbjahr)) {
                    this.addFehler(GostBelegungsfehler.PF_17_INFO);
                    continue;
                }
                if (this.projektkurs != null) {
                    this.addFehler(GostBelegungsfehler.PF_14);
                    continue block0;
                }
                this.projektkurs = fachbelegung;
                if (this.projektkursHalbjahre == null) {
                    this.projektkursHalbjahre = new ArrayList();
                }
                this.projektkursHalbjahre.add(halbjahr);
                this.projektkursHalbjahre.add(nextHalbjahr);
                continue block0;
            }
        }
    }

    private void pruefeBelegungHalbjahre() {
        if (this.projektkursBelegung == null) {
            return;
        }
        @NotNull HashSet<@NotNull GostHalbjahr> pjkHalbjahre = new HashSet<GostHalbjahr>();
        for (AbiturFachbelegung fachbelegung : this.projektkursBelegung) {
            for (AbiturFachbelegungHalbjahr belegungHalbjahr : fachbelegung.belegungen) {
                GostHalbjahr nextHalbjahr;
                GostHalbjahr halbjahr;
                if (belegungHalbjahr == null || (halbjahr = GostHalbjahr.fromKuerzel(belegungHalbjahr.halbjahrKuerzel)) == null || halbjahr == GostHalbjahr.EF1 || halbjahr == GostHalbjahr.EF2) continue;
                if (!pjkHalbjahre.add(halbjahr)) {
                    this.addFehler(GostBelegungsfehler.PF_14);
                    continue;
                }
                if (this.projektkurs != null && this.projektkurs.equals(fachbelegung) && this.projektkursHalbjahre != null && this.projektkursHalbjahre.contains((Object)halbjahr) || (nextHalbjahr = halbjahr.next()) != null && GostFachUtils.istWaehlbar(this.manager.getFach(fachbelegung), nextHalbjahr) && (this.projektkurs == null || this.projektkursHalbjahre == null || halbjahr.compareTo(this.projektkursHalbjahre.get(0)) < 0)) continue;
                this.addFehler(GostBelegungsfehler.PF_14);
            }
        }
    }

    private void pruefeBelegungLeitfaecher() {
        if (this.projektkursBelegung == null) {
            return;
        }
        for (AbiturFachbelegung fachbelegung : this.projektkursBelegung) {
            ZulaessigesFach zf;
            GostFach lf;
            GostFach fach = this.manager.getFach(fachbelegung);
            if (fach == null) continue;
            AbiturFachbelegung leitfach1 = this.manager.getFachbelegungByKuerzel(fach.projektKursLeitfach1Kuerzel);
            AbiturFachbelegung leitfach2 = this.manager.getFachbelegungByKuerzel(fach.projektKursLeitfach2Kuerzel);
            if (leitfach1 != null && this.pruefeBelegungLeitfachbelegung(fachbelegung, leitfach1)) {
                lf = this.manager.getFach(leitfach1);
                if (lf == null) {
                    throw new DeveloperNotificationException("Interner Fehler: Das Leitfach mit der angegebenen ID existiert nicht als Fach der gymnasialen Oberstufe in diesem Jahrgang.");
                }
                zf = ZulaessigesFach.getByKuerzelASD(lf.kuerzel);
                if (!GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ.hat(lf) && !zf.equals((Object)ZulaessigesFach.PX) && !zf.equals((Object)ZulaessigesFach.VX)) continue;
                this.addFehler(GostBelegungsfehler.PF_19);
                continue;
            }
            if (leitfach2 != null && this.pruefeBelegungLeitfachbelegung(fachbelegung, leitfach2)) {
                lf = this.manager.getFach(leitfach2);
                if (lf == null) {
                    throw new DeveloperNotificationException("Interner Fehler: Das Leitfach mit der angegebenen ID existiert nicht als Fach der gymnasialen Oberstufe in diesem Jahrgang.");
                }
                zf = ZulaessigesFach.getByKuerzelASD(lf.kuerzel);
                if (!GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ.hat(lf) && !zf.equals((Object)ZulaessigesFach.PX) && !zf.equals((Object)ZulaessigesFach.VX)) continue;
                this.addFehler(GostBelegungsfehler.PF_19);
                continue;
            }
            this.addFehler(GostBelegungsfehler.PF_13);
        }
    }

    private boolean pruefeBelegungLeitfachbelegungNormal(@NotNull AbiturFachbelegung projektkurs, @NotNull AbiturFachbelegung leitfach, @NotNull GostHalbjahr halbjahr1) {
        if (halbjahr1 == GostHalbjahr.Q22) {
            return false;
        }
        if (!this.manager.pruefeBelegung(projektkurs, halbjahr1, halbjahr1.nextOrException())) {
            return false;
        }
        GostHalbjahr hj = halbjahr1;
        while (hj.istQualifikationsphase()) {
            if (this.manager.pruefeBelegung(leitfach, hj, hj.nextOrException())) {
                return true;
            }
            hj = hj.previousOrException();
        }
        return false;
    }

    private boolean pruefeBelegungLeitfachbelegungEinzel(@NotNull AbiturFachbelegung projektkurs, @NotNull AbiturFachbelegung leitfach, @NotNull GostHalbjahr halbjahr1) {
        if (!this.manager.pruefeBelegung(projektkurs, halbjahr1)) {
            return false;
        }
        if (this.manager.pruefeBelegung(leitfach, halbjahr1)) {
            return true;
        }
        @NotNull GostHalbjahr hj = halbjahr1.previousOrException();
        while (hj.istQualifikationsphase()) {
            if (this.manager.pruefeBelegung(leitfach, hj, hj.nextOrException())) {
                return true;
            }
            hj = hj.previousOrException();
        }
        return false;
    }

    private boolean pruefeBelegungLeitfachbelegung(@NotNull AbiturFachbelegung projektkurs, @NotNull AbiturFachbelegung leitfach) {
        return this.pruefeBelegungLeitfachbelegungNormal(projektkurs, leitfach, GostHalbjahr.Q11) || this.pruefeBelegungLeitfachbelegungNormal(projektkurs, leitfach, GostHalbjahr.Q12) || this.pruefeBelegungLeitfachbelegungNormal(projektkurs, leitfach, GostHalbjahr.Q21) || this.pruefeBelegungLeitfachbelegungEinzel(projektkurs, leitfach, GostHalbjahr.Q11) || this.pruefeBelegungLeitfachbelegungEinzel(projektkurs, leitfach, GostHalbjahr.Q12) || this.pruefeBelegungLeitfachbelegungEinzel(projektkurs, leitfach, GostHalbjahr.Q21) || this.pruefeBelegungLeitfachbelegungEinzel(projektkurs, leitfach, GostHalbjahr.Q22);
    }

    public AbiturFachbelegung getProjektkurs() {
        return this.projektkurs;
    }

    public boolean istAnrechenbar(AbiturFachbelegungHalbjahr fachbelegungHalbjahr) {
        if (fachbelegungHalbjahr == null) {
            return false;
        }
        if (GostKursart.fromKuerzel(fachbelegungHalbjahr.kursartKuerzel) != GostKursart.PJK) {
            return false;
        }
        GostHalbjahr halbjahr = GostHalbjahr.fromKuerzel(fachbelegungHalbjahr.halbjahrKuerzel);
        if (this.projektkurs == null || this.projektkursHalbjahre == null || this.manager.istProjektKursBesondereLernleistung()) {
            return false;
        }
        return halbjahr == this.projektkursHalbjahre.get(0) || halbjahr == this.projektkursHalbjahre.get(1);
    }

    public int getAnrechenbareKurse() {
        if (this.projektkurs == null || this.manager.istProjektKursBesondereLernleistung()) {
            return 0;
        }
        return 2;
    }
}

