/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt;

import jakarta.validation.constraints.NotNull;

public final class LongArrayKey
implements Comparable<LongArrayKey> {
    @NotNull
    private final long[] _keys;
    private final int _hashcode;

    public LongArrayKey(@NotNull long[] arrayOfKeys) {
        this._keys = new long[arrayOfKeys.length];
        int hashCode = 1;
        for (int i = 0; i < arrayOfKeys.length; ++i) {
            long value;
            this._keys[i] = value = arrayOfKeys[i];
            hashCode = 31 * hashCode + (int)(value ^ value >>> 32);
        }
        this._hashcode = hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongArrayKey)) {
            return false;
        }
        @NotNull long[] keys2 = ((LongArrayKey)obj)._keys;
        if (this._keys.length != keys2.length) {
            return false;
        }
        for (int i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] == keys2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._hashcode;
    }

    @Override
    public int compareTo(@NotNull LongArrayKey o) {
        @NotNull long[] keys2 = o._keys;
        if (this._keys.length < keys2.length) {
            return -1;
        }
        if (this._keys.length > keys2.length) {
            return 1;
        }
        for (int i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] < keys2[i]) {
                return -1;
            }
            if (this._keys[i] <= keys2[i]) continue;
            return 1;
        }
        return 0;
    }
}

